/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.cnkjava.CNKBlobClassHandler;
import com.insightful.cnkjava.CNKObj;
import com.insightful.miner.ColumnDefinitions;
import com.insightful.miner.GuiMessageHandler;
import com.insightful.miner.MinerApp;
import com.insightful.miner.Retrievable;
import com.insightful.miner.XTMetaData;
import java.text.DecimalFormat;

public class GridDataSource
implements Retrievable {
    private static int CHAR_WIDTH = 9;
    private boolean m_rounding = true;
    private DecimalFormat m_decimalFormat = new DecimalFormat();
    private DecimalFormat m_scientificFormat = new DecimalFormat();
    private int m_formatDecimalPlaces = -1;
    private double m_scientificMaxBound = 9.99999999E8;
    private double m_scientificMinBound = 1.0E-4;
    private boolean[] m_continuous;
    private String[] m_columnTypes;
    private String[] m_columnDisplayTypes;
    private int m_portIndex = 0;
    private boolean isInput = false;
    protected String m_worksheetID;
    protected String m_nodeID;
    protected long m_rowCount;
    protected int m_colCount;
    protected String[] m_colNames;
    protected int currentColOrigin;
    protected long currentRowOrigin;
    protected int chunkNumCols;
    protected int chunkNumRows;
    protected String[] cachedLoadedData;

    public GridDataSource(String worksheetID, String nodeID, int portIndex, boolean isInp) {
        this.m_worksheetID = worksheetID;
        this.m_nodeID = nodeID;
        this.m_portIndex = portIndex;
        this.isInput = isInp;
        this.refresh(portIndex);
        this.chunkNumCols = Math.min(50, this.getTotalColumns());
        this.chunkNumRows = (int)Math.min(50L, this.getTotalRows());
        this.currentColOrigin = 0;
        this.currentRowOrigin = 0L;
        this.cachedLoadedData = null;
        XTMetaData metaData = null;
        metaData = this.isInput ? (XTMetaData)this.sendMessageToEngine("getInputMetaData", new Object[]{new Integer(portIndex)}) : (XTMetaData)this.sendMessageToEngine("getOutputMetaData", new Object[]{new Integer(portIndex)});
        int numCols = metaData.getNumColumns();
        this.m_continuous = new boolean[numCols];
        this.m_columnTypes = new String[numCols];
        this.m_columnDisplayTypes = null;
        for (int i = 0; i < this.m_continuous.length; ++i) {
            this.m_columnTypes[i] = metaData.getColumnType(i);
            this.m_continuous[i] = this.m_columnTypes[i].equals(XTMetaData.CONTINUOUS_TYPE_ATTRIBUTE_TAG);
            if (!this.m_columnTypes[i].equals(XTMetaData.BLOB_TYPE_ATTRIBUTE_TAG)) continue;
            if (this.m_columnDisplayTypes == null) {
                this.m_columnDisplayTypes = new String[numCols];
            }
            this.m_columnDisplayTypes[i] = CNKBlobClassHandler.getDisplayClassName(metaData.getBlobDataFieldClassName(i));
        }
    }

    public void setRounding(boolean rounding) {
        this.m_rounding = rounding;
    }

    public boolean isRounding() {
        return this.m_rounding;
    }

    public void setRounding(boolean rounding, int decimalPlaces) {
        this.m_rounding = rounding;
        if (this.m_rounding) {
            this.m_formatDecimalPlaces = decimalPlaces;
            MinerApp.getWorksheetPropertiesManager().initViewerRoundingObject(this.m_decimalFormat, decimalPlaces);
            if (decimalPlaces < 0) {
                this.m_scientificFormat.setDecimalFormatSymbols(MinerApp.getWorksheetPropertiesManager().getDecimalFormatSymbols());
                this.m_scientificFormat.applyPattern("0.0##################E0");
                this.m_scientificMinBound = 1.0E-4;
            } else {
                MinerApp.getWorksheetPropertiesManager().initViewerScientificRoundingObject(this.m_scientificFormat, decimalPlaces);
                this.m_scientificMinBound = Math.pow(10.0, -this.m_formatDecimalPlaces);
            }
        }
    }

    public String getRowLabel(long rowNum) {
        return null;
    }

    public int getRowLabelWidth() {
        int maxDigits = (int)Math.round(Math.log(this.getTotalRows()) / 2.3);
        int rowNumWidth = 6 * CHAR_WIDTH;
        if (maxDigits > 6) {
            rowNumWidth += CHAR_WIDTH * (maxDigits - 6);
        }
        return rowNumWidth;
    }

    public boolean isSortable() {
        return false;
    }

    public Object getData(long row, int column) {
        return this.getValueAt(row, column);
    }

    public long getTotalRows() {
        return this.getRowCount();
    }

    public int getTotalColumns() {
        return this.getColumnCount();
    }

    public String getColumnType(int col) {
        return this.m_columnTypes[col];
    }

    public String getColumnDisplayType(int col) {
        if (this.m_columnDisplayTypes != null && this.m_columnDisplayTypes[col] != null) {
            return this.m_columnDisplayTypes[col];
        }
        String sReturn = this.m_columnTypes[col];
        if (MinerApp.isInBDL()) {
            if (sReturn.equals(ColumnDefinitions.CONTINUOUS_TYPE_ATTRIBUTE_TAG)) {
                sReturn = ColumnDefinitions.NUMERIC_TYPE_ATTRIBUTE_TAG;
            } else if (sReturn.equals(ColumnDefinitions.CATEGORICAL_TYPE_ATTRIBUTE_TAG)) {
                sReturn = ColumnDefinitions.FACTOR_TYPE_ATTRIBUTE_TAG;
            }
        }
        return sReturn;
    }

    public String getColumnName(int col) {
        return this.m_colNames[col];
    }

    public int getColumnWidth(int col) {
        int headerWidth = Math.max(this.getColumnName(col).length(), this.getColumnType(col).length());
        String dataSample = this.getValueAt(0L, col);
        int dataWidth = dataSample == null ? 10 : dataSample.length();
        return Math.max(headerWidth, dataWidth) * CHAR_WIDTH;
    }

    private Object sendMessageToEngine(String msg, Object[] args) {
        return this.sendMessageToEngine(this.m_nodeID, msg, args);
    }

    private Object sendMessageToEngine(String nodeID, String msg, Object[] args) {
        return GuiMessageHandler.sendMessageToEngine(this.m_worksheetID, nodeID, msg, args);
    }

    protected String[] getValues(long startRow, int startCol, int numRows, int numCols, int portIndex) {
        String[] out = null;
        try {
            Object obj = this.sendMessageToEngine(null, "getNodeDataViewerDataArray", new Object[]{this.m_nodeID, new Long(startRow), new Long(startRow + (long)numRows - 1L), new Integer(startCol), new Integer(startCol + numCols - 1), new Integer(portIndex), new Boolean(this.isInput)});
            out = (String[])obj;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return out;
    }

    protected long getRowCount() {
        return this.m_rowCount;
    }

    protected int getColumnCount() {
        return this.m_colCount;
    }

    protected void refresh(int portIndex) {
        Long numRows = (Long)this.sendMessageToEngine(null, "getNodeDataViewerNumRows", new Object[]{this.m_nodeID, new Integer(this.m_portIndex), new Boolean(this.isInput)});
        Integer numCols = (Integer)this.sendMessageToEngine(null, "getNodeDataViewerNumColumns", new Object[]{this.m_nodeID, new Integer(this.m_portIndex), new Boolean(this.isInput)});
        String[] columnNames = (String[])this.sendMessageToEngine(null, "getNodeDataViewerColumnNames", new Object[]{this.m_nodeID, new Integer(this.m_portIndex), new Boolean(this.isInput)});
        if (numRows == null || numCols == null || columnNames == null) {
            throw new RuntimeException("No data was found.");
        }
        if (numRows == 0L) {
            throw new RuntimeException("No Rows were output.");
        }
        if (numCols == 0) {
            throw new RuntimeException("No Columns were output.");
        }
        this.m_rowCount = numRows;
        this.m_colCount = numCols;
        this.m_colNames = columnNames;
        if (this.m_colCount != columnNames.length) {
            throw new RuntimeException("Column Count does not equal number of column names.");
        }
    }

    protected int matrixToArray(long row, int col) {
        return (int)(row - this.currentRowOrigin + (long)((col - this.currentColOrigin) * this.chunkNumRows));
    }

    protected boolean isInCurrentBlock(long row, int column) {
        return this.cachedLoadedData != null && this.whereIsRowInCurrentBlock(row) == 0 && this.whereIsColInCurrentBlock(column) == 0;
    }

    protected int whereIsRowInCurrentBlock(long row) {
        if (row >= this.currentRowOrigin + (long)this.chunkNumRows) {
            return 1;
        }
        if (row < this.currentRowOrigin) {
            return -1;
        }
        return 0;
    }

    protected int whereIsColInCurrentBlock(int column) {
        if (column >= this.currentColOrigin + this.chunkNumCols) {
            return 1;
        }
        if (column < this.currentColOrigin) {
            return -1;
        }
        return 0;
    }

    protected String getValueAt(long row, int column) {
        if (!this.isInCurrentBlock(row, column)) {
            this.getNextBlock(row, column);
        }
        if (this.cachedLoadedData == null || this.cachedLoadedData.length == 0) {
            return "";
        }
        if (this.m_continuous[column] && this.m_rounding) {
            String ret = this.cachedLoadedData[this.matrixToArray(row, column)];
            try {
                double full = Double.parseDouble(ret);
                double absFull = Math.abs(full);
                ret = absFull > this.m_scientificMaxBound || absFull > 0.0 && absFull < this.m_scientificMinBound ? this.m_scientificFormat.format(full) : this.m_decimalFormat.format(full);
                return ret;
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return this.cachedLoadedData[this.matrixToArray(row, column)];
    }

    public void updateWindowPosition(long neededRowOrigin, int neededNumRows, int neededColOrigin, int neededNumCols) {
        boolean originInBlock = this.isInCurrentBlock(neededRowOrigin, neededColOrigin);
        boolean endInBlock = this.isInCurrentBlock(neededRowOrigin + (long)neededNumRows, neededColOrigin + neededNumCols);
        if (originInBlock && endInBlock) {
            return;
        }
        if (neededNumRows <= this.chunkNumRows && neededNumCols <= this.chunkNumCols) {
            int colOrigin = Math.min(neededColOrigin, this.getTotalColumns() - this.chunkNumCols);
            long rowOrigin = Math.min(neededRowOrigin, this.getTotalRows() - (long)this.chunkNumRows);
            this.cachedLoadedData = this.getValues(rowOrigin, colOrigin, this.chunkNumRows, this.chunkNumCols, this.m_portIndex);
            this.currentRowOrigin = rowOrigin;
            this.currentColOrigin = colOrigin;
        }
    }

    protected void getNextBlock(long row, int column) {
        int adjustableStartCol;
        long adjustableStartRow;
        long variable;
        int where = this.whereIsRowInCurrentBlock(row);
        if (where == -1) {
            variable = Math.min(this.currentRowOrigin - (long)this.chunkNumRows, row);
            adjustableStartRow = Math.max(variable, 0L);
        } else if (where == 1) {
            variable = Math.max(this.currentRowOrigin + (long)this.chunkNumRows, row);
            adjustableStartRow = Math.min(variable, this.getTotalRows() - (long)this.chunkNumRows);
        } else {
            adjustableStartRow = this.currentRowOrigin;
        }
        where = this.whereIsColInCurrentBlock(column);
        if (where == -1) {
            int variable2 = Math.min(this.currentColOrigin - this.chunkNumCols, column);
            adjustableStartCol = Math.max(variable2, 0);
        } else if (where == 1) {
            int variable3 = Math.max(this.currentColOrigin + this.chunkNumCols, column);
            adjustableStartCol = Math.min(variable3, this.getTotalColumns() - this.chunkNumCols);
        } else {
            adjustableStartCol = this.currentColOrigin;
        }
        this.cachedLoadedData = this.getValues(adjustableStartRow, adjustableStartCol, this.chunkNumRows, this.chunkNumCols, this.m_portIndex);
        this.currentRowOrigin = adjustableStartRow;
        this.currentColOrigin = adjustableStartCol;
    }

    public Object[] getOriginalData(int[] colNums, long firstRow, int numRows) {
        Object[] out = null;
        try {
            Object obj = this.sendMessageToEngine("getOriginalData", new Object[]{colNums, new Long(firstRow), new Integer(numRows), new Integer(this.m_portIndex), new Boolean(this.isInput)});
            out = (Object[])obj;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return out;
    }

    public String getDisplayDateTime(long val) {
        if (CNKObj.isTimeDateNA(val)) {
            return "";
        }
        return MinerApp.getWorksheetPropertiesManager().getDateFormatter().convertJulianDateToString(val);
    }

    public String getDisplayDouble(double val) {
        if (CNKObj.isDoubleNA(val)) {
            return "";
        }
        return MinerApp.getWorksheetPropertiesManager().formatDouble(val);
    }
}

