/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.miner.DataCacheRowBuf;
import com.insightful.miner.EngineNode;
import com.insightful.miner.SortAndShuffle;
import com.insightful.miner.UniqueEngineNode;
import com.insightful.miner.XTMetaData;
import com.insightful.miner.XTProps;
import java.io.BufferedInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.RandomAccessFile;
import java.util.Vector;

public class MatchEngineNode
extends UniqueEngineNode {
    public static final int TRUE_INT = 0;
    public static final int FALSE_INT = 1;
    public static final String MATCH_COL_NAME = "MATCHED";
    public static final String NO_MATCH_DEFAULT_VAL = "NA";
    public static final String NO_MATCH_DEFAULT_CLASS_NA = "NA";
    public static final String MATCH_ATTRIBUTE_TAG = "matchColumn";
    public static final String NO_MATCH_ATTRIBUTE_TAG = "nomatch";
    public static final String NO_MATCH_CLASS_ATTRIBUTE_TAG = "nomatchClass";
    protected String m_duplicateName = "MATCHED";
    protected double m_noMatchObject = Double.NaN;
    private int m_sortInput = 0;
    protected XTMetaData m_indexedMD2 = null;
    protected XTMetaData m_sortedMD2 = null;
    protected File m_indexedFile2 = null;
    protected File m_sortedFile2 = null;
    protected File m_indexedBlobFile2 = null;
    protected File m_sortedBlobFile2 = null;

    public boolean executeDataCacheProc() throws Exception {
        XTProps props = this.getNodeProperties();
        this.m_duplicateName = props.getValue(MATCH_ATTRIBUTE_TAG, MATCH_COL_NAME);
        try {
            String noMatchVal = props.getValue(NO_MATCH_ATTRIBUTE_TAG, "NA");
            this.m_noMatchObject = Double.parseDouble(noMatchVal);
        }
        catch (NumberFormatException e) {
            this.m_noMatchObject = Double.NaN;
        }
        boolean ok = super.executeDataCacheProc();
        if (this.m_indexedFile2 != null) {
            this.m_indexedFile2.delete();
        }
        if (this.m_sortedFile2 != null) {
            this.m_sortedFile2.delete();
        }
        if (this.m_indexedBlobFile2 != null) {
            this.m_indexedBlobFile2.delete();
        }
        if (this.m_sortedBlobFile2 != null) {
            this.m_sortedBlobFile2.delete();
        }
        return ok;
    }

    protected void initVars() {
        super.initVars();
        this.m_sortedMD2 = null;
        this.m_indexedMD2 = null;
        this.m_sortedFile2 = null;
        this.m_indexedFile2 = null;
        this.m_sortedBlobFile2 = null;
        this.m_indexedBlobFile2 = null;
    }

    protected boolean handleIndex() throws Exception {
        String inputDCF = this.getInputDataCacheFileName(0);
        XTMetaData inputMD = this.getInputMD();
        XTMetaData indexedMD = this.getIndexedMD();
        indexedMD.setNumRows(inputMD.getNumRows());
        this.m_indexedFile = this.createWorkspaceTempFile("index", "tmp");
        this.m_indexedBlobFile = this.createWorkspaceTempFile("index", "tmp");
        boolean ok = this.fileManipulation(new File(inputDCF), new File(this.getNetworkManager().getInputDataBlobFileName(this.getNodeID(), 0)), inputMD, this.m_indexedFile, this.m_indexedBlobFile, indexedMD, 0);
        if (!ok) {
            return false;
        }
        String inputDCF2 = this.getInputDataCacheFileName(1);
        XTMetaData inputMD2 = this.getInputMD2();
        XTMetaData indexedMD2 = this.getIndexedMD2();
        indexedMD2.setNumRows(inputMD2.getNumRows());
        this.m_indexedFile2 = this.createWorkspaceTempFile("index", "tmp");
        this.m_indexedBlobFile2 = this.createWorkspaceTempFile("index", "tmp");
        ok = this.fileManipulation(new File(inputDCF2), new File(this.getNetworkManager().getInputDataBlobFileName(this.getNodeID(), 1)), inputMD2, this.m_indexedFile2, this.m_indexedBlobFile2, indexedMD2, 0);
        indexedMD2.setNumRows(inputMD2.getNumRows());
        return ok;
    }

    protected boolean handleSort() throws Exception {
        this.m_sortedFile = this.createWorkspaceTempFile("sort", "tmp");
        this.m_sortedBlobFile = this.createWorkspaceTempFile("sort", "tmp");
        this.m_sortInput = 0;
        boolean ok = this.fileManipulation(this.m_indexedFile, this.m_indexedBlobFile, this.getIndexedMD(), this.m_sortedFile, this.m_sortedBlobFile, this.getSortedMD(), 1);
        if (!ok) {
            return ok;
        }
        this.m_sortedFile2 = this.createWorkspaceTempFile("sort", "tmp");
        this.m_sortedBlobFile2 = this.createWorkspaceTempFile("sort", "tmp");
        this.m_sortInput = 1;
        return this.fileManipulation(this.m_indexedFile2, this.m_indexedBlobFile2, this.getIndexedMD2(), this.m_sortedFile2, this.m_sortedBlobFile2, this.getSortedMD2(), 1);
    }

    protected boolean sort() throws Exception {
        boolean[] ascend = new boolean[this.m_equalityColNames.length + 1];
        boolean[] naTop = new boolean[this.m_equalityColNames.length + 1];
        for (int i = 0; i < naTop.length; ++i) {
            naTop[i] = true;
            ascend[i] = true;
        }
        File index = this.m_indexedFile;
        File sorted = this.m_sortedFile;
        String[] colNames = this.m_equalityColNames;
        XTMetaData md = this.m_indexedMD;
        if (this.m_sortInput == 1) {
            index = this.m_indexedFile2;
            sorted = this.m_sortedFile2;
            md = this.m_indexedMD2;
            colNames = new String[this.m_equalityColNames.length + 1];
            for (int i = 0; i < this.m_equalityColNames.length; ++i) {
                colNames[i] = md.ordinalToName(i);
            }
            colNames[this.m_equalityColNames.length] = this.getIndexColNameForAddingIndex();
        } else {
            colNames = new String[this.m_equalityColNames.length + 1];
            for (int i = 0; i < this.m_equalityColNames.length; ++i) {
                colNames[i] = this.m_equalityColNames[i];
            }
            colNames[this.m_equalityColNames.length] = this.getIndexColNameForAddingIndex();
        }
        return SortAndShuffle.sort(index, sorted, md, (EngineNode)this, this.getMaxRowsPerBlock(), colNames, ascend, naTop, true, true);
    }

    protected int compareCell(DataCacheRowBuf preBuf, DataCacheRowBuf preBuf2, Vector[] levels, Vector[] levels2, int in1, int in2) {
        if (preBuf.isNA(in1)) {
            if (preBuf2.isNA(in2)) {
                return 0;
            }
            return -1;
        }
        if (preBuf2.isNA(in2)) {
            return 1;
        }
        if (preBuf.isDouble(in1) && preBuf2.isDouble(in2)) {
            double dVal2;
            double dVal1 = preBuf.getDouble(in1);
            if (dVal1 > (dVal2 = preBuf2.getDouble(in2))) {
                return 1;
            }
            if (dVal1 < dVal2) {
                return -1;
            }
            return 0;
        }
        if (preBuf.isFactor(in1) && (preBuf2.isFactor(in2) || preBuf2.isString(in2))) {
            int level1 = preBuf.getLevelNum(in1);
            String l1 = (String)levels[in1].get(level1);
            String l2 = null;
            if (preBuf2.isString(in2)) {
                l2 = preBuf2.getString(in2);
            } else {
                int level2 = preBuf2.getLevelNum(in2);
                l2 = (String)levels2[in2].get(level2);
            }
            int comp = l1.compareTo(l2);
            return comp;
        }
        if (preBuf.isString(in1) && preBuf2.isString(in2)) {
            String str1 = preBuf.getString(in1);
            String str2 = preBuf2.getString(in2);
            int comp = str1.compareTo(str2);
            return comp;
        }
        if (preBuf.isTimeDate(in1) && preBuf2.isTimeDate(in2)) {
            long td2;
            long td1 = preBuf.getTimeDate(in1);
            if (td1 > (td2 = preBuf2.getTimeDate(in2))) {
                return 1;
            }
            if (td1 < td2) {
                return -1;
            }
            return 0;
        }
        if (preBuf.isBlob(in1) && preBuf2.isBlob(in2)) {
            long len2;
            long off2;
            long off1 = preBuf.getBlobOffset(in1);
            if (off1 > (off2 = preBuf2.getBlobOffset(in2))) {
                return 1;
            }
            if (off1 < off2) {
                return -1;
            }
            long len1 = preBuf.getBlobLength(in1);
            if (len1 > (len2 = preBuf2.getBlobLength(in2))) {
                return 1;
            }
            if (len1 < len2) {
                return -1;
            }
            return 0;
        }
        return -1;
    }

    protected int compareRow(DataCacheRowBuf preBuf, DataCacheRowBuf preBuf2, Vector[] levels, Vector[] levels2, int[] in2toIn1) {
        for (int i = 0; i < in2toIn1.length; ++i) {
            int comp;
            int in2 = i;
            int in1 = in2toIn1[i];
            if (in1 == -1 || (comp = this.compareCell(preBuf, preBuf2, levels, levels2, in2, in2)) == 0) continue;
            return comp;
        }
        return 0;
    }

    protected boolean isMatch(int comparisonVal, DataCacheRowBuf preBuf, long rowNum2, int[] in2toIn1) {
        return comparisonVal == 0;
    }

    protected boolean isGreaterThan(int comparisonVal) {
        return comparisonVal > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected boolean manip(DataCacheRowBuf preBuf, DataInput preStream, DataCacheRowBuf newBuf, DataOutput newStream, XTMetaData preMD, XTMetaData newMD) {
        boolean bl;
        FilterInputStream preStream2;
        block24: {
            int outIndexCol;
            int outMatchCol;
            int indexCol2;
            int indexCol1;
            int numCols2;
            long rowsout;
            long rownum2;
            long rownum1;
            long numrows2;
            long numrows1;
            Vector[] levels2;
            Vector[] levels;
            DataCacheRowBuf preBuf2;
            block22: {
                boolean bl2;
                block23: {
                    preStream2 = null;
                    XTMetaData preMD2 = this.getSortedMD2();
                    FileInputStream stream2 = new FileInputStream(this.m_sortedFile2);
                    BufferedInputStream buffer2 = new BufferedInputStream(stream2);
                    preStream2 = new DataInputStream(buffer2);
                    preBuf2 = new DataCacheRowBuf(preMD2);
                    RandomAccessFile blobFile2 = null;
                    if (preBuf2.containsBlobs()) {
                        blobFile2 = new RandomAccessFile(this.m_sortedBlobFile2, "r");
                        preBuf2.setReadBlobFile(blobFile2);
                    }
                    levels = new Vector[preMD.getNumColumns()];
                    for (int i = 0; i < levels.length; ++i) {
                        String cname = preMD.ordinalToName(i);
                        levels[i] = preMD.getCategoricalDataFieldLevels(cname);
                    }
                    levels2 = new Vector[preMD2.getNumColumns()];
                    for (int i = 0; i < levels2.length; ++i) {
                        String cname = preMD2.ordinalToName(i);
                        levels2[i] = preMD2.getCategoricalDataFieldLevels(cname);
                    }
                    numrows1 = preMD.getNumRows();
                    numrows2 = preMD2.getNumRows();
                    rownum1 = 0L;
                    rownum2 = 0L;
                    rowsout = 0L;
                    int numCols1 = preMD.getNumColumns();
                    numCols2 = preMD2.getNumColumns();
                    indexCol1 = preMD.nameToOrdinal(".im_index_im.");
                    indexCol2 = preMD2.nameToOrdinal(".im_index_im.");
                    outMatchCol = newMD.nameToOrdinal(this.m_duplicateName);
                    outIndexCol = newMD.nameToOrdinal(".im_index_im.");
                    if (numCols1 == numCols2) break block22;
                    bl2 = true;
                    Object var34_34 = null;
                    if (preStream2 == null) break block23;
                    try {
                        preStream2.close();
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
                return bl2;
            }
            int[] in2toIn1 = new int[numCols2];
            for (int i = 0; i < numCols2; ++i) {
                in2toIn1[i] = i == indexCol2 ? -1 : i;
            }
            block15: while (rownum1 < numrows1 && rownum2 < numrows2) {
                try {
                    int comparision;
                    if (rownum1 == 0L && rownum2 == 0L) {
                        preBuf.readRow(preStream);
                        preBuf2.readRow((DataInput)((Object)preStream2));
                    }
                    if (this.isMatch(comparision = this.compareRow(preBuf, preBuf2, levels, levels2, in2toIn1), preBuf, rownum2, in2toIn1)) {
                        newBuf.setDouble(outMatchCol, preBuf2.getDouble(indexCol2) + 1.0);
                        newBuf.setDouble(outIndexCol, preBuf.getDouble(indexCol1));
                        newBuf.writeRow(newStream);
                        ++rowsout;
                        preBuf.readRow(preStream);
                        ++rownum1;
                        continue;
                    }
                    if (this.isGreaterThan(comparision)) {
                        while (rownum2 < numrows2) {
                            preBuf2.readRow((DataInput)((Object)preStream2));
                            ++rownum2;
                            if (this.isGreaterThan(this.compareRow(preBuf, preBuf2, levels, levels2, in2toIn1))) continue;
                            continue block15;
                        }
                        continue;
                    }
                    newBuf.setDouble(outMatchCol, this.m_noMatchObject);
                    newBuf.setDouble(outIndexCol, preBuf.getDouble(indexCol1));
                    newBuf.writeRow(newStream);
                    ++rowsout;
                    preBuf.readRow(preStream);
                    ++rownum1;
                }
                catch (Exception e) {
                    // empty catch block
                    break;
                }
            }
            while (rownum1 < numrows1) {
                newBuf.setDouble(outMatchCol, this.m_noMatchObject);
                newBuf.setDouble(outIndexCol, preBuf.getDouble(indexCol1));
                newBuf.writeRow(newStream);
                ++rowsout;
                preBuf.readRow(preStream);
                ++rownum1;
            }
            newMD.setNumRows(rowsout);
            bl = true;
            Object var34_35 = null;
            if (preStream2 == null) break block24;
            try {
                preStream2.close();
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        return bl;
        catch (FileNotFoundException e) {
            boolean bl3;
            block25: {
                try {
                    e.printStackTrace();
                    newMD.setNumRows(0L);
                    bl3 = false;
                    Object var34_36 = null;
                    if (preStream2 == null) break block25;
                }
                catch (Throwable throwable) {
                    block26: {
                        Object var34_37 = null;
                        if (preStream2 == null) break block26;
                        try {
                            preStream2.close();
                        }
                        catch (Exception ex) {}
                    }
                    throw throwable;
                }
                try {
                    preStream2.close();
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            return bl3;
        }
    }

    protected XTMetaData getInputMD2() {
        return this.getInputMetaData(1);
    }

    protected XTMetaData getIndexedMD2() {
        if (this.m_indexedMD2 == null) {
            this.m_indexedMD2 = (XTMetaData)this.getInputMD2().clone();
            this.m_indexedMD2.appendContinousDataField(".im_index_im.");
        }
        return this.m_indexedMD2;
    }

    protected XTMetaData getSortedMD2() {
        if (this.m_sortedMD2 == null) {
            this.m_sortedMD2 = (XTMetaData)this.getIndexedMD2().clone();
        }
        return this.m_sortedMD2;
    }

    protected XTMetaData getModifiedMD() {
        if (this.m_modifiedMD == null) {
            try {
                this.m_modifiedMD = new XTMetaData();
                this.m_modifiedMD.appendContinousDataField(this.m_duplicateName);
                this.m_modifiedMD.appendContinousDataField(".im_index_im.");
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
        return this.m_modifiedMD;
    }
}

