/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.miner.ExecViewer;
import com.insightful.miner.NeuralNetViewer;
import com.insightful.miner.XMLTree;
import com.insightful.miner.XTMetaData;
import com.insightful.miner.XTProps;
import java.util.Hashtable;
import javax.swing.JTextArea;

public class NeuralNetworkExecViewer
extends ExecViewer {
    private NeuralNetViewer m_frame = new NeuralNetViewer(this, "", true);
    private JTextArea m_textArea = null;
    private String m_saveWeightsFile = null;
    private String m_retrieveWeightsFile = null;
    private String m_bestWeightsFile = null;
    private boolean m_jitter = false;
    private boolean m_weightArrayRequested = true;
    private int m_terminateOption = 0;
    public static String EPOCH_TAG = "epoch";
    public static String DEV_TAG = "dev";
    public static String DELTADEV_TAG = "deltadev";
    public static String VALIDATEDEV_TAG = "validatedev";
    public static String BEST_WEIGHTS_EPOCH_NUM_TAG = "bestEpoch";
    public static String ACCURACY_TAG = "accuracy";
    public static String XTPROPS_TAG = "xtprops";
    public static String NODENAME_TAG = "nodename";
    public static String NODEID_TAG = "nodeID";
    public static String METADATA_TAG = "metadata";
    public static String FITTEDMODEL_TAG = "fittedModel";
    public static String CURRENT_WEIGHTS_TAG = "currentWeights";
    public static String SEARCH_COMPLETE_TAG = "searchComplete";
    public static String IS_REGRESSION_TAG = "isRegression";
    public static final int NNET_NO_TERMINATE = 0;
    public static final int NNET_TERMINATE_WITH_BEST = 1;
    public static final int NNET_TERMINATE_WITH_LAST = 2;
    public static final int NNET_TERMINATE_WITH_SAVED = 3;
    private static Hashtable EMPTY_DATA = null;

    public NeuralNetworkExecViewer() {
        this.m_frame.showGraph();
    }

    public void show() {
        if (EMPTY_DATA == null) {
            EMPTY_DATA = new Hashtable();
            EMPTY_DATA.put(DEV_TAG, "0");
            EMPTY_DATA.put(VALIDATEDEV_TAG, "0");
            EMPTY_DATA.put(BEST_WEIGHTS_EPOCH_NUM_TAG, "0");
            EMPTY_DATA.put(EPOCH_TAG, "0");
            EMPTY_DATA.put(SEARCH_COMPLETE_TAG, new Boolean(false));
        }
        this.appendData(EMPTY_DATA);
        this.m_frame.initializeDialog();
        this.m_frame.showGraph();
    }

    public void appendData(Hashtable h) {
        try {
            this.m_frame.updateGUI(h);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void updateLabels() {
        try {
            this.m_frame.updateLabels();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void loadFinalWeights(String XML) {
        try {
            this.m_frame.loadFinalWeights(XML);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void closeExecViewer() {
    }

    public void setNodeName(String nodeName) {
        this.m_nodeName = nodeName;
        this.m_frame.setViewerTitle(nodeName);
    }

    public void setNodeID(String nodeID) {
        this.m_nodeID = nodeID;
        this.m_frame.setNodeId(nodeID);
    }

    public void setWorksheetID(String worksheetID) {
        this.m_worksheetID = worksheetID;
        this.m_frame.setWorksheetId(worksheetID);
    }

    public void setNeuralNetProps(Hashtable nodeData) {
        XTProps nodeProps = (XTProps)nodeData.get(XTPROPS_TAG);
        XTMetaData metadata = (XTMetaData)nodeData.get(METADATA_TAG);
        XMLTree fitted = (XMLTree)nodeData.get(FITTEDMODEL_TAG);
        this.m_metadata = metadata;
        this.m_nodeProps = nodeProps;
        this.m_frame.setConfigData(nodeProps, metadata, fitted);
    }

    public void setIsRegression(boolean b) {
        this.m_frame.setIsRegression(b);
    }

    public void setTerminateOption(int opt) {
        switch (opt) {
            case 1: {
                this.m_terminateOption = opt;
                break;
            }
            case 2: {
                this.m_terminateOption = opt;
                break;
            }
            case 3: {
                this.m_terminateOption = opt;
                break;
            }
            default: {
                this.m_terminateOption = 0;
            }
        }
    }

    public int getTerminateOption() {
        return this.m_terminateOption;
    }

    public boolean isWeightsRequested() {
        return this.m_weightArrayRequested;
    }

    public void setWeightsRequested(boolean b) {
        this.m_weightArrayRequested = b;
    }

    public String getSaveWeightsFile() {
        return this.m_saveWeightsFile;
    }

    public void setSaveWeightsFile(String s) {
        this.m_saveWeightsFile = s;
    }

    public String getSaveBestWeightsFile() {
        return this.m_bestWeightsFile;
    }

    public void setSaveBestWeightsFile(String file) {
        this.m_bestWeightsFile = file;
    }

    public boolean isJitterbWeightsRequested() {
        return this.m_jitter;
    }

    public String getRetrieveWeightsFile() {
        return this.m_retrieveWeightsFile;
    }

    public void setRetrieveWeightsFile(String s) {
        this.m_retrieveWeightsFile = s;
    }

    public void setJitterWeightsFlag(boolean b) {
        this.m_jitter = b;
    }
}

