/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.miner.AcceleratorOptionPane;
import com.insightful.miner.MinerApp;
import com.insightful.miner.NodeDialog;
import com.insightful.miner.OutlierDetectionEngineNode;
import com.insightful.miner.XTMetaData;
import com.insightful.miner.XTProps;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class OutlierDetectionDialog
extends NodeDialog {
    private NodeDialog.SortingScrollPane availableScrollPane;
    private NodeDialog.SortingScrollPane selectedScrollPane;
    private NodeDialog.DNDList availableList;
    private NodeDialog.DNDListModel availableListModel;
    private NodeDialog.DNDList selectedList;
    private NodeDialog.DNDListModel selectedListModel;
    private JComboBox factorComboBox;
    private JCheckBox copyInputsCheckBox;
    private JCheckBox outlierDistanceCheckBox;
    private JCheckBox outlierIndexCheckBox;
    private JCheckBox outlierStateCheckBox;
    private JTextField thresholdTextField;
    private JRadioButton[] outputRowsButtons;
    private static String[] outputRowTypes = new String[]{OutlierDetectionEngineNode.ALL_ROWS_ATTRIBUTE_TAG, OutlierDetectionEngineNode.NON_OUTLIER_ROWS_ATTRIBUTE_TAG, OutlierDetectionEngineNode.OUTLIER_ROWS_ATTRIBUTE_TAG};
    private static String thresholdDefault = "0.99";
    private AbstractAction addAction;
    private AbstractAction removeAction;
    private static OutlierDetectionDialog instance = null;

    public static OutlierDetectionDialog getInstance() {
        if (instance == null) {
            instance = new OutlierDetectionDialog();
        }
        return instance;
    }

    private OutlierDetectionDialog() {
        this.setSize(400, 400);
        this.setMinimumSize(new Dimension(400, 400));
        this.setResizable(true);
    }

    public void restoreProperties() {
        XTMetaData metaData;
        super.restoreProperties();
        this.availableListModel.removeAllElements();
        this.selectedListModel.removeAllElements();
        this.factorComboBox.removeAllItems();
        this.factorComboBox.addItem("");
        XTProps props = this.getNodeModel().getXTProps();
        Vector propNames = props.getSubProperties(OutlierDetectionEngineNode.SELECTED_COLUMNS_ATTRIBUTE_TAG);
        try {
            metaData = this.getNodeModel().getInputMetaData(0);
        }
        catch (Exception e) {
            AcceleratorOptionPane.showOKDialog(this, MinerApp.getText("NodeDialog_cannotRestoreProperties"), MinerApp.getText("NodeDialog_propertiesNotRestored"), 0);
            e.printStackTrace();
            return;
        }
        Vector names = metaData.getColumnNames();
        Vector types = metaData.getColumnTypes();
        Vector roles = metaData.getColumnRoles();
        for (int i = 0; i < names.size(); ++i) {
            String name = (String)names.get(i);
            String type = (String)types.get(i);
            String role = (String)roles.get(i);
            if (type.equals(XTMetaData.CONTINUOUS_TYPE_ATTRIBUTE_TAG)) {
                NodeDialog.ColumnInformationObject info = new NodeDialog.ColumnInformationObject(name, type, role, false, i);
                if (propNames.contains(name)) {
                    this.selectedListModel.addElement(info);
                    continue;
                }
                this.availableListModel.addElement(info);
                continue;
            }
            if (!type.equals(XTMetaData.CATEGORICAL_TYPE_ATTRIBUTE_TAG)) continue;
            this.factorComboBox.addItem(name);
        }
        String factor = props.getValue(OutlierDetectionEngineNode.FACTOR_COLUMN_ATTRIBUTE_TAG, (String)this.factorComboBox.getItemAt(0));
        this.factorComboBox.setSelectedItem(factor);
        this.outlierDistanceCheckBox.setSelected(props.getBoolean(OutlierDetectionEngineNode.OUTPUT_OUTLIER_DISTANCE_ATTRIBUTE_TAG, true));
        this.outlierIndexCheckBox.setSelected(props.getBoolean(OutlierDetectionEngineNode.OUTPUT_OUTLIER_INDEX_ATTRIBUTE_TAG, true));
        this.outlierStateCheckBox.setSelected(props.getBoolean(OutlierDetectionEngineNode.OUTPUT_OUTLIER_STATE_ATTRIBUTE_TAG, true));
        this.thresholdTextField.setText(props.getValue(OutlierDetectionEngineNode.OUTLIER_DISTANCE_THRESHOLD_ATTRIBUTE_TAG, thresholdDefault));
        String outputRowsString = props.getValue(OutlierDetectionEngineNode.OUTPUT_ROWS_ATTRIBUTE_TAG, outputRowTypes[0]);
        for (int i = 0; i < outputRowTypes.length; ++i) {
            if (!outputRowsString.equals(outputRowTypes[i])) continue;
            this.outputRowsButtons[i].setSelected(true);
            this.outputRowsButtons[i].doClick();
            break;
        }
        this.copyInputsCheckBox.setSelected(props.getBoolean(OutlierDetectionEngineNode.OUTPUT_COPY_INPUTS_ATTRIBUTE_TAG, true));
    }

    public void saveProperties() throws NodeDialog.DialogException {
        super.saveProperties();
        XTProps props = this.getNodeModel().getXTProps();
        props.removeProperty(new String[]{OutlierDetectionEngineNode.SELECTED_COLUMNS_ATTRIBUTE_TAG});
        NodeDialog.ColumnInformationObject object = null;
        Enumeration selectedColumns = this.selectedListModel.elements();
        while (selectedColumns.hasMoreElements()) {
            object = (NodeDialog.ColumnInformationObject)selectedColumns.nextElement();
            props.set(OutlierDetectionEngineNode.SELECTED_COLUMNS_ATTRIBUTE_TAG, object.getText(), "");
        }
        props.set(OutlierDetectionEngineNode.FACTOR_COLUMN_ATTRIBUTE_TAG, (String)this.factorComboBox.getSelectedItem());
        props.set(OutlierDetectionEngineNode.OUTPUT_OUTLIER_DISTANCE_ATTRIBUTE_TAG, this.outlierDistanceCheckBox.isSelected());
        props.set(OutlierDetectionEngineNode.OUTPUT_OUTLIER_INDEX_ATTRIBUTE_TAG, this.outlierIndexCheckBox.isSelected());
        props.set(OutlierDetectionEngineNode.OUTPUT_OUTLIER_STATE_ATTRIBUTE_TAG, this.outlierStateCheckBox.isSelected());
        props.set(OutlierDetectionEngineNode.OUTLIER_DISTANCE_THRESHOLD_ATTRIBUTE_TAG, this.thresholdTextField.getText());
        for (int i = 0; i < this.outputRowsButtons.length; ++i) {
            if (!this.outputRowsButtons[i].isSelected()) continue;
            props.set(OutlierDetectionEngineNode.OUTPUT_ROWS_ATTRIBUTE_TAG, outputRowTypes[i]);
            break;
        }
        props.set(OutlierDetectionEngineNode.OUTPUT_COPY_INPUTS_ATTRIBUTE_TAG, this.copyInputsCheckBox.isSelected());
    }

    public void createActions() {
        super.createActions();
        this.addAction = new AbstractAction(">>"){

            public void actionPerformed(ActionEvent e) {
                if (!OutlierDetectionDialog.this.availableList.isSelectionEmpty()) {
                    Object[] values = OutlierDetectionDialog.this.availableList.getSelectedValues();
                    int[] indices = OutlierDetectionDialog.this.availableList.getSelectedIndices();
                    OutlierDetectionDialog.this.availableList.getSelectionModel().clearSelection();
                    OutlierDetectionDialog.this.availableListModel.removeListDataListeners();
                    OutlierDetectionDialog.this.selectedListModel.removeListDataListeners();
                    for (int i = 0; i < values.length; ++i) {
                        OutlierDetectionDialog.this.availableListModel.removeElementAt(indices[i] - i);
                        OutlierDetectionDialog.this.selectedListModel.addElement(values[i]);
                    }
                    OutlierDetectionDialog.this.availableListModel.undoRemoveListDataListeners();
                    OutlierDetectionDialog.this.selectedListModel.undoRemoveListDataListeners();
                    OutlierDetectionDialog.this.selectedScrollPane.sort();
                    OutlierDetectionDialog.this.availableListModel.listContentsChanged();
                    OutlierDetectionDialog.this.selectedListModel.listContentsChanged();
                    indices = null;
                    Object var2_2 = null;
                }
            }
        };
        this.removeAction = new AbstractAction("<<"){

            public void actionPerformed(ActionEvent e) {
                if (!OutlierDetectionDialog.this.selectedList.isSelectionEmpty()) {
                    Object[] values = OutlierDetectionDialog.this.selectedList.getSelectedValues();
                    int[] indices = OutlierDetectionDialog.this.selectedList.getSelectedIndices();
                    OutlierDetectionDialog.this.selectedList.getSelectionModel().clearSelection();
                    OutlierDetectionDialog.this.selectedListModel.removeListDataListeners();
                    OutlierDetectionDialog.this.availableListModel.removeListDataListeners();
                    for (int i = 0; i < values.length; ++i) {
                        OutlierDetectionDialog.this.selectedListModel.removeElementAt(indices[i] - i);
                        OutlierDetectionDialog.this.availableListModel.addElement(values[i]);
                    }
                    OutlierDetectionDialog.this.selectedListModel.undoRemoveListDataListeners();
                    OutlierDetectionDialog.this.availableListModel.undoRemoveListDataListeners();
                    OutlierDetectionDialog.this.availableScrollPane.sort();
                    OutlierDetectionDialog.this.selectedListModel.listContentsChanged();
                    OutlierDetectionDialog.this.availableListModel.listContentsChanged();
                    indices = null;
                    Object var2_2 = null;
                }
            }
        };
    }

    public JPanel createOptionsPanel() {
        JPanel selectColumnsPanel = new JPanel(new GridBagLayout());
        selectColumnsPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(MinerApp.getText("OutlierDetectionDialog_selectColumns")), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        JLabel availableLabel = new JLabel(MinerApp.getText("OutlierDetectionDialog_availableColumns"));
        availableLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0));
        this.availableListModel = new NodeDialog.DNDListModel();
        this.availableList = new NodeDialog.DNDList(this.availableListModel);
        NodeDialog.ColumnInformationRenderer renderer = new NodeDialog.ColumnInformationRenderer();
        this.availableList.setCellRenderer(renderer);
        this.availableList.setSelectionMode(2);
        this.availableScrollPane = new NodeDialog.SortingScrollPane(this.availableList);
        this.availableScrollPane.setBorder(BorderFactory.createLoweredBevelBorder());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridheight = 1;
        constraints.gridwidth = 5;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 1;
        constraints.anchor = 17;
        selectColumnsPanel.add((Component)availableLabel, constraints);
        constraints.gridy = 1;
        constraints.gridheight = 10;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        selectColumnsPanel.add((Component)this.availableScrollPane, constraints);
        JButton addButton = new JButton(this.addAction);
        JButton removeButton = new JButton(this.removeAction);
        constraints.gridx = 5;
        constraints.gridheight = 1;
        constraints.gridwidth = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.insets = new Insets(3, 10, 3, 10);
        constraints.fill = 0;
        selectColumnsPanel.add((Component)addButton, constraints);
        constraints.gridy = 2;
        selectColumnsPanel.add((Component)removeButton, constraints);
        JLabel selectedLabel = new JLabel(MinerApp.getText("OutlierDetectionDialog_selectedColumns"));
        selectedLabel.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
        this.selectedListModel = new NodeDialog.DNDListModel();
        this.selectedList = new NodeDialog.DNDList(this.selectedListModel);
        this.selectedList.setCellRenderer(renderer);
        this.selectedList.setSelectionMode(2);
        this.selectedScrollPane = new NodeDialog.SortingScrollPane(this.selectedList);
        this.selectedScrollPane.setBorder(BorderFactory.createLoweredBevelBorder());
        JLabel factorLabel = new JLabel(MinerApp.getText("OutlierDetectionDialog_categoricalColumn"));
        factorLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0));
        this.factorComboBox = new JComboBox();
        factorLabel.setDisplayedMnemonic('g');
        factorLabel.setLabelFor(this.factorComboBox);
        constraints.gridx = 6;
        constraints.gridy = 0;
        constraints.gridheight = 1;
        constraints.gridwidth = 5;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.insets = new Insets(0, 0, 0, 0);
        constraints.anchor = 17;
        constraints.fill = 1;
        selectColumnsPanel.add((Component)selectedLabel, constraints);
        constraints.gridy = 1;
        constraints.gridheight = 8;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        selectColumnsPanel.add((Component)this.selectedScrollPane, constraints);
        constraints.gridy = 9;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.insets = new Insets(10, 0, 0, 0);
        selectColumnsPanel.add((Component)factorLabel, constraints);
        constraints.gridy = 10;
        constraints.insets = new Insets(0, 0, 0, 0);
        selectColumnsPanel.add((Component)this.factorComboBox, constraints);
        return selectColumnsPanel;
    }

    private JPanel getOutputPanel() {
        JPanel outputPanel = new JPanel(new BorderLayout());
        outputPanel.setName(MinerApp.getText("NodeViewer_outputText"));
        outputPanel.add((Component)this.getColumnsPanel(), "Center");
        outputPanel.add((Component)this.getRowsPanel(), "South");
        return outputPanel;
    }

    private JPanel getColumnsPanel() {
        JPanel newColumnsPanel = new JPanel(new GridBagLayout());
        newColumnsPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(MinerApp.getText("OutlierDetectionDialog_newColumns")), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        this.outlierDistanceCheckBox = new JCheckBox(MinerApp.getText("OutlierDetectionDialog_outputOutlierDistance"));
        this.outlierDistanceCheckBox.setMnemonic('d');
        this.outlierStateCheckBox = new JCheckBox(MinerApp.getText("OutlierDetectionDialog_outputOutlierState"));
        this.outlierStateCheckBox.setMnemonic('s');
        this.outlierIndexCheckBox = new JCheckBox(MinerApp.getText("OutlierDetectionDialog_outputOutlierIndex"));
        this.outlierIndexCheckBox.setMnemonic('i');
        JLabel thresholdLabel = new JLabel(MinerApp.getText("OutlierDetectionDialog_outlierDistanceThreshold"));
        this.thresholdTextField = new JTextField();
        thresholdLabel.setDisplayedMnemonic('t');
        thresholdLabel.setLabelFor(this.thresholdTextField);
        this.thresholdTextField.setPreferredSize(new Dimension(75, 20));
        this.thresholdTextField.setMaximumSize(new Dimension(75, 20));
        this.thresholdTextField.setDocument(new NodeDialog.InputDoubleDoc());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 18;
        constraints.gridy = 0;
        constraints.gridx = 0;
        newColumnsPanel.add((Component)this.outlierDistanceCheckBox, constraints);
        ++constraints.gridy;
        newColumnsPanel.add((Component)this.outlierIndexCheckBox, constraints);
        ++constraints.gridy;
        newColumnsPanel.add((Component)this.outlierStateCheckBox, constraints);
        ++constraints.gridy;
        newColumnsPanel.add((Component)thresholdLabel, constraints);
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.insets = new Insets(0, 75, 0, 0);
        constraints.anchor = 12;
        newColumnsPanel.add((Component)this.thresholdTextField, constraints);
        JPanel inputColumnsPanel = new JPanel(new GridBagLayout());
        inputColumnsPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(MinerApp.getText("OutlierDetectionDialog_copyInputColumns")), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        this.copyInputsCheckBox = new JCheckBox(MinerApp.getText("OutlierDetectionDialog_copyAll"));
        this.copyInputsCheckBox.setMnemonic('c');
        GridBagConstraints inputConstraints = new GridBagConstraints();
        inputConstraints.anchor = 18;
        inputConstraints.gridx = 0;
        inputConstraints.weightx = 1.0;
        inputConstraints.weighty = 1.0;
        inputColumnsPanel.add((Component)this.copyInputsCheckBox, inputConstraints);
        JPanel columnsPanel = new JPanel(new BorderLayout());
        columnsPanel.add((Component)newColumnsPanel, "West");
        columnsPanel.add((Component)inputColumnsPanel, "Center");
        return columnsPanel;
    }

    private JPanel getRowsPanel() {
        JPanel rowsPanel = new JPanel(new GridBagLayout());
        rowsPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(MinerApp.getText("OutlierDetectionDialog_rows")), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        ButtonGroup outputRowsGroup = new ButtonGroup();
        this.outputRowsButtons = new JRadioButton[3];
        JRadioButton outputAllRadioButton = new JRadioButton(MinerApp.getText("OutlierDetectionDialog_outputAllInputRows"));
        outputAllRadioButton.setMnemonic('a');
        outputRowsGroup.add(outputAllRadioButton);
        this.outputRowsButtons[0] = outputAllRadioButton;
        JRadioButton outputNonOutlierRadioButton = new JRadioButton(MinerApp.getText("OutlierDetectionDialog_outputNonOutlierRowsOnly"));
        outputNonOutlierRadioButton.setMnemonic('n');
        outputRowsGroup.add(outputNonOutlierRadioButton);
        this.outputRowsButtons[1] = outputNonOutlierRadioButton;
        JRadioButton outputOutlierRadioButton = new JRadioButton(MinerApp.getText("OutlierDetectionDialog_outputOutlierRowsOnly"));
        outputOutlierRadioButton.setMnemonic('u');
        outputRowsGroup.add(outputOutlierRadioButton);
        this.outputRowsButtons[2] = outputOutlierRadioButton;
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 18;
        constraints.weightx = 1.0;
        rowsPanel.add((Component)outputAllRadioButton, constraints);
        constraints.gridy = 1;
        rowsPanel.add((Component)outputNonOutlierRadioButton, constraints);
        constraints.gridy = 2;
        constraints.weighty = 1.0;
        rowsPanel.add((Component)outputOutlierRadioButton, constraints);
        return rowsPanel;
    }

    public Vector createOtherTabs() {
        Vector<JPanel> panels = new Vector<JPanel>();
        panels.add(this.getOutputPanel());
        return panels;
    }
}

