/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.miner.DataCacheRowBuf;
import com.insightful.miner.MatchEngineNode;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Vector;

public class PartialMatchEngineNode
extends MatchEngineNode {
    private static final int LESS_THAN = -1;
    private static final int EXACT_MATCH = 0;
    private static final int PARTIAL_MATCH = 1;
    private static final int GREATER_THAN = 2;
    protected RandomAccessFile m_partialMatchCheckFile = null;
    protected DataCacheRowBuf m_partialMatchCheckBuf = null;
    protected byte[] m_partialMatchCheckData = null;

    protected int compareCell(DataCacheRowBuf preBuf, DataCacheRowBuf preBuf2, Vector[] levels, Vector[] levels2, int in1, int in2) {
        if (preBuf.isNA(in1)) {
            if (preBuf2.isNA(in2)) {
                return 0;
            }
            return -1;
        }
        if (preBuf2.isNA(in2)) {
            return 2;
        }
        if (preBuf.isString(in1) && preBuf2.isString(in2)) {
            String str2;
            String str1 = preBuf.getString(in1);
            int comp = str1.compareTo(str2 = preBuf2.getString(in2));
            if (comp == 0) {
                return 0;
            }
            if (str2.startsWith(str1)) {
                return 1;
            }
            if (comp < 0) {
                return -1;
            }
            return 2;
        }
        return -1;
    }

    protected int compareRow(DataCacheRowBuf preBuf, DataCacheRowBuf preBuf2, Vector[] levels, Vector[] levels2, int[] in2toIn1) {
        int ret = 0;
        for (int i = 0; i < in2toIn1.length; ++i) {
            int in2 = i;
            int in1 = in2toIn1[i];
            if (in1 == -1) continue;
            int comp = this.compareCell(preBuf, preBuf2, levels, levels2, in2, in2);
            if (comp == -1 || comp == 2) {
                return comp;
            }
            if (comp != 1) continue;
            ret = 1;
        }
        return ret;
    }

    protected RandomAccessFile getPartialMatchCheckFile() {
        if (this.m_partialMatchCheckFile == null) {
            try {
                this.m_partialMatchCheckFile = new RandomAccessFile(this.m_sortedFile2, "r");
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        }
        return this.m_partialMatchCheckFile;
    }

    protected DataCacheRowBuf getPartialMatchCheckBuf() {
        if (this.m_partialMatchCheckBuf == null) {
            this.m_partialMatchCheckBuf = new DataCacheRowBuf(this.m_sortedMD);
        }
        return this.m_partialMatchCheckBuf;
    }

    protected byte[] getPartialMatchCheckData() {
        if (this.m_partialMatchCheckData == null) {
            this.m_partialMatchCheckData = new byte[this.getPartialMatchCheckBuf().getBytesPerRow()];
        }
        return this.m_partialMatchCheckData;
    }

    protected boolean isMatch(int comparisonVal, DataCacheRowBuf preBuf, long rowNum2, int[] in2toIn1) {
        if (comparisonVal == 0) {
            return true;
        }
        if (comparisonVal == 1) {
            RandomAccessFile raf = this.getPartialMatchCheckFile();
            DataCacheRowBuf dcrb = this.getPartialMatchCheckBuf();
            byte[] bytes = this.getPartialMatchCheckData();
            int numBytes = dcrb.getBytesPerRow();
            if (rowNum2 != 0L) {
                try {
                    raf.seek((rowNum2 - 1L) * (long)numBytes);
                    raf.read(bytes, 0, numBytes);
                    dcrb.setData(bytes, 0);
                    if (this.compareRow(preBuf, dcrb, null, null, in2toIn1) == 1) {
                        return false;
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (rowNum2 != this.m_sortedMD2.getNumRows() - 1L) {
                try {
                    raf.seek((rowNum2 + 1L) * (long)numBytes);
                    raf.read(bytes, 0, numBytes);
                    dcrb.setData(bytes, 0);
                    if (this.compareRow(preBuf, dcrb, null, null, in2toIn1) == 1) {
                        return false;
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            return true;
        }
        return false;
    }

    protected boolean isGreaterThan(int comparisonVal) {
        return comparisonVal == 2;
    }
}

