/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.miner.ActivityNodeArea;
import com.insightful.miner.ActivityNodeComputed;
import com.insightful.miner.ActivityNodeModel;
import com.insightful.miner.BaseNodeArea;
import com.insightful.miner.MinerApp;
import com.insightful.miner.NodeDialog;
import com.insightful.miner.PMMLExportable;
import com.insightful.miner.PredictEngineNode;
import com.insightful.miner.PredictNodeModel;
import com.insightful.miner.SetSurvivalRolesPanel;
import com.insightful.miner.WorksheetDocument;
import com.insightful.miner.WorksheetPropertiesPanel;
import com.insightful.miner.XMLTree;
import com.insightful.miner.XTMetaData;
import com.insightful.miner.XTNetwork;
import com.insightful.miner.XTProps;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.table.DefaultTableModel;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class PredictionPanel
extends JPanel {
    private ActivityNodeModel model;
    private CardLayout upperLeftPanelCardLayout;
    private JPanel upperLeftPanel;
    private CardLayout upperRightPanelCardLayout;
    private JPanel upperRightPanel;
    private int modelType;
    public static final String[] modelTypes = new String[]{"Regression", "Classification", "Clustering", "Dimension Reduction", "Survival"};
    public static final int REGRESSION = 0;
    public static final int CLASSIFICATION = 1;
    public static final int CLUSTERING = 2;
    public static final int DIMENSION_REDUCTION = 3;
    public static final int SURVIVAL = 4;
    public static final String UNKNOWN_LEVEL_USER_ITEM_NAN = MinerApp.getText("PredictionPanel_unknownLevelItemNAN");
    public static final String UNKNOWN_LEVEL_USER_ITEM_GENERATE_ERROR = MinerApp.getText("PredictionPanel_unknownLevelItemGenerateError");
    private JCheckBox fittedValuesCheckBox;
    private JCheckBox residualsCheckBox;
    private JCheckBox probabilityCheckBox;
    private JRadioButton[] probabilityButtons;
    private JRadioButton lastCategoryRadioButton;
    private JRadioButton specifiedCategoryRadioButton;
    private JRadioButton allCategoriesRadioButton;
    private JComboBox specifiedCategoryComboBox;
    private boolean allCategoriesAllowed = false;
    private String[] probabilityForStrings = new String[]{"forLastCategory", "forSpecifiedCategory", "allCategories"};
    private JCheckBox classificationCheckBox;
    private JCheckBox agreementCheckBox;
    private JCheckBox clusterMembershipCheckBox;
    private JCheckBox distanceToCenterCheckBox;
    private JCheckBox scoresCheckBox;
    private JCheckBox independentCheckBox;
    private JCheckBox dependentCheckBox;
    private JCheckBox variablesCheckBox;
    private JCheckBox otherCheckBox;
    private JCheckBox clusterColumnsCheckBox;
    private JCheckBox otherClusterCheckBox;
    private JCheckBox otherPrincipalCompCheckBox;
    private JCheckBox riskCheckBox;
    private JCheckBox survCheckBox;
    private JCheckBox survIndependentCheckBox;
    private JCheckBox survDependentCheckBox;
    private JCheckBox survOtherCheckBox;
    private JRadioButton survTimeRadioButton;
    private JRadioButton survTimeColumnRadioButton;
    private JComboBox survTimeColumnComboBox;
    private JTextField survTimeTextField;
    private boolean predictionNode;
    private ModelPanel modelSelPanel;
    private JTable unknownTable;
    private PredictionTableModel unknownTableModel;
    private AbstractAction probabilityAction;
    private AbstractAction lastCategoryAction;
    private AbstractAction specifiedCategoryAction;
    private AbstractAction allCategoriesAction;
    private AbstractAction survivalAction;
    private AbstractAction survTimeAction;
    private AbstractAction survTimeColumnAction;

    public PredictionPanel() {
        this(false);
    }

    public PredictionPanel(boolean predictionNode) {
        this.predictionNode = predictionNode;
        this.setName(MinerApp.getText("PredictionPanel_prediction"));
        this.createActions();
        this.createLayout();
    }

    private void restorePanels(ActivityNodeModel model, int modelType) {
        XTProps props = model.getXTProps();
        String[] twoStringPath = new String[]{"", ""};
        switch (modelType) {
            case 0: {
                twoStringPath[0] = "newColumns";
                twoStringPath[1] = "fittedValues";
                this.fittedValuesCheckBox.setSelected(props.getBoolean(twoStringPath, true));
                twoStringPath[1] = "residuals";
                this.residualsCheckBox.setSelected(props.getBoolean(twoStringPath, false));
                twoStringPath[0] = "copyInputColumns";
                twoStringPath[1] = "independent";
                this.independentCheckBox.setSelected(props.getBoolean(twoStringPath, false));
                twoStringPath[1] = "dependent";
                this.dependentCheckBox.setSelected(props.getBoolean(twoStringPath, true));
                twoStringPath[1] = "other";
                this.otherCheckBox.setSelected(props.getBoolean(twoStringPath, false));
                this.upperLeftPanelCardLayout.show(this.upperLeftPanel, modelTypes[0]);
                this.upperRightPanelCardLayout.show(this.upperRightPanel, modelTypes[0]);
                break;
            }
            case 1: {
                twoStringPath[0] = "newColumns";
                twoStringPath[1] = "probability";
                boolean outputProb = props.getBoolean(twoStringPath, true);
                this.probabilityCheckBox.setSelected(outputProb);
                twoStringPath[1] = "probabilityFor";
                String probabilityForString = props.getValue(twoStringPath, "forLastCategory");
                for (int i = 0; i < this.probabilityForStrings.length; ++i) {
                    if (!this.probabilityForStrings[i].equals(probabilityForString)) continue;
                    this.probabilityButtons[i].setSelected(true);
                }
                String dependentString = null;
                XTMetaData fittedModelMD = PredictNodeModel.getFittedModelMetaData(model);
                if (fittedModelMD != null) {
                    dependentString = PredictEngineNode.getFirstDependentVar(props, fittedModelMD);
                } else {
                    Vector propNames = props.getSubProperties("columnRoles");
                    Vector propRoles = props.getSubPropertyValues("columnRoles");
                    for (int i = 0; i < propRoles.size(); ++i) {
                        if (!((String)propRoles.get(i)).equals(XTMetaData.DEPENDENT_ROLE_ATTRIBUTE_TAG)) continue;
                        dependentString = (String)propNames.get(i);
                        break;
                    }
                }
                this.dependentChanged(dependentString);
                this.lastCategoryRadioButton.setEnabled(outputProb);
                this.specifiedCategoryRadioButton.setEnabled(outputProb);
                this.allCategoriesAllowed = model instanceof PredictNodeModel;
                this.allCategoriesRadioButton.setEnabled(outputProb && this.allCategoriesAllowed);
                twoStringPath[1] = "specifiedCategory";
                String specifiedCategoryString = props.getValue(twoStringPath, "");
                int length = this.specifiedCategoryComboBox.getItemCount();
                if (this.probabilityButtons[1].isSelected()) {
                    int i;
                    boolean found = false;
                    for (i = 0; i < length; ++i) {
                        if (!specifiedCategoryString.equals(this.specifiedCategoryComboBox.getItemAt(i))) continue;
                        this.specifiedCategoryComboBox.setSelectedIndex(i);
                        found = true;
                        break;
                    }
                    if (!found) {
                        this.specifiedCategoryComboBox.addItem(specifiedCategoryString);
                        for (i = 0; i < length + 1; ++i) {
                            if (!specifiedCategoryString.equals(this.specifiedCategoryComboBox.getItemAt(i))) continue;
                            this.specifiedCategoryComboBox.setSelectedIndex(i);
                            break;
                        }
                    }
                    this.specifiedCategoryComboBox.setEnabled(outputProb);
                } else if (this.probabilityButtons[0].isSelected()) {
                    if (length > 0) {
                        this.specifiedCategoryComboBox.setSelectedIndex(length - 1);
                    }
                    this.specifiedCategoryComboBox.setEnabled(false);
                } else {
                    this.specifiedCategoryComboBox.setEnabled(outputProb);
                }
                twoStringPath[1] = "classification";
                this.classificationCheckBox.setSelected(props.getBoolean(twoStringPath, true));
                twoStringPath[1] = "agreement";
                this.agreementCheckBox.setSelected(props.getBoolean(twoStringPath, false));
                twoStringPath[0] = "copyInputColumns";
                twoStringPath[1] = "independent";
                this.independentCheckBox.setSelected(props.getBoolean(twoStringPath, false));
                twoStringPath[1] = "dependent";
                this.dependentCheckBox.setSelected(props.getBoolean(twoStringPath, true));
                twoStringPath[1] = "other";
                this.otherCheckBox.setSelected(props.getBoolean(twoStringPath, false));
                this.upperLeftPanelCardLayout.show(this.upperLeftPanel, modelTypes[1]);
                this.upperRightPanelCardLayout.show(this.upperRightPanel, modelTypes[0]);
                break;
            }
            case 2: {
                twoStringPath[0] = "newColumns";
                twoStringPath[1] = "clusterMembership";
                this.clusterMembershipCheckBox.setSelected(props.getBoolean(twoStringPath, true));
                twoStringPath[1] = "distanceToCenter";
                this.distanceToCenterCheckBox.setSelected(props.getBoolean(twoStringPath, false));
                twoStringPath[0] = "copyInputColumns";
                twoStringPath[1] = "clusterColumns";
                this.clusterColumnsCheckBox.setSelected(props.getBoolean(twoStringPath, true));
                twoStringPath[1] = "clusterOther";
                this.otherClusterCheckBox.setSelected(props.getBoolean(twoStringPath, false));
                this.upperLeftPanelCardLayout.show(this.upperLeftPanel, modelTypes[2]);
                this.upperRightPanelCardLayout.show(this.upperRightPanel, modelTypes[2]);
                break;
            }
            case 3: {
                twoStringPath[0] = "newColumns";
                twoStringPath[1] = "scores";
                this.scoresCheckBox.setSelected(props.getBoolean(twoStringPath, true));
                twoStringPath[1] = "featureVariables";
                this.variablesCheckBox.setSelected(props.getBoolean(twoStringPath, false));
                twoStringPath[0] = "copyInputColumns";
                twoStringPath[1] = "other";
                this.otherPrincipalCompCheckBox.setSelected(props.getBoolean(twoStringPath, false));
                this.upperLeftPanelCardLayout.show(this.upperLeftPanel, modelTypes[3]);
                this.upperRightPanelCardLayout.show(this.upperRightPanel, modelTypes[3]);
                break;
            }
            case 4: {
                this.survTimeColumnComboBox.removeAllItems();
                this.survTimeColumnComboBox.addItem("");
                twoStringPath[0] = "newColumns";
                twoStringPath[1] = "risk";
                this.riskCheckBox.setSelected(props.getBoolean(twoStringPath, true));
                XTMetaData metaData = null;
                try {
                    metaData = model.getInputMetaData(0);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return;
                }
                Vector names = metaData.getColumnNames();
                Iterator it = names.iterator();
                String sTimeDef = "";
                twoStringPath[0] = "columnRoles";
                String[] threeStringPath = new String[]{"columnRoles", "roleSpecials", ""};
                while (it.hasNext()) {
                    String val = (String)it.next();
                    if (!metaData.isContinuousColumn(val) && !metaData.isDateTimeColumn(val)) continue;
                    this.survTimeColumnComboBox.addItem(val);
                    twoStringPath[1] = val;
                    if (!props.getValue(twoStringPath).equals("dependent")) continue;
                    threeStringPath[2] = val;
                    if (!props.getValue(threeStringPath).equals(SetSurvivalRolesPanel.TIME1_ROLE_ATTRIBUTE_TAG)) continue;
                    sTimeDef = val;
                }
                twoStringPath[0] = "newColumns";
                twoStringPath[1] = "survival";
                String survType = props.getValue(twoStringPath, "none");
                twoStringPath[1] = "survivalType";
                this.survCheckBox.setSelected(!(survType = props.getValue(twoStringPath, survType)).equals("none"));
                threeStringPath[0] = "newColumns";
                threeStringPath[1] = "survival";
                threeStringPath[2] = "survivalTimeColumn";
                String sTime = props.getValue(threeStringPath, "");
                if (!(model instanceof PredictNodeModel) && sTime.length() == 0) {
                    sTime = sTimeDef;
                }
                this.survTimeColumnComboBox.setSelectedItem(sTime);
                threeStringPath[2] = "survivalTime";
                this.survTimeTextField.setText(props.getValue(threeStringPath, ""));
                boolean sel = survType.equals("column");
                this.survTimeColumnRadioButton.setSelected(sel);
                this.survTimeRadioButton.setSelected(!sel);
                this.survivalAction.actionPerformed(new ActionEvent(this.survCheckBox, 0, "", 0));
                twoStringPath[0] = "copyInputColumns";
                twoStringPath[1] = "independent";
                this.independentCheckBox.setSelected(props.getBoolean(twoStringPath, false));
                twoStringPath[1] = "dependent";
                this.dependentCheckBox.setSelected(props.getBoolean(twoStringPath, true));
                twoStringPath[1] = "other";
                this.otherCheckBox.setSelected(props.getBoolean(twoStringPath, false));
                this.upperLeftPanelCardLayout.show(this.upperLeftPanel, modelTypes[4]);
                this.upperRightPanelCardLayout.show(this.upperRightPanel, modelTypes[0]);
            }
        }
    }

    private void unknownTableSave(ActivityNodeModel model, int modelType) {
        if (this.predictionNode) {
            XTProps props = model.getXTProps();
            props.removeProperty(new String[]{"unknownLevelSubs"});
            String[] path = new String[]{"unknownLevelSubs", ""};
            for (int i = 0; i < this.unknownTableModel.getRowCount(); ++i) {
                path[1] = (String)this.unknownTableModel.getValueAt(i, 0);
                String val = (String)this.unknownTableModel.getValueAt(i, 1);
                if (val == null || val.equals(UNKNOWN_LEVEL_USER_ITEM_NAN)) continue;
                if (val.equals(UNKNOWN_LEVEL_USER_ITEM_GENERATE_ERROR)) {
                    props.set(path, "unknownLevelGenerateError");
                    continue;
                }
                props.set(path, val);
            }
        }
    }

    private void unknownTableRestore(ActivityNodeModel model, int modelType) {
        try {
            if (this.predictionNode) {
                this.unknownTableModel.clearTable();
                XTMetaData metaData = PredictNodeModel.getFittedModelMetaData(model);
                if (metaData == null) {
                    return;
                }
                XTProps props = model.getXTProps();
                Vector indepVars = PredictNodeModel.getIndependentVariables(model);
                if (indepVars.size() == 0) {
                    indepVars = metaData.getDataFieldsWithRole(XTMetaData.INDEPENDENT_ROLE_ATTRIBUTE_TAG);
                }
                HashMap<String, Vector> map = new HashMap<String, Vector>(indepVars.size());
                String[] path = new String[]{"unknownLevelSubs", ""};
                Object[] rowData = new String[]{"", ""};
                for (int i = 0; i < indepVars.size(); ++i) {
                    path[1] = (String)indepVars.get(i);
                    if (!metaData.isCategoricalColumn(path[1])) continue;
                    Vector levels = metaData.getCategoricalDataFieldLevels(path[1]);
                    Collections.sort(levels);
                    levels.insertElementAt(UNKNOWN_LEVEL_USER_ITEM_NAN, 0);
                    levels.insertElementAt(UNKNOWN_LEVEL_USER_ITEM_GENERATE_ERROR, 1);
                    String selectedValue = props.getValue(path, null);
                    if (selectedValue == null || selectedValue.equals("unknownLevelNAN")) {
                        selectedValue = UNKNOWN_LEVEL_USER_ITEM_NAN;
                    } else if (selectedValue.equals("unknownLevelGenerateError")) {
                        selectedValue = UNKNOWN_LEVEL_USER_ITEM_GENERATE_ERROR;
                    }
                    rowData[0] = path[1];
                    rowData[1] = selectedValue;
                    this.unknownTableModel.addRow(rowData);
                    map.put(path[1], levels);
                }
                UnknownTableEditor editor = new UnknownTableEditor(map, this.unknownTable);
                this.unknownTable.getColumnModel().getColumn(1).setCellEditor(editor);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void unknownLabelSelectAll() {
        if (this.unknownTable.getRowCount() > 0) {
            this.unknownTable.selectAll();
        }
    }

    public void unknownLabelSetNAN() {
        this.unknownLabelSetSelectedColumns(UNKNOWN_LEVEL_USER_ITEM_NAN);
    }

    public void unknownLabelSetGenerateError() {
        this.unknownLabelSetSelectedColumns(UNKNOWN_LEVEL_USER_ITEM_GENERATE_ERROR);
    }

    public void unknownLabelSetSelectedColumns(String newVal) {
        int[] rows = this.unknownTable.getSelectedRows();
        for (int i = 0; i < rows.length; ++i) {
            this.unknownTable.setValueAt(newVal, rows[i], 1);
        }
        this.unknownTable.repaint();
    }

    private void predictModelRestore(ActivityNodeModel model) {
        if (this.predictionNode) {
            this.modelSelPanel.predictModelRestore(model);
        }
    }

    public void restoreProperties(ActivityNodeModel model, int modelType) {
        this.model = model;
        this.modelType = modelType;
        this.restorePanels(model, modelType);
        this.predictModelRestore(model);
        this.unknownTableRestore(model, modelType);
    }

    public void saveProperties(ActivityNodeModel model, int modelType) throws NodeDialog.DialogException {
        XTProps props = model.getXTProps();
        this.unknownTableSave(model, modelType);
        switch (modelType) {
            case 0: {
                props.set("newColumns", "fittedValues", this.fittedValuesCheckBox.isSelected());
                props.set("newColumns", "residuals", this.residualsCheckBox.isSelected());
                props.set("copyInputColumns", "independent", this.independentCheckBox.isSelected());
                props.set("copyInputColumns", "dependent", this.dependentCheckBox.isSelected());
                props.set("copyInputColumns", "other", this.otherCheckBox.isSelected());
                break;
            }
            case 1: {
                if (this.probabilityButtons[1].isSelected() && (this.specifiedCategoryComboBox.getSelectedItem() == null || ((String)this.specifiedCategoryComboBox.getSelectedItem()).equals(""))) {
                    throw new NodeDialog.DialogException(MinerApp.getText("PredictionPanel_errorMessage"));
                }
                props.set("newColumns", "probability", this.probabilityCheckBox.isSelected());
                String probabilityForString = "";
                for (int i = 0; i < this.probabilityButtons.length; ++i) {
                    if (!this.probabilityButtons[i].isSelected()) continue;
                    probabilityForString = this.probabilityForStrings[i];
                }
                props.set("newColumns", "probabilityFor", probabilityForString);
                props.set("newColumns", "specifiedCategory", (String)this.specifiedCategoryComboBox.getSelectedItem());
                props.set("newColumns", "classification", this.classificationCheckBox.isSelected());
                props.set("newColumns", "agreement", this.agreementCheckBox.isSelected());
                props.set("copyInputColumns", "independent", this.independentCheckBox.isSelected());
                props.set("copyInputColumns", "dependent", this.dependentCheckBox.isSelected());
                props.set("copyInputColumns", "other", this.otherCheckBox.isSelected());
                break;
            }
            case 2: {
                props.set("newColumns", "clusterMembership", this.clusterMembershipCheckBox.isSelected());
                props.set("newColumns", "distanceToCenter", this.distanceToCenterCheckBox.isSelected());
                props.set("copyInputColumns", "clusterColumns", this.clusterColumnsCheckBox.isSelected());
                props.set("copyInputColumns", "clusterOther", this.otherClusterCheckBox.isSelected());
                break;
            }
            case 3: {
                props.set("newColumns", "scores", this.scoresCheckBox.isSelected());
                props.set("copyInputColumns", "featureVariables", this.variablesCheckBox.isSelected());
                props.set("copyInputColumns", "other", this.otherPrincipalCompCheckBox.isSelected());
                break;
            }
            case 4: {
                props.set("newColumns", "risk", this.riskCheckBox.isSelected());
                String survType = "none";
                if (this.survCheckBox.isSelected()) {
                    survType = this.survTimeColumnRadioButton.isSelected() ? "column" : "time";
                }
                props.set("newColumns", "survival", survType);
                String[] path = new String[]{"newColumns", "survival", "survivalTime"};
                props.set(path, this.survTimeTextField.getText());
                path[2] = "survivalTimeColumn";
                props.set(path, (String)this.survTimeColumnComboBox.getSelectedItem());
                props.set("copyInputColumns", "independent", this.independentCheckBox.isSelected());
                props.set("copyInputColumns", "dependent", this.dependentCheckBox.isSelected());
                props.set("copyInputColumns", "other", this.otherCheckBox.isSelected());
            }
        }
    }

    public void dependentChanged(String newDependent) {
        this.dependentChanged(this.specifiedCategoryComboBox, newDependent);
    }

    public void dependentChanged(JComboBox cb, String newDependent) {
        if (this.modelType == 1) {
            XTMetaData metaData = null;
            try {
                metaData = PredictNodeModel.getFittedModelMetaData(this.model);
                if (!this.predictionNode && metaData == null) {
                    metaData = this.model.getInputMetaData(0);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                return;
            }
            Vector levels = new Vector();
            cb.removeAllItems();
            if (metaData == null) {
                return;
            }
            if (newDependent != null) {
                levels = metaData.getCategoricalDataFieldLevels(newDependent);
            } else {
                Vector dependents = metaData.getDataFieldsWithRole(XTMetaData.DEPENDENT_ROLE_ATTRIBUTE_TAG);
                if (!dependents.isEmpty()) {
                    levels = metaData.getCategoricalDataFieldLevels((String)dependents.get(0));
                }
            }
            if (levels.isEmpty()) {
                cb.addItem("");
            } else {
                for (int i = 0; i < levels.size(); ++i) {
                    cb.addItem((String)levels.get(i));
                }
                cb.setSelectedIndex(levels.size() - 1);
            }
        }
    }

    public void setEnabledSurvival(boolean bEnable) {
        if (!bEnable) {
            this.survCheckBox.setSelected(false);
        }
        this.survCheckBox.setEnabled(bEnable);
        this.survTimeColumnComboBox.setEnabled(bEnable);
    }

    public void createActions() {
        this.probabilityAction = new AbstractAction(MinerApp.getText("PredictionPanel_probability")){

            public void actionPerformed(ActionEvent e) {
                boolean outputProb = PredictionPanel.this.probabilityCheckBox.isSelected();
                PredictionPanel.this.lastCategoryRadioButton.setEnabled(outputProb);
                PredictionPanel.this.specifiedCategoryRadioButton.setEnabled(outputProb);
                PredictionPanel.this.allCategoriesRadioButton.setEnabled(outputProb && PredictionPanel.this.allCategoriesAllowed);
                PredictionPanel.this.specifiedCategoryComboBox.setEnabled(outputProb && (PredictionPanel.this.probabilityButtons[1].isSelected() || PredictionPanel.this.probabilityButtons[2].isSelected()));
            }
        };
        this.lastCategoryAction = new AbstractAction(MinerApp.getText("PredictionPanel_forLastCategory")){

            public void actionPerformed(ActionEvent e) {
                int length = PredictionPanel.this.specifiedCategoryComboBox.getItemCount();
                if (length > 0) {
                    PredictionPanel.this.specifiedCategoryComboBox.setSelectedIndex(length - 1);
                }
                PredictionPanel.this.specifiedCategoryComboBox.setEnabled(false);
            }
        };
        this.specifiedCategoryAction = new AbstractAction(MinerApp.getText("PredictionPanel_forSpecifiedCategory")){

            public void actionPerformed(ActionEvent e) {
                PredictionPanel.this.specifiedCategoryComboBox.setEnabled(true);
            }
        };
        this.allCategoriesAction = new AbstractAction(MinerApp.getText("PredictionPanel_allCategories")){

            public void actionPerformed(ActionEvent e) {
                PredictionPanel.this.specifiedCategoryComboBox.setEnabled(true);
            }
        };
        this.survivalAction = new AbstractAction(MinerApp.getText("SurvivalDialog_survival_text")){

            public void actionPerformed(ActionEvent e) {
                if (PredictionPanel.this.survCheckBox.isSelected()) {
                    PredictionPanel.this.survTimeRadioButton.setEnabled(true);
                    PredictionPanel.this.survTimeColumnRadioButton.setEnabled(true);
                    if (PredictionPanel.this.survTimeRadioButton.isSelected()) {
                        PredictionPanel.this.survTimeTextField.setEnabled(true);
                        PredictionPanel.this.survTimeColumnComboBox.setEnabled(false);
                    } else {
                        PredictionPanel.this.survTimeTextField.setEnabled(false);
                        PredictionPanel.this.survTimeColumnComboBox.setEnabled(true);
                    }
                    PredictionPanel.this.survCheckBox.transferFocus();
                } else {
                    PredictionPanel.this.survTimeRadioButton.setEnabled(false);
                    PredictionPanel.this.survTimeColumnRadioButton.setEnabled(false);
                    PredictionPanel.this.survTimeTextField.setEnabled(false);
                    PredictionPanel.this.survTimeColumnComboBox.setEnabled(false);
                }
            }
        };
        this.survTimeAction = new AbstractAction(MinerApp.getText("SurvivalDialog_at_time")){

            public void actionPerformed(ActionEvent e) {
                PredictionPanel.this.survTimeTextField.setEnabled(true);
                PredictionPanel.this.survTimeColumnComboBox.setEnabled(false);
                PredictionPanel.this.survTimeRadioButton.transferFocus();
            }
        };
        this.survTimeColumnAction = new AbstractAction(MinerApp.getText("SurvivalDialog_time_column")){

            public void actionPerformed(ActionEvent e) {
                PredictionPanel.this.survTimeTextField.setEnabled(false);
                PredictionPanel.this.survTimeColumnComboBox.setEnabled(true);
                PredictionPanel.this.survTimeColumnRadioButton.transferFocus();
            }
        };
    }

    private void createLayout() {
        JPanel regressionPanel = new JPanel();
        regressionPanel.setLayout(new BoxLayout(regressionPanel, 1));
        this.fittedValuesCheckBox = new JCheckBox(MinerApp.getText("PredictionPanel_fittedValues"));
        this.fittedValuesCheckBox.setMnemonic('f');
        this.residualsCheckBox = new JCheckBox(MinerApp.getText("PredictionPanel_residuals"));
        this.residualsCheckBox.setMnemonic('r');
        regressionPanel.add(this.fittedValuesCheckBox);
        Box.createVerticalStrut(5);
        regressionPanel.add(this.residualsCheckBox);
        JPanel classificationPanel = new JPanel(new GridBagLayout());
        this.probabilityCheckBox = new JCheckBox(this.probabilityAction);
        this.probabilityCheckBox.setMnemonic('p');
        ButtonGroup probabilityGroup = new ButtonGroup();
        this.probabilityButtons = new JRadioButton[3];
        this.lastCategoryRadioButton = new JRadioButton(this.lastCategoryAction);
        this.lastCategoryRadioButton.setMnemonic('f');
        this.lastCategoryRadioButton.setSelected(true);
        probabilityGroup.add(this.lastCategoryRadioButton);
        this.probabilityButtons[0] = this.lastCategoryRadioButton;
        this.specifiedCategoryRadioButton = new JRadioButton(this.specifiedCategoryAction);
        this.specifiedCategoryRadioButton.setMnemonic('s');
        probabilityGroup.add(this.specifiedCategoryRadioButton);
        this.probabilityButtons[1] = this.specifiedCategoryRadioButton;
        this.specifiedCategoryComboBox = new JComboBox();
        this.specifiedCategoryComboBox.setEditable(true);
        this.specifiedCategoryComboBox.setEnabled(false);
        this.allCategoriesRadioButton = new JRadioButton(this.allCategoriesAction);
        this.allCategoriesRadioButton.setMnemonic('g');
        probabilityGroup.add(this.allCategoriesRadioButton);
        this.probabilityButtons[2] = this.allCategoriesRadioButton;
        this.classificationCheckBox = new JCheckBox(MinerApp.getText("PredictionPanel_classification"));
        this.classificationCheckBox.setMnemonic('l');
        this.agreementCheckBox = new JCheckBox(MinerApp.getText("PredictionPanel_agreement"));
        this.agreementCheckBox.setMnemonic('a');
        GridBagConstraints classificationConstraints = new GridBagConstraints();
        classificationConstraints.anchor = 18;
        classificationPanel.add((Component)this.probabilityCheckBox, classificationConstraints);
        classificationConstraints.gridy = 1;
        classificationConstraints.insets = new Insets(0, 15, 0, 0);
        classificationPanel.add((Component)this.lastCategoryRadioButton, classificationConstraints);
        classificationConstraints.gridy = 2;
        classificationPanel.add((Component)this.specifiedCategoryRadioButton, classificationConstraints);
        classificationConstraints.gridy = 3;
        classificationConstraints.insets = new Insets(0, 30, 0, 0);
        classificationPanel.add((Component)this.specifiedCategoryComboBox, classificationConstraints);
        classificationConstraints.gridy = 4;
        classificationConstraints.weightx = 0.0;
        classificationConstraints.insets = new Insets(0, 15, 0, 0);
        classificationPanel.add((Component)this.allCategoriesRadioButton, classificationConstraints);
        classificationConstraints.gridy = 5;
        classificationConstraints.insets = new Insets(0, 0, 0, 0);
        classificationPanel.add((Component)this.classificationCheckBox, classificationConstraints);
        classificationConstraints.gridy = 6;
        classificationConstraints.weightx = 1.0;
        classificationConstraints.weighty = 1.0;
        classificationPanel.add((Component)this.agreementCheckBox, classificationConstraints);
        JPanel clusteringPanel = new JPanel();
        clusteringPanel.setLayout(new BoxLayout(clusteringPanel, 1));
        this.clusterMembershipCheckBox = new JCheckBox(MinerApp.getText("PredictionPanel_clusterMembership"));
        this.clusterMembershipCheckBox.setMnemonic('m');
        this.distanceToCenterCheckBox = new JCheckBox(MinerApp.getText("PredictionPanel_distanceToCenter"));
        this.distanceToCenterCheckBox.setMnemonic('d');
        clusteringPanel.add(this.clusterMembershipCheckBox);
        Box.createVerticalStrut(5);
        clusteringPanel.add(this.distanceToCenterCheckBox);
        JPanel dimensionReductionPanel = new JPanel();
        dimensionReductionPanel.setLayout(new BoxLayout(dimensionReductionPanel, 1));
        this.scoresCheckBox = new JCheckBox(MinerApp.getText("PredictionPanel_scores"));
        this.scoresCheckBox.setMnemonic('s');
        dimensionReductionPanel.add(this.scoresCheckBox);
        this.riskCheckBox = new JCheckBox(MinerApp.getText("SurvivalDialog_risk_text"));
        this.riskCheckBox.setMnemonic('k');
        this.survCheckBox = new JCheckBox(this.survivalAction);
        this.survCheckBox.setMnemonic('s');
        JLabel noteLabel = new JLabel(MinerApp.getText("SurvivalDialog_require_baseline_survival"));
        ButtonGroup survGroup = new ButtonGroup();
        this.survTimeRadioButton = new JRadioButton(this.survTimeAction);
        this.survTimeRadioButton.setSelected(true);
        this.survTimeTextField = new JTextField(10);
        this.survTimeColumnRadioButton = new JRadioButton(this.survTimeColumnAction);
        this.survTimeColumnComboBox = new JComboBox();
        survGroup.add(this.survTimeRadioButton);
        survGroup.add(this.survTimeColumnRadioButton);
        this.survTimeColumnComboBox.setPreferredSize(this.survTimeTextField.getPreferredSize());
        Insets none = new Insets(0, 0, 0, 0);
        Insets idnt = new Insets(0, 10, 0, 0);
        Insets d_idnt = new Insets(0, 20, 0, 0);
        JPanel survivalPanel = new JPanel(new GridBagLayout());
        GridBagConstraints survConstraints = new GridBagConstraints();
        survConstraints.anchor = 18;
        survConstraints.fill = 2;
        survConstraints.gridy = 0;
        survConstraints.gridx = 0;
        survConstraints.weighty = 0.0;
        survConstraints.weightx = 1.0;
        survConstraints.insets = none;
        survivalPanel.add((Component)this.riskCheckBox, survConstraints);
        ++survConstraints.gridy;
        survConstraints.insets = none;
        survivalPanel.add((Component)this.survCheckBox, survConstraints);
        ++survConstraints.gridy;
        survConstraints.insets = idnt;
        survivalPanel.add((Component)noteLabel, survConstraints);
        ++survConstraints.gridy;
        survConstraints.insets = idnt;
        survivalPanel.add((Component)this.survTimeRadioButton, survConstraints);
        ++survConstraints.gridy;
        survConstraints.insets = d_idnt;
        survivalPanel.add((Component)this.survTimeTextField, survConstraints);
        ++survConstraints.gridy;
        survConstraints.insets = idnt;
        survivalPanel.add((Component)this.survTimeColumnRadioButton, survConstraints);
        ++survConstraints.gridy;
        survConstraints.insets = d_idnt;
        survConstraints.weighty = 1.0;
        survivalPanel.add((Component)this.survTimeColumnComboBox, survConstraints);
        this.upperLeftPanel = new JPanel();
        this.upperLeftPanelCardLayout = new CardLayout();
        this.upperLeftPanel.setLayout(this.upperLeftPanelCardLayout);
        this.upperLeftPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(MinerApp.getText("PredictionPanel_newColumns")), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        this.upperLeftPanel.add(modelTypes[0], regressionPanel);
        this.upperLeftPanel.add(modelTypes[1], classificationPanel);
        this.upperLeftPanel.add(modelTypes[2], clusteringPanel);
        this.upperLeftPanel.add(modelTypes[3], dimensionReductionPanel);
        this.upperLeftPanel.add(modelTypes[4], survivalPanel);
        this.upperLeftPanelCardLayout.show(this.upperLeftPanel, modelTypes[0]);
        JPanel defaultLowerPanel = new JPanel();
        defaultLowerPanel.setLayout(new BoxLayout(defaultLowerPanel, 1));
        this.independentCheckBox = new JCheckBox(MinerApp.getText("PredictionPanel_independent"));
        this.independentCheckBox.setMnemonic('i');
        this.dependentCheckBox = new JCheckBox(MinerApp.getText("PredictionPanel_dependent"));
        this.dependentCheckBox.setMnemonic('d');
        this.otherCheckBox = new JCheckBox(MinerApp.getText("PredictionPanel_other"));
        this.otherCheckBox.setMnemonic('t');
        defaultLowerPanel.add(this.independentCheckBox);
        Box.createVerticalStrut(5);
        defaultLowerPanel.add(this.dependentCheckBox);
        Box.createVerticalStrut(5);
        defaultLowerPanel.add(this.otherCheckBox);
        JPanel clusteringLowerPanel = new JPanel();
        clusteringLowerPanel.setLayout(new BoxLayout(clusteringLowerPanel, 1));
        this.clusterColumnsCheckBox = new JCheckBox(MinerApp.getText("PredictionPanel_clusterColumns"));
        this.clusterColumnsCheckBox.setMnemonic('l');
        this.otherClusterCheckBox = new JCheckBox(MinerApp.getText("PredictionPanel_other"));
        this.otherClusterCheckBox.setMnemonic('t');
        clusteringLowerPanel.add(this.clusterColumnsCheckBox);
        Box.createVerticalStrut(5);
        clusteringLowerPanel.add(this.otherClusterCheckBox);
        JPanel dimensionReductionLowerPanel = new JPanel();
        dimensionReductionLowerPanel.setLayout(new BoxLayout(dimensionReductionLowerPanel, 1));
        this.variablesCheckBox = new JCheckBox(MinerApp.getText("PredictionPanel_variables"));
        this.variablesCheckBox.setMnemonic('v');
        dimensionReductionLowerPanel.add(this.variablesCheckBox);
        Box.createVerticalStrut(5);
        this.otherPrincipalCompCheckBox = new JCheckBox(MinerApp.getText("PredictionPanel_other"));
        this.otherPrincipalCompCheckBox.setMnemonic('t');
        dimensionReductionLowerPanel.add(this.otherPrincipalCompCheckBox);
        this.upperRightPanel = new JPanel();
        this.upperRightPanelCardLayout = new CardLayout();
        this.upperRightPanel.setLayout(this.upperRightPanelCardLayout);
        this.upperRightPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(MinerApp.getText("PredictionPanel_copyInputColumns")), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        this.upperRightPanel.add(modelTypes[0], defaultLowerPanel);
        this.upperRightPanel.add(modelTypes[2], clusteringLowerPanel);
        this.upperRightPanel.add(modelTypes[3], dimensionReductionLowerPanel);
        this.upperRightPanelCardLayout.show(this.upperRightPanel, modelTypes[0]);
        this.modelSelPanel = new ModelPanel();
        JButton selectAllButton = WorksheetPropertiesPanel.createButton("PredictionPanel_selectAllButtonLabel", "PredictionPanel_selectAllButtonHotkey", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                PredictionPanel.this.unknownLabelSelectAll();
            }
        });
        JButton setNANButton = WorksheetPropertiesPanel.createButton("PredictionPanel_setNANButtonLabel", "PredictionPanel_setNANButtonHotkey", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                PredictionPanel.this.unknownLabelSetNAN();
            }
        });
        JButton setGenerateErrorButton = WorksheetPropertiesPanel.createButton("PredictionPanel_setGenerateErrorButtonLabel", "PredictionPanel_setGenerateErrorButtonHotkey", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                PredictionPanel.this.unknownLabelSetGenerateError();
            }
        });
        this.createPredictionTable();
        JPanel unknownPanel = new JPanel(new GridBagLayout());
        unknownPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(MinerApp.getText("PredictionPanel_unknownLevelBorderTitle")), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 0;
        gbc.gridheight = 1;
        gbc.weighty = 1.0;
        gbc.weightx = 1.0;
        unknownPanel.add((Component)new JScrollPane(this.unknownTable), gbc);
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.fill = 3;
        gbc.gridy = 1;
        gbc.gridx = 0;
        gbc.weighty = 0.0;
        gbc.weightx = 0.0;
        gbc.insets = new Insets(5, 2, 5, 3);
        unknownPanel.add((Component)selectAllButton, gbc);
        gbc.gridx = 1;
        unknownPanel.add((Component)setNANButton, gbc);
        gbc.gridx = 2;
        unknownPanel.add((Component)setGenerateErrorButton, gbc);
        if (this.predictionNode) {
            JPanel topPanel = new JPanel(new GridLayout(1, 2));
            topPanel.add(this.upperLeftPanel);
            topPanel.add(this.upperRightPanel);
            this.setLayout(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.anchor = 18;
            c.fill = 2;
            c.gridy = 0;
            c.gridx = 0;
            c.weightx = 1.0;
            c.weighty = 0.0;
            c.gridwidth = 0;
            this.add((Component)topPanel, c);
            ++c.gridy;
            c.fill = 1;
            c.weighty = 1.0;
            this.add((Component)unknownPanel, c);
            ++c.gridy;
            c.weighty = 0.0;
            c.fill = 2;
            this.add((Component)this.modelSelPanel, c);
        } else {
            this.setLayout(new GridLayout(1, 2));
            this.add(this.upperLeftPanel);
            this.add(this.upperRightPanel);
        }
    }

    protected void createPredictionTable() {
        Object[] columnNames = new String[]{MinerApp.getText("PredictionPanel_unknownLevelColumnName"), MinerApp.getText("PredictionPanel_unknownLevelAction")};
        this.unknownTableModel = new PredictionTableModel(columnNames, 0);
        this.unknownTable = new JTable(this.unknownTableModel);
        this.unknownTable.setRowHeight(25);
    }

    public static class ModelPanel
    extends JPanel {
        private JLabel modelSourceTextField;
        private JLabel modelDateCreatedTextField;

        public ModelPanel() {
            JLabel modelSourceLabel = new JLabel(MinerApp.getText("PredictionPanel_modelSource"));
            this.modelSourceTextField = new JLabel("");
            JLabel modelDateLabel = new JLabel(MinerApp.getText("PredictionPanel_modelDate"));
            this.modelDateCreatedTextField = new JLabel("");
            Insets noIndent = new Insets(0, 0, 0, 0);
            Insets indent = new Insets(0, 15, 0, 0);
            JPanel modelSelPanel = new JPanel(new GridBagLayout());
            modelSelPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(MinerApp.getText("PredictionPanel_modelSpecification")), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.anchor = 18;
            gbc.fill = 2;
            gbc.weighty = 0.0;
            gbc.weightx = 0.0;
            gbc.gridx = 0;
            gbc.gridy = 0;
            modelSelPanel.add((Component)modelSourceLabel, gbc);
            ++gbc.gridx;
            gbc.weightx = 1.0;
            gbc.insets = indent;
            modelSelPanel.add((Component)this.modelSourceTextField, gbc);
            ++gbc.gridy;
            gbc.gridx = 0;
            gbc.weightx = 0.0;
            gbc.insets = noIndent;
            modelSelPanel.add((Component)modelDateLabel, gbc);
            ++gbc.gridx;
            gbc.weightx = 1.0;
            gbc.insets = indent;
            modelSelPanel.add((Component)this.modelDateCreatedTextField, gbc);
            this.setLayout(new BorderLayout());
            this.add((Component)modelSelPanel, "Center");
        }

        public void predictModelRestore(ActivityNodeModel model) {
            ActivityNodeModel testModel;
            this.modelSourceTextField.setText(MinerApp.getText("PredictionPanel_modelSourceNotFound"));
            XTNetwork.NodeInfo ni = model.getNodeInfo();
            boolean dynamic = ni.model == null;
            int parentID = ni.modelParent == null ? -1 : Integer.parseInt(ni.modelParent);
            XMLTree fitM = dynamic ? null : ni.model.getXMLTree();
            WorksheetDocument doc = model.getDocument();
            BaseNodeArea pArea = doc.findFlatNodeByID(parentID);
            if (pArea instanceof ActivityNodeArea && (testModel = ((ActivityNodeArea)pArea).getNodeModel()) instanceof PMMLExportable) {
                this.modelSourceTextField.setText(testModel.getLabelText());
                if (dynamic && testModel.getState() == ActivityNodeComputed.instance()) {
                    fitM = ((PMMLExportable)((Object)testModel)).getFittedModel();
                }
            }
            if (fitM != null) {
                Node tn;
                Element element = (Element)fitM.getXML().getElementsByTagName("Header").item(0);
                if (element != null && (element = (Element)element.getElementsByTagName("Timestamp").item(0)) != null && (tn = element.getFirstChild()) != null) {
                    String str = tn.getNodeValue().trim();
                    if (str.charAt(0) == '\"') {
                        str = str.substring(1, str.length() - 1);
                    }
                    this.modelDateCreatedTextField.setText(str);
                }
            } else {
                this.modelDateCreatedTextField.setText(MinerApp.getText("PredictionPanel_modelNotFound"));
            }
        }
    }

    public static class UnknownTableEditor
    extends DefaultCellEditor {
        private HashMap levelMap;
        private JTable myOwner;
        private JTextField textField;

        public UnknownTableEditor(HashMap map, JTable owner) {
            super(new JComboBox());
            this.levelMap = map;
            this.myOwner = owner;
            this.textField = new JTextField();
        }

        public void editingCanceled(ChangeEvent e) {
            super.cancelCellEditing();
            this.myOwner.getCellEditor().cancelCellEditing();
        }

        public void editingStopped(ChangeEvent e) {
            super.stopCellEditing();
            this.myOwner.getCellEditor().cancelCellEditing();
        }

        public Component getTableCellEditorComponent(JTable table, Object value, boolean sel, int row, int column) {
            String strVal = (String)table.getValueAt(row, 0);
            Vector levels = (Vector)this.levelMap.get(strVal);
            JComboBox cb = (JComboBox)super.getTableCellEditorComponent(table, strVal, sel, row, column);
            cb.removeAllItems();
            if (levels != null && levels.size() > 0) {
                for (int i = 0; i < levels.size(); ++i) {
                    cb.addItem(levels.get(i));
                }
                cb.setSelectedItem(value.toString());
            }
            cb.setEditable(false);
            return cb;
        }
    }

    private class PredictionTableModel
    extends DefaultTableModel {
        public PredictionTableModel(Object[] cNames, int rows) {
            super(cNames, rows);
        }

        public boolean isCellEditable(int row, int col) {
            return col != 0;
        }

        public void clearTable() {
            this.dataVector.removeAllElements();
            this.fireTableDataChanged();
        }
    }
}

