/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.miner.DataCacheRowBuf;
import com.insightful.miner.EngineNode;
import com.insightful.miner.SortAndShuffle;
import com.insightful.miner.UniqueEngineNode;
import com.insightful.miner.XTMetaData;
import com.insightful.miner.XTProps;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.util.HashMap;
import java.util.Vector;

public class RCDivideEngineNode
extends UniqueEngineNode {
    public static final String VALUE_COLUMN_ATTRIBUTE_TAG = "valueCol";
    public static final String GROUP_COLUMN_ATTRIBUTE_TAG = "groupCol";
    public static final String MEMBERSHIP_ATTRIBUTE_TAG = "membership";
    private HashMap m_levelMap;

    protected void setEqualityColumns(XTProps props, XTMetaData md) {
        String vCol = props.getValue(VALUE_COLUMN_ATTRIBUTE_TAG);
        String gCol = props.getValue(GROUP_COLUMN_ATTRIBUTE_TAG);
        Vector mmbs = props.getSubProperties(MEMBERSHIP_ATTRIBUTE_TAG);
        int numCols = 2;
        this.m_equalityColNames = new String[numCols];
        this.m_equalityColNums = new int[numCols];
        this.m_equalityColNames[0] = vCol;
        this.m_equalityColNums[0] = md.nameToOrdinal(this.m_equalityColNames[0]);
        this.m_equalityColNames[1] = gCol;
        this.m_equalityColNums[1] = md.nameToOrdinal(this.m_equalityColNames[1]);
        this.m_levelMap = new HashMap(mmbs.size());
        for (int i = 0; i < mmbs.size(); ++i) {
            Object lev = mmbs.get(i);
            this.m_levelMap.put(lev, new Integer(i));
        }
    }

    protected boolean handleSort() throws Exception {
        this.m_indexedFile = new File(this.getInputDataCacheFileName(0));
        this.m_indexedBlobFile = new File(this.getNetworkManager().getInputDataBlobFileName(this.getNodeID(), 0));
        this.m_indexedMD = this.getInputMetaData(0);
        this.m_sortedFile = this.createWorkspaceTempFile("sort", "tmp");
        this.m_sortedBlobFile = this.createWorkspaceTempFile("sort", "tmp");
        return this.fileManipulation(this.m_indexedFile, this.m_indexedBlobFile, this.m_indexedMD, this.m_sortedFile, this.m_sortedBlobFile, this.m_indexedMD, 1);
    }

    protected boolean sort() throws Exception {
        boolean[] ascend = new boolean[this.m_equalityColNames.length];
        boolean[] naTop = new boolean[this.m_equalityColNames.length];
        for (int i = 0; i < naTop.length; ++i) {
            naTop[i] = true;
            ascend[i] = true;
        }
        return SortAndShuffle.sort(this.m_indexedFile, this.m_sortedFile, this.m_indexedMD, (EngineNode)this, this.getMaxRowsPerBlock(), this.m_equalityColNames, ascend, naTop, true, true);
    }

    protected boolean handleOutput() throws Exception {
        File outputFile = new File(this.getOutputDataCacheFileName(0));
        File outputBlobFile = new File(this.getNetworkManager().getOutputDataBlobFileName(this.getNodeID(), 0));
        Vector<String> valueColumnsVec = new Vector<String>();
        valueColumnsVec.add(this.m_equalityColNames[0]);
        XTMetaData outputMD = this.m_indexedMD.selectiveClone(valueColumnsVec);
        boolean ok = this.fileManipulation(this.m_sortedFile, this.m_sortedBlobFile, this.m_indexedMD, outputFile, outputBlobFile, outputMD, 4);
        this.setOutputMetaData(0, outputMD);
        return ok;
    }

    private boolean hasAllLevels(boolean[] levs) {
        for (int i = 0; i < levs.length; ++i) {
            if (levs[i]) continue;
            return false;
        }
        return true;
    }

    private void resetAllLevels(boolean[] levs) {
        for (int i = 0; i < levs.length; ++i) {
            levs[i] = false;
        }
    }

    protected boolean drop(DataCacheRowBuf preBuf, DataInput preStream, DataCacheRowBuf newBuf, DataOutput newStream, XTMetaData preMD, XTMetaData newMD) {
        long numRows = preMD.getNumRows();
        DataCacheRowBuf lastBuf = new DataCacheRowBuf(preMD);
        int numColumns = preMD.getNumColumns();
        String groupCol = preMD.ordinalToName(this.m_equalityColNums[1]);
        Vector factors = preMD.getCategoricalDataFieldLevels(groupCol);
        int membershipCount = this.m_levelMap.size();
        boolean[] allLevs = new boolean[membershipCount];
        long outputRows = 0L;
        boolean outputRow = false;
        for (long rowNum = 0L; rowNum < numRows; ++rowNum) {
            try {
                boolean allLevsFound;
                preBuf.readRow(preStream);
                if (rowNum > 0L && !preBuf.isSame(lastBuf, this.m_equalityColNums[0])) {
                    this.resetAllLevels(allLevs);
                    outputRow = false;
                }
                if (!(allLevsFound = this.hasAllLevels(allLevs))) {
                    int tempIndex;
                    int levNum = preBuf.getLevelNum(this.m_equalityColNums[1]);
                    Integer integer = (Integer)this.m_levelMap.get(factors.get(levNum));
                    int n = tempIndex = integer == null ? -1 : integer;
                    if (tempIndex > -1 && !allLevs[tempIndex]) {
                        allLevs[tempIndex] = true;
                        allLevsFound = this.hasAllLevels(allLevs);
                    }
                }
                if (!outputRow && allLevsFound) {
                    newBuf.copyColumn(0, this.m_equalityColNums[0], preBuf);
                    newBuf.writeRow(newStream);
                    outputRow = true;
                    ++outputRows;
                }
                lastBuf.copyAllColumns(preBuf);
                continue;
            }
            catch (Exception e) {
                // empty catch block
                break;
            }
        }
        newMD.setNumRows(outputRows);
        return true;
    }

    protected boolean handleIndex() throws Exception {
        return true;
    }

    protected boolean handleRows() throws Exception {
        return true;
    }

    protected boolean handleUnsort() throws Exception {
        return true;
    }
}

