/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.miner.MinerApp;
import com.insightful.miner.NodeDialog;
import com.insightful.miner.ReadOtherFileDialog;
import com.insightful.miner.XTMetaData;
import com.insightful.miner.XTProps;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.Collections;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;

public class ReadDatabaseDialog
extends ReadOtherFileDialog {
    protected JTextField m_dbUserTextField;
    protected JPasswordField m_dbPasswordTextField;
    protected JTextField m_dbDatabaseTextField;
    protected JTextField m_dbTableTextField;
    protected JTextArea m_dbSqlTextArea;
    protected JTextField m_dbServerTextField;
    private static ReadDatabaseDialog m_ReadDatabaseDialog = null;

    public static ReadDatabaseDialog getReadDatabaseDialog() {
        if (m_ReadDatabaseDialog == null) {
            m_ReadDatabaseDialog = new ReadDatabaseDialog();
        }
        return m_ReadDatabaseDialog;
    }

    protected ReadDatabaseDialog() {
        Dimension dim = new Dimension(525, 600);
        this.setMinimumSize(dim);
        this.setSize(dim);
    }

    protected void restoreSpecialFileProperties(XTProps props) {
        if (this.m_dbUserTextField != null) {
            this.m_dbUserTextField.setText(props.getValue("dbUser", ""));
        }
        if (this.m_dbPasswordTextField != null) {
            this.m_dbPasswordTextField.setText(props.getValue("dbPassword", ""));
        }
        if (this.m_dbDatabaseTextField != null) {
            this.m_dbDatabaseTextField.setText(props.getValue("dbDatabase", ""));
        }
        if (this.m_dbTableTextField != null) {
            this.m_dbTableTextField.setText(props.getValue("dbTable", ""));
        }
        if (this.m_dbSqlTextArea != null) {
            this.m_dbSqlTextArea.setText(props.getValue("dbSql", ""));
        }
        if (this.m_dbServerTextField != null) {
            this.m_dbServerTextField.setText(props.getValue("dbServer", ""));
        }
    }

    protected void saveSpecialFileProperties(XTProps props) {
        if (this.m_dbUserTextField != null) {
            props.set("dbUser", this.m_dbUserTextField.getText());
        }
        if (this.m_dbPasswordTextField != null) {
            props.set("dbPassword", String.valueOf(this.m_dbPasswordTextField.getPassword()));
        }
        if (this.m_dbDatabaseTextField != null) {
            props.set("dbDatabase", this.m_dbDatabaseTextField.getText());
        }
        if (this.m_dbTableTextField != null) {
            props.set("dbTable", this.m_dbTableTextField.getText());
        }
        if (this.m_dbSqlTextArea != null) {
            props.set("dbSql", this.m_dbSqlTextArea.getText());
        }
        if (this.m_dbServerTextField != null) {
            props.set("dbServer", this.m_dbServerTextField.getText());
        }
    }

    protected JTextField addDBField(GridBagConstraints gc, JPanel panel, int gridy, String textTag, char mnemonic, boolean isPasswordTextField) {
        JTextField textField = isPasswordTextField ? new JPasswordField() : new JTextField();
        JLabel label = new JLabel(MinerApp.getText(textTag));
        label.setLabelFor(textField);
        label.setDisplayedMnemonic(mnemonic);
        gc.fill = 0;
        gc.anchor = 18;
        gc.insets = new Insets(0, 5, 0, 5);
        gc.gridx = 0;
        gc.gridy = gridy;
        gc.gridheight = 1;
        gc.gridwidth = 2;
        gc.weightx = 0.0;
        gc.weighty = 0.0;
        panel.add((Component)label, gc);
        gc.fill = 2;
        gc.anchor = 18;
        gc.insets = new Insets(0, 5, 0, 5);
        gc.gridx = -1;
        gc.gridy = gridy;
        gc.gridheight = 1;
        gc.gridwidth = 6;
        gc.weightx = 1.0;
        gc.weighty = 0.0;
        panel.add((Component)textField, gc);
        return textField;
    }

    protected JTextField addDBTableNameField(GridBagConstraints gc, JPanel panel, int gridy, String textTag, char mnemonic) {
        JTextField textField = new JTextField();
        JLabel label = new JLabel(MinerApp.getText(textTag));
        label.setLabelFor(textField);
        label.setDisplayedMnemonic(mnemonic);
        String buttonLabel = MinerApp.getText("ReadDatabaseDialog_browseTablesButtonLabel");
        AbstractAction buttonAction = new AbstractAction(buttonLabel){

            public void actionPerformed(ActionEvent e) {
                if (ReadDatabaseDialog.this.m_dbTableTextField == null) {
                    return;
                }
                String oldTable = ReadDatabaseDialog.this.m_dbTableTextField.getText();
                String newTable = ReadDatabaseDialog.browseTableNames(ReadDatabaseDialog.this, ReadDatabaseDialog.this.getCurrentFileProperties(), oldTable);
                if (newTable != null) {
                    ReadDatabaseDialog.this.m_dbTableTextField.setText(newTable);
                }
            }
        };
        JButton browseButton = new JButton(buttonAction);
        String buttonHotkey = MinerApp.getText("ReadDatabaseDialog_browseTablesButtonHotkey");
        if (buttonHotkey != null && buttonHotkey.length() > 0) {
            browseButton.setMnemonic(buttonHotkey.charAt(0));
        }
        gc.fill = 0;
        gc.anchor = 18;
        gc.insets = new Insets(0, 5, 0, 5);
        gc.gridx = 0;
        gc.gridy = gridy;
        gc.gridheight = 1;
        gc.gridwidth = 2;
        gc.weightx = 0.0;
        gc.weighty = 0.0;
        panel.add((Component)label, gc);
        gc.fill = 2;
        gc.anchor = 18;
        gc.insets = new Insets(0, 5, 0, 5);
        gc.gridx = 2;
        gc.gridy = gridy;
        gc.gridheight = 1;
        gc.gridwidth = 2;
        gc.weightx = 1.0;
        gc.weighty = 0.0;
        panel.add((Component)textField, gc);
        gc.fill = 2;
        gc.anchor = 18;
        gc.insets = new Insets(0, 5, 0, 5);
        gc.gridx = 4;
        gc.gridy = gridy;
        gc.gridheight = 1;
        gc.gridwidth = 2;
        gc.weightx = 0.0;
        gc.weighty = 0.0;
        panel.add((Component)browseButton, gc);
        return textField;
    }

    protected JTextArea addDBSqlField(GridBagConstraints gc, JPanel panel, int gridy, String textTag, char mnemonic) {
        JTextArea sqlTextArea = new JTextArea();
        sqlTextArea.setRows(3);
        JScrollPane scrollPane = new JScrollPane(sqlTextArea);
        scrollPane.getViewport().setPreferredSize(sqlTextArea.getPreferredSize());
        JLabel sqlLabel = new JLabel(MinerApp.getText(textTag));
        sqlLabel.setDisplayedMnemonic(mnemonic);
        sqlLabel.setLabelFor(sqlTextArea);
        gc.fill = 0;
        gc.anchor = 18;
        gc.insets = new Insets(0, 5, 0, 5);
        gc.gridx = 0;
        gc.gridy = gridy;
        gc.weightx = 0.0;
        gc.weighty = 0.0;
        gc.gridheight = 1;
        gc.gridwidth = 2;
        panel.add((Component)sqlLabel, gc);
        gc.fill = 1;
        gc.anchor = 18;
        gc.insets = new Insets(0, 5, 0, 5);
        gc.gridx = -1;
        gc.gridy = gridy;
        gc.gridwidth = 0;
        gc.gridheight = 0;
        gc.weightx = 1.0;
        gc.weighty = 1.0;
        panel.add((Component)scrollPane, gc);
        return sqlTextArea;
    }

    protected JPanel createMoreOptionsPanel() {
        JPanel moreOptionsPanel = new JPanel(new GridBagLayout());
        moreOptionsPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(MinerApp.getText("ReadTextFileDialog_options")), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        JLabel defaultStringTypeLabel = new JLabel(MinerApp.getText("ReadTextFileDialog_columnType"));
        defaultStringTypeLabel.setDisplayedMnemonic('d');
        this.m_defaultStringColumnTypeComboBox = new JComboBox<Object>(new Object[]{XTMetaData.STRING_TYPE_ATTRIBUTE_TAG, XTMetaData.CATEGORICAL_TYPE_ATTRIBUTE_TAG});
        defaultStringTypeLabel.setLabelFor(this.m_defaultStringColumnTypeComboBox);
        GridBagConstraints optionsConstraints = new GridBagConstraints();
        optionsConstraints.anchor = 18;
        optionsConstraints.gridx = 0;
        optionsConstraints.gridy = 0;
        optionsConstraints.weightx = 0.0;
        moreOptionsPanel.add((Component)defaultStringTypeLabel, optionsConstraints);
        optionsConstraints.gridx = 1;
        optionsConstraints.weightx = 1.0;
        optionsConstraints.weighty = 1.0;
        optionsConstraints.fill = 2;
        optionsConstraints.gridwidth = 0;
        moreOptionsPanel.add((Component)this.m_defaultStringColumnTypeComboBox, optionsConstraints);
        return moreOptionsPanel;
    }

    public JPanel createOptionsPanel() {
        JPanel optionsPanel = new JPanel(new GridBagLayout());
        optionsPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        panel.setBorder(new TitledBorder(new EtchedBorder(), MinerApp.getText("ReadDatabaseDialog_odbc")));
        GridBagConstraints gc = new GridBagConstraints();
        this.m_dbUserTextField = this.addDBField(gc, panel, 0, "ReadDatabaseDialog_dbUser", 'u', false);
        this.m_dbPasswordTextField = (JPasswordField)this.addDBField(gc, panel, 1, "ReadDatabaseDialog_dbPassword", 'w', true);
        this.m_dbDatabaseTextField = this.addDBField(gc, panel, 2, "ReadDatabaseDialog_dbDataSourceName", 'd', false);
        this.m_dbTableTextField = this.addDBTableNameField(gc, panel, 3, "ReadDatabaseDialog_dbTable", 't');
        this.m_dbSqlTextArea = this.addDBSqlField(gc, panel, 4, "ReadDatabaseDialog_dbSql", 'q');
        JPanel topPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.weighty = 1.0;
        gbc.weightx = 1.0;
        gbc.anchor = 18;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.fill = 1;
        topPanel.add((Component)panel, gbc);
        gbc.fill = 2;
        gbc.weighty = 0.0;
        ++gbc.gridy;
        topPanel.add((Component)this.createMoreOptionsPanel(), gbc);
        ++gbc.gridy;
        topPanel.add((Component)this.createSamplePanel(true), gbc);
        gbc.weighty = 1.0;
        gbc.weightx = 1.0;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.fill = 1;
        optionsPanel.add((Component)topPanel, gbc);
        ++gbc.gridy;
        optionsPanel.add((Component)this.createPreviewPanel(), gbc);
        optionsPanel.setSize(optionsPanel.getPreferredSize());
        return optionsPanel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String browseTableNames(NodeDialog dialog, XTProps currentFileProps, String currentTableName) {
        String string;
        int numTableNames;
        Vector tableNames;
        block9: {
            if (dialog != null) {
                dialog.setCursor(Cursor.getPredefinedCursor(3));
            }
            XTProps tableNameProps = ReadDatabaseDialog.getDataSourceTableNames(dialog, currentFileProps, 2000);
            tableNames = null;
            String errorString = "";
            numTableNames = 0;
            if (tableNameProps == null) {
                tableNames = new Vector();
                errorString = MinerApp.getText("ReadDatabaseDialog_browseTablesUnknownError");
            } else {
                tableNames = tableNameProps.getSubPropertyValues("tableNames");
                errorString = tableNameProps.getValue("tableNameErrors", "");
                numTableNames = tableNameProps.getInt("tableNameCount", 0);
            }
            if (numTableNames >= true) break block9;
            String fullErrorString = MinerApp.getText("ReadDatabaseDialog_browseTablesCantAccess") + "\n\n" + errorString;
            String errorTitle = MinerApp.getText("ReadDatabaseDialog_browseTablesErrorTitle");
            JOptionPane.showMessageDialog(dialog, fullErrorString, errorTitle, 0);
            String string2 = null;
            Object var14_15 = null;
            if (dialog == null) return string2;
            dialog.setCursor(Cursor.getPredefinedCursor(0));
            return string2;
        }
        try {
            Collections.sort(tableNames);
            int numTablesNamesToDisplay = tableNames.size();
            Object[] possibleValues = new Object[numTablesNamesToDisplay];
            for (int i = 0; i < numTablesNamesToDisplay; ++i) {
                possibleValues[i] = tableNames.get(i);
            }
            String chooserTitle = MinerApp.getText("ReadDatabaseDialog_browseTablesTitle");
            String chooserMessage = MinerApp.getText("ReadDatabaseDialog_browseTablesChooseTableName") + " [" + numTablesNamesToDisplay + (numTablesNamesToDisplay != numTableNames ? "/" + numTableNames : "") + " " + MinerApp.getText("ReadDatabaseDialog_browseTablesTablesListed") + "]";
            Object selectedValue = JOptionPane.showInputDialog(dialog, chooserMessage, chooserTitle, 3, null, possibleValues, currentTableName);
            string = (String)selectedValue;
            Object var14_16 = null;
            if (dialog == null) return string;
        }
        catch (Exception ex) {
            try {
                ex.printStackTrace();
                Object var14_17 = null;
                if (dialog == null) return null;
            }
            catch (Throwable throwable) {
                Object var14_18 = null;
                if (dialog == null) throw throwable;
                dialog.setCursor(Cursor.getPredefinedCursor(0));
                throw throwable;
            }
            dialog.setCursor(Cursor.getPredefinedCursor(0));
            return null;
        }
        dialog.setCursor(Cursor.getPredefinedCursor(0));
        return string;
    }

    public static XTProps getDataSourceTableNames(NodeDialog dialog, XTProps props, int maxTableNames) throws Exception {
        XTProps tableNameProps = null;
        try {
            dialog.getNodeModel().saveGuiNetworkToEngine();
            tableNameProps = (XTProps)dialog.getNodeModel().sendMessageToEngine("getAllTableNames", new Object[]{props, new Integer(maxTableNames)});
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return tableNameProps;
    }
}

