/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.cnkjava.CNKProc;
import com.insightful.cnkjava.CNKProcJavaTransform;
import com.insightful.cnkjava.CNKProcJavaTransformExec;
import com.insightful.miner.EngineNode;
import com.insightful.miner.XTMetaData;
import com.insightful.miner.XTProps;

public class SeqEngineNode
extends EngineNode
implements CNKProcJavaTransformExec {
    private double m_startVal = -1.0;
    private double m_endVal = -1.0;
    private double m_increment = -1.0;
    private double m_curVal = -1.0;
    private double m_includeLast = Double.NaN;
    public static String START_ATTRIBUTE_TAG = "start";
    public static String END_ATTRIBUTE_TAG = "end";
    public static String INCREMENT_ATTRIBUTE_TAG = "inc";
    public static String INCLUDE_LAST_ATTRIBUTE_TAG = "last";

    public boolean hasCNKProc() {
        return true;
    }

    public boolean hasDataCacheProc() {
        return false;
    }

    public CNKProc procCreate() {
        CNKProcJavaTransform proc = new CNKProcJavaTransform();
        proc.setExecObject(this);
        return proc;
    }

    public void procSetProperties(CNKProc proc) {
        XTProps props = this.getNodeProperties();
        this.m_startVal = props.getDouble(START_ATTRIBUTE_TAG, 1.0);
        this.m_endVal = props.getDouble(END_ATTRIBUTE_TAG, 1.0);
        this.m_increment = props.getDouble(INCREMENT_ATTRIBUTE_TAG, 1.0);
        this.m_includeLast = props.getDouble(INCLUDE_LAST_ATTRIBUTE_TAG, Double.NaN);
        this.m_curVal = this.m_startVal;
    }

    private boolean isDone(double val) {
        if (this.m_startVal <= this.m_endVal) {
            return val > this.m_endVal;
        }
        return val < this.m_endVal;
    }

    private double increment(double val) {
        return val + this.m_increment;
    }

    public void execute(CNKProcJavaTransform proc) {
        long oPos = proc.getChunkOutputPosition(0);
        int oRowBlock = proc.getChunkOutputRows(0);
        double[] v = proc.getChunkOutputColumnDoubles(0, 0);
        boolean totalSpecified = !Double.isNaN(this.m_includeLast);
        double totalRows = this.m_includeLast;
        boolean isDone = false;
        double val = this.m_curVal;
        int numRows = 0;
        numRows = 0;
        while (numRows < oRowBlock) {
            if (totalSpecified) {
                if ((double)((long)numRows + oPos) == totalRows - 1.0) {
                    v[numRows++] = this.m_endVal;
                    isDone = true;
                    break;
                }
                if ((double)((long)numRows + oPos) > totalRows - 1.0) {
                    isDone = true;
                    break;
                }
            } else if (this.isDone(val)) {
                isDone = true;
                break;
            }
            v[numRows++] = val;
            val = this.increment(val);
        }
        this.m_curVal = val;
        proc.setChunkOutputReleaseRows(0, numRows);
        proc.setChunkDone(isDone);
    }

    public XTMetaData calculateOutputMetaData(int outputNum) {
        try {
            XTMetaData md = new XTMetaData();
            md.appendContinousDataField("x");
            return md;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

