/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner.dndtree;

import java.util.Vector;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEdit;
import javax.swing.undo.UndoableEditSupport;

public class InfoUndoManager
extends UndoManager {
    private Object source;
    private UndoableEditSupport m_undoSupport = new UndoableEditSupport(){

        public synchronized void postEdit(UndoableEdit ue) {
            this.realSource = InfoUndoManager.this.source;
            super.postEdit(ue);
        }
    };
    private transient Vector changeListeners;
    private static int count = 0;

    public synchronized void undo() throws CannotUndoException {
        super.undo();
        this.fireStateChanged(new ChangeEvent(this));
    }

    public synchronized void undoTo(UndoableEdit edit) {
        super.undoTo(edit);
        this.fireStateChanged(new ChangeEvent(this));
    }

    public synchronized void redo() throws CannotRedoException {
        super.redo();
        this.fireStateChanged(new ChangeEvent(this));
    }

    public synchronized void redoTo(UndoableEdit edit) {
        super.redoTo(edit);
        this.fireStateChanged(new ChangeEvent(this));
    }

    public synchronized void undoOrRedo() throws CannotUndoException, CannotRedoException {
        super.undoOrRedo();
        this.fireStateChanged(new ChangeEvent(this));
    }

    public synchronized UndoableEdit[] getEdits() {
        Object[] array = new UndoableEdit[this.edits.size()];
        this.edits.copyInto(array);
        return array;
    }

    public synchronized void discardAllEdits() {
        super.discardAllEdits();
        this.fireStateChanged(new ChangeEvent(this));
    }

    public synchronized UndoableEdit[] getUndoableEdits() {
        int size = this.edits.size();
        Vector<UndoableEdit> v = new Vector<UndoableEdit>(size);
        for (int i = size - 1; i >= 0; --i) {
            UndoableEdit u = (UndoableEdit)this.edits.elementAt(i);
            if (!u.canUndo() || !u.isSignificant()) continue;
            v.addElement(u);
        }
        Object[] array = new UndoableEdit[v.size()];
        v.copyInto(array);
        return array;
    }

    public synchronized UndoableEdit[] getRedoableEdits() {
        int size = this.edits.size();
        Vector<UndoableEdit> v = new Vector<UndoableEdit>(size);
        for (int i = 0; i < size; ++i) {
            UndoableEdit u = (UndoableEdit)this.edits.elementAt(i);
            if (!u.canRedo() || !u.isSignificant()) continue;
            v.addElement(u);
        }
        Object[] array = new UndoableEdit[v.size()];
        v.copyInto(array);
        return array;
    }

    public synchronized boolean addEdit(UndoableEdit anEdit) {
        boolean b = super.addEdit(anEdit);
        if (b) {
            this.m_undoSupport.postEdit(anEdit);
        }
        return b;
    }

    public synchronized void undoableEditHappened(UndoableEditEvent ev) {
        UndoableEdit ue = ev.getEdit();
        this.source = ev.getSource();
        this.addEdit(ue);
    }

    public synchronized void addUndoableEditListener(UndoableEditListener l) {
        this.m_undoSupport.addUndoableEditListener(l);
    }

    public synchronized void removeUndoableEditListener(UndoableEditListener l) {
        this.m_undoSupport.removeUndoableEditListener(l);
    }

    public synchronized void removeChangeListener(ChangeListener l) {
        if (this.changeListeners != null && this.changeListeners.contains(l)) {
            Vector v = (Vector)this.changeListeners.clone();
            v.removeElement(l);
            this.changeListeners = v;
        }
    }

    public synchronized void addChangeListener(ChangeListener l) {
        Vector v;
        Vector vector = v = this.changeListeners == null ? new Vector(2) : (Vector)this.changeListeners.clone();
        if (!v.contains(l)) {
            v.addElement(l);
            this.changeListeners = v;
        }
    }

    protected void fireStateChanged(ChangeEvent e) {
        if (this.changeListeners != null) {
            Vector listeners = this.changeListeners;
            int count = listeners.size();
            for (int i = 0; i < count; ++i) {
                ((ChangeListener)listeners.elementAt(i)).stateChanged(e);
            }
        }
    }
}

