/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner.graph;

import com.insightful.gdevice.SCanvas;
import com.insightful.miner.AcceleratorOptionPane;
import com.insightful.miner.MinerApp;
import com.insightful.miner.ModifiableViewerFrame;
import com.insightful.miner.graph.CanvasTabbedPane;
import com.insightful.miner.graph.ExportGraphCommand;
import com.insightful.miner.graph.GraphOptionsDialog;
import com.insightful.splus.SplusSystem;
import com.insightful.splus.graph.GraphColorsDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Printable;
import java.awt.print.PrinterJob;
import java.io.File;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;

public class GraphFrame
extends ModifiableViewerFrame
implements Pageable,
Printable {
    CanvasTabbedPane paneTabs;
    static int graphNameCounter = 0;

    public GraphFrame(SCanvas canvasNew) {
        this(canvasNew, null, null, null);
    }

    public GraphFrame(SCanvas canvasNew, String title, Image icon, Point location) {
        if (title == null) {
            title = "Graph Window " + ++graphNameCounter;
        }
        this.setTitle(title);
        this.setDefaultCloseOperation(2);
        this.paneTabs = new CanvasTabbedPane();
        JComponent c = (JComponent)this.getContentPane();
        c.setLayout(new BorderLayout());
        c.add((Component)this.paneTabs, "Center");
        this.paneTabs.setActiveCanvas(canvasNew);
        this.paneTabs.addCanvasTab(canvasNew);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosed(WindowEvent e) {
                GraphFrame.this.exitFunction();
            }
        });
        JMenuBar menuBar = new JMenuBar();
        JMenu menu = new JMenu(MinerApp.getText("graph_frame_file"));
        menu.setMnemonic(70);
        menuBar.add(menu);
        menu.add(this.newMenuItem(MinerApp.getText("graph_frame_saveas"), 'A', new ActionListener(){

            public void actionPerformed(ActionEvent a) {
                GraphFrame.this.saveAs(GraphFrame.this, SplusSystem.getCwd());
            }
        }));
        menu.add(this.newMenuItem(MinerApp.getText("graph_frame_print"), 'P', new ActionListener(){

            public void actionPerformed(ActionEvent a) {
                GraphFrame.this.doPrint();
            }
        }));
        menu.add(this.newMenuItem(MinerApp.getText("graph_frame_print_setup"), 'U', new ActionListener(){

            public void actionPerformed(ActionEvent a) {
                Thread thrd = new Thread(){

                    public void run() {
                        PrinterJob job = PrinterJob.getPrinterJob();
                        MinerApp.setDefaultPageFormat(job.pageDialog(MinerApp.getPrintAttributeSet()));
                        if (MinerApp.getMainFrame() != null) {
                            MinerApp.getCurrentView().requestFocus();
                        }
                        GraphFrame.this.requestFocus();
                    }
                };
                thrd.start();
            }
        }));
        menu.addSeparator();
        menu.add(this.newMenuItem(MinerApp.getText("graph_frame_close"), 'C', new ActionListener(){

            public void actionPerformed(ActionEvent a) {
                GraphFrame.this.dispose();
            }
        }));
        menu = new JMenu(MinerApp.getText("graph_frame_view"));
        menu.setMnemonic(86);
        menuBar.add(menu);
        JMenu submenu = new JMenu(MinerApp.getText("graph_frame_zoom_graph"));
        submenu.add(this.newMenuItem(MinerApp.getText("graph_frame_zoom_in"), new ActionListener(){

            public void actionPerformed(ActionEvent a) {
                GraphFrame.this.paneTabs.zoom(1.5);
            }
        }));
        submenu.add(this.newMenuItem(MinerApp.getText("graph_frame_zoom_out"), new ActionListener(){

            public void actionPerformed(ActionEvent a) {
                GraphFrame.this.paneTabs.zoom(0.6666666865348816);
            }
        }));
        submenu.add(this.newMenuItem(MinerApp.getText("graph_frame_zoom_to_rect"), new ActionListener(){

            public void actionPerformed(ActionEvent a) {
                GraphFrame.this.paneTabs.zoomToRect();
            }
        }));
        submenu.add(this.newMenuItem(MinerApp.getText("graph_frame_fit_to_window"), new ActionListener(){

            public void actionPerformed(ActionEvent a) {
                GraphFrame.this.paneTabs.zoomToFrame();
            }
        }));
        menu.add(submenu);
        menu = new JMenu(MinerApp.getText("graph_frame_options"));
        menu.setMnemonic(80);
        menuBar.add(menu);
        JMenuItem item = this.newMenuItem(MinerApp.getText("graph_frame_set_graph_colors"), 'C', new ActionListener(){

            public void actionPerformed(ActionEvent a) {
                if (!com.insightful.splus.graph.GraphFrame.isLegacyGraphicsMode()) {
                    AcceleratorOptionPane.showOKDialog(GraphFrame.this, com.insightful.splus.graph.GraphFrame.getColorSetErrorMsg(), com.insightful.splus.graph.GraphFrame.getColorSetErrorTitle(), 0);
                    return;
                }
                SCanvas canvas = GraphFrame.this.paneTabs.getCanvas();
                GraphColorsDialog dlg = new GraphColorsDialog((Frame)GraphFrame.this, canvas, true);
                dlg.show();
            }
        });
        menu.add(item);
        menu.add(this.newMenuItem(MinerApp.getText("graph_frame_graph_options"), 'G', new ActionListener(){

            public void actionPerformed(ActionEvent a) {
                GraphOptionsDialog dlg = new GraphOptionsDialog(GraphFrame.this);
                dlg.show();
            }
        }));
        this.setJMenuBar(menuBar);
        Dimension userSize = null;
        if (canvasNew != null) {
            userSize = new Dimension(canvasNew.getUserSize());
        }
        if (userSize == null || userSize.width < 1 || userSize.height < 1) {
            userSize = new Dimension(520, 390);
        }
        userSize.width = Math.min(1000, Math.max(100, userSize.width));
        userSize.height = Math.min(1000, Math.max(100, userSize.height));
        this.setSize(userSize.width + 10, userSize.height + 60);
        if (icon != null) {
            this.setIconImage(icon);
        }
        if (location != null) {
            this.setLocation(location);
        }
        ActionListener cancelListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GraphFrame.this.exitFunction();
                GraphFrame.this.dispose();
            }
        };
        this.getJMenuBar().registerKeyboardAction(cancelListener, KeyStroke.getKeyStroke("ESCAPE"), 2);
        this.show();
        Dimension canvasSize = this.paneTabs.getCanvasComponent().getSize();
        this.setSize(this.getWidth() + userSize.width - canvasSize.width, this.getHeight() + userSize.height - canvasSize.height);
    }

    JMenuItem newMenuItem(String text, char mnemonic, ActionListener actionListener) {
        JMenuItem menuItem = this.newMenuItem(text, actionListener);
        menuItem.setMnemonic(mnemonic);
        return menuItem;
    }

    JMenuItem newMenuItem(String text, ActionListener actionListener) {
        JMenuItem menuItem = new JMenuItem(text);
        menuItem.addActionListener(actionListener);
        return menuItem;
    }

    public CanvasTabbedPane getCanvasTabbedPane() {
        return this.paneTabs;
    }

    private void exitFunction() {
        int deviceNumber = this.paneTabs.getDeviceNumber();
        if (deviceNumber > 0) {
            this.paneTabs.unlinkCanvases();
            if (SplusSystem.getEngineQueryHandler() != null) {
                String devOffCmd = "{dev.off(" + deviceNumber + ");vector(\"missing\",0)}\n";
                SplusSystem.getEngineQueryHandler().processDataQuery(devOffCmd, 5);
            } else {
                String warn = "Closing this window does not close the S-PLUS device.\nExecute dev.off(" + deviceNumber + ") to close the device.";
                AcceleratorOptionPane.showOKDialog(this, warn, MinerApp.getText("GraphFrame_message_warning"), 2);
            }
        }
    }

    public void doPrint() {
        this.setCursor(Cursor.getPredefinedCursor(3));
        PrintThread thrd = new PrintThread(this);
        thrd.start();
        this.setCursor(Cursor.getDefaultCursor());
    }

    public int print(Graphics g, PageFormat fmt, int iPage) {
        return GraphFrame.printPage(g, fmt, iPage, this.paneTabs);
    }

    public int getNumberOfPages() {
        return this.paneTabs.getTabCount();
    }

    public PageFormat getPageFormat(int i) {
        return MinerApp.getDefaultPageFormat();
    }

    public Printable getPrintable(int i) {
        return this;
    }

    public File saveAs(Frame fr, File fiCurrentDirectory) {
        return GraphFrame.savePages(fr, fiCurrentDirectory, this.paneTabs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int printPage(Graphics g, PageFormat fmt, int iPage, CanvasTabbedPane tabbedPane) {
        if (iPage >= tabbedPane.getTabCount()) {
            return 1;
        }
        SCanvas cv = tabbedPane.getCanvas(iPage);
        int oldWidth = cv.getWidth();
        int oldHeight = cv.getHeight();
        try {
            int iWidth = (int)fmt.getImageableWidth() - 8;
            int iHeight = (int)fmt.getImageableHeight() - 8;
            int iX = (int)fmt.getImageableX() + 4;
            int iY = (int)fmt.getImageableY() + 4;
            Dimension bestSize = cv.getBestFitSize(new Dimension(iWidth, iHeight));
            cv.setSize(bestSize.width, bestSize.height);
            g.translate(iX + (iWidth - bestSize.width) / 2, iY + (iHeight - bestSize.height) / 2);
            cv.paint(g);
            Object var13_12 = null;
        }
        catch (Throwable throwable) {
            Object var13_13 = null;
            cv.setSize(oldWidth, oldHeight);
            throw throwable;
        }
        cv.setSize(oldWidth, oldHeight);
        return 0;
    }

    private static File savePages(Frame fr, File fiCurrentDirectory, CanvasTabbedPane tabbedPane) {
        if (fiCurrentDirectory != null) {
            SplusSystem.setCwd((File)fiCurrentDirectory);
        }
        ExportGraphCommand cmd = new ExportGraphCommand(fr, tabbedPane);
        cmd.m_iminer_canvasPane = tabbedPane;
        cmd.doExecute();
        return SplusSystem.getCwd();
    }

    protected class PrintThread
    extends Thread {
        private GraphFrame m_frame;

        public PrintThread(GraphFrame frame) {
            this.m_frame = frame;
        }

        public void run() {
            PrinterJob pj = PrinterJob.getPrinterJob();
            if (pj.printDialog(MinerApp.getPrintAttributeSet())) {
                PageFormat pf = pj.validatePage(MinerApp.getDefaultPageFormat());
                pj.setPageable(this.m_frame);
                new MinerApp.GenericPrintThread(pj).start();
            }
            MinerApp.getMainFrame().requestFocus();
            this.m_frame.requestFocus();
        }
    }
}

