/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner.graphdlg.controls;

import com.insightful.miner.EngineNetworkManager;
import com.insightful.miner.XTProps;
import com.insightful.miner.graphdlg.controls.MinerControlMethods;
import com.insightful.splus.util.StringUtilities;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.event.EventListenerList;

public class MinerFunctionInfo {
    public static final String FUNC_INFO_TAG = "minerFunctionInfo";
    public static final String FUNC_NAME_TAG = "funcName";
    public static final String RESULT_CONTROL_VALUE_TAG = "resultControlValue";
    public static final String CONTROL_LIST_TAG = "controlList";
    public static final String IS_QUOTED_TAG = "isQuoted";
    public static final String IS_LISTED_TAG = "isListed";
    public static final String OMIT_VALUE_TAG = "omitValue";
    String functionName = "";
    MinerControlMethods resultControl = null;
    Vector controlList = new Vector();
    private EventListenerList listenerList = new EventListenerList();
    private String actionCommand = "setValues";
    private boolean firingActionEvent = false;

    public MinerFunctionInfo() {
    }

    public MinerFunctionInfo(String aName) {
        this.functionName = aName.trim();
    }

    public void setFunctionName(String aName) {
        this.functionName = aName.trim();
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public void setResultControl(MinerControlMethods control) {
        this.resultControl = control;
    }

    public MinerControlMethods getResultControl() {
        return this.resultControl;
    }

    public void add(MinerControlMethods aControl) {
        this.controlList.add(new ControlInfo(aControl, "", false, false, null));
    }

    public void add(MinerControlMethods aControl, String aName) {
        this.controlList.add(new ControlInfo(aControl, aName, false, false, null));
    }

    public void add(MinerControlMethods aControl, String aName, boolean isQuoted) {
        this.controlList.add(new ControlInfo(aControl, aName, isQuoted, false, null));
    }

    public void add(MinerControlMethods aControl, String aName, boolean isQuoted, boolean isListed) {
        this.controlList.add(new ControlInfo(aControl, aName, isQuoted, isListed, null));
    }

    public void add(MinerControlMethods aControl, String aName, boolean isQuoted, boolean isListed, String omitValue) {
        this.controlList.add(new ControlInfo(aControl, aName, isQuoted, isListed, omitValue));
    }

    public String getFunctionCall() {
        String resultName;
        StringBuffer buffer = new StringBuffer();
        if (this.resultControl != null && (resultName = this.resultControl.getValue().trim()).length() > 0) {
            buffer.append(resultName + " <- ");
        }
        if (this.functionName == null || this.functionName.length() <= 0) {
            return "";
        }
        buffer.append(this.functionName + "(");
        for (int i = 0; i < this.controlList.size(); ++i) {
            int j;
            ControlInfo controlInfo = (ControlInfo)this.controlList.get(i);
            if (controlInfo == null || controlInfo.control == null || controlInfo.control.getValue() == null) continue;
            String value = controlInfo.control.getValue().trim();
            String argumentName = controlInfo.argName;
            if (controlInfo.omitValue != null && value.equals(controlInfo.omitValue)) {
                value = "";
            }
            if (value.endsWith("\\") && !value.endsWith("\\\\")) {
                value = value.substring(0, value.length() - 1);
            }
            if (value.length() <= 0 || argumentName == null || argumentName.length() <= 0) continue;
            buffer.append(argumentName + " = ");
            boolean isList = controlInfo.listed;
            boolean useQuotes = controlInfo.quoted;
            if (useQuotes) {
                StringBuffer tempBuffer = new StringBuffer();
                int stringLength = value.length();
                char currentChar = value.charAt(0);
                if (currentChar != '\"') {
                    tempBuffer.append(currentChar);
                } else {
                    tempBuffer.append("\\\"");
                }
                for (j = 1; j < stringLength; ++j) {
                    currentChar = value.charAt(j);
                    if (currentChar != '\"' || value.charAt(j - 1) == '\\') {
                        tempBuffer.append(currentChar);
                        continue;
                    }
                    tempBuffer.append("\\\"");
                }
                value = tempBuffer.toString();
            }
            if (isList) {
                if (useQuotes) {
                    String newValue = "";
                    StringTokenizer tokenizer = new StringTokenizer(value, ",");
                    int numValues = tokenizer.countTokens();
                    for (j = 0; j < numValues; ++j) {
                        newValue = newValue + "\"" + tokenizer.nextToken().trim() + "\", ";
                    }
                    value = newValue.substring(0, newValue.length() - 2);
                }
                value = "list(" + value + ")";
            } else if (useQuotes) {
                value = "\"" + value + "\"";
            }
            buffer.append(value + ", ");
        }
        if (buffer.substring(buffer.length() - 2).equals(", ")) {
            buffer.delete(buffer.length() - 2, buffer.length());
        }
        buffer.append(")\n");
        return buffer.toString();
    }

    public void setValues(XTProps props) {
        Vector argNameVec;
        String funcName = props.getValue(new String[]{FUNC_INFO_TAG, FUNC_NAME_TAG}, "");
        if (funcName.length() > 0) {
            this.setFunctionName(funcName);
        }
        if (this.getResultControl() != null) {
            this.getResultControl().setValue(props.getValue(new String[]{FUNC_INFO_TAG, RESULT_CONTROL_VALUE_TAG}, ""));
        }
        if ((argNameVec = props.getSubProperties(new String[]{FUNC_INFO_TAG, CONTROL_LIST_TAG})) != null && argNameVec.size() > 0) {
            String[] propPath1 = new String[]{FUNC_INFO_TAG, CONTROL_LIST_TAG, ""};
            String[] propPath2 = new String[]{FUNC_INFO_TAG, CONTROL_LIST_TAG, "", ""};
            Iterator argNameIter = argNameVec.iterator();
            ControlInfo curInfo = null;
            while (argNameIter.hasNext()) {
                String argName = (String)argNameIter.next();
                boolean bFoundName = false;
                Iterator controlListIter = this.controlList.iterator();
                while (!bFoundName && controlListIter.hasNext()) {
                    curInfo = (ControlInfo)controlListIter.next();
                    if (!argName.equals(curInfo.argName)) continue;
                    bFoundName = true;
                }
                if (!bFoundName) continue;
                propPath1[2] = argName;
                curInfo.control.setValue(props.getValue(propPath1, ""));
                propPath2[2] = argName;
                propPath2[3] = IS_QUOTED_TAG;
                curInfo.quoted = props.getBoolean(propPath2, false);
                propPath2[3] = IS_LISTED_TAG;
                curInfo.listed = props.getBoolean(propPath2, false);
                propPath2[3] = OMIT_VALUE_TAG;
                curInfo.omitValue = props.getValue(propPath2, null);
            }
        }
        this.fireActionEvent();
    }

    public XTProps getXTProps() {
        XTProps props = null;
        try {
            props = new XTProps();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        this.updateXTProps(props);
        return props;
    }

    public void updateXTProps(XTProps props) {
        String resultControlValue;
        props.removeProperty(new String[]{FUNC_INFO_TAG});
        props.set(new String[]{FUNC_INFO_TAG, FUNC_NAME_TAG}, this.getFunctionName());
        if (this.resultControl != null && (resultControlValue = this.resultControl.getValue()) != null && resultControlValue.length() > 0) {
            props.set(new String[]{FUNC_INFO_TAG, RESULT_CONTROL_VALUE_TAG}, resultControlValue);
        }
        String[] propPath1 = new String[]{FUNC_INFO_TAG, CONTROL_LIST_TAG, ""};
        String[] propPath2 = new String[]{FUNC_INFO_TAG, CONTROL_LIST_TAG, "", ""};
        for (ControlInfo curInfo : this.controlList) {
            if (curInfo == null) continue;
            propPath1[2] = curInfo.argName;
            props.set(propPath1, curInfo.control.getValue());
            propPath2[2] = curInfo.argName;
            propPath2[3] = IS_QUOTED_TAG;
            props.set(propPath2, curInfo.quoted);
            propPath2[3] = IS_LISTED_TAG;
            props.set(propPath2, curInfo.listed);
            if (curInfo.omitValue == null) continue;
            propPath2[3] = OMIT_VALUE_TAG;
            props.set(propPath2, curInfo.omitValue);
        }
    }

    public static String getFunctionCall(XTProps props, EngineNetworkManager mgr) {
        String funcName;
        StringBuffer buffer = new StringBuffer();
        String resultControlValue = props.getValue(new String[]{FUNC_INFO_TAG, RESULT_CONTROL_VALUE_TAG}, "");
        if (resultControlValue.length() > 0) {
            buffer.append(resultControlValue + " <- ");
        }
        if ((funcName = props.getValue(new String[]{FUNC_INFO_TAG, FUNC_NAME_TAG}, "")) == null || funcName.length() <= 0) {
            return "";
        }
        buffer.append(funcName + "(");
        String[] propPath1 = new String[]{FUNC_INFO_TAG, CONTROL_LIST_TAG, ""};
        String[] propPath2 = new String[]{FUNC_INFO_TAG, CONTROL_LIST_TAG, "", ""};
        Vector argNameVec = props.getSubProperties(new String[]{FUNC_INFO_TAG, CONTROL_LIST_TAG});
        for (int i = 0; i < argNameVec.size(); ++i) {
            int j;
            String curName;
            propPath1[2] = curName = (String)argNameVec.get(i);
            String curValue = StringUtilities.escapeSpecialCharacters((String)props.getValue(propPath1, "")).trim();
            if (curValue.length() <= 0) continue;
            propPath2[2] = curName;
            propPath2[3] = IS_QUOTED_TAG;
            boolean useQuotes = props.getBoolean(propPath2, false);
            propPath2[3] = IS_LISTED_TAG;
            boolean isList = props.getBoolean(propPath2, false);
            propPath2[3] = OMIT_VALUE_TAG;
            String omitValue = props.getValue(propPath2, "");
            if (omitValue != "" && curValue.equals(omitValue)) {
                curValue = "";
            }
            if (curValue.endsWith("\\") && !curValue.endsWith("\\\\")) {
                curValue = curValue.substring(0, curValue.length() - 1);
            }
            if (curValue.length() <= 0 || curName == null || curName.length() <= 0) continue;
            if (curName.equals("fileName")) {
                curValue = mgr.getAbsolutePath(curValue).replace("\\", "\\\\");
            }
            buffer.append(curName + " = ");
            if (useQuotes) {
                StringBuffer tempBuffer = new StringBuffer();
                int stringLength = curValue.length();
                char currentChar = curValue.charAt(0);
                if (currentChar != '\"') {
                    tempBuffer.append(currentChar);
                } else {
                    tempBuffer.append("\\\"");
                }
                for (j = 1; j < stringLength; ++j) {
                    currentChar = curValue.charAt(j);
                    if (currentChar != '\"' || curValue.charAt(j - 1) == '\\') {
                        tempBuffer.append(currentChar);
                        continue;
                    }
                    tempBuffer.append("\\\"");
                }
                curValue = tempBuffer.toString();
            }
            if (isList) {
                if (useQuotes) {
                    String newValue = "";
                    StringTokenizer tokenizer = new StringTokenizer(curValue, ",");
                    int numValues = tokenizer.countTokens();
                    for (j = 0; j < numValues; ++j) {
                        newValue = newValue + "\"" + tokenizer.nextToken().trim() + "\", ";
                    }
                    curValue = newValue.substring(0, newValue.length() - 2);
                }
                curValue = "list(" + curValue + ")";
            } else if (useQuotes) {
                curValue = "\"" + curValue + "\"";
            }
            buffer.append(curValue + ", ");
        }
        if (buffer.substring(buffer.length() - 2).equals(", ")) {
            buffer.delete(buffer.length() - 2, buffer.length());
        }
        buffer.append(")\n");
        return buffer.toString();
    }

    public void addActionListener(ActionListener l) {
        this.listenerList.add(ActionListener.class, l);
    }

    protected void fireActionEvent() {
        if (!this.firingActionEvent) {
            this.firingActionEvent = true;
            ActionEvent e = new ActionEvent(this, 1001, this.getActionCommand());
            Object[] listeners = this.listenerList.getListenerList();
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != ActionListener.class) continue;
                ((ActionListener)listeners[i + 1]).actionPerformed(e);
            }
            this.firingActionEvent = false;
        }
    }

    public String getActionCommand() {
        return this.actionCommand;
    }

    class ControlInfo {
        MinerControlMethods control;
        String argName;
        boolean quoted = false;
        boolean listed = false;
        String omitValue;

        ControlInfo(MinerControlMethods aControl, String aName, boolean isQuoted, boolean isListed, String aValue) {
            this.control = aControl;
            this.argName = aName.trim();
            this.quoted = isQuoted;
            this.listed = isListed;
            this.omitValue = aValue;
        }
    }
}

