/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner.tree.model;

import com.insightful.miner.MinerApp;
import com.insightful.miner.tree.model.ClassificationRegressionTreeNode;
import com.insightful.miner.tree.model.TreeCollection;
import java.util.StringTokenizer;
import java.util.Vector;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ClassificationRegressionTree {
    private ClassificationRegressionTreeNode rootNode = null;
    private TreeCollection treeColl;
    private boolean is_regression_tree = false;
    private double[] variableDevianceValues = null;
    private int nodeCount = 0;
    private int approxDepth = 0;
    public double max_score = Double.NEGATIVE_INFINITY;
    public double min_score = Double.POSITIVE_INFINITY;
    public int max_size;
    public double max_deviance;
    public double max_risk = 0.0;
    public static final int EQUAL_OPERATOR_CODE = 1;
    public static final int NOT_EQUAL_OPERATOR_CODE = 2;
    public static final int LESS_THAN_OPERATOR_CODE = 3;
    public static final int LESS_OR_EQUAL_OPERATOR_CODE = 4;
    public static final int GREATER_THAN_OPERATOR_CODE = 5;
    public static final int GREATER_OR_EQUAL_OPERATOR_CODE = 6;

    public ClassificationRegressionTree(TreeCollection coll, boolean isRegressionTree) {
        this.is_regression_tree = isRegressionTree;
        this.treeColl = coll;
        this.variableDevianceValues = new double[this.treeColl.getNumberColumns()];
    }

    public ClassificationRegressionTreeNode createNodes(Element treeModel) {
        NodeList treeModelElements = treeModel.getChildNodes();
        for (int a = 0; a < treeModelElements.getLength(); ++a) {
            Element modelElement;
            if (treeModelElements.item(a).getNodeType() != 1 || !(modelElement = (Element)treeModelElements.item(a)).getTagName().equals("Node")) continue;
            int recordCount = Integer.parseInt(modelElement.getAttribute("recordCount"));
            this.max_size = Math.max(recordCount, this.max_size);
            this.max_deviance = Double.parseDouble(modelElement.getAttribute("deviance"));
            if (modelElement.getAttribute("risk").length() != 0) {
                this.max_risk = Double.parseDouble(modelElement.getAttribute("risk"));
            }
            if (this.is_regression_tree) {
                NodeList allNodes = modelElement.getElementsByTagName("Node");
                for (int c = 0; c < allNodes.getLength(); ++c) {
                    Node anode = allNodes.item(c);
                    double score = Double.parseDouble(((Element)anode).getAttribute("score"));
                    this.max_score = Math.max(score, this.max_score);
                    this.min_score = Math.min(score, this.min_score);
                }
            }
            ++this.approxDepth;
            this.rootNode = this.buildCRTree(modelElement, null);
        }
        return this.rootNode;
    }

    private ClassificationRegressionTreeNode buildCRTree(Element nodeElement, ClassificationRegressionTreeNode parentNode) {
        ClassificationRegressionTreeNode node = null;
        double[] yprob = null;
        ++this.nodeCount;
        String score = nodeElement.getAttribute("score");
        int recordCount = Integer.parseInt(nodeElement.getAttribute("recordCount"));
        String subnodesArePruned = nodeElement.getAttribute("subnodesArePruned");
        double deviance = Double.parseDouble(nodeElement.getAttribute("deviance"));
        double entropy = Double.NaN;
        try {
            entropy = Double.parseDouble(nodeElement.getAttribute("entropy"));
        }
        catch (Exception e) {
            // empty catch block
        }
        double gini = Double.NaN;
        try {
            gini = Double.parseDouble(nodeElement.getAttribute("gini"));
        }
        catch (Exception e) {
            // empty catch block
        }
        double risk = 0.0;
        if (nodeElement.getAttribute("risk").length() != 0) {
            risk = Double.parseDouble(nodeElement.getAttribute("risk"));
        }
        String probabilities = nodeElement.getAttribute("yprob");
        double predictionProportion = 0.0;
        int splitGroup = Integer.parseInt(nodeElement.getAttribute("group"));
        if (this.is_regression_tree) {
            if (this.max_score == this.min_score) {
                this.max_score += 0.1;
            }
            yprob = new double[]{Double.parseDouble(score)};
            predictionProportion = Math.max((Double.parseDouble(score) - this.min_score) / (this.max_score - this.min_score), 0.1);
            score = MinerApp.formatDouble(Double.parseDouble(score));
        } else {
            StringTokenizer st = new StringTokenizer(probabilities, " ");
            int probSize = st.countTokens();
            yprob = new double[probSize];
            String s = "";
            for (int a = 0; a < probSize; ++a) {
                s = st.nextToken();
                yprob[a] = Double.parseDouble(s);
            }
        }
        Vector[] split = new Vector[4];
        int splitColIndex = 0;
        boolean splitColContinuous = false;
        double[] leftCatSplitVals = null;
        Element parent = (Element)nodeElement.getParentNode();
        if (parent.getTagName().equals("TreeModel")) {
            Vector<String> v = new Vector<String>();
            v.addElement("root");
            split[3] = v;
        } else {
            split = this.handlePredicates(nodeElement, splitGroup, "");
            splitColIndex = this.treeColl.getColumnIndex((String)split[0].elementAt(0));
            splitColContinuous = this.treeColl.isColumnContinuous(splitColIndex);
            leftCatSplitVals = new double[split[2].size()];
            if (splitColContinuous) {
                leftCatSplitVals[0] = Double.parseDouble((String)split[2].elementAt(0));
            } else {
                for (int a = 0; a < split[2].size(); ++a) {
                    leftCatSplitVals[a] = this.treeColl.getLevelIndex(splitColIndex, (String)split[2].elementAt(a));
                }
            }
        }
        node = new ClassificationRegressionTreeNode(this, parentNode, splitGroup, split[1], (String)split[3].elementAt(0), splitColIndex, splitColContinuous, leftCatSplitVals, recordCount, this.max_size, this.max_deviance, this.max_risk, subnodesArePruned, deviance, gini, entropy, risk, score, yprob, predictionProportion);
        double sumOfChildrensDeviance = 0.0;
        int childSplitCol = -1;
        NodeList children = nodeElement.getChildNodes();
        boolean hasChildren = false;
        for (int i = 0; i < children.getLength(); ++i) {
            Element child;
            Node item = children.item(i);
            if (item.getNodeType() != 1 || !(child = (Element)item).getTagName().equals("Node")) continue;
            if (!hasChildren) {
                hasChildren = true;
                ++this.approxDepth;
                Vector[] childsplitinfo = this.handlePredicates(child, Integer.parseInt(nodeElement.getAttribute("group")), "");
                childSplitCol = this.treeColl.getColumnIndex((String)childsplitinfo[0].elementAt(0));
            }
            sumOfChildrensDeviance += Double.parseDouble(child.getAttribute("deviance"));
            node.add(this.buildCRTree(child, node));
        }
        if (hasChildren) {
            int n = childSplitCol;
            this.variableDevianceValues[n] = this.variableDevianceValues[n] + (deviance - sumOfChildrensDeviance);
        }
        return node;
    }

    private Vector[] handlePredicates(Element node, int splitGroup, String compoundOp) {
        Element parent = (Element)node.getParentNode();
        Element[] compoundPredArray = this.getChildrenOfType(parent, "CompoundPredicate");
        Element[] simplePredArray = null;
        Element predicate = null;
        if (compoundPredArray == null) {
            simplePredArray = this.getChildrenOfType(parent, "SimplePredicate");
            if (simplePredArray == null) {
                return null;
            }
            predicate = simplePredArray[0];
            return this.handleSimplePredicate(predicate, splitGroup, "");
        }
        Element compoundPred = compoundPredArray[0];
        String compoundOperator = compoundPred.getAttribute("booleanOperator");
        Vector[] splitInfo = new Vector[4];
        for (int q = 0; q < splitInfo.length; ++q) {
            splitInfo[q] = new Vector();
        }
        splitInfo[1].addElement("-1");
        if (splitGroup == 2) {
            splitInfo[3].addElement("NOT ");
        }
        NodeList PredNodeList = compoundPred.getChildNodes();
        String addOn = " " + compoundOperator + " ";
        for (int i = 0; i < PredNodeList.getLength(); ++i) {
            Node predNode = PredNodeList.item(i);
            if (predNode.getNodeType() != 1) continue;
            predicate = (Element)predNode;
            if (i == PredNodeList.getLength() - 1) {
                addOn = "";
            }
            if (predicate.getTagName().equals("SimplePredicate")) {
                splitInfo = this.mergeArrays(splitInfo, this.handleSimplePredicate(predicate, 1, addOn));
                continue;
            }
            if (!predicate.getTagName().equals("CompoundPredicate")) continue;
            splitInfo = this.mergeArrays(splitInfo, this.handlePredicates(predicate, 1, addOn));
        }
        String description = (String)splitInfo[3].elementAt(0);
        description = description + compoundOp;
        splitInfo[3].setElementAt(description, 0);
        return splitInfo;
    }

    private Vector[] mergeArrays(Vector[] array1, Vector[] array2) {
        if (array1.length != array2.length || array2.length != 4) {
            return null;
        }
        if (array1[array1.length - 1].size() > 1 || array2[array2.length - 1].size() > 1) {
            return null;
        }
        for (int i = 0; i < array1.length - 1; ++i) {
            for (int j = 0; j < array2[i].size(); ++j) {
                array1[i].addElement(array2[i].elementAt(j));
            }
        }
        String description1 = "";
        String description2 = "";
        if (array1[array1.length - 1].size() > 0) {
            description1 = (String)array1[array1.length - 1].elementAt(0);
        }
        if (array2[array2.length - 1].size() > 0) {
            description2 = (String)array2[array2.length - 1].elementAt(0);
        }
        description1 = description1 + description2;
        array1[array1.length - 1].removeAllElements();
        array1[array1.length - 1].addElement(description1);
        return array1;
    }

    private Vector[] handleSimplePredicate(Element predicate, int splitGroup, String compoundOp) {
        Vector<String> colVector = new Vector<String>();
        Vector<String> opVector = new Vector<String>();
        Vector<String> levelVector = new Vector<String>();
        String fieldColumn = predicate.getAttribute("field");
        String valueLevel = predicate.getAttribute("value");
        colVector.add(fieldColumn);
        levelVector.add(valueLevel);
        StringBuffer descBuffer = new StringBuffer(fieldColumn);
        String opString = predicate.getAttribute("operator");
        String op_symbol = "";
        int opCode = 0;
        if ("equal".equals(opString)) {
            opCode = 1;
            op_symbol = splitGroup == 1 ? "=" : "!=";
        } else if ("notEqual".equals(opString)) {
            opCode = 2;
            op_symbol = splitGroup == 1 ? "!=" : "=";
        } else if ("lessThan".equals(opString)) {
            opCode = 3;
            op_symbol = splitGroup == 1 ? "<" : ">=";
        } else if ("lessOrEqual".equals(opString)) {
            opCode = 4;
            op_symbol = splitGroup == 1 ? "<=" : ">";
        } else if ("greaterThan".equals(opString)) {
            opCode = 5;
            op_symbol = splitGroup == 1 ? ">" : "<=";
        } else if ("greaterOrEqual".equals(opString)) {
            opCode = 6;
            op_symbol = splitGroup == 1 ? ">=" : "<";
        }
        opVector.add(Integer.toString(opCode));
        descBuffer.append(op_symbol);
        Vector[] splitInfo = new Vector[4];
        splitInfo[0] = colVector;
        splitInfo[1] = opVector;
        splitInfo[2] = levelVector;
        if (this.treeColl.isColumnContinuous(this.treeColl.getColumnIndex(fieldColumn))) {
            double d = Double.parseDouble(valueLevel);
            levelVector.setElementAt(Double.toString(d), 0);
            descBuffer.append(MinerApp.formatDouble(d));
        } else {
            descBuffer.append(valueLevel);
        }
        descBuffer.append(compoundOp);
        Vector<String> descriptionVector = new Vector<String>();
        descriptionVector.add(descBuffer.toString());
        splitInfo[3] = descriptionVector;
        return splitInfo;
    }

    private Element[] getChildrenOfType(Element node, String type) {
        int i;
        NodeList nlist = node.getChildNodes();
        Element e = null;
        Node n = null;
        Element[] elementArray = null;
        int count = 0;
        for (i = 0; i < nlist.getLength(); ++i) {
            n = nlist.item(i);
            if (n.getNodeType() != 1 || !(e = (Element)n).getTagName().equals(type)) continue;
            ++count;
        }
        if (count == 0) {
            return null;
        }
        elementArray = new Element[count];
        count = 0;
        for (i = 0; i < nlist.getLength(); ++i) {
            n = nlist.item(i);
            if (n.getNodeType() != 1 || !(e = (Element)n).getTagName().equals(type)) continue;
            elementArray[count] = e;
            ++count;
        }
        return elementArray;
    }

    public ClassificationRegressionTreeNode getRootNode() {
        return this.rootNode;
    }

    public TreeCollection getTreeCollection() {
        return this.treeColl;
    }

    public boolean isRegression() {
        return this.is_regression_tree;
    }

    public void setRegressionTree(boolean flag) {
        this.is_regression_tree = flag;
    }

    public double[] getVariableDevianceValues() {
        return this.variableDevianceValues;
    }

    public int getNodeCount() {
        return this.nodeCount;
    }
}

