/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner.tree.model;

import com.insightful.miner.EngineNode;
import com.insightful.miner.XMLTree;
import com.insightful.miner.XTMetaData;
import com.insightful.miner.tree.model.ClassificationRegressionTree;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import javax.swing.JFrame;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class TreeCollection {
    private String header_element_tag = "Header";
    private String header_name_attribute_tag = "name";
    private String header_copyright_attribute_tag = "copyright";
    private String header_description_attribute_tag = "description";
    private String application_element_tag = "Application";
    private String application_version_attribute_tag = "version";
    private String application_name_attribute_tag = "name";
    private String annotation_element_tag = "Annotation";
    private String timestamp_element_tag = "Timestamp";
    private String XTMetaData_element_tag = "XTMetaData";
    private String columnDefinitions_element_tag = "ColumnDefinitions";
    private String treeList_element_tag = "TreeList";
    private String treeList_attribute_modelType_tag = "modelType";
    private String miningSchema_element_tag = "MiningSchema";
    private String miningSchema_attribute_usageType_tag = "usageType";
    private String miningSchema_attribute_name_tag = "name";
    private String miningSchema_attribute_criterion_tag = "criterion";
    private String treeModel_element_tag = "TreeModel";
    private String columnInfo_element_tag = "ColumnInfo";
    private String columnInfo_attribute_name_tag = "name";
    private String columnInfo_attribute_type_tag = "type";
    private String level_element_tag = "Level";
    private String level_attribute_value_tag = "value";
    public String miningSchema_attribute_entropy_value = "entropy";
    public String miningSchema_attribute_gini_value = "Gini";
    private XMLTree xmltree = null;
    private String modelName = "";
    private String copyright = "";
    private String description = "";
    private String application = "";
    private double appversion = 0.0;
    private String annotation = "";
    private String timestamp = "";
    private String criterion = "";
    private int numColumns = 0;
    private boolean[] columnTypeIsContinuous;
    private Vector columnNames = new Vector();
    private int[] numCatVars;
    private Vector[] catNames;
    private String dependentVar = "";
    private int dependentVarIndex = 0;
    private double[][] VariableDevianceVals = null;
    private JFrame parentFrame = null;
    private XTMetaData inputMetaData = null;
    private ClassificationRegressionTree[] trees = null;
    private EngineNode engineNode = null;
    private int nodeID = -1;
    private String docID = "";
    private boolean regression_tree = false;
    private boolean displaySplit = true;
    private boolean displaySize = true;
    private boolean displayScore = true;
    private boolean displayDeviance = true;
    private boolean displayRisk = true;
    private boolean displayProbs = true;
    private boolean displaySizeGraphic = false;
    private boolean showProportions = true;

    public TreeCollection(InputStream stream) {
        this(TreeCollection.getXMLTrees(stream).getDocumentElement(), null, -1, "");
    }

    public TreeCollection(XMLTree xt, XTMetaData inputData, int node_id, String doc_id) {
        this(xt.getXML(), inputData, node_id, doc_id);
    }

    public TreeCollection(Element XMLelt, XTMetaData inputData, int node_id, String doc_id) {
        this.nodeID = node_id;
        this.docID = doc_id;
        this.inputMetaData = inputData;
        try {
            this.xmltree = new XMLTree(XMLelt);
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        this.trees = this.createTrees(XMLelt);
        this.calculateVarDevValues(this.trees);
    }

    public XTMetaData getInputMetaData() {
        return this.inputMetaData;
    }

    public void setParentFrame(JFrame frame) {
        this.parentFrame = frame;
    }

    public JFrame getParentFrame() {
        return this.parentFrame;
    }

    public int getNodeID() {
        return this.nodeID;
    }

    public String getDocID() {
        return this.docID;
    }

    public XMLTree getXMLTree() {
        return this.xmltree;
    }

    private ClassificationRegressionTree[] createTrees(Element imml) {
        NodeList nodes = imml.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Element treeInstanceElement;
            int a;
            int j;
            Node imml_child = nodes.item(i);
            if (imml_child.getNodeType() != 1) continue;
            Element imml_child_elt = (Element)imml_child;
            if (imml_child_elt.getTagName().equals(this.header_element_tag)) {
                this.modelName = imml_child_elt.getAttribute(this.header_name_attribute_tag);
                this.copyright = imml_child_elt.getAttribute(this.header_copyright_attribute_tag);
                this.description = imml_child_elt.getAttribute(this.header_description_attribute_tag);
                NodeList headerItems = imml_child_elt.getChildNodes();
                for (j = 0; j < headerItems.getLength(); ++j) {
                    Node h_item = headerItems.item(j);
                    if (h_item.getNodeType() != 1) continue;
                    Element h_item_elt = (Element)h_item;
                    if (h_item_elt.getTagName().equals(this.application_element_tag)) {
                        this.application = h_item_elt.getAttribute(this.application_name_attribute_tag);
                        this.appversion = Double.parseDouble(h_item_elt.getAttribute(this.application_version_attribute_tag));
                        continue;
                    }
                    if (h_item_elt.getTagName().equals(this.annotation_element_tag)) {
                        this.annotation = h_item_elt.getFirstChild().toString();
                        continue;
                    }
                    if (!h_item_elt.getTagName().equals(this.timestamp_element_tag)) continue;
                    this.timestamp = h_item_elt.getFirstChild().toString();
                }
                continue;
            }
            if (imml_child_elt.getTagName().equals(this.XTMetaData_element_tag)) {
                NodeList colInfoNodeList = imml_child_elt.getChildNodes();
                for (j = 0; j < colInfoNodeList.getLength(); ++j) {
                    Element c_item_elt;
                    Node c_item = colInfoNodeList.item(j);
                    if (c_item.getNodeType() != 1 || !(c_item_elt = (Element)c_item).getTagName().equals(this.columnDefinitions_element_tag)) continue;
                    this.getColumnDefinitionsElements(c_item_elt);
                }
                continue;
            }
            if (!imml_child_elt.getTagName().equals(this.treeList_element_tag)) continue;
            this.regression_tree = "regression".equals(imml_child_elt.getAttribute(this.treeList_attribute_modelType_tag));
            NodeList treeListNodeList = imml_child_elt.getChildNodes();
            int count = 0;
            int collcount = 0;
            for (a = 0; a < treeListNodeList.getLength(); ++a) {
                if (treeListNodeList.item(a).getNodeType() == 1) {
                    treeInstanceElement = (Element)treeListNodeList.item(a);
                    if (treeInstanceElement.getTagName().equals(this.miningSchema_element_tag)) {
                        NodeList columns = treeInstanceElement.getChildNodes();
                        collcount = 0;
                        for (int b = 0; b < columns.getLength(); ++b) {
                            if (columns.item(b).getNodeType() != 1) continue;
                            Element column = (Element)columns.item(b);
                            if ("predicted".equals(column.getAttribute(this.miningSchema_attribute_usageType_tag))) {
                                this.dependentVar = column.getAttribute(this.miningSchema_attribute_name_tag);
                                this.dependentVarIndex = collcount;
                            }
                            this.addColumn(column.getAttribute(this.miningSchema_attribute_name_tag));
                            ++collcount;
                        }
                    } else if (treeInstanceElement.getTagName().equals(this.treeModel_element_tag)) {
                        ++count;
                        this.criterion = treeInstanceElement.getAttribute(this.miningSchema_attribute_criterion_tag);
                    }
                }
                this.VariableDevianceVals = new double[count][collcount - 1];
            }
            this.trees = new ClassificationRegressionTree[count];
            count = 0;
            for (a = 0; a < treeListNodeList.getLength(); ++a) {
                if (treeListNodeList.item(a).getNodeType() != 1 || !(treeInstanceElement = (Element)treeListNodeList.item(a)).getTagName().equals(this.treeModel_element_tag)) continue;
                this.trees[count] = new ClassificationRegressionTree(this, this.regression_tree);
                this.trees[count].createNodes(treeInstanceElement);
                ++count;
            }
        }
        return this.trees;
    }

    private void getColumnDefinitionsElements(Element elt) {
        String dataFieldName = "";
        String dataFieldType = "";
        NodeList columnDefinitionsElements = elt.getChildNodes();
        int colDefCounter = 0;
        for (int q = 0; q < columnDefinitionsElements.getLength(); ++q) {
            if (columnDefinitionsElements.item(q).getNodeType() != 1) continue;
            ++colDefCounter;
        }
        this.numCatVars = new int[colDefCounter];
        this.catNames = new Vector[colDefCounter];
        this.columnTypeIsContinuous = new boolean[colDefCounter];
        colDefCounter = 0;
        for (int z = 0; z < columnDefinitionsElements.getLength(); ++z) {
            Element dataField;
            if (columnDefinitionsElements.item(z).getNodeType() != 1 || !(dataField = (Element)columnDefinitionsElements.item(z)).getTagName().equals(this.columnInfo_element_tag)) continue;
            dataFieldName = dataField.getAttribute(this.columnInfo_attribute_name_tag);
            dataFieldType = dataField.getAttribute(this.columnInfo_attribute_type_tag);
            if ("continuous".equals(dataFieldType)) {
                this.numCatVars[colDefCounter] = 0;
                this.catNames[colDefCounter] = new Vector();
                this.catNames[colDefCounter].addElement("none");
                this.columnTypeIsContinuous[colDefCounter] = true;
            } else if ("categorical".equals(dataFieldType)) {
                this.columnTypeIsContinuous[colDefCounter] = false;
                NodeList categoricalElements = dataField.getChildNodes();
                for (int e = 0; e < categoricalElements.getLength(); ++e) {
                    if (categoricalElements.item(e).getNodeType() != 1) continue;
                    Element catElement = (Element)categoricalElements.item(e);
                    if (catElement.getTagName().equals(this.level_element_tag) && this.catNames[colDefCounter] == null) {
                        this.catNames[colDefCounter] = new Vector();
                    }
                    this.catNames[colDefCounter].addElement(catElement.getAttribute(this.level_attribute_value_tag));
                    int n = colDefCounter;
                    this.numCatVars[n] = this.numCatVars[n] + 1;
                }
            }
            ++colDefCounter;
        }
    }

    private void addColumn(String field) {
        ++this.numColumns;
        this.columnNames.addElement(field);
    }

    private void calculateVarDevValues(ClassificationRegressionTree[] trees) {
        int count = 0;
        for (int i = 0; i < trees.length; ++i) {
            double[] valsForOneTree = trees[i].getVariableDevianceValues();
            for (int j = 0; j < valsForOneTree.length; ++j) {
                if (j == this.getDependentVarIndex()) {
                    ++count;
                    continue;
                }
                double[] dArray = this.VariableDevianceVals[i];
                int n = j - count;
                dArray[n] = dArray[n] + valsForOneTree[j];
            }
            count = 0;
        }
    }

    public double[] getImportanceValues() {
        double[] importanceValues = new double[this.VariableDevianceVals[0].length];
        double importance = 0.0;
        for (int i = 0; i < this.VariableDevianceVals[0].length; ++i) {
            for (int j = 0; j < this.VariableDevianceVals.length; ++j) {
                importance += this.VariableDevianceVals[j][i];
            }
            importanceValues[i] = importance;
            importance = 0.0;
        }
        return importanceValues;
    }

    public String[] getIndependentColNames() {
        String depVar = this.getDependentVar();
        String tempvar = "";
        String[] colNames = new String[this.getNumberColumns() - 1];
        int count = 0;
        for (int i = 0; i < this.getNumberColumns(); ++i) {
            tempvar = this.getColumnName(i);
            if (depVar.equals(tempvar)) {
                --count;
                continue;
            }
            colNames[i + count] = tempvar;
        }
        return colNames;
    }

    private static Document getXMLTrees(InputStream ins) {
        Document document = null;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            document = builder.parse(ins);
        }
        catch (SAXParseException spe) {
            document = null;
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            document = null;
        }
        catch (SAXException sxe) {
            Exception x = sxe;
            if (sxe.getException() != null) {
                x = sxe.getException();
            }
            x.printStackTrace();
            document = null;
        }
        catch (ParserConfigurationException pce) {
            pce.printStackTrace();
            document = null;
        }
        return document;
    }

    public boolean isRegression() {
        return this.regression_tree;
    }

    public int getNumberColumns() {
        return this.columnNames.size();
    }

    public boolean isColumnContinuous(int columnIndex) {
        return this.columnTypeIsContinuous[columnIndex];
    }

    public int getColumnIndex(String name) {
        return this.columnNames.indexOf(name);
    }

    public String getColumnName(int index) {
        return (String)this.columnNames.elementAt(index);
    }

    public double[][] getVarDevVals() {
        return this.VariableDevianceVals;
    }

    public int getLevelIndex(int column, String level) {
        return this.catNames[column].indexOf(level);
    }

    public String getLevelName(int column, int levelIndex) {
        return (String)this.catNames[column].elementAt(levelIndex);
    }

    public int getNumberLevels(int column) {
        return this.catNames[column].size();
    }

    public int getNumberTrees() {
        return this.trees.length;
    }

    public ClassificationRegressionTree getTree(int index) {
        return this.trees[index];
    }

    public String getModelName() {
        return this.modelName;
    }

    public String getDependentVar() {
        return this.dependentVar;
    }

    public int getDependentVarIndex() {
        return this.dependentVarIndex;
    }

    public int[] getNumCatVarsArray() {
        return this.numCatVars;
    }

    public String getName() {
        return this.modelName;
    }

    public String getCopyright() {
        return this.copyright;
    }

    public String getDescription() {
        return this.description;
    }

    public String getApplication() {
        return this.application;
    }

    public double getAppversion() {
        return this.appversion;
    }

    public String getAnnotation() {
        return this.annotation;
    }

    public String getTimestamp() {
        return this.timestamp;
    }

    public String getCriterion() {
        return this.criterion;
    }

    public String getString() {
        String s = "";
        s = s + (this.isRegression() ? "REGRESSION" : "CLASSIFICATION") + " TREE MODEL:  \"" + this.modelName + "\"  (" + this.trees.length + (this.trees.length > 1 ? " trees)" : " tree)") + "\n";
        return s;
    }

    public void setDisplaySplit(boolean split) {
        this.displaySplit = split;
    }

    public boolean getDisplaySplit() {
        return this.displaySplit;
    }

    public void setDisplaySize(boolean size) {
        this.displaySize = size;
    }

    public boolean getDisplaySize() {
        return this.displaySize;
    }

    public void setDisplayScore(boolean score) {
        this.displayScore = score;
    }

    public boolean getDisplayScore() {
        return this.displayScore;
    }

    public void setDisplayDeviance(boolean dev) {
        this.displayDeviance = dev;
    }

    public boolean getDisplayDeviance() {
        return this.displayDeviance;
    }

    public void setDisplayProbs(boolean probs) {
        this.displayProbs = probs;
    }

    public boolean getDisplayProbs() {
        return this.displayProbs;
    }

    public void setDisplayRisk(boolean risk) {
        this.displayRisk = risk;
    }

    public boolean getDisplayRisk() {
        return this.displayRisk;
    }

    public void setDisplaySizeGraphic(boolean size) {
        this.displaySizeGraphic = size;
    }

    public boolean getDisplaySizeGraphic() {
        return this.displaySizeGraphic;
    }

    public void setShowProportions(boolean flag) {
        this.showProportions = flag;
    }

    public boolean getShowProportions() {
        return this.showProportions;
    }
}

