/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.data.junit;

import com.jrefinery.data.Month;
import com.jrefinery.data.TimePeriodFormatException;
import java.util.Date;
import java.util.TimeZone;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class MonthTests
extends TestCase {
    protected Month jan_1900;
    protected Month feb_1900;
    protected Month nov_9999;
    protected Month dec_9999;
    static /* synthetic */ Class class$com$jrefinery$data$junit$MonthTests;

    public static Test suite() {
        return new TestSuite(class$com$jrefinery$data$junit$MonthTests == null ? (class$com$jrefinery$data$junit$MonthTests = MonthTests.class$("com.jrefinery.data.junit.MonthTests")) : class$com$jrefinery$data$junit$MonthTests);
    }

    public MonthTests(String string) {
        super(string);
    }

    protected void setUp() {
        this.jan_1900 = new Month(1, 1900);
        this.feb_1900 = new Month(2, 1900);
        this.nov_9999 = new Month(11, 9999);
        this.dec_9999 = new Month(12, 9999);
    }

    public void testDateConstructor1() {
        TimeZone timeZone = TimeZone.getTimeZone("GMT");
        Month month = new Month(new Date(951868799999L), timeZone);
        Month month2 = new Month(new Date(951868800000L), timeZone);
        Assert.assertEquals((int)2, (int)month.getMonth());
        Assert.assertEquals((long)951868799999L, (long)month.getEnd(timeZone));
        Assert.assertEquals((int)3, (int)month2.getMonth());
        Assert.assertEquals((long)951868800000L, (long)month2.getStart(timeZone));
    }

    public void testDateConstructor2() {
        TimeZone timeZone = TimeZone.getTimeZone("Pacific/Auckland");
        Month month = new Month(new Date(951821999999L), timeZone);
        Month month2 = new Month(new Date(951822000000L), timeZone);
        Assert.assertEquals((int)2, (int)month.getMonth());
        Assert.assertEquals((long)951821999999L, (long)month.getEnd(timeZone));
        Assert.assertEquals((int)3, (int)month2.getMonth());
        Assert.assertEquals((long)951822000000L, (long)month2.getStart(timeZone));
    }

    public void testJan_1900_previous() {
        Month month = (Month)this.jan_1900.previous();
        Assert.assertNull((Object)month);
    }

    public void testJan_1900_next() {
        Month month = (Month)this.jan_1900.next();
        Assert.assertEquals((Object)this.feb_1900, (Object)month);
    }

    public void testDec_9999_previous() {
        Month month = (Month)this.dec_9999.previous();
        Assert.assertEquals((Object)this.nov_9999, (Object)month);
    }

    public void testDec_9999_next() {
        Month month = (Month)this.dec_9999.next();
        Assert.assertNull((Object)month);
    }

    public void testParseMonth() {
        Month month = null;
        try {
            month = Month.parseMonth("1990-01");
        }
        catch (TimePeriodFormatException timePeriodFormatException) {
            month = new Month(1, 1900);
        }
        Assert.assertEquals((int)1, (int)month.getMonth());
        Assert.assertEquals((int)1990, (int)month.getYear().getYear());
        try {
            month = Month.parseMonth("02-1991");
        }
        catch (TimePeriodFormatException timePeriodFormatException) {
            month = new Month(1, 1900);
        }
        Assert.assertEquals((int)2, (int)month.getMonth());
        Assert.assertEquals((int)1991, (int)month.getYear().getYear());
        try {
            month = Month.parseMonth("March 1993");
        }
        catch (TimePeriodFormatException timePeriodFormatException) {
            month = new Month(1, 1900);
        }
        Assert.assertEquals((int)3, (int)month.getMonth());
        Assert.assertEquals((int)1993, (int)month.getYear().getYear());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

