/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.context.request;

import java.util.Iterator;
import java.util.Map;
import org.springframework.core.CollectionFactory;
import org.springframework.util.Assert;
import org.springframework.web.context.request.RequestAttributes;

public abstract class AbstractRequestAttributes
implements RequestAttributes {
    protected final Map requestDestructionCallbacks = CollectionFactory.createLinkedMapIfPossible(8);

    public void requestCompleted() {
        this.executeRequestDestructionCallbacks();
        this.updateAccessedSessionAttributes();
    }

    protected final void registerRequestDestructionCallback(String name, Runnable callback) {
        Assert.notNull(name, "Name must not be null");
        Assert.notNull(callback, "Callback must not be null");
        this.requestDestructionCallbacks.put(name, callback);
    }

    protected final void removeRequestDestructionCallback(String name) {
        Assert.notNull(name, "Name must not be null");
        this.requestDestructionCallbacks.remove(name);
    }

    private void executeRequestDestructionCallbacks() {
        Iterator it = this.requestDestructionCallbacks.values().iterator();
        while (it.hasNext()) {
            ((Runnable)it.next()).run();
        }
    }

    protected abstract void updateAccessedSessionAttributes();
}

