/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.gdevice;

import com.insightful.gdevice.SCanvasAWT;
import com.insightful.gdevice.SCanvasPoint;
import java.awt.Rectangle;
import java.io.Serializable;

public class SCanvasRectangle
implements Serializable {
    float m_x;
    float m_y;
    float m_width;
    float m_height;

    public SCanvasRectangle(float f, float f2, float f3, float f4) {
        this.m_x = f;
        this.m_y = f2;
        this.m_width = f3;
        this.m_height = f4;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof SCanvasRectangle)) {
            return false;
        }
        SCanvasRectangle sCanvasRectangle = (SCanvasRectangle)object;
        return this.m_x == sCanvasRectangle.m_x && this.m_y == sCanvasRectangle.m_y && this.m_width == sCanvasRectangle.m_width && this.m_height == sCanvasRectangle.m_height;
    }

    public SCanvasPoint getFirstCorner() {
        return new SCanvasPoint(this.m_x, this.m_y);
    }

    public SCanvasPoint getSecondCorner() {
        return new SCanvasPoint(this.m_x + this.m_width, this.m_y + this.m_height);
    }

    public int getLeft(SCanvasAWT sCanvasAWT) {
        return sCanvasAWT.fracToGraphX(this.m_width >= 0.0f ? this.m_x : this.m_x + this.m_width);
    }

    public int getTop(SCanvasAWT sCanvasAWT) {
        return sCanvasAWT.fracToGraphY(this.m_height >= 0.0f ? this.m_y : this.m_y + this.m_height);
    }

    public int getWidth(SCanvasAWT sCanvasAWT) {
        return sCanvasAWT.fracToGraphX(this.m_width >= 0.0f ? this.m_width : -this.m_width);
    }

    public int getHeight(SCanvasAWT sCanvasAWT) {
        return sCanvasAWT.fracToGraphY(this.m_height >= 0.0f ? this.m_height : -this.m_height);
    }

    public Rectangle getWindowRect(SCanvasAWT sCanvasAWT) {
        int n = sCanvasAWT.fracToGraphX(this.m_x);
        int n2 = sCanvasAWT.fracToGraphY(this.m_y);
        int n3 = sCanvasAWT.fracToGraphX(this.m_width);
        int n4 = sCanvasAWT.fracToGraphY(this.m_height);
        if (n3 < 0) {
            n += n3;
            n3 = -n3;
        }
        if (n4 < 0) {
            n2 += n4;
            n4 = -n4;
        }
        return new Rectangle(n, n2, n3, n4);
    }

    public boolean contains(float f, float f2) {
        return !(f < this.minX() || f > this.maxX() || f2 < this.minY() || f2 > this.maxY());
    }

    public float getX() {
        return this.m_x;
    }

    public float getY() {
        return this.m_y;
    }

    public float getWidth() {
        return this.m_width;
    }

    public float getHeight() {
        return this.m_height;
    }

    public float minX() {
        return Math.min(this.m_x, this.m_x + this.m_width);
    }

    public float maxX() {
        return Math.max(this.m_x, this.m_x + this.m_width);
    }

    public float minY() {
        return Math.min(this.m_y, this.m_y + this.m_height);
    }

    public float maxY() {
        return Math.max(this.m_y, this.m_y + this.m_height);
    }
}

