/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.gdevice;

import com.insightful.gdevice.IDHash;
import com.insightful.gdevice.SCanvasAWT;
import com.insightful.gdevice.SGraphCommand;
import com.insightful.gdevice.XML;
import com.insightful.gdevice.XMLElement;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.io.PrintWriter;

class SGraphPoints
extends SGraphCommand {
    static int[][] symbolActions = new int[][]{{1, 0}, {2, 0}, {3, 0}, {4, 0}, {5, 0}, {6, 0}, {7, 0}, {1, 5}, {4, 5}, {4, 6}, {2, 4}, {3, 7}, {1, 4}, {2, 5}, {8, 0}, {-1, 0}, {-2, 0}, {-3, 0}, {-6, 0}};
    static int[][] xSymbol = new int[][]{{-2, 2, 2, -2}, {-1, 1, 2, 2, 1, -1, -2, -2, -1}, {0, 2, -2, 0}, {-2, 2, 0, 0}, {-2, 2, 2, -2}, {0, 2, 0, -2, 0}, {-2, 2, 0, -2}, {-2, -2, 2, 2, -2, 0, 2}};
    static int[][] ySymbol = new int[][]{{2, 2, -2, -2}, {-2, -2, -1, 1, 2, 2, 1, -1, -2}, {2, -2, -2, 2}, {0, 0, -2, 2}, {-2, 2, -2, 2}, {-2, 0, 2, 0, -2}, {2, 2, -2, 2}, {-2, 2, 2, -2, -2, 2, -2}};
    static boolean[] connectedLinesSymbol = new boolean[]{true, true, true, false, false, true, true, true};
    private float[] m_ax;
    private float[] m_ay;
    private char m_chPlot;
    private float m_fontSize;
    private float m_symbolSize;
    private float m_fontNumber;

    SGraphPoints(float[] fArray, float[] fArray2, char c, float f, float f2, float f3) {
        this.m_ax = new float[fArray.length];
        this.m_ay = new float[fArray2.length];
        System.arraycopy(fArray, 0, this.m_ax, 0, fArray.length);
        System.arraycopy(fArray2, 0, this.m_ay, 0, fArray2.length);
        this.m_chPlot = c;
        this.m_fontSize = f;
        this.m_symbolSize = f2;
        this.m_fontNumber = f3;
    }

    void print(SCanvasAWT sCanvasAWT, Graphics graphics) {
        this.display(sCanvasAWT, graphics, true);
    }

    void display(SCanvasAWT sCanvasAWT, Graphics graphics) {
        this.display(sCanvasAWT, graphics, false);
    }

    void display(SCanvasAWT sCanvasAWT, Graphics graphics, boolean bl) {
        Rectangle rectangle = this.setParClip(sCanvasAWT, graphics);
        if (this.m_chPlot < ' ') {
            this.displaySymbolPoints(sCanvasAWT, graphics);
        } else {
            this.displayCharPoints(sCanvasAWT, graphics, bl);
        }
        this.resetClip(sCanvasAWT, graphics, rectangle);
    }

    void displayCharPoints(SCanvasAWT sCanvasAWT, Graphics graphics, boolean bl) {
        this.setTextColor(sCanvasAWT, graphics);
        if (this.m_chPlot == '.') {
            for (int i = 0; i < this.m_ax.length; ++i) {
                int n = this.valToWindowX(sCanvasAWT, this.m_ax[i]);
                int n2 = this.valToWindowY(sCanvasAWT, this.m_ay[i]);
                graphics.drawLine(n, n2, n, n2);
            }
            return;
        }
        graphics.setFont(sCanvasAWT.getFont(this.m_fontSize, this.m_fontNumber));
        String string = sCanvasAWT.getFontText(String.valueOf(this.m_chPlot), this.m_fontNumber);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n = fontMetrics.stringWidth(string);
        int n3 = n / 2;
        int n4 = fontMetrics.getAscent() / 2;
        for (int i = 0; i < this.m_ax.length; ++i) {
            int n5 = this.valToWindowX(sCanvasAWT, this.m_ax[i]) - n3;
            int n6 = this.valToWindowY(sCanvasAWT, this.m_ay[i]) + n4;
            if (bl) {
                sCanvasAWT.printString(graphics, string, n5, n6);
                continue;
            }
            graphics.drawString(string, n5, n6);
        }
    }

    void displaySymbolPoints(SCanvasAWT sCanvasAWT, Graphics graphics) {
        int n;
        char c = this.m_chPlot <= '\u0012' && this.m_chPlot >= '\u0000' ? this.m_chPlot : (char)'\u0001';
        this.setTextColor(sCanvasAWT, graphics);
        graphics.setFont(sCanvasAWT.getFont(this.m_fontSize, this.m_fontNumber));
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n2 = n = (int)(0.2 * (double)fontMetrics.getHeight());
        for (int i = 0; i < 2; ++i) {
            int n3 = symbolActions[c][i];
            if (n3 == 0) continue;
            int n4 = Math.abs(n3) - 1;
            if (n4 == 1 && n < 2 && n2 < 2) {
                n4 = 5;
            }
            int[] nArray = new int[xSymbol[n4].length];
            int[] nArray2 = new int[ySymbol[n4].length];
            for (int j = 0; j < this.m_ax.length; ++j) {
                int n5;
                int n6 = this.valToWindowX(sCanvasAWT, this.m_ax[j]);
                int n7 = this.valToWindowY(sCanvasAWT, this.m_ay[j]);
                if (n < 1 && n2 < 1) {
                    graphics.drawLine(n6, n7, n6, n7);
                    continue;
                }
                for (n5 = 0; n5 < nArray.length; ++n5) {
                    nArray[n5] = xSymbol[n4][n5] * n / 2 + n6;
                    nArray2[n5] = n7 - ySymbol[n4][n5] * n2 / 2;
                }
                if (n3 < 0) {
                    graphics.fillPolygon(nArray, nArray2, nArray.length);
                    continue;
                }
                if (connectedLinesSymbol[n4]) {
                    graphics.drawPolygon(nArray, nArray2, nArray.length);
                    continue;
                }
                for (n5 = 0; n5 < nArray.length - 1; n5 += 2) {
                    graphics.drawLine(nArray[n5], nArray2[n5], nArray[n5 + 1], nArray2[n5 + 1]);
                }
            }
        }
    }

    public String getXMLTag() {
        return "POINTS";
    }

    public void writeXMLProperties(PrintWriter printWriter) {
        XML.writeProperty(printWriter, "CHAR", this.m_chPlot);
        XML.writeProperty(printWriter, "FONTSIZE", this.m_fontSize);
        XML.writeProperty(printWriter, "SYMBOLSIZE", this.m_symbolSize);
        XML.writeProperty(printWriter, "FONTNUMBER", this.m_fontNumber);
    }

    public void writeXMLContents(PrintWriter printWriter) {
        XML.writeData(printWriter, "X", this.m_ax);
        XML.writeData(printWriter, "Y", this.m_ay);
    }

    public static SGraphCommand createFromXML(XMLElement xMLElement, IDHash iDHash) {
        char c = (char)XML.getIntProperty(xMLElement, "CHAR", iDHash);
        float f = XML.getFloatProperty(xMLElement, "FONTSIZE", iDHash);
        float f2 = XML.getFloatProperty(xMLElement, "SYMBOLSIZE", iDHash);
        float f3 = XML.getFloatProperty(xMLElement, "FONTNUMBER", iDHash);
        float[] fArray = XML.getFloatArrayData(xMLElement, "X");
        float[] fArray2 = XML.getFloatArrayData(xMLElement, "Y");
        return new SGraphPoints(fArray, fArray2, c, f, f2, f3);
    }
}

