/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.splus.eclipse.server.util.dialogs;

import com.insightful.splus.eclipse.server.UiProperties;
import com.insightful.splus.eclipse.server.util.RemoteResults;
import com.insightful.splus.eclipse.server.util.RemoteUtils;
import com.insightful.splus.eclipse.server.util.SplusDialog;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.texteditor.ITextEditor;

public class RunRemoteDialog
extends SplusDialog {
    private IWorkbenchWindow m_window;
    private ISelection m_selection;
    private Combo m_ip = null;
    private Text m_userName = null;
    private Text m_password = null;
    private Text m_script = null;
    private Button m_useEditor = null;
    private Button m_useSelection = null;
    private Button m_useScript = null;
    private Button m_run = null;
    private Button m_cancel = null;

    public RunRemoteDialog(Shell shell, IWorkbenchWindow iWorkbenchWindow, ISelection iSelection) {
        super(shell, UiProperties.getString("RunRemoteDialog.DialogTitle"), new String[]{UiProperties.getString("RunRemoteDialog.SplusServerLibrary")});
        this.m_window = iWorkbenchWindow;
        this.m_selection = iSelection;
    }

    public String getIP() {
        return this.m_ip.getText();
    }

    public String getUserName() {
        return this.m_userName.getText();
    }

    public String getPassword() {
        return this.m_password.getText();
    }

    public String getScript() {
        String string = null;
        if (this.m_useEditor.getSelection()) {
            IEditorPart iEditorPart = this.m_window.getActivePage().getActiveEditor();
            if (iEditorPart instanceof ITextEditor) {
                ITextEditor iTextEditor = (ITextEditor)iEditorPart;
                IDocument iDocument = iTextEditor.getDocumentProvider().getDocument((Object)iEditorPart.getEditorInput());
                string = iDocument.get();
            }
        } else if (this.m_useSelection.getSelection()) {
            if (this.m_selection != null && this.m_selection instanceof ITextSelection) {
                string = ((ITextSelection)this.m_selection).getText();
            }
        } else {
            string = this.m_script.getText();
        }
        return string;
    }

    public boolean getAsync() {
        return true;
    }

    protected void createContents(Shell shell) {
        GridData gridData = new GridData(768);
        GridData gridData2 = new GridData(768);
        GridData gridData3 = new GridData(1808);
        Composite composite = new Composite((Composite)shell, 0);
        composite.setLayoutData((Object)gridData);
        composite.setLayout((Layout)new GridLayout(2, false));
        Label label = new Label(composite, 0);
        label.setText(UiProperties.getString("RunRemoteDialog.ServerLocation"));
        this.m_ip = new Combo(composite, 0);
        this.m_ip.setLayoutData((Object)gridData);
        Label label2 = new Label(composite, 0);
        label2.setText(UiProperties.getString("RunRemoteDialog.UserName"));
        this.m_userName = new Text(composite, 2048);
        this.m_userName.setLayoutData((Object)gridData);
        Label label3 = new Label(composite, 0);
        label3.setText(UiProperties.getString("RunRemoteDialog.Password"));
        this.m_password = new Text(composite, 0x400800);
        this.m_password.setLayoutData((Object)gridData);
        Composite composite2 = new Composite((Composite)shell, 0);
        composite2.setLayoutData((Object)gridData3);
        composite2.setLayout((Layout)new GridLayout(1, false));
        this.m_useEditor = new Button(composite2, 16);
        this.m_useEditor.setText(UiProperties.getString("RunRemoteDialog.ActiveScript"));
        this.m_useEditor.setLayoutData((Object)gridData2);
        this.m_useSelection = new Button(composite2, 16);
        this.m_useSelection.setLayoutData((Object)gridData2);
        this.m_useSelection.setText(UiProperties.getString("RunRemoteDialog.SelectedText"));
        this.m_useScript = new Button(composite2, 16);
        this.m_useScript.setLayoutData((Object)gridData2);
        this.m_useScript.setText(UiProperties.getString("RunRemoteDialog.Script"));
        this.m_script = new Text(composite2, 2818);
        GridData gridData4 = new GridData(1808);
        gridData4.horizontalIndent = 20;
        this.m_script.setLayoutData((Object)gridData4);
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                RunRemoteDialog.this.updateDialogState();
            }
        };
        this.m_useEditor.addListener(13, listener);
        this.m_useSelection.addListener(13, listener);
        this.m_useScript.addListener(13, listener);
    }

    protected void createButtons(final Shell shell) {
        Composite composite = new Composite((Composite)shell, 0);
        composite.setLayoutData((Object)new GridData(128));
        FillLayout fillLayout = new FillLayout(256);
        composite.setLayout((Layout)fillLayout);
        fillLayout.marginWidth = 2;
        fillLayout.marginHeight = 5;
        fillLayout.spacing = 5;
        this.m_run = new Button(composite, 0);
        this.m_run.setText(UiProperties.getString("RunRemoteDialog.Run"));
        this.m_cancel = new Button(composite, 0);
        this.m_cancel.setText(UiProperties.getString("RunRemoteDialog.Cancel"));
        this.m_run.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                RunRemoteDialog.this.storeSettings();
                RunRemoteDialog.this.runRemotely(RunRemoteDialog.this.getIP(), RunRemoteDialog.this.getUserName(), RunRemoteDialog.this.getPassword(), RunRemoteDialog.this.getScript(), RunRemoteDialog.this.getAsync());
                shell.close();
            }
        });
        this.m_cancel.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                shell.close();
            }
        });
    }

    private void runRemotely(String string, String string2, String string3, String string4, boolean bl) {
        string4 = UiProperties.getString("RunRemoteDialog.AutoGeneratedCode_Line1") + UiProperties.getString("RunRemoteDialog.AutoGeneratedCode_Line2") + UiProperties.getString("RunRemoteDialog.AutoGeneratedCode_Line3") + UiProperties.getString("RunRemoteDialog.AutoGeneratedCode_Line4") + UiProperties.getString("RunRemoteDialog.AutoGeneratedCode_Line5") + UiProperties.getString("RunRemoteDialog.AutoGeneratedCode_Line6") + UiProperties.getString("RunRemoteDialog.AutoGeneratedCode_Line7") + UiProperties.getString("RunRemoteDialog.AutoGeneratedCode_LastLine") + string4;
        RemoteResults remoteResults = RemoteUtils.runRemotely(string, string2, string3, string4, bl, this);
        String string5 = null;
        string5 = bl ? remoteResults.constructInput(string4) : remoteResults.constructOutput();
        RemoteUtils.sendOutputToWorkbench(string5);
    }

    private void storeSettings() {
        RemoteUtils.saveServerLocations(this.m_ip);
        RemoteUtils.saveUserName(this.m_userName);
    }

    protected void initializeContents() {
        RemoteUtils.loadServerLocations(this.m_ip);
        RemoteUtils.loadUserName(this.m_userName);
        boolean bl = false;
        if (this.m_selection != null) {
            String string;
            bl = this.m_selection instanceof ITextSelection ? (string = ((ITextSelection)this.m_selection).getText()) != null && string.length() != 0 : false;
        }
        boolean bl2 = false;
        if (this.m_window != null) {
            IWorkbenchPage[] iWorkbenchPageArray = this.m_window.getPages();
            for (int i = 0; !bl2 && iWorkbenchPageArray != null && i < iWorkbenchPageArray.length; ++i) {
                if (iWorkbenchPageArray[i].getActiveEditor() == null) continue;
                bl2 = true;
            }
        }
        this.m_useEditor.setEnabled(bl2);
        this.m_useSelection.setEnabled(bl);
        if (bl2) {
            this.m_useEditor.setSelection(true);
        } else if (bl) {
            this.m_useSelection.setSelection(true);
        } else {
            this.m_useScript.setSelection(true);
        }
        this.updateDialogState();
    }

    protected void addDialogStateListener(Listener listener) {
        this.m_ip.addListener(24, listener);
        this.m_userName.addListener(24, listener);
        this.m_password.addListener(24, listener);
        this.m_script.addListener(24, listener);
        this.m_useEditor.addListener(13, listener);
        this.m_useSelection.addListener(13, listener);
        this.m_useScript.addListener(13, listener);
    }

    protected void updateDialogState() {
        boolean bl = this.m_useScript.getSelection();
        this.m_script.setEnabled(bl);
        boolean bl2 = this.m_ip.getText().length() != 0;
        boolean bl3 = true;
        boolean bl4 = true;
        boolean bl5 = !bl || this.m_script.getText().length() != 0;
        this.m_run.setEnabled(bl2 && bl3 && bl4 && bl5);
    }

    protected boolean hasFocus() {
        return this.m_ip.isFocusControl() || this.m_userName.isFocusControl() || this.m_password.isFocusControl() || this.m_script.isFocusControl() || this.m_useEditor.isFocusControl() || this.m_useSelection.isFocusControl() || this.m_useScript.isFocusControl() || this.m_run.isFocusControl() || this.m_cancel.isFocusControl();
    }

    public void open() {
        this.doVoidOpen();
    }
}

