/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart;

import com.jrefinery.chart.CategoryPlot;
import com.jrefinery.chart.ValueAxis;
import com.jrefinery.chart.VerticalAxis;
import com.jrefinery.chart.VerticalBarRenderer;
import com.jrefinery.chart.VerticalNumberAxis3D;
import com.jrefinery.data.CategoryDataset;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;

public class VerticalBarRenderer3D
extends VerticalBarRenderer {
    public boolean hasItemGaps() {
        return true;
    }

    public int barWidthsPerCategory(CategoryDataset categoryDataset) {
        return categoryDataset.getSeriesCount();
    }

    public Shape drawCategoryItem(Graphics2D graphics2D, Rectangle2D rectangle2D, CategoryPlot categoryPlot, ValueAxis valueAxis, CategoryDataset categoryDataset, int n, Object object, int n2, Object object2) {
        Rectangle2D.Double double_ = null;
        Number number = categoryDataset.getValue(n, object);
        if (number != null) {
            double d = rectangle2D.getX() + rectangle2D.getWidth() * categoryPlot.getIntroGapPercent();
            int n3 = categoryDataset.getCategoryCount();
            int n4 = categoryDataset.getSeriesCount();
            if (n3 > 1) {
                d = d + (double)n2 * (this.categorySpan / (double)n3) + ((double)n2 * (this.categoryGapSpan / (double)(n3 - 1)) + (double)n * this.itemSpan / (double)(n3 * n4));
                if (n4 > 1) {
                    d += (double)n * this.itemGapSpan / (double)(n3 * (n4 - 1));
                }
            } else {
                d += (double)n * this.itemSpan / (double)(n3 * n4);
                if (n4 > 1) {
                    d += (double)n * this.itemGapSpan / (double)(n3 * (n4 - 1));
                }
            }
            double d2 = valueAxis.translateValueToJava2D(number.doubleValue(), rectangle2D);
            double d3 = Math.min(this.zeroInJava2D, d2);
            double d4 = this.itemWidth;
            double d5 = Math.abs(d2 - this.zeroInJava2D);
            Rectangle2D.Double double_2 = new Rectangle2D.Double(d, d3, d4, d5);
            Paint paint = categoryPlot.getSeriesPaint(n);
            graphics2D.setPaint(paint);
            graphics2D.fill(double_2);
            double_ = double_2;
            GeneralPath generalPath = null;
            GeneralPath generalPath2 = null;
            double d6 = 0.0;
            VerticalAxis verticalAxis = categoryPlot.getVerticalAxis();
            if (d5 != 0.0 && verticalAxis instanceof VerticalNumberAxis3D) {
                d6 = ((VerticalNumberAxis3D)verticalAxis).getEffect3d();
                generalPath = new GeneralPath();
                generalPath.moveTo((float)(d + d4), (float)d3);
                generalPath.lineTo((float)(d + d4), (float)(d3 + d5));
                generalPath.lineTo((float)(d + d4 + d6), (float)(d3 + d5 - d6));
                generalPath.lineTo((float)(d + d4 + d6), (float)(d3 - d6));
                if (paint instanceof Color) {
                    graphics2D.setPaint(((Color)paint).darker());
                }
                graphics2D.fill(generalPath);
                generalPath2 = new GeneralPath();
                generalPath2.moveTo((float)d, (float)d3);
                generalPath2.lineTo((float)(d + d6), (float)(d3 - d6));
                generalPath2.lineTo((float)(d + d4 + d6), (float)(d3 - d6));
                generalPath2.lineTo((float)(d + d4), (float)d3);
                if (paint instanceof Color) {
                    graphics2D.setPaint((Color)paint);
                }
                graphics2D.fill(generalPath2);
            }
            if (this.itemWidth > 3.0) {
                graphics2D.setStroke(categoryPlot.getSeriesOutlineStroke(n));
                graphics2D.setPaint(categoryPlot.getSeriesOutlinePaint(n));
                graphics2D.draw(double_2);
                if (generalPath != null) {
                    graphics2D.draw(generalPath);
                }
                if (generalPath2 != null) {
                    graphics2D.draw(generalPath2);
                }
            }
        }
        return double_;
    }
}

