/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart.tooltips;

import com.jrefinery.chart.tooltips.XYToolTipGenerator;
import com.jrefinery.data.TimeSeriesCollection;
import com.jrefinery.data.XYDataset;
import com.jrefinery.data.XisSymbolic;
import com.jrefinery.data.YisSymbolic;

public class SymbolicXYToolTipGenerator
implements XYToolTipGenerator {
    public String generateToolTip(XYDataset xYDataset, int n, int n2) {
        String string;
        Number number;
        String string2;
        if (xYDataset instanceof YisSymbolic) {
            string2 = ((YisSymbolic)xYDataset).getYSymbolicValue(n, n2);
        } else {
            number = xYDataset.getYValue(n, n2);
            string2 = Double.toString(SymbolicXYToolTipGenerator.round(number.doubleValue(), 2));
        }
        if (xYDataset instanceof XisSymbolic) {
            string = ((XisSymbolic)xYDataset).getXSymbolicValue(n, n2);
        } else if (xYDataset instanceof TimeSeriesCollection) {
            number = ((TimeSeriesCollection)xYDataset).getSeries(n).getTimePeriod(n2);
            string = number.toString();
        } else {
            number = xYDataset.getXValue(n, n2);
            string = Double.toString(SymbolicXYToolTipGenerator.round(number.doubleValue(), 2));
        }
        return "X: " + string + ", Y: " + string2;
    }

    private static double round(double d, int n) {
        if (n <= 0) {
            return Math.floor(d + 0.5);
        }
        double d2 = Math.pow(10.0, n);
        double d3 = Math.floor(d * d2 + 0.5);
        return d3 / d2;
    }
}

