/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.compare;

import com.ibm.icu.text.MessageFormat;
import org.eclipse.compare.CompareViewerPane;
import org.eclipse.compare.INavigatable;
import org.eclipse.compare.Splitter;
import org.eclipse.compare.contentmergeviewer.IFlushable;
import org.eclipse.compare.internal.CompareMessages;
import org.eclipse.compare.internal.NullViewer;
import org.eclipse.compare.internal.Utilities;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public abstract class CompareViewerSwitchingPane
extends CompareViewerPane {
    private Viewer fViewer;
    private boolean fControlVisibility = false;
    private String fTitle;
    private String fTitleArgument;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public CompareViewerSwitchingPane(Composite parent, int style) {
        this(parent, style, false);
    }

    public CompareViewerSwitchingPane(Composite parent, int style, boolean visibility) {
        super(parent, style);
        this.fControlVisibility = visibility;
        this.setViewer(new NullViewer((Composite)this));
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (CompareViewerSwitchingPane.this.fViewer != null) {
                    CompareViewerSwitchingPane.this.fViewer.removeSelectionChangedListener((ISelectionChangedListener)CompareViewerSwitchingPane.this);
                }
                if (CompareViewerSwitchingPane.this.fViewer instanceof StructuredViewer) {
                    StructuredViewer sv = (StructuredViewer)CompareViewerSwitchingPane.this.fViewer;
                    sv.removeDoubleClickListener((IDoubleClickListener)CompareViewerSwitchingPane.this);
                    sv.removeOpenListener((IOpenListener)CompareViewerSwitchingPane.this);
                }
                CompareViewerSwitchingPane.this.fViewer = null;
            }
        });
    }

    public Viewer getViewer() {
        return this.fViewer;
    }

    private void setViewer(Viewer newViewer) {
        if (newViewer == this.fViewer) {
            return;
        }
        boolean oldEmpty = this.isEmpty();
        if (this.fViewer != null) {
            this.fViewer.removeSelectionChangedListener((ISelectionChangedListener)this);
            if (this.fViewer instanceof StructuredViewer) {
                StructuredViewer sv = (StructuredViewer)this.fViewer;
                sv.removeDoubleClickListener((IDoubleClickListener)this);
                sv.removeOpenListener((IOpenListener)this);
            }
            Control content = this.getContent();
            this.setContent(null);
            this.fViewer.setInput(null);
            if (content != null && !content.isDisposed()) {
                content.dispose();
            }
        } else {
            oldEmpty = false;
        }
        this.setContent(null);
        this.fViewer = newViewer;
        if (this.fViewer != null) {
            Composite parent;
            boolean old = this.getVisible();
            this.setContent(this.fViewer.getControl());
            this.setVisible(old);
            boolean newEmpty = this.isEmpty();
            this.fViewer.addSelectionChangedListener((ISelectionChangedListener)this);
            if (this.fViewer instanceof StructuredViewer) {
                StructuredViewer sv = (StructuredViewer)this.fViewer;
                sv.addDoubleClickListener((IDoubleClickListener)this);
                sv.addOpenListener((IOpenListener)this);
            }
            if (oldEmpty != newEmpty && (parent = this.getParent()) instanceof Splitter) {
                ((Splitter)parent).setVisible((Control)this, this.fControlVisibility ? !newEmpty : true);
            }
            this.layout(true);
        }
    }

    public String getTitleArgument() {
        return this.fTitleArgument;
    }

    public boolean isEmpty() {
        return this.fViewer == null || this.fViewer instanceof NullViewer;
    }

    public ISelection getSelection() {
        if (this.fViewer != null) {
            return this.fViewer.getSelection();
        }
        return super.getSelection();
    }

    public void setSelection(ISelection s) {
        if (this.fViewer != null) {
            this.fViewer.setSelection(s);
        }
    }

    private boolean hasFocus2() {
        Display display = this.getDisplay();
        if (display != null) {
            Control focus = display.getFocusControl();
            while (focus != null) {
                if (focus == this) {
                    return true;
                }
                focus = focus.getParent();
            }
        }
        return false;
    }

    public void setInput(Object input) {
        Control c;
        if (this.getInput() == input) {
            return;
        }
        boolean hadFocus = this.hasFocus2();
        super.setInput(input);
        Viewer newViewer = null;
        if (input != null) {
            newViewer = this.getViewer(this.fViewer, input);
        }
        if (newViewer == null) {
            if (this.fViewer instanceof NullViewer) {
                return;
            }
            newViewer = new NullViewer((Composite)this);
        }
        this.setViewer(newViewer);
        this.fViewer.setInput(input);
        Image image = null;
        if (!(this.fViewer instanceof NullViewer) && input instanceof ICompareInput) {
            image = ((ICompareInput)input).getImage();
        }
        this.setImage(image);
        String title = null;
        if (this.fViewer != null && (c = this.fViewer.getControl()) != null) {
            Object data = c.getData("org.eclipse.compare.CompareUI.CompareViewerTitle");
            if (data instanceof String) {
                title = (String)data;
            }
            if (hadFocus) {
                c.setFocus();
            }
        }
        this.fTitle = title;
        this.updateTitle();
    }

    public void setTitleArgument(String argument) {
        this.fTitleArgument = argument;
        this.updateTitle();
    }

    private void updateTitle() {
        if (this.fTitle != null) {
            if (this.fTitleArgument != null) {
                String format = CompareMessages.CompareViewerSwitchingPane_Titleformat;
                String t = MessageFormat.format((String)format, (Object[])new String[]{this.fTitle, this.fTitleArgument});
                this.setText(t);
            } else {
                this.setText(this.fTitle);
            }
        } else {
            this.setText("");
        }
    }

    public Object getAdapter(Class adapter) {
        Viewer v;
        Class<?> clazz;
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.compare.INavigatable");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter == clazz2) {
            if (this.isEmpty()) {
                return null;
            }
            Viewer viewer = this.getViewer();
            if (viewer == null) {
                return null;
            }
            Control control = viewer.getControl();
            if (control == null) {
                return null;
            }
            Object data = control.getData("org.eclipse.compare.internal.Navigator");
            if (data instanceof INavigatable) {
                return data;
            }
        }
        if ((clazz = class$1) == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.compare.contentmergeviewer.IFlushable");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter == clazz && (v = this.getViewer()) != null) {
            IFlushable flushable;
            Class<?> clazz3 = class$1;
            if (clazz3 == null) {
                try {
                    clazz3 = class$1 = Class.forName("org.eclipse.compare.contentmergeviewer.IFlushable");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((flushable = (IFlushable)Utilities.getAdapter(v, clazz3)) != null) {
                return flushable;
            }
        }
        return super.getAdapter(adapter);
    }

    public boolean setFocus() {
        Control c;
        Viewer v = this.getViewer();
        if (v != null && (c = v.getControl()) != null && c.setFocus()) {
            return true;
        }
        return super.setFocus();
    }

    protected abstract Viewer getViewer(Viewer var1, Object var2);
}

