/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.controls;

import com.insightful.controls.SplusControlMetrics;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;

public class SplusLabelBox
extends JComponent {
    private JLabel label;
    private JComponent actionControl;
    static final Dimension labelDimension = SplusControlMetrics.getLabelDimension();
    static final Dimension fullDimension = SplusControlMetrics.getFullDimension();
    private Dimension boxDimension = fullDimension;

    public SplusLabelBox(String string, char c) {
        this(string);
        this.setMnemonic(c);
    }

    public SplusLabelBox(String string) {
        if (!string.endsWith(":")) {
            string = string + ":";
        }
        this.label = new JLabel(string);
    }

    public String getText() {
        return this.label.getText();
    }

    public void setText(String string) {
        if (!string.endsWith(":")) {
            string = string + ":";
        }
        this.label.setText(string);
    }

    public int getMnemonic() {
        return this.label.getDisplayedMnemonic();
    }

    public void setMnemonic(char c) {
        this.label.setDisplayedMnemonic(c);
    }

    public void setMnemonic(int n) {
        this.label.setDisplayedMnemonic(n);
    }

    public void setLabelEnabled(boolean bl) {
        this.label.setEnabled(bl);
    }

    public void setActionControl(JComponent jComponent) {
        this.actionControl = jComponent;
        this.label.setLabelFor(jComponent);
        this.layoutBox();
    }

    public void setLabelFor(JComponent jComponent) {
        this.label.setLabelFor(jComponent);
    }

    private void layoutBox() {
        if (!SplusControlMetrics.isLongLabel(this.label)) {
            Dimension dimension = this.actionControl.getPreferredSize();
            this.label.setPreferredSize(new Dimension(SplusLabelBox.labelDimension.width, dimension.height));
            if (dimension.height == SplusLabelBox.labelDimension.height) {
                this.label.setVerticalAlignment(0);
            } else {
                this.label.setVerticalAlignment(1);
            }
            this.setLayout(new FlowLayout(0, 5, 0));
            this.add(this.label);
            this.add(this.actionControl);
            this.boxDimension = new Dimension(SplusLabelBox.fullDimension.width, this.actionControl.getPreferredSize().height + 5);
        } else {
            this.label.setPreferredSize(new Dimension(SplusLabelBox.labelDimension.width * 2, SplusLabelBox.labelDimension.height));
            this.label.setMinimumSize(new Dimension(SplusLabelBox.labelDimension.width * 2, SplusLabelBox.labelDimension.height));
            this.setLayout(new GridLayout(2, 1));
            Box box = new Box(0);
            box.add(Box.createHorizontalStrut(5));
            box.add(this.label);
            this.add(box);
            Box box2 = new Box(0);
            box2.add(Box.createRigidArea(new Dimension(SplusLabelBox.labelDimension.width + 10, SplusLabelBox.labelDimension.height)));
            box2.add(this.actionControl);
            this.add(box2);
            this.boxDimension = new Dimension(SplusLabelBox.fullDimension.width, SplusLabelBox.fullDimension.height + this.actionControl.getPreferredSize().height + 5);
        }
        this.setPreferredSize(this.boxDimension);
        this.setMinimumSize(this.boxDimension);
    }
}

