/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.gdevice;

import com.insightful.gdevice.ColorScheme;
import com.insightful.gdevice.IDHash;
import com.insightful.gdevice.SCanvas;
import com.insightful.gdevice.SCanvasHit;
import com.insightful.gdevice.SCanvasPoint;
import com.insightful.gdevice.SCanvasRectangle;
import com.insightful.gdevice.SGraphCommand;
import com.insightful.gdevice.SGraphTextAWT;
import com.insightful.gdevice.TagSet;
import com.insightful.gdevice.XML;
import com.insightful.gdevice.XMLElement;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.IndexColorModel;
import java.io.PrintWriter;
import java.io.Serializable;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class SCanvasAWT
implements Serializable {
    public static final int SPLUS_DISPLAY_WIDTH = 512;
    public static final int SPLUS_DISPLAY_HEIGHT = 384;
    private Rectangle m_graphRect = new Rectangle(0, 0, 512, 384);
    Vector m_displayList = new Vector();
    protected String m_title = "#";
    protected String m_tag = "";
    protected int m_clearCount = 0;
    private static ColorScheme m_defaultColorScheme = null;
    private ColorScheme m_colorScheme = null;
    private transient ColorScheme m_altColorScheme = null;
    private transient Color m_altBackgroundColor = null;
    static int[][] m_dashesArrays = new int[][]{null, {2, 4}, {4, 3, 2, 3}, {8, 3}, {2, 2, 4, 2, 2, 2, 2, 2}, {2, 2, 8, 2}, {2, 2, 2, 2, 2, 5}, {4, 4}};
    static Hashtable m_fontHash = new Hashtable(5);
    static final float m_defaultFontSize = 12.0f;
    static String[] m_fontNames = new String[]{"SansSerif", "SansSerif", "SansSerif", "Serif", "Serif", "Serif"};
    static int[] m_fontStyles = new int[]{0, 2, 1, 0, 2, 1};
    static final int GREEK_FONT_NUMBER = 13;
    private transient Vector m_uniqueRegionCommands = null;
    private Dimension m_userSize = new Dimension(-1, -1);
    private transient TagSet m_canvasTagSet = null;
    private URL m_documentBase = null;
    private boolean m_clipIdentify = true;
    private boolean m_debug = false;
    private boolean m_inApplet = false;
    protected transient boolean m_hasEmbeddedFileData = false;
    private String m_propertyAction = null;
    protected int m_bgColorR = 255;
    protected int m_bgColorG = 255;
    protected int m_bgColorB = 255;
    protected int m_bgColorA = 255;
    protected Color m_bgColor = null;

    public String getTitle() {
        return this.m_title;
    }

    public void setTitle(String string) {
        this.m_title = string;
    }

    public String getTag() {
        return this.m_tag;
    }

    public void setTag(String string) {
        this.m_tag = string;
    }

    public boolean isEmpty() {
        return this.m_displayList.isEmpty();
    }

    int fracToGraphX(float f) {
        return (int)((float)this.getWidth() * f);
    }

    int fracToGraphY(float f) {
        return (int)((float)this.getHeight() * f);
    }

    float graphToFracX(int n) {
        return (float)n / (float)this.getWidth();
    }

    float graphToFracY(int n) {
        return (float)n / (float)this.getHeight();
    }

    public void setSize(int n, int n2) {
        boolean bl;
        if (n == 0) {
            n = 512;
        }
        if (n2 == 0) {
            n2 = 384;
        }
        boolean bl2 = bl = this.m_graphRect.width != n || this.m_graphRect.height != n2;
        if (bl) {
            this.m_graphRect.width = n;
            this.m_graphRect.height = n2;
            this.graphSizeChanged();
        }
    }

    public void graphSizeChanged() {
        int n = this.m_displayList.size();
        for (int i = 0; i < n; ++i) {
            SGraphCommand sGraphCommand = (SGraphCommand)this.m_displayList.elementAt(i);
            sGraphCommand.graphSizeChanged();
        }
    }

    public int getWidth() {
        return this.m_graphRect.width;
    }

    public int getHeight() {
        return this.m_graphRect.height;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(SGraphCommand sGraphCommand) {
        SCanvasAWT sCanvasAWT = this;
        synchronized (sCanvasAWT) {
            this.m_displayList.addElement(sGraphCommand);
            this.m_uniqueRegionCommands = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Vector vector) {
        SCanvasAWT sCanvasAWT = this;
        synchronized (sCanvasAWT) {
            if (vector == null) {
                return;
            }
            int n = vector.size();
            this.m_displayList.ensureCapacity(this.m_displayList.size() + n + 10);
            for (int i = 0; i < n; ++i) {
                SGraphCommand sGraphCommand = (SGraphCommand)vector.elementAt(i);
                this.m_displayList.addElement(sGraphCommand);
            }
            this.m_uniqueRegionCommands = null;
        }
    }

    public synchronized int getClearCount() {
        return this.m_clearCount;
    }

    public synchronized int getNumberCommands() {
        return this.m_displayList.size();
    }

    public synchronized void clear() {
        ++this.m_clearCount;
        this.m_displayList.removeAllElements();
        this.m_uniqueRegionCommands = null;
    }

    public void paint(Graphics graphics) {
        this.paint(graphics, 0);
    }

    public synchronized void paint(Graphics graphics, int n) {
        if (n < 1) {
            graphics.setColor(this.getBackgroundColor());
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
            n = 0;
        }
        int n2 = this.m_displayList.size();
        for (int i = n; i < n2; ++i) {
            SGraphCommand sGraphCommand = (SGraphCommand)this.m_displayList.elementAt(i);
            try {
                sGraphCommand.display(this, graphics);
                continue;
            }
            catch (Throwable throwable) {
                if (!this.getDebug()) continue;
                throwable.printStackTrace();
            }
        }
        SCanvasAWT.flushGraphics(graphics);
    }

    public synchronized void paintSelections(Graphics graphics, TagSet tagSet) {
        int n = this.m_displayList.size();
        for (int i = 0; i < n; ++i) {
            SGraphCommand sGraphCommand = (SGraphCommand)this.m_displayList.elementAt(i);
            try {
                sGraphCommand.highlightActiveRegions(this, graphics, tagSet);
                continue;
            }
            catch (Throwable throwable) {
                if (!this.getDebug()) continue;
                throwable.printStackTrace();
            }
        }
    }

    public synchronized void print(Graphics graphics) {
        graphics.setColor(this.getBackgroundColor());
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        int n = this.m_displayList.size();
        for (int i = 0; i < n; ++i) {
            SGraphCommand sGraphCommand = (SGraphCommand)this.m_displayList.elementAt(i);
            try {
                sGraphCommand.print(this, graphics);
                continue;
            }
            catch (Throwable throwable) {
                if (!this.getDebug()) continue;
                throwable.printStackTrace();
            }
        }
        SCanvasAWT.flushGraphics(graphics);
    }

    private ColorScheme getDefaultColorScheme() {
        if (m_defaultColorScheme == null) {
            m_defaultColorScheme = new ColorScheme(false);
        }
        return m_defaultColorScheme;
    }

    public ColorScheme getColorScheme() {
        if (this.m_colorScheme == null) {
            this.m_colorScheme = this.getDefaultColorScheme();
        }
        return this.m_colorScheme;
    }

    public void setColorScheme(ColorScheme colorScheme) {
        this.m_colorScheme = colorScheme == null ? this.getDefaultColorScheme() : colorScheme;
        this.graphSizeChanged();
    }

    public Color getBackgroundColor() {
        Color color = this.m_bgColor;
        if (color != null) {
            return color;
        }
        color = this.getAltBackgroundColor();
        if (color != null) {
            return color;
        }
        color = this.getRendererColorScheme().getBackgroundColor();
        return color;
    }

    public Color getPaletteColor(SGraphCommand sGraphCommand) {
        return sGraphCommand.getUseNewColor() ? sGraphCommand.getNewColor() : this.getRendererColorScheme().getPaletteColor(sGraphCommand.getColorInt());
    }

    public Color getLineColor(SGraphCommand sGraphCommand) {
        return sGraphCommand.getUseNewColor() ? sGraphCommand.getNewColor() : this.getRendererColorScheme().getLineColor(sGraphCommand.getColorInt());
    }

    public Color getTextColor(SGraphCommand sGraphCommand) {
        return sGraphCommand.getUseNewColor() ? sGraphCommand.getNewColor() : this.getRendererColorScheme().getTextColor(sGraphCommand.getColorInt());
    }

    public Color getPolygonColor(SGraphCommand sGraphCommand) {
        return sGraphCommand.getUseNewColor() ? sGraphCommand.getNewColor() : this.getRendererColorScheme().getPolygonColor(sGraphCommand.getColorInt());
    }

    public Color getTextColor(int n) {
        return this.getRendererColorScheme().getTextColor(n);
    }

    public Color getImageColor(int n) {
        return this.getRendererColorScheme().getImageColor(n);
    }

    public IndexColorModel getImageIndexColorModel() {
        return this.getRendererColorScheme().getImageIndexColorModel();
    }

    public IndexColorModel getImageIndexColorModel(byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4) {
        IndexColorModel indexColorModel = null;
        try {
            indexColorModel = new IndexColorModel(8, byArray.length, byArray, byArray2, byArray3, byArray4);
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
        }
        return indexColorModel;
    }

    public boolean usingPDFColorScheme() {
        return this.getRendererColorScheme().isPDF();
    }

    public ColorScheme getAltColorScheme() {
        return this.m_altColorScheme;
    }

    public void setAltColorScheme(ColorScheme colorScheme) {
        this.m_altColorScheme = colorScheme;
    }

    protected ColorScheme getRendererColorScheme() {
        return this.m_altColorScheme != null ? this.m_altColorScheme : this.m_colorScheme;
    }

    public Color getAltBackgroundColor() {
        return this.m_altBackgroundColor;
    }

    public void setAltBackgroundColor(Color color) {
        this.m_altBackgroundColor = color;
    }

    int[] getLineDashes(int n) {
        if (n < 1) {
            return null;
        }
        int n2 = (n - 1) % m_dashesArrays.length;
        return m_dashesArrays[n2];
    }

    synchronized Font getFont(float f, float f2) {
        Integer n;
        Font font;
        float f3 = (float)this.getWidth() / 512.0f;
        float f4 = (float)this.getHeight() / 384.0f;
        float f5 = Math.min(f3, f4);
        int n2 = Math.max(1, (int)(12.0f * f * f5));
        int n3 = 0;
        if (f2 != 13.0f) {
            n3 = Math.max(0, (int)f2 - 1) % m_fontNames.length;
        }
        if ((font = (Font)m_fontHash.get(n = new Integer(n2 + 1000 * n3))) == null) {
            font = new Font(m_fontNames[n3], m_fontStyles[n3], n2);
            m_fontHash.put(n, font);
        }
        return font;
    }

    String getFontText(String string, float f) {
        if (string == null || f != 13.0f) {
            return string;
        }
        char[] cArray = new char[string.length()];
        for (int i = 0; i < string.length(); ++i) {
            cArray[i] = (char)(string.charAt(i) + 913 - 65);
        }
        return new String(cArray);
    }

    private static void flushGraphics(Graphics graphics) {
        try {
            if (graphics != null) {
                graphics.getFontMetrics().stringWidth("abc");
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public synchronized SGraphCommand getSmallestPlotRegionCommand(int n, int n2) {
        if (this.m_uniqueRegionCommands == null) {
            Vector<SGraphCommand> vector = new Vector<SGraphCommand>();
            Vector<SCanvasRectangle> vector2 = new Vector<SCanvasRectangle>();
            int n3 = this.m_displayList.size();
            for (int i = 0; i < n3; ++i) {
                SGraphCommand sGraphCommand = (SGraphCommand)this.m_displayList.elementAt(i);
                SCanvasRectangle sCanvasRectangle = sGraphCommand.getPlotRect();
                int n4 = vector2.lastIndexOf(sCanvasRectangle);
                if (n4 < 0) {
                    vector.addElement(sGraphCommand);
                    vector2.addElement(sCanvasRectangle);
                    continue;
                }
                vector.setElementAt(sGraphCommand, n4);
            }
            this.m_uniqueRegionCommands = vector;
        }
        float f = (float)n / (float)this.getWidth();
        float f2 = (float)n2 / (float)this.getHeight();
        float f3 = Float.MAX_VALUE;
        SGraphCommand sGraphCommand = null;
        int n5 = this.m_uniqueRegionCommands.size();
        for (int i = 0; i < n5; ++i) {
            float f4;
            SGraphCommand sGraphCommand2 = (SGraphCommand)this.m_uniqueRegionCommands.elementAt(i);
            SCanvasRectangle sCanvasRectangle = sGraphCommand2.getPlotRect();
            if (!sCanvasRectangle.contains(f, f2) || !((f4 = Math.abs(sCanvasRectangle.getWidth() * sCanvasRectangle.getHeight())) < f3)) continue;
            f3 = f4;
            sGraphCommand = sGraphCommand2;
        }
        return sGraphCommand;
    }

    public SCanvasPoint getValueFromPoint(Point point) {
        return point == null ? null : this.getValueFromPoint(point.x, point.y);
    }

    public SCanvasPoint getValueFromPoint(int n, int n2) {
        return this.getValueFromPoint(this.getSmallestPlotRegionCommand(n, n2), n, n2);
    }

    public SCanvasPoint getValueFromPoint(SGraphCommand sGraphCommand, Point point) {
        return point == null ? null : this.getValueFromPoint(sGraphCommand, point.x, point.y);
    }

    public SCanvasPoint getValueFromPoint(SGraphCommand sGraphCommand, int n, int n2) {
        if (sGraphCommand == null) {
            return null;
        }
        float f = sGraphCommand.windowToValX(this, n);
        float f2 = sGraphCommand.windowToValY(this, n2);
        return new SCanvasPoint(f, f2);
    }

    public SCanvasAWT createSCanvasAWT() {
        return this;
    }

    public void printString(Graphics graphics, String string, int n, int n2) {
        SGraphTextAWT.paintTextPixels(graphics, string, n, n2, 0.0f, 0.0f, false);
    }

    public SCanvasHit getHit(Point point) {
        return point == null ? null : this.getHit(point.x, point.y);
    }

    public SCanvasHit getHit(int n, int n2) {
        int n3 = this.m_displayList.size();
        for (int i = n3 - 1; i >= 0; --i) {
            SGraphCommand sGraphCommand = (SGraphCommand)this.m_displayList.elementAt(i);
            SCanvasHit sCanvasHit = sGraphCommand.getHit(this, n, n2);
            if (sCanvasHit == null) continue;
            return sCanvasHit;
        }
        return null;
    }

    public String[] getIntersectingTags(Rectangle rectangle) {
        int n = this.m_displayList.size();
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < n; ++i) {
            SGraphCommand sGraphCommand = (SGraphCommand)this.m_displayList.elementAt(i);
            String[] stringArray = sGraphCommand.getIntersectingTags(rectangle, this);
            if (stringArray == null) continue;
            for (int j = 0; j < stringArray.length; ++j) {
                vector.addElement(stringArray[j]);
            }
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public void writeXML(PrintWriter printWriter, String string, Vector vector) {
        printWriter.print("<CANVAS");
        XML.writeProperty(printWriter, "COLORSCHEME", string);
        if (this.m_bgColor != null) {
            String string2 = SGraphCommand.createRGBAString(this.m_bgColorR, this.m_bgColorG, this.m_bgColorB, this.m_bgColorA);
            XML.writeProperty(printWriter, "BG", string2);
        }
        XML.writeProperty(printWriter, "TITLE", this.getTitle());
        XML.writeProperty(printWriter, "TAG", this.getTag());
        XML.writeProperty(printWriter, "USERWIDTH", this.getUserSize().width);
        XML.writeProperty(printWriter, "USERHEIGHT", this.getUserSize().height);
        printWriter.print(">\n");
        int n = this.m_displayList.size();
        for (int i = 0; i < n; ++i) {
            SGraphCommand sGraphCommand = (SGraphCommand)this.m_displayList.elementAt(i);
            sGraphCommand.writeXML(printWriter, vector);
        }
        printWriter.print("</CANVAS>\n");
    }

    public static SCanvasAWT createFromXML(XMLElement xMLElement, IDHash iDHash) {
        SCanvasAWT sCanvasAWT = new SCanvasAWT();
        sCanvasAWT.setFromXML(xMLElement, iDHash);
        return sCanvasAWT;
    }

    public void setFromXML(XMLElement xMLElement, IDHash iDHash) {
        String string;
        int[] nArray;
        String string2 = XML.getStringProperty(xMLElement, "COLORSCHEME", iDHash);
        ColorScheme colorScheme = iDHash.getColorScheme(string2);
        String string3 = XML.getStringProperty(xMLElement, "TITLE", iDHash);
        String string4 = XML.getStringProperty(xMLElement, "TAG", iDHash);
        if (string3 != null) {
            this.setTitle(string3);
        }
        if (string4 != null) {
            this.setTag(string4);
        }
        if (colorScheme != null) {
            this.setColorScheme(colorScheme);
        }
        if ((nArray = SGraphCommand.readRGBAString(string = XML.getStringProperty(xMLElement, "BG", iDHash))) != null) {
            this.setBackgroundRGBA(nArray[0], nArray[1], nArray[2], nArray[3]);
        }
        String string5 = XML.getStringProperty(xMLElement, "USERWIDTH", iDHash);
        String string6 = XML.getStringProperty(xMLElement, "USERHEIGHT", iDHash);
        Dimension dimension = new Dimension(-1, -1);
        if (string5 != null) {
            try {
                dimension.width = Integer.parseInt(string5);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (string6 != null) {
            try {
                dimension.height = Integer.parseInt(string6);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.setUserSize(dimension);
        Enumeration enumeration = xMLElement.enumerateChildren();
        while (enumeration.hasMoreElements()) {
            XMLElement xMLElement2 = (XMLElement)enumeration.nextElement();
            String string7 = xMLElement2.getTagName();
            if (string7.equalsIgnoreCase("PAGEINFO")) {
                string2 = XML.getStringProperty(xMLElement, "COLORSCHEME");
                colorScheme = iDHash.getColorScheme(string2);
                string3 = XML.getStringProperty(xMLElement2, "TITLE");
                string4 = XML.getStringProperty(xMLElement2, "TAG");
                if (string3 != null) {
                    this.setTitle(string3);
                }
                if (string4 != null) {
                    this.setTag(string4);
                }
                if (colorScheme == null) continue;
                this.setColorScheme(colorScheme);
                continue;
            }
            SGraphCommand sGraphCommand = SGraphCommand.createFromXML(xMLElement2, iDHash);
            if (sGraphCommand == null) continue;
            this.add(sGraphCommand);
        }
    }

    public static SCanvasAWT createErrorCanvas(String string) {
        String string2;
        SCanvasAWT sCanvasAWT = new SCanvasAWT();
        if (string == null) {
            string = "unknown error";
        }
        int n = string.length();
        int n2 = 0;
        for (float f = 0.25f; f < 1.0f && n2 < n; n2 += string2.length(), f += 0.1f) {
            int n3;
            string2 = string.substring(n2);
            if (string2.length() > 50 && (n3 = (string2 = string2.substring(0, 50)).lastIndexOf(" ")) > 0) {
                string2 = string2.substring(0, n3 + 1);
            }
            sCanvasAWT.add(new SGraphTextAWT(string2, 0.5f, f, 0.0f, 0.5f, 1.0f, 1.0f));
        }
        return sCanvasAWT;
    }

    public void setUserSize(Dimension dimension) {
        this.m_userSize = dimension;
    }

    public Dimension getUserSize() {
        return this.m_userSize;
    }

    public Dimension getBestFitSize(Dimension dimension) {
        return SCanvasAWT.getMaxFitSize(this.m_userSize, dimension);
    }

    public static Dimension getMaxFitSize(Dimension dimension, Dimension dimension2) {
        float f = dimension.width < 1 || dimension.height < 1 ? 1.33333f : (float)dimension.width / (float)dimension.height;
        float f2 = dimension2.width < 1 || dimension2.height < 1 ? 1.33333f : (float)dimension2.width / (float)dimension2.height;
        int n = dimension2.width;
        int n2 = dimension2.height;
        if (f2 > f) {
            n = (int)((float)n2 * f);
        } else if (f2 < f) {
            n2 = (int)((float)n / f);
        }
        return new Dimension(n, n2);
    }

    public void setCanvasTagSet(TagSet tagSet) {
        this.m_canvasTagSet = tagSet;
    }

    public String[] getSelectedTagArray() {
        return this.m_canvasTagSet == null ? new String[]{} : this.m_canvasTagSet.getSelectedTagArray();
    }

    public void setSelectedTagArray(String[] stringArray) {
        if (this.m_canvasTagSet == null) {
            this.m_canvasTagSet = new TagSet();
        }
        this.m_canvasTagSet.setSelectedTagArray(stringArray);
    }

    public SCanvas createSCanvas() {
        SCanvas sCanvas = new SCanvas();
        sCanvas.setTag(this.getTag());
        sCanvas.setTitle(this.getTitle());
        sCanvas.setSize(this.getWidth(), this.getHeight());
        sCanvas.add(this.m_displayList);
        return sCanvas;
    }

    public void setDocumentBase(URL uRL) {
        this.m_documentBase = uRL;
    }

    public URL getDocumentBase() {
        return this.m_documentBase;
    }

    public void setClipIdentify(boolean bl) {
        this.m_clipIdentify = bl;
    }

    public boolean getClipIdentify() {
        return this.m_clipIdentify;
    }

    public void setDebug(boolean bl) {
        this.m_debug = bl;
    }

    public boolean getDebug() {
        return this.m_debug;
    }

    public void setInApplet(boolean bl) {
        this.m_inApplet = bl;
    }

    public boolean getInApplet() {
        return this.m_inApplet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseMemory() {
        SCanvasAWT sCanvasAWT = this;
        synchronized (sCanvasAWT) {
            this.m_uniqueRegionCommands = null;
            int n = this.m_displayList.size();
            for (int i = 0; i < n; ++i) {
                SGraphCommand sGraphCommand = (SGraphCommand)this.m_displayList.elementAt(i);
                if (sGraphCommand == null) continue;
                sGraphCommand.releaseMemory();
            }
            this.clearEmbeddedFileData();
        }
    }

    public boolean hasEmbeddedFileData() {
        return this.m_hasEmbeddedFileData;
    }

    public void clearEmbeddedFileData() {
        if (!this.m_hasEmbeddedFileData) {
            return;
        }
        this.m_displayList.removeAllElements();
        this.m_hasEmbeddedFileData = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadEmbeddedCanvas(SCanvasAWT sCanvasAWT) {
        this.clear();
        SCanvasAWT sCanvasAWT2 = this;
        synchronized (sCanvasAWT2) {
            Vector vector = sCanvasAWT.m_displayList;
            int n = vector.size();
            this.m_displayList.ensureCapacity(n);
            for (int i = 0; i < n; ++i) {
                SGraphCommand sGraphCommand = (SGraphCommand)vector.elementAt(i);
                this.m_displayList.addElement(sGraphCommand);
            }
            this.m_uniqueRegionCommands = null;
            this.setColorScheme(sCanvasAWT.getColorScheme());
            this.setUserSize(sCanvasAWT.getUserSize());
        }
        this.m_hasEmbeddedFileData = true;
    }

    public String getPropertyAction() {
        return this.m_propertyAction;
    }

    public void setPropertyAction(String string) {
        this.m_propertyAction = string;
    }

    public void setBackgroundRGBA(int n, int n2, int n3, int n4) {
        this.m_bgColorR = n;
        this.m_bgColorG = n2;
        this.m_bgColorB = n3;
        this.m_bgColorA = n4;
        this.m_bgColor = new Color(n, n2, n3);
    }

    public void clearBackgroundRGBA() {
        this.m_bgColor = null;
    }
}

