/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.gdevice;

import com.insightful.gdevice.ColorScheme;
import com.insightful.gdevice.SCanvasAWT;
import com.insightful.gdevice.SCanvasHit;
import com.insightful.gdevice.SCanvasHitRegion;
import com.insightful.gdevice.SCanvasPaneView;
import com.insightful.gdevice.SCanvasPaneView2;
import com.insightful.gdevice.SCanvasPoint;
import com.insightful.gdevice.SCanvasRectangle;
import com.insightful.gdevice.SGraphTextAWT;
import com.insightful.gdevice.STreeNode;
import com.insightful.gdevice.TagSet;
import com.insightful.gdevice.XML;
import com.insightful.gdevice.XMLElement;
import java.awt.Adjustable;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.text.NumberFormat;
import java.util.Enumeration;
import java.util.Vector;

public class SCanvasPaneController {
    static int m_numBadPaints = 0;
    static final double MAX_SCROLL_VALUE = 2.0E9;
    int m_displayPageIndex = 0;
    Vector m_pages = new Vector();
    SCanvasPaneView m_view = null;
    CanvasComponentListener m_canvasListener = new CanvasComponentListener();
    TabComponentListener m_tabListener = new TabComponentListener();
    AdjustmentListener m_scrollListener = new AdjustmentListener(){

        public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
            SCanvasPaneController.this.updateViewFromScrollbars();
        }
    };
    protected boolean m_showQueryErrorDialog;
    protected Color m_clrSelectionHighlight = Color.red;
    protected boolean m_bXorSelectedRegions = true;
    protected Color m_backgroundColor = null;
    static boolean m_backgroundBorders = false;
    static NumberFormat m_locatorNumberFormat = NumberFormat.getNumberInstance();
    static int m_locatorFractionDigits = -1;
    static boolean m_showMouse;
    static boolean m_showActiveRegions;
    static int m_iAnnotationTextColor;
    private static Color m_labelColor;
    protected boolean m_highlightOutline = true;
    protected boolean m_debug = false;
    protected TagSet m_tagset = null;
    private Vector m_tabHistory = new Vector();
    private int m_tabHistoryBackLocation = -1;
    boolean m_ignoreScrollBars = false;
    public static boolean m_debugFirehose;
    public static int m_debugFirehosePaintCount;
    public static int m_debugFirehoseCheckSleep;

    public void setSelectionHighlightColor(Color color) {
        this.m_clrSelectionHighlight = color != null ? color : Color.red;
    }

    public void setSelectionHighlightMode(String string) {
        this.m_bXorSelectedRegions = string == null || !string.equalsIgnoreCase("paint");
    }

    public void setBackgroundColor(Color color) {
        this.m_backgroundColor = color;
    }

    public Color getBackgroundColor() {
        return this.m_backgroundColor;
    }

    public static boolean getBackgroundBorders() {
        return m_backgroundBorders;
    }

    public static void setBackgroundBorders(boolean bl) {
        m_backgroundBorders = bl;
    }

    public static int getLocatorFractionDigits() {
        return m_locatorFractionDigits;
    }

    public static void setLocatorFractionDigits(int n) {
        if ((n = Math.min(18, Math.max(0, n))) != m_locatorFractionDigits) {
            m_locatorFractionDigits = n;
            m_locatorNumberFormat.setMaximumFractionDigits(m_locatorFractionDigits);
            m_locatorNumberFormat.setMinimumFractionDigits(m_locatorFractionDigits);
            m_locatorNumberFormat.setGroupingUsed(false);
        }
    }

    public static boolean getShowMouseLocation() {
        return m_showMouse;
    }

    public static void setShowMouseLocation(boolean bl) {
        m_showMouse = bl;
    }

    public static boolean getShowActiveRegions() {
        return m_showActiveRegions;
    }

    public static void setShowActiveRegions(boolean bl) {
        m_showActiveRegions = bl;
    }

    public static int getAnnotationTextColor() {
        return m_iAnnotationTextColor;
    }

    public static void setAnnotationTextColor(int n) {
        m_iAnnotationTextColor = n;
    }

    public static void setLabelColor(Color color) {
        m_labelColor = color;
    }

    public static Color getAnnotationColor(CanvasPage canvasPage) {
        if (m_labelColor != null) {
            return m_labelColor;
        }
        if (canvasPage != null) {
            return canvasPage.getCanvas().getTextColor(SCanvasPaneController.getAnnotationTextColor());
        }
        return Color.black;
    }

    public boolean getHighlightOutline() {
        return this.m_highlightOutline;
    }

    public void setHighlightOutline(boolean bl) {
        this.m_highlightOutline = bl;
    }

    public boolean getDebug() {
        return this.m_debug;
    }

    public void setDebug(boolean bl) {
        this.m_debug = bl;
    }

    public SCanvasPaneController(SCanvasPaneView sCanvasPaneView) {
        Adjustable adjustable;
        Adjustable adjustable2;
        Component component;
        this.m_view = sCanvasPaneView;
        Component component2 = this.m_view.getCanvasComponent();
        if (component2 != null) {
            component2.addComponentListener(this.m_canvasListener);
            component2.addMouseListener(this.m_canvasListener);
            component2.addMouseMotionListener(this.m_canvasListener);
        }
        if ((component = this.m_view.getTabComponent()) != null) {
            component.addMouseListener(this.m_tabListener);
            component.addComponentListener(this.m_tabListener);
        }
        if ((adjustable2 = this.m_view.getScrollAdjustable(0)) != null) {
            adjustable2.addAdjustmentListener(this.m_scrollListener);
        }
        if ((adjustable = this.m_view.getScrollAdjustable(1)) != null) {
            adjustable.addAdjustmentListener(this.m_scrollListener);
        }
        this.m_tagset = new TagSet();
    }

    public SCanvasPaneView getView() {
        return this.m_view;
    }

    public void paintCanvas(Graphics graphics) {
        this.m_canvasListener.paint(graphics);
    }

    public void printCanvas(Graphics graphics) {
        this.m_canvasListener.print(graphics);
    }

    public void paintTabs(Graphics graphics) {
        this.m_tabListener.paint(graphics);
    }

    public void printTabs(Graphics graphics) {
        this.m_tabListener.print(graphics);
    }

    public void printTabsApplet(Graphics graphics) {
        this.m_tabListener.printApplet(graphics);
    }

    public int getTabNumberFromTagName(String string) {
        if (string == null) {
            return -1;
        }
        for (int i = 0; i < this.getTabCount(); ++i) {
            if (!string.equals(this.getPage(i).getTagName())) continue;
            return i;
        }
        return -1;
    }

    public int getTabNumber(int n, int n2) {
        return this.m_tabListener.getTabNumber(n, n2);
    }

    public void setSelectedTab(int n) {
        this.addHistory(n);
        this.internalSetSelectedTab(n);
    }

    private void internalSetSelectedTab(int n) {
        XMLElement xMLElement;
        this.m_displayPageIndex = n;
        this.updateDisplay();
        this.showSelectedTab();
        CanvasPage canvasPage = this.getPage(0);
        if (canvasPage != null && (xMLElement = canvasPage.getOnPageChangedAction()) != null) {
            this.doHitAction(xMLElement, canvasPage.getTag(), 0, 0, true, false, false, false, false);
        }
    }

    private void addHistory(int n) {
        try {
            if (this.m_tabHistoryBackLocation >= 0) {
                while (this.m_tabHistoryBackLocation + 1 < this.m_tabHistory.size()) {
                    this.m_tabHistory.removeElementAt(this.m_tabHistory.size() - 1);
                }
                this.m_tabHistoryBackLocation = -1;
            }
            if (this.m_tabHistory.size() < 1 || n != this.getHistoryTab(this.m_tabHistory.size() - 1)) {
                this.m_tabHistory.addElement(new Integer(n));
            }
            while (this.m_tabHistory.size() > 20) {
                this.m_tabHistory.removeElementAt(0);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private int getHistoryTab(int n) {
        return (Integer)this.m_tabHistory.elementAt(n);
    }

    public void setSelectedTabBack() {
        try {
            if (this.m_tabHistory.size() == 0) {
                this.m_tabHistoryBackLocation = -1;
            } else if (this.m_tabHistoryBackLocation != 0) {
                if (this.m_tabHistoryBackLocation > 0) {
                    if (this.m_tabHistoryBackLocation - 1 < this.m_tabHistory.size()) {
                        --this.m_tabHistoryBackLocation;
                        this.internalSetSelectedTab(this.getHistoryTab(this.m_tabHistoryBackLocation));
                    }
                } else if (this.m_tabHistory.size() > 1) {
                    this.m_tabHistoryBackLocation = this.m_tabHistory.size() - 2;
                    this.internalSetSelectedTab(this.getHistoryTab(this.m_tabHistoryBackLocation));
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setSelectedTabForward() {
        try {
            if (this.m_tabHistory.size() != 0 && this.m_tabHistoryBackLocation >= 0 && this.m_tabHistoryBackLocation < this.m_tabHistory.size() && this.m_tabHistoryBackLocation + 1 >= 0 && this.m_tabHistoryBackLocation + 1 < this.m_tabHistory.size()) {
                ++this.m_tabHistoryBackLocation;
                this.internalSetSelectedTab(this.getHistoryTab(this.m_tabHistoryBackLocation));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void showSelectedTab() {
        this.m_tabListener.showSelectedTab();
    }

    public int getSelectedTab() {
        return Math.max(0, Math.min(this.m_displayPageIndex, this.m_pages.size() - 1));
    }

    public int getTabCount() {
        return this.m_pages.size();
    }

    public void removeTabAt(int n) {
        if (n >= 0 && n < this.m_pages.size()) {
            this.m_pages.removeElementAt(n);
            this.m_displayPageIndex = Math.min(this.m_displayPageIndex, this.m_pages.size() - 1);
            this.updateDisplay();
            this.updateTabs();
            this.internalSetSelectedTab(this.m_displayPageIndex);
        }
    }

    public String getTabTitle(int n) {
        CanvasPage canvasPage = this.getPage(n);
        return canvasPage == null ? null : canvasPage.getCanvas().getTitle();
    }

    public String getTabTagName(int n) {
        CanvasPage canvasPage = this.getPage(n);
        return canvasPage == null ? null : canvasPage.getTagName();
    }

    public String getTabTag(int n) {
        CanvasPage canvasPage = this.getPage(n);
        return canvasPage == null ? null : canvasPage.getTag();
    }

    public void setTabTitle(int n, String string) {
        CanvasPage canvasPage = this.getPage(n);
        if (canvasPage == null) {
            return;
        }
        String string2 = this.getTabTitle(n);
        if (string == null || !string.equals(string2)) {
            canvasPage.getCanvas().setTitle(string);
            this.updateTabs();
        }
    }

    public void setTabTag(int n, String string) {
        CanvasPage canvasPage = this.getPage(n);
        if (canvasPage == null) {
            return;
        }
        canvasPage.setTag(string);
        if (n == 0) {
            int n2 = this.getTabCount();
            for (int i = 0; i < n2; ++i) {
                SCanvasAWT sCanvasAWT = this.getCanvas(i);
                if (sCanvasAWT != null) {
                    sCanvasAWT.releaseMemory();
                }
                this.updateCanvas(i);
            }
        } else {
            SCanvasAWT sCanvasAWT = this.getCanvas(n);
            if (sCanvasAWT != null) {
                sCanvasAWT.releaseMemory();
            }
            this.updateCanvas(n);
        }
    }

    public void zoom(double d) {
        CanvasPage canvasPage = this.getPage();
        if (canvasPage != null) {
            canvasPage.zoom(d);
        }
    }

    public void zoomToRect() {
        CanvasPage canvasPage = this.getPage();
        if (canvasPage != null) {
            canvasPage.zoomToRect();
        }
    }

    public void selectRect() {
        CanvasPage canvasPage = this.getPage();
        if (canvasPage != null) {
            canvasPage.selectRect();
        }
        this.invalidateAllSelectionImages();
    }

    public void updateTabs() {
        this.m_tabListener.updateTabs();
    }

    public void updateCanvas(int n) {
        CanvasPage canvasPage = this.getPage(n);
        if (canvasPage != null) {
            Component component;
            canvasPage.initDisplay();
            if (this.getPage() == canvasPage && (component = this.m_view.getCanvasComponent()) != null) {
                component.repaint(1000L);
            }
        }
    }

    public void updateCanvas() {
        this.updateCanvas(this.getSelectedTab());
    }

    public SCanvasAWT getCanvas(int n) {
        CanvasPage canvasPage = this.getPage(n);
        return canvasPage == null ? null : canvasPage.getCanvas();
    }

    public SCanvasAWT getCanvas() {
        return this.getCanvas(this.getSelectedTab());
    }

    public void releaseMemory() {
        int n = this.getTabCount();
        for (int i = 0; i < n; ++i) {
            CanvasPage canvasPage = this.getPage(i);
            if (canvasPage == null) continue;
            canvasPage.releaseMemory();
        }
    }

    public void doHitAction(String string) {
        this.doHitAction(string, 0, 0, false, false);
    }

    public void doHitAction(String string, int n, int n2, boolean bl, boolean bl2) {
        this.doHitAction(string, n, n2, true, false, false, bl, bl2);
    }

    public void doHitAction(String string, int n, int n2, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        this.m_showQueryErrorDialog = true;
        if (string == null || string.length() < 1) {
            this.doHitSelect(null, bl4, bl5);
            return;
        }
        XMLElement xMLElement = new XMLElement();
        String string2 = null;
        try {
            xMLElement.parseString(string);
        }
        catch (Exception exception) {
            string2 = exception.getLocalizedMessage();
        }
        if (string2 != null) {
            this.m_view.doHitError(string, string2);
            return;
        }
        this.doHitAction(xMLElement, string, n, n2, bl, bl2, bl3, bl4, bl5);
    }

    public void doHitAction(XMLElement xMLElement, String string, int n, int n2, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        block22: {
            try {
                if (xMLElement == null || xMLElement.getTagName() == null) {
                    throw new Exception("empty tag");
                }
                if (xMLElement.getTagName().equalsIgnoreCase("SELECT")) {
                    boolean bl6;
                    String string2 = xMLElement.getProperty("TAG");
                    boolean bl7 = bl6 = string2 != null && !string2.equals("");
                    if (bl6 && this.actionMatchesEvent(xMLElement, bl, bl2, bl3, bl4, bl5)) {
                        String string3 = this.getElementProperty(xMLElement, "DO", "KEY");
                        this.doHitSelect(string2, string3, bl4, bl5);
                        return;
                    }
                    Vector vector = xMLElement.getChildren();
                    if (vector == null || vector.size() < 1) {
                        return;
                    }
                    for (int i = 0; i < vector.size(); ++i) {
                        XMLElement xMLElement2 = (XMLElement)vector.elementAt(i);
                        if (!this.actionMatchesEvent(xMLElement2, bl, bl2, bl3, bl4, bl5)) continue;
                        this.doHitAction(xMLElement2, string, n, n2, bl, bl2, bl3, bl4, bl5);
                        return;
                    }
                    break block22;
                }
                if (!this.actionMatchesEvent(xMLElement, bl, bl2, bl3, bl4, bl5)) {
                    return;
                }
                if (xMLElement.getTagName().equalsIgnoreCase("PAGE")) {
                    String string4 = xMLElement.getProperty("TAG");
                    if (string4 == null) {
                        throw new Exception("no tag specified");
                    }
                    int n3 = this.getTabNumberFromTagName(string4);
                    if (n3 >= 0) {
                        this.setSelectedTab(n3);
                        break block22;
                    }
                    throw new Exception("page tag not found: " + string4);
                }
                if (xMLElement.getTagName().equalsIgnoreCase("LINK")) {
                    String string5 = xMLElement.getProperty("HREF");
                    String string6 = xMLElement.getProperty("TARGET", "_top");
                    if (string5 == null) {
                        throw new Exception("no href specified");
                    }
                    String string7 = xMLElement.getProperty("SUBSTITUTE", "");
                    if (string7.equalsIgnoreCase("TRUE") && string5.indexOf("%SELECTEDTAGS%") >= 0) {
                        String[] stringArray = this.getSelectedTags();
                        StringBuffer stringBuffer = new StringBuffer();
                        for (int i = 0; stringArray != null && i < stringArray.length; ++i) {
                            if (i > 0) {
                                stringBuffer.append(",");
                            }
                            stringBuffer.append(stringArray[i]);
                        }
                        string5 = this.substituteAll(string5, "%SELECTEDTAGS%", stringArray.toString());
                    }
                    this.m_view.doHitURL(string5, string6);
                    break block22;
                }
                if (xMLElement.getTagName().equalsIgnoreCase("MENU")) {
                    STreeNode sTreeNode = new STreeNode();
                    STreeNode sTreeNode2 = new STreeNode();
                    boolean bl8 = this.collectMenuInfo(xMLElement, sTreeNode, sTreeNode2);
                    if (bl8) {
                        this.doHitMenu(this.m_view, sTreeNode, sTreeNode2, n, n2);
                    }
                    break block22;
                }
                if (xMLElement.getTagName().equalsIgnoreCase("QUERY")) {
                    STreeNode sTreeNode = new STreeNode();
                    STreeNode sTreeNode3 = new STreeNode();
                    boolean bl9 = this.doHitQueryWebService(this.m_view, xMLElement, sTreeNode, sTreeNode3, this.m_showQueryErrorDialog);
                    if (bl9) {
                        this.doHitMenu(this.m_view, sTreeNode, sTreeNode3, n, n2);
                    } else {
                        this.m_showQueryErrorDialog = false;
                    }
                    break block22;
                }
                if (xMLElement.getTagName().equalsIgnoreCase("EXEC")) {
                    String string8 = xMLElement.getProperty("CODE");
                    String string9 = xMLElement.getProperty("LANGUAGE");
                    this.doExec(this.m_view, string8, string9);
                    break block22;
                }
                throw new Exception("unknown tag " + xMLElement.getTagName());
            }
            catch (Exception exception) {
                this.m_view.doHitError(string, exception.toString());
            }
        }
    }

    public boolean doContextMenu(int n, int n2) {
        if (!(this.m_view instanceof ContextMenuAccess)) {
            return false;
        }
        ContextMenuAccess contextMenuAccess = (ContextMenuAccess)((Object)this.m_view);
        boolean bl = contextMenuAccess.doContextMenu(n, n2);
        return bl;
    }

    private String substituteAll(String string, String string2, String string3) {
        int n = string.indexOf(string2);
        if (n < 0) {
            return string;
        }
        return string.substring(0, n) + string3 + this.substituteAll(string.substring(n + string2.length()), string2, string3);
    }

    private boolean actionMatchesEvent(XMLElement xMLElement, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        String string = this.getElementProperty(xMLElement, "BUTTON", "LEFT");
        boolean bl6 = false;
        bl6 = string.equalsIgnoreCase("NONE") ? false : (string.equalsIgnoreCase("ANY") ? true : (string.equalsIgnoreCase("LEFT") ? bl : (string.equalsIgnoreCase("MIDDLE") ? bl2 : (string.equalsIgnoreCase("RIGHT") ? bl3 : false))));
        if (!bl6) {
            return false;
        }
        String string2 = this.getElementProperty(xMLElement, "SHIFT", "ANY");
        if (!this.shiftControlMatch(string2, bl5)) {
            return false;
        }
        String string3 = this.getElementProperty(xMLElement, "CONTROL", "ANY");
        return this.shiftControlMatch(string3, bl4);
    }

    private boolean shiftControlMatch(String string, boolean bl) {
        if (string.equalsIgnoreCase("ANY")) {
            return true;
        }
        if (bl && (string.equalsIgnoreCase("ON") || string.equalsIgnoreCase("YES") || string.equalsIgnoreCase("T") || string.equalsIgnoreCase("TRUE"))) {
            return true;
        }
        return !bl && (string.equalsIgnoreCase("OFF") || string.equalsIgnoreCase("NO") || string.equalsIgnoreCase("F") || string.equalsIgnoreCase("FALSE"));
    }

    private String getElementProperty(XMLElement xMLElement, String string, String string2) {
        String string3;
        String string4 = string3 = xMLElement == null ? string2 : xMLElement.getProperty(string);
        if (string3 == null || string3.equals("")) {
            string3 = string2;
        }
        return string3;
    }

    public boolean doHitQueryWebService(SCanvasPaneView sCanvasPaneView, XMLElement xMLElement, STreeNode sTreeNode, STreeNode sTreeNode2, boolean bl) throws Exception {
        if (sCanvasPaneView == null || !(sCanvasPaneView instanceof SCanvasPaneView2)) {
            throw new Exception("can't call doHitQueryWebService: no SCanvasPaneView2");
        }
        return ((SCanvasPaneView2)sCanvasPaneView).doHitQueryWebService(xMLElement, sTreeNode, sTreeNode2, bl);
    }

    public void doHitMenu(SCanvasPaneView sCanvasPaneView, STreeNode sTreeNode, STreeNode sTreeNode2, int n, int n2) {
        if (sCanvasPaneView != null && sTreeNode != null && sTreeNode2 != null && sTreeNode.getChildCount() >= 1 && sTreeNode2.getChildCount() >= 1) {
            if (!(sCanvasPaneView instanceof SCanvasPaneView2)) {
                String string = String.valueOf(sTreeNode.getUserObject());
                int n3 = Math.min(sTreeNode.getChildCount(), sTreeNode2.getChildCount());
                String[] stringArray = new String[n3];
                String[] stringArray2 = new String[n3];
                for (int i = 0; i < n3; ++i) {
                    STreeNode sTreeNode3 = sTreeNode.getChildAt(i);
                    STreeNode sTreeNode4 = sTreeNode2.getChildAt(i);
                    stringArray[i] = (String)sTreeNode3.getUserObject();
                    stringArray2[i] = sTreeNode4.isLeaf() ? (String)sTreeNode4.getUserObject() : "";
                }
                sCanvasPaneView.doHitMenu(string, stringArray, stringArray2, n, n2);
            } else {
                ((SCanvasPaneView2)sCanvasPaneView).doHitMenu(sTreeNode, sTreeNode2, n, n2);
            }
        }
    }

    public void doExec(SCanvasPaneView sCanvasPaneView, String string, String string2) {
        if (sCanvasPaneView != null && sCanvasPaneView instanceof SCanvasPaneView2) {
            ((SCanvasPaneView2)sCanvasPaneView).doExec(string, string2);
        }
    }

    protected boolean collectMenuInfo(XMLElement xMLElement, STreeNode sTreeNode, STreeNode sTreeNode2) throws Exception {
        String string = xMLElement.getProperty("TITLE", "");
        if (string.equals("")) {
            string = xMLElement.getProperty("LABEL", "");
        }
        sTreeNode.setUserObject(string);
        Enumeration enumeration = xMLElement.enumerateChildren();
        while (enumeration.hasMoreElements()) {
            Object object;
            Object object2;
            XMLElement xMLElement2 = (XMLElement)enumeration.nextElement();
            String string2 = xMLElement2.getTagName();
            if (string2.equalsIgnoreCase("MENUITEM")) {
                object2 = xMLElement2.getProperty("LABEL", "item");
                object = "";
                if (xMLElement2.countChildren() > 0) {
                    XMLElement xMLElement3 = (XMLElement)xMLElement2.getChildren().firstElement();
                    object = XML.getXMLString(xMLElement3);
                }
                sTreeNode.add(new STreeNode(object2));
                sTreeNode2.add(new STreeNode(object));
                continue;
            }
            if (string2.equalsIgnoreCase("MENU")) {
                object2 = new STreeNode();
                object = new STreeNode();
                boolean bl = this.collectMenuInfo(xMLElement2, (STreeNode)object2, (STreeNode)object);
                if (!bl) continue;
                sTreeNode.add((STreeNode)object2);
                sTreeNode2.add((STreeNode)object);
                continue;
            }
            if (string2.equalsIgnoreCase("SEPARATOR")) {
                sTreeNode.add(new STreeNode("-"));
                sTreeNode2.add(new STreeNode());
                continue;
            }
            if (!string2.equalsIgnoreCase("QUERY")) continue;
            object2 = new STreeNode();
            object = new STreeNode();
            boolean bl = this.doHitQueryWebService(this.m_view, xMLElement2, (STreeNode)object2, (STreeNode)object, this.m_showQueryErrorDialog);
            if (bl) {
                sTreeNode.add((STreeNode)object2);
                sTreeNode2.add((STreeNode)object);
                continue;
            }
            this.m_showQueryErrorDialog = false;
        }
        return sTreeNode.getChildCount() > 0;
    }

    protected void doHitSelect(String string, boolean bl, boolean bl2) {
        this.doHitSelect(string, "KEY", bl, bl2);
    }

    protected void doHitSelect(String string, String string2, boolean bl, boolean bl2) {
        if (string2 == null || string2.equalsIgnoreCase("KEY")) {
            if (bl) {
                this.toggleSelectedTag(string);
            } else if (bl2) {
                this.addSelectedTag(string);
            } else {
                this.clearSetSelectedTag(string);
            }
        } else if (string2.equalsIgnoreCase("SET")) {
            this.clearSetSelectedTag(string);
        } else if (string2.equalsIgnoreCase("ADD")) {
            this.addSelectedTag(string);
        } else if (string2.equalsIgnoreCase("REMOVE")) {
            this.removeSelectedTag(string);
        } else if (string2.equalsIgnoreCase("TOGGLE")) {
            this.toggleSelectedTag(string);
        }
        this.invalidateAllSelectionImages();
    }

    public Dimension getCanvasComponentSize() {
        Component component = this.m_view.getCanvasComponent();
        return component == null ? new Dimension(100, 100) : component.getSize();
    }

    public void addCanvas(SCanvasAWT sCanvasAWT) {
        this.addCanvas(sCanvasAWT, this.m_pages.size());
    }

    public void addCanvas(SCanvasAWT sCanvasAWT, int n) {
        if (sCanvasAWT == null) {
            return;
        }
        sCanvasAWT.setCanvasTagSet(this.m_tagset);
        CanvasPage canvasPage = new CanvasPage(sCanvasAWT);
        int n2 = Math.max(0, Math.min(this.m_pages.size(), n));
        this.m_pages.insertElementAt(canvasPage, n2);
        this.m_displayPageIndex = n2;
        this.updateDisplay();
        this.updateTabs();
    }

    CanvasPage getPage() {
        return this.getPage(this.m_displayPageIndex);
    }

    CanvasPage getPage(int n) {
        int n2 = Math.max(0, Math.min(this.m_pages.size() - 1, n));
        if (n2 >= this.m_pages.size()) {
            return null;
        }
        return (CanvasPage)this.m_pages.elementAt(n2);
    }

    public Point getCanvasPointFromMouse(Point point) {
        CanvasPage canvasPage = this.getPage();
        Point point2 = this.getBorderPoint();
        if (canvasPage == null || point == null || point2 == null) {
            return null;
        }
        Point point3 = canvasPage.getPosition();
        return new Point(point.x + point3.x - point2.x - 2, point.y + point3.y - point2.y - 2);
    }

    Point getBorderPoint() {
        Component component = this.m_view.getCanvasComponent();
        CanvasPage canvasPage = this.getPage();
        if (component == null || canvasPage == null) {
            return null;
        }
        Dimension dimension = component.getSize();
        Dimension dimension2 = canvasPage.getSize();
        int n = dimension2.width >= dimension.width ? 0 : (dimension.width - dimension2.width) / 2;
        int n2 = dimension2.height >= dimension.height ? 0 : (dimension.height - dimension2.height) / 2;
        return new Point(n, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateDisplay() {
        Component component = this.m_view.getCanvasComponent();
        if (component == null) {
            return;
        }
        m_numBadPaints = 0;
        try {
            this.m_ignoreScrollBars = true;
            Adjustable adjustable = this.m_view.getScrollAdjustable(0);
            Adjustable adjustable2 = this.m_view.getScrollAdjustable(1);
            Dimension dimension = component.getSize();
            CanvasPage canvasPage = this.getPage();
            Dimension dimension2 = canvasPage == null ? null : canvasPage.getSize();
            boolean bl = canvasPage == null ? true : canvasPage.getAutoZoom();
            boolean bl2 = !bl && adjustable != null && canvasPage != null && dimension2.width > component.getSize().width;
            boolean bl3 = !bl && adjustable2 != null && canvasPage != null && dimension2.height > component.getSize().height;
            this.m_view.setScrollVisible(0, bl2);
            this.m_view.setScrollVisible(1, bl3);
            if (canvasPage != null) {
                dimension = component.getSize();
                Point point = canvasPage.getPosition();
                int n = Math.max(0, Math.min(point.x, dimension2.width - dimension.width));
                int n2 = Math.max(0, Math.min(point.y, dimension2.height - dimension.height));
                canvasPage.m_position = new Point(n, n2);
                if (bl2) {
                    this.setScrollInfo(adjustable, n, dimension.width, dimension2.width);
                }
                if (bl3) {
                    this.setScrollInfo(adjustable2, n2, dimension.height, dimension2.height);
                }
            }
        }
        finally {
            this.m_ignoreScrollBars = false;
        }
        this.m_canvasListener.clearAnnotationState();
        component.repaint();
    }

    void setScrollInfo(Adjustable adjustable, int n, int n2, int n3) {
        int n4 = (int)Math.round(2.0E9 * (double)n / (double)n3);
        int n5 = (int)Math.round(2.0E9 * (double)n2 / (double)n3);
        int n6 = (int)Math.round((double)n5 * 0.8);
        int n7 = Math.max(1, (int)Math.round(1.0E10 / (double)n3));
        adjustable.setMinimum(0);
        adjustable.setMaximum(2000000000);
        adjustable.setValue(n4);
        adjustable.setVisibleAmount(n5);
        adjustable.setBlockIncrement(n6);
        adjustable.setUnitIncrement(n7);
    }

    void updateViewFromScrollbars() {
        if (this.m_ignoreScrollBars) {
            return;
        }
        CanvasPage canvasPage = this.getPage();
        if (canvasPage == null || canvasPage.getAutoZoom()) {
            return;
        }
        Component component = this.m_view.getCanvasComponent();
        if (component == null) {
            return;
        }
        Dimension dimension = canvasPage.getSize();
        Dimension dimension2 = component.getSize();
        boolean bl = this.m_view.getScrollVisible(0);
        boolean bl2 = this.m_view.getScrollVisible(1);
        Adjustable adjustable = this.m_view.getScrollAdjustable(0);
        Adjustable adjustable2 = this.m_view.getScrollAdjustable(1);
        int n = 0;
        int n2 = 0;
        if (adjustable != null && bl) {
            n = (int)Math.round((double)adjustable.getValue() / 2.0E9 * (double)dimension.width);
        }
        if (adjustable2 != null && bl2) {
            n2 = (int)Math.round((double)adjustable2.getValue() / 2.0E9 * (double)dimension.height);
        }
        if (!bl && !bl2) {
            return;
        }
        n = Math.max(0, Math.min(n, dimension.width - dimension2.width));
        n2 = Math.max(0, Math.min(n2, dimension.height - dimension2.height));
        canvasPage.m_position = new Point(n, n2);
        component.repaint();
    }

    public void setAutoZoom(boolean bl) {
        CanvasPage canvasPage = this.getPage();
        if (canvasPage != null && bl != canvasPage.getAutoZoom()) {
            canvasPage.setAutoZoom(bl);
            this.updateDisplay();
        }
    }

    public boolean getAutoZoom() {
        CanvasPage canvasPage = this.getPage();
        return canvasPage != null ? canvasPage.getAutoZoom() : true;
    }

    public void removeAllPages() {
        this.m_displayPageIndex = 0;
        this.m_pages.removeAllElements();
        this.updateDisplay();
        this.updateTabs();
    }

    protected void invalidateAllSelectionImages() {
        for (int i = 0; i < this.m_pages.size(); ++i) {
            ((CanvasPage)this.m_pages.elementAt(i)).invalidateSelectionImages();
        }
        this.m_view.getCanvasComponent().repaint();
    }

    static boolean leftButtonEvent(MouseEvent mouseEvent) {
        int n = mouseEvent.getModifiers();
        boolean bl = (n & 0x10) != 0;
        boolean bl2 = (n & 8) != 0;
        boolean bl3 = (n & 4) != 0;
        return bl || !bl && !bl2 && !bl3;
    }

    public String[] getSelectedTags() {
        return this.m_tagset.getSelectedTagArray();
    }

    public void setSelectedTags(String[] stringArray) {
        this.m_tagset.setSelectedTagArray(null);
        this.invalidateAllSelectionImages();
        this.m_tagset.setSelectedTagArray(stringArray);
        this.invalidateAllSelectionImages();
        this.callOnSelectChanged();
    }

    public void clearSelectedTags() {
        this.m_tagset.clearChanged();
        this.m_tagset.clear();
        this.invalidateAllSelectionImages();
        if (this.m_tagset.hasChanged()) {
            this.callOnSelectChanged();
        }
    }

    public void addSelectedTag(String string) {
        this.m_tagset.clearChanged();
        this.m_tagset.add(string);
        this.invalidateAllSelectionImages();
        if (this.m_tagset.hasChanged()) {
            this.callOnSelectChanged();
        }
    }

    public void clearSetSelectedTag(String string) {
        this.m_tagset.clearChanged();
        this.m_tagset.clear();
        this.m_tagset.add(string);
        this.invalidateAllSelectionImages();
        if (this.m_tagset.hasChanged()) {
            this.callOnSelectChanged();
        }
    }

    public void removeSelectedTag(String string) {
        this.m_tagset.clearChanged();
        this.m_tagset.remove(string);
        this.invalidateAllSelectionImages();
        if (this.m_tagset.hasChanged()) {
            this.callOnSelectChanged();
        }
    }

    public void toggleSelectedTag(String string) {
        this.m_tagset.clearChanged();
        this.m_tagset.toggle(string);
        this.invalidateAllSelectionImages();
        if (this.m_tagset.hasChanged()) {
            this.callOnSelectChanged();
        }
    }

    public void toggleSelectedTagArray(String[] stringArray) {
        this.m_tagset.clearChanged();
        this.m_tagset.toggle(stringArray);
        this.invalidateAllSelectionImages();
        if (this.m_tagset.hasChanged()) {
            this.callOnSelectChanged();
        }
    }

    public void addSelectedTagArray(String[] stringArray) {
        this.m_tagset.clearChanged();
        this.m_tagset.add(stringArray);
        this.invalidateAllSelectionImages();
        if (this.m_tagset.hasChanged()) {
            this.callOnSelectChanged();
        }
    }

    public void clearSetSelectedTagArray(String[] stringArray) {
        this.m_tagset.clearChanged();
        this.m_tagset.clear();
        this.m_tagset.add(stringArray);
        this.invalidateAllSelectionImages();
        if (this.m_tagset.hasChanged()) {
            this.callOnSelectChanged();
        }
    }

    protected void callOnSelectChanged() {
        XMLElement xMLElement;
        CanvasPage canvasPage = this.getPage(0);
        if (canvasPage != null && (xMLElement = canvasPage.getOnSelectChangedAction()) != null) {
            this.doHitAction(xMLElement, canvasPage.getTag(), 0, 0, true, false, false, false, false);
        }
    }

    public boolean isSelectedTag(String string) {
        return this.m_tagset.contains(string);
    }

    public String getCurrentPageTagName() {
        String string = this.getTabTagName(this.getSelectedTab());
        return string == null ? "" : string;
    }

    public int getCurrentPageNumber() {
        return this.getSelectedTab() + 1;
    }

    public int getNumberPages() {
        return this.getTabCount();
    }

    public void setCurrentPageByTagName(String string) {
        this.setCurrentPageByNumber(this.getTabNumberFromTagName(string == null ? "" : string) + 1);
    }

    public void setCurrentPageByNumber(int n) {
        if (n > 0 && n <= this.getNumberPages()) {
            this.setSelectedTab(n - 1);
        }
    }

    public void setCurrentPageBack() {
        this.setSelectedTabBack();
    }

    public void setCurrentPageForward() {
        this.setSelectedTabForward();
    }

    private int getPrintPageCenter(int n, int n2, int n3) {
        int n4 = 0;
        n4 = n <= n2 ? (n2 - n) / 2 : (n3 < n2 ? (n2 - n3) / 2 : 0);
        return n4;
    }

    public void printPage(int n, Graphics graphics, Dimension dimension, boolean bl, boolean bl2) {
        this.printPage(n, graphics, dimension, bl, bl2, true);
    }

    public void printPage(int n, Graphics graphics, Dimension dimension, boolean bl, boolean bl2, boolean bl3) {
        CanvasPage canvasPage = this.getPage(n);
        if (canvasPage != null) {
            Component component;
            if (bl3) {
                int n2 = (int)((double)dimension.width * 0.05);
                int n3 = (int)((double)dimension.height * 0.05);
                dimension = new Dimension(dimension.width - 2 * n2, dimension.height - 2 * n3);
                graphics.translate(n2, n3);
            }
            if ((component = this.m_view.getCanvasComponent()) == null) {
                return;
            }
            Dimension dimension2 = component.getSize();
            Dimension dimension3 = canvasPage.getSize();
            Point point = canvasPage.getPosition();
            if (bl) {
                dimension2 = dimension3;
                point = new Point(0, 0);
            }
            if (dimension3.width <= dimension2.width) {
                dimension2 = new Dimension(dimension3.width, dimension2.height);
                point = new Point(0, point.y);
            }
            if (dimension3.height <= dimension2.height) {
                dimension2 = new Dimension(dimension2.width, dimension3.height);
                point = new Point(point.x, 0);
            }
            Dimension dimension4 = SCanvasAWT.getMaxFitSize(dimension2, dimension);
            double d = dimension2.width < 1 ? 1.0 : (double)dimension4.width / (double)dimension2.width;
            dimension3 = new Dimension((int)(d * (double)dimension3.width), (int)(d * (double)dimension3.height));
            point = new Point((int)(d * (double)point.x), (int)(d * (double)point.y));
            int n4 = this.getPrintPageCenter(dimension3.width, dimension.width, dimension4.width);
            int n5 = this.getPrintPageCenter(dimension3.height, dimension.height, dimension4.height);
            graphics.translate(n4 - point.x, n5 - point.y);
            canvasPage.paintCanvasPage(graphics, true, 0, dimension3);
            if (bl2) {
                graphics.setColor(this.m_clrSelectionHighlight);
                canvasPage.getCanvas().paintSelections(graphics, this.m_tagset);
            }
            canvasPage.initDisplay();
            this.updateDisplay();
        }
    }

    public void retrieveEmbeddedSPJFile() {
        SCanvasAWT sCanvasAWT;
        CanvasPage canvasPage = this.getPage();
        SCanvasAWT sCanvasAWT2 = sCanvasAWT = canvasPage == null ? null : canvasPage.getCanvas();
        if (sCanvasAWT == null || !sCanvasAWT.getInApplet()) {
            return;
        }
        if (sCanvasAWT.hasEmbeddedFileData()) {
            return;
        }
        String string = canvasPage.getEmbeddedFileName();
        if (string == null) {
            return;
        }
        int n = canvasPage.getEmbeddedFilePage();
        SCanvasAWT sCanvasAWT3 = null;
        try {
            if (!(this.m_view instanceof EmbeddedFileAccess)) {
                throw new Exception("embedded files only supported in applets");
            }
            EmbeddedFileAccess embeddedFileAccess = (EmbeddedFileAccess)((Object)this.m_view);
            Vector vector = embeddedFileAccess.getEmbeddedCanvasVector(string);
            if (n < 1 || n > vector.size()) {
                throw new Exception("Can't open specified page " + n + " from SPJ file with " + vector.size() + " pages");
            }
            sCanvasAWT3 = (SCanvasAWT)vector.elementAt(n - 1);
            embeddedFileAccess.prepareEmbeddedCanvas(sCanvasAWT3);
            ColorScheme colorScheme = this.parsePDFColorScheme(sCanvasAWT3.getTag());
            if (colorScheme == null && vector.size() > 0) {
                SCanvasAWT sCanvasAWT4 = (SCanvasAWT)vector.elementAt(0);
                colorScheme = this.parsePDFColorScheme(sCanvasAWT4.getTag());
            }
            if (colorScheme != null) {
                sCanvasAWT3.setColorScheme(colorScheme);
            }
        }
        catch (Exception exception) {
            sCanvasAWT3 = SCanvasAWT.createErrorCanvas("Error loading embedded file " + string + " p" + n + ": " + exception);
        }
        sCanvasAWT.loadEmbeddedCanvas(sCanvasAWT3);
    }

    private ColorScheme parsePDFColorScheme(String string) {
        Object object;
        Object object2;
        Object object3;
        XMLElement xMLElement = null;
        XMLElement xMLElement2 = null;
        if (string.indexOf("<") >= 0) {
            xMLElement = new XMLElement();
            try {
                xMLElement.parseString(string);
            }
            catch (Exception exception) {
                if (this.getDebug() || this.getCanvas(0) != null && this.getCanvas(0).getInApplet()) {
                    System.out.println("exception " + exception + " while parsing tag XML: " + string);
                }
                xMLElement = null;
            }
            if (xMLElement != null && xMLElement.getTagName() != null && xMLElement.getTagName().equalsIgnoreCase("TAG") && (object3 = xMLElement.getChildren()) != null) {
                for (int i = 0; i < ((Vector)object3).size(); ++i) {
                    XMLElement xMLElement3 = (XMLElement)((Vector)object3).elementAt(i);
                    if ((xMLElement3 == null || xMLElement3.getTagName() == null) && !xMLElement3.getTagName().equalsIgnoreCase("PDFCOLORSPEC")) continue;
                    xMLElement2 = xMLElement3;
                    break;
                }
            }
        }
        if (xMLElement2 == null) {
            return null;
        }
        object3 = xMLElement2.getProperty("GRAYSCALE", "FALSE");
        String string2 = xMLElement2.getProperty("FRACTIONS", "FALSE");
        boolean bl = ((String)object3).equalsIgnoreCase("TRUE");
        boolean bl2 = string2.equalsIgnoreCase("TRUE");
        Vector vector = new Vector();
        Vector vector2 = new Vector();
        Vector vector3 = new Vector();
        Vector vector4 = new Vector();
        Vector vector5 = new Vector();
        Vector vector6 = new Vector();
        Vector vector7 = xMLElement2.getChildren();
        if (vector7 != null) {
            for (int i = 0; i < vector7.size(); ++i) {
                object2 = (XMLElement)vector7.elementAt(i);
                if (object2 == null || (object = (Object)((XMLElement)object2).getTagName()) == null) continue;
                if (((String)object).equalsIgnoreCase("COLORMAP")) {
                    SCanvasPaneController.parseAddNumbers((XMLElement)object2, vector, bl2);
                    continue;
                }
                if (((String)object).equalsIgnoreCase("LINECOLORS")) {
                    SCanvasPaneController.parseAddNumbers((XMLElement)object2, vector2, false);
                    continue;
                }
                if (((String)object).equalsIgnoreCase("TEXTCOLORS")) {
                    SCanvasPaneController.parseAddNumbers((XMLElement)object2, vector3, false);
                    continue;
                }
                if (((String)object).equalsIgnoreCase("POLYGONCOLORS")) {
                    SCanvasPaneController.parseAddNumbers((XMLElement)object2, vector4, false);
                    continue;
                }
                if (((String)object).equalsIgnoreCase("IMAGECOLORS")) {
                    SCanvasPaneController.parseAddNumbers((XMLElement)object2, vector5, false);
                    continue;
                }
                if (!((String)object).equalsIgnoreCase("BACKGROUNDCOLOR")) continue;
                SCanvasPaneController.parseAddNumbers((XMLElement)object2, vector6, false);
            }
        }
        int[] nArray = SCanvasPaneController.intVectorToArray(vector);
        object2 = SCanvasPaneController.intVectorToArray(vector2);
        object = SCanvasPaneController.intVectorToArray(vector3);
        int[] nArray2 = SCanvasPaneController.intVectorToArray(vector4);
        int[] nArray3 = SCanvasPaneController.intVectorToArray(vector5);
        int[] nArray4 = SCanvasPaneController.intVectorToArray(vector6);
        if (nArray.length < (bl ? 1 : 3) || ((Object)object2).length < 1 || ((Object)object).length < 1 || nArray2.length < 1 || nArray3.length < 1 || nArray4.length < 1) {
            return null;
        }
        return new ColorScheme.PDFColorScheme(bl, nArray, (int[])object2, (int[])object, nArray2, nArray3, nArray4[0]);
    }

    private static void parseAddNumbers(XMLElement xMLElement, Vector vector, boolean bl) {
        String string = xMLElement.getProperty("D", "");
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            int n3 = string.indexOf(44, n2);
            String string2 = null;
            if (n3 >= 0) {
                string2 = string.substring(n2, n3).trim();
                n2 = n3 + 1;
            } else {
                string2 = string.substring(n2).trim();
                n2 = n;
            }
            if (bl) {
                try {
                    double d = Double.valueOf(string2);
                    int n4 = (int)Math.floor(d * 256.0);
                    if (n4 > 255) {
                        n4 = 255;
                    }
                    if (n4 < 0) {
                        n4 = 0;
                    }
                    vector.addElement(new Integer(n4));
                }
                catch (Exception exception) {}
                continue;
            }
            try {
                vector.addElement(new Integer(string2));
            }
            catch (Exception exception) {}
        }
    }

    private static int[] intVectorToArray(Vector vector) {
        int[] nArray = new int[vector.size()];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = (Integer)vector.elementAt(i);
        }
        return nArray;
    }

    public double getZoom() {
        CanvasPage canvasPage = this.getPage();
        return canvasPage != null ? canvasPage.getZoom() : 1.0;
    }

    public void setZoom(double d) {
        CanvasPage canvasPage = this.getPage();
        if (canvasPage != null) {
            if (d == 1.0) {
                this.setAutoZoom(true);
            } else {
                canvasPage.setZoom(d);
            }
        }
    }

    public void setZoomToRect(SCanvasRectangle sCanvasRectangle) {
        CanvasPage canvasPage = this.getPage();
        if (canvasPage != null) {
            canvasPage.setZoomToRect(sCanvasRectangle);
        }
    }

    public SCanvasRectangle getSelectionRect() {
        SCanvasRectangle sCanvasRectangle = null;
        CanvasPage canvasPage = this.getPage();
        if (canvasPage != null) {
            sCanvasRectangle = canvasPage.m_lastSweepRect;
        }
        if (sCanvasRectangle == null) {
            sCanvasRectangle = new SCanvasRectangle(0.0f, 0.0f, 1.0f, 1.0f);
        }
        return new SCanvasRectangle(sCanvasRectangle.getX(), sCanvasRectangle.getY(), sCanvasRectangle.getWidth(), sCanvasRectangle.getHeight());
    }

    public void setSelectionRect(SCanvasRectangle sCanvasRectangle) {
        CanvasPage canvasPage = this.getPage();
        if (sCanvasRectangle == null) {
            sCanvasRectangle = new SCanvasRectangle(0.0f, 0.0f, 1.0f, 1.0f);
        }
        if (canvasPage != null) {
            canvasPage.m_lastSweepRect = sCanvasRectangle;
        }
    }

    public boolean getSelectionRectShiftDown() {
        CanvasPage canvasPage = this.getPage();
        return canvasPage != null ? canvasPage.m_bSweepShiftDown : false;
    }

    public void setSelectionRectShiftDown(boolean bl) {
        CanvasPage canvasPage = this.getPage();
        if (canvasPage != null) {
            canvasPage.m_bSweepShiftDown = bl;
        }
    }

    public boolean getSelectionRectControlDown() {
        CanvasPage canvasPage = this.getPage();
        return canvasPage != null ? canvasPage.m_bSweepControlDown : false;
    }

    public void setSelectionRectControlDown(boolean bl) {
        CanvasPage canvasPage = this.getPage();
        if (canvasPage != null) {
            canvasPage.m_bSweepControlDown = bl;
        }
    }

    public String[] getTagsInRect(SCanvasRectangle sCanvasRectangle) {
        CanvasPage canvasPage = this.getPage();
        if (canvasPage == null) {
            return new String[0];
        }
        return canvasPage.getTagsInRect(sCanvasRectangle);
    }

    public static void setDebugFirehose(boolean bl) {
        m_debugFirehose = bl;
    }

    public static void setDebugFirehoseCheckSleep(int n) {
        m_debugFirehoseCheckSleep = n;
    }

    static {
        SCanvasPaneController.setLocatorFractionDigits(2);
        m_showMouse = false;
        m_showActiveRegions = true;
        m_iAnnotationTextColor = 1;
        m_labelColor = null;
        m_debugFirehose = false;
        m_debugFirehosePaintCount = 0;
        m_debugFirehoseCheckSleep = 25;
    }

    public static interface EmbeddedFileAccess {
        public Vector getEmbeddedCanvasVector(String var1) throws Exception;

        public void prepareEmbeddedCanvas(SCanvasAWT var1) throws Exception;
    }

    class CanvasComponentListener
    implements MouseListener,
    MouseMotionListener,
    ComponentListener {
        final int SWEEP_OFF = 0;
        final int SWEEP_WAIT_FOR_MOUSE = 1;
        final int SWEEP_ON = 3;
        int m_sweepRectMode = 0;
        Rectangle m_sweepRect = null;
        Point m_sweepPoint = null;
        String m_mouseString = null;
        int m_mouseX = -99999;
        int m_mouseY = -99999;
        SCanvasHit m_hit = null;
        Rectangle m_hitRect = null;
        String m_leftLabel = null;
        String m_rightLabel = null;
        Rectangle m_leftLabelRect = null;
        Rectangle m_rightLabelRect = null;
        final int LABEL_BORDER_X = 5;
        final int LABEL_BORDER_Y = 5;

        CanvasComponentListener() {
        }

        public void componentResized(ComponentEvent componentEvent) {
            SCanvasPaneController.this.updateDisplay();
        }

        public void componentMoved(ComponentEvent componentEvent) {
        }

        public void componentShown(ComponentEvent componentEvent) {
        }

        public void componentHidden(ComponentEvent componentEvent) {
        }

        public void print(Graphics graphics) {
            Component component = SCanvasPaneController.this.m_view.getCanvasComponent();
            if (component == null) {
                return;
            }
            Dimension dimension = component.getSize();
            CanvasPage canvasPage = SCanvasPaneController.this.getPage();
            if (canvasPage == null) {
                graphics.setColor(Color.lightGray);
                graphics.fillRect(0, 0, dimension.width, dimension.height);
                return;
            }
            Dimension dimension2 = canvasPage.getSize();
            Point point = SCanvasPaneController.this.getBorderPoint();
            this.paintBorders(graphics, dimension2, dimension, point, canvasPage.getCanvas().getBackgroundColor());
            Point point2 = canvasPage.getPosition();
            int n = -point2.x + point.x;
            int n2 = -point2.y + point.y;
            graphics.translate(n, n2);
            canvasPage.paintCanvasPage(graphics, true, 0);
        }

        void paintBorders(Graphics graphics, Dimension dimension, Dimension dimension2, Point point, Color color) {
            int n = point.x;
            int n2 = n + dimension.width;
            int n3 = point.y;
            int n4 = n3 + dimension.height;
            Color color2 = Color.lightGray;
            Color color3 = Color.black;
            if (m_backgroundBorders) {
                color2 = color;
                color3 = color;
            }
            if (n < 5) {
                graphics.setColor(color);
                graphics.fillRect(0, 0, n, dimension2.height);
                graphics.fillRect(n2, 0, dimension2.width - n2, dimension2.height);
                n = 0;
                n2 = dimension2.width;
            }
            if (n3 < 5) {
                graphics.setColor(color);
                graphics.fillRect(0, 0, dimension2.width, n3);
                graphics.fillRect(0, n4, dimension2.width, dimension2.height - n4);
                n3 = 0;
                n4 = dimension2.height;
            }
            if (n > 0) {
                graphics.setColor(color2);
                graphics.fillRect(0, 0, n, dimension2.height);
                graphics.fillRect(n2, 0, dimension2.width - n2, dimension2.height);
                graphics.setColor(color3);
                graphics.drawLine(n - 1, n3 - 1, n - 1, n4);
                graphics.drawLine(n2, n3 - 1, n2, n4);
            }
            if (n3 > 0) {
                graphics.setColor(color2);
                graphics.fillRect(0, 0, dimension2.width, n3);
                graphics.fillRect(0, n4, dimension2.width, dimension2.height - n4);
                graphics.setColor(color3);
                graphics.drawLine(n - 1, n3 - 1, n2, n3 - 1);
                graphics.drawLine(n - 1, n4, n2, n4);
            }
        }

        public synchronized void paint(Graphics graphics) {
            block13: {
                Component component = null;
                Dimension dimension = null;
                try {
                    if (m_debugFirehose) {
                        System.out.print("<" + m_debugFirehosePaintCount++ + "," + (SCanvasPaneController.this.getPage() != null ? SCanvasPaneController.this.getPage().m_canvas.getNumberCommands() : 0) + ">");
                    }
                    graphics.setPaintMode();
                    component = SCanvasPaneController.this.m_view.getCanvasComponent();
                    if (component == null) {
                        return;
                    }
                    dimension = component.getSize();
                    CanvasPage canvasPage = SCanvasPaneController.this.getPage();
                    if (canvasPage == null) {
                        graphics.setColor(Color.lightGray);
                        graphics.fillRect(0, 0, dimension.width, dimension.height);
                        return;
                    }
                    SCanvasPaneController.this.retrieveEmbeddedSPJFile();
                    Image image = canvasPage.getGraphImage(component);
                    Dimension dimension2 = canvasPage.m_doubleBufferSize;
                    Rectangle rectangle = canvasPage.m_doubleBufferViewRect;
                    Point point = SCanvasPaneController.this.getBorderPoint();
                    this.paintBorders(graphics, dimension2, dimension, point, canvasPage.getCanvas().getBackgroundColor());
                    Point point2 = canvasPage.getPosition();
                    int n = -point2.x + point.x;
                    int n2 = -point2.y + point.y;
                    graphics.translate(n, n2);
                    if (rectangle == null) {
                        graphics.drawImage(image, 0, 0, dimension2.width, dimension2.height, 0, 0, dimension2.width, dimension2.height, component);
                    } else {
                        graphics.drawImage(image, rectangle.x, rectangle.y, rectangle.x + rectangle.width, rectangle.y + rectangle.height, 0, 0, rectangle.width, rectangle.height, component);
                    }
                    graphics.translate(-n, -n2);
                    graphics.setColor(SCanvasPaneController.getAnnotationColor(canvasPage));
                    this.paintLeftLabel(graphics);
                    this.paintRightLabel(graphics);
                    this.paintHitRect(graphics);
                    canvasPage.checkFireHose();
                    m_numBadPaints = 0;
                }
                catch (Throwable throwable) {
                    boolean bl;
                    ++m_numBadPaints;
                    if (SCanvasPaneController.this.getDebug()) {
                        System.out.println("paint error " + m_numBadPaints);
                        throwable.printStackTrace();
                    }
                    String string = "Error during display: " + throwable;
                    if (throwable instanceof OutOfMemoryError) {
                        string = "Error during display: Out of memory";
                    }
                    graphics.setColor(Color.white);
                    if (dimension == null) {
                        dimension = new Dimension(2000, 2000);
                    }
                    graphics.fillRect(0, 0, dimension.width, dimension.height);
                    boolean bl2 = component != null && m_numBadPaints < 7;
                    boolean bl3 = bl2 && m_numBadPaints < 4;
                    boolean bl4 = bl = bl3 && m_numBadPaints == 2;
                    if (bl) {
                        if (SCanvasPaneController.this.getDebug()) {
                            System.out.println("calling releaseMemory()");
                        }
                        SCanvasPaneController.this.releaseMemory();
                    }
                    if (!bl3) {
                        graphics.setFont(new Font("Default", 1, 20));
                        graphics.setColor(Color.red);
                        graphics.drawString(string, 15, 30);
                    }
                    if (!bl2) break block13;
                    component.repaint(bl3 ? 100L : 1500L, 0, 0, dimension.width, dimension.height);
                }
            }
        }

        void clearAnnotationState() {
            this.m_hit = null;
            this.m_hitRect = null;
            this.m_sweepRect = null;
            this.m_mouseString = null;
            this.m_leftLabel = null;
            this.m_rightLabel = null;
            this.m_sweepRectMode = 0;
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (!SCanvasPaneController.leftButtonEvent(mouseEvent)) {
                return;
            }
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            this.m_sweepPoint = new Point(n, n2);
            this.m_sweepRectMode = 1;
            this.showHit(n, n2);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            if (this.m_sweepRectMode == 3) {
                this.updateRect(n, n2);
                this.endRect(mouseEvent.isControlDown(), mouseEvent.isShiftDown());
                this.repaintCanvasComponent();
                this.m_sweepRectMode = 0;
                return;
            }
            this.doHit(n, n2, mouseEvent);
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            if (this.m_sweepRectMode == 1 && (Math.abs(n - this.m_sweepPoint.x) > 10 || Math.abs(n2 - this.m_sweepPoint.y) > 10)) {
                this.m_sweepRectMode = 3;
                this.m_sweepRect = new Rectangle(this.m_sweepPoint.x, this.m_sweepPoint.y, n - this.m_sweepPoint.x, n2 - this.m_sweepPoint.y);
                this.xorRect(this.m_sweepRect);
                this.hideHit();
                this.setMouseString(null);
            } else if (this.m_sweepRectMode == 3) {
                this.updateRect(n, n2);
            } else {
                this.showHit(n, n2);
                this.setMouseString(n, n2);
            }
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            if (this.m_sweepRectMode != 3) {
                this.showHit(n, n2);
                this.setMouseString(n, n2);
            }
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            this.m_mouseX = -99999;
            this.m_mouseY = -99999;
        }

        public void mouseExited(MouseEvent mouseEvent) {
            if (this.m_sweepRectMode == 3) {
                this.endRect(mouseEvent.isControlDown(), mouseEvent.isShiftDown());
            }
            this.hideHit();
            this.setMouseString(null);
            this.repaintCanvasComponent();
            this.m_sweepRectMode = 0;
        }

        void setMouseString(int n, int n2) {
            if (!m_showMouse) {
                this.setMouseString(null);
                return;
            }
            if (n == this.m_mouseX && n2 == this.m_mouseY) {
                return;
            }
            this.m_mouseX = n;
            this.m_mouseY = n2;
            CanvasPage canvasPage = SCanvasPaneController.this.getPage();
            if (canvasPage == null) {
                return;
            }
            Point point = canvasPage.getPosition();
            SCanvasAWT sCanvasAWT = canvasPage.getCanvas();
            SCanvasPoint sCanvasPoint = sCanvasAWT.getValueFromPoint(SCanvasPaneController.this.getCanvasPointFromMouse(new Point(n, n2)));
            String string = sCanvasPoint == null ? "" : "x=" + m_locatorNumberFormat.format(sCanvasPoint.getX()) + "\ny=" + m_locatorNumberFormat.format(sCanvasPoint.getY());
            this.setMouseString(string);
        }

        void setMouseString(String string) {
            if (string == null || !string.equals(this.m_mouseString)) {
                this.m_mouseString = string;
                this.setLeftLabel(this.m_mouseString);
            }
        }

        void startRect(int n, int n2) {
            this.m_sweepRect = new Rectangle(n, n2, 0, 0);
            this.xorRect(this.m_sweepRect);
        }

        void updateRect(int n, int n2) {
            if (this.m_sweepRect == null) {
                return;
            }
            this.xorRect(this.m_sweepRect);
            this.m_sweepRect.width = n - this.m_sweepRect.x;
            this.m_sweepRect.height = n2 - this.m_sweepRect.y;
            this.xorRect(this.m_sweepRect);
        }

        void endRect(boolean bl, boolean bl2) {
            if (this.m_sweepRect == null) {
                return;
            }
            this.xorRect(this.m_sweepRect);
            CanvasPage canvasPage = SCanvasPaneController.this.getPage();
            if (canvasPage == null) {
                return;
            }
            Dimension dimension = canvasPage.getSize();
            Point point = SCanvasPaneController.this.getCanvasPointFromMouse(new Point(this.m_sweepRect.x, this.m_sweepRect.y));
            if (point == null) {
                return;
            }
            float f = (float)point.x / (float)dimension.width;
            float f2 = (float)point.y / (float)dimension.height;
            float f3 = (float)this.m_sweepRect.width / (float)dimension.width;
            float f4 = (float)this.m_sweepRect.height / (float)dimension.height;
            if (f3 < 0.0f) {
                f += f3;
                f3 = -f3;
            }
            if (f4 < 0.0f) {
                f2 += f4;
                f4 = -f4;
            }
            canvasPage.m_lastSweepRect = new SCanvasRectangle(f, f2, f3, f4);
            canvasPage.m_bSweepControlDown = bl;
            canvasPage.m_bSweepShiftDown = bl2;
            this.m_sweepRect = null;
        }

        void xorRect(Rectangle rectangle) {
            if (rectangle == null) {
                return;
            }
            Component component = SCanvasPaneController.this.m_view.getCanvasComponent();
            if (component == null) {
                return;
            }
            Graphics graphics = component.getGraphics();
            this.xorRect(graphics, rectangle);
        }

        void xorRect(Graphics graphics, Rectangle rectangle) {
            int n = rectangle.x;
            int n2 = rectangle.y;
            int n3 = n + rectangle.width;
            int n4 = n2 + rectangle.height;
            if (Math.abs(rectangle.width) < 4 && Math.abs(rectangle.height) < 4) {
                return;
            }
            graphics.setColor(Color.black);
            graphics.setXORMode(Color.white);
            graphics.drawLine(n, n2, n3, n2);
            if (n2 != n4) {
                graphics.drawLine(n, n4, n3, n4);
            }
            graphics.drawLine(n, n2, n, n4);
            if (n != n3) {
                graphics.drawLine(n3, n2, n3, n4);
            }
        }

        void paintHitRect(Graphics graphics) {
            if (this.m_hit == null) {
                return;
            }
            CanvasPage canvasPage = SCanvasPaneController.this.getPage();
            SCanvasAWT sCanvasAWT = canvasPage.getCanvas();
            Point point = canvasPage.getPosition();
            Point point2 = SCanvasPaneController.this.getBorderPoint();
            int n = -point.x + point2.x + 2;
            int n2 = -point.y + point2.y + 2;
            String string = this.m_hit.getAction();
            boolean bl = string != null && string.length() > 0;
            graphics.translate(n, n2);
            if (bl) {
                graphics.setColor(Color.black);
                graphics.setXORMode(Color.yellow);
                if (this.drawRegionSupportsXOR(this.m_hit)) {
                    this.fillRegion(this.m_hit, sCanvasAWT, graphics);
                } else {
                    this.xorHitViaImage(sCanvasAWT, graphics);
                }
                graphics.setColor(Color.black);
                graphics.setPaintMode();
                if (SCanvasPaneController.this.getHighlightOutline()) {
                    this.drawRegion(this.m_hit, sCanvasAWT, graphics);
                }
            } else {
                graphics.setColor(Color.black);
                graphics.setPaintMode();
                this.drawRegion(this.m_hit, sCanvasAWT, graphics);
            }
            graphics.translate(-n, -n2);
        }

        public void drawRegion(SCanvasHit sCanvasHit, SCanvasAWT sCanvasAWT, Graphics graphics) {
            if (sCanvasHit != null && sCanvasHit instanceof SCanvasHitRegion) {
                ((SCanvasHitRegion)sCanvasHit).drawRegion(sCanvasAWT, graphics);
            }
        }

        public void fillRegion(SCanvasHit sCanvasHit, SCanvasAWT sCanvasAWT, Graphics graphics) {
            if (sCanvasHit != null && sCanvasHit instanceof SCanvasHitRegion) {
                ((SCanvasHitRegion)sCanvasHit).fillRegion(sCanvasAWT, graphics);
            }
        }

        public boolean drawRegionSupportsXOR(SCanvasHit sCanvasHit) {
            if (sCanvasHit == null || !(sCanvasHit instanceof SCanvasHitRegion)) {
                return false;
            }
            return ((SCanvasHitRegion)sCanvasHit).drawRegionSupportsXOR();
        }

        void xorHitViaImage(SCanvasAWT sCanvasAWT, Graphics graphics) {
            if (this.m_hit == null) {
                return;
            }
            Component component = SCanvasPaneController.this.m_view.getCanvasComponent();
            if (component == null) {
                return;
            }
            Rectangle rectangle = this.m_hit.getRectangle(sCanvasAWT);
            int n = 100;
            int n2 = 100;
            Image image = component.createImage(n, n2);
            if (image == null) {
                return;
            }
            Graphics graphics2 = image.getGraphics();
            if (graphics2 == null) {
                return;
            }
            if (SCanvasPaneController.this.getPage() != null && SCanvasPaneController.this.getPage().m_doubleBufferViewRect != null) {
                rectangle = rectangle.intersection(SCanvasPaneController.this.getPage().m_doubleBufferViewRect);
            }
            for (int i = 0; i < rectangle.width; i += n) {
                for (int j = 0; j < rectangle.height; j += n2) {
                    graphics2.setColor(Color.yellow);
                    graphics2.fillRect(0, 0, n, n2);
                    graphics2.setColor(Color.black);
                    graphics2.translate(-rectangle.x - i, -rectangle.y - j);
                    this.fillRegion(this.m_hit, sCanvasAWT, graphics2);
                    graphics2.translate(rectangle.x + i, rectangle.y + j);
                    graphics.drawImage(image, rectangle.x + i, rectangle.y + j, component);
                }
            }
            graphics2.dispose();
        }

        void showHit(int n, int n2) {
            if (!m_showActiveRegions) {
                this.m_hit = null;
            } else {
                CanvasPage canvasPage = SCanvasPaneController.this.getPage();
                if (canvasPage == null) {
                    return;
                }
                SCanvasHit sCanvasHit = canvasPage.getCanvas().getHit(SCanvasPaneController.this.getCanvasPointFromMouse(new Point(n, n2)));
                if (this.m_hit != null && ((Object)this.m_hit).equals(sCanvasHit)) {
                    return;
                }
                this.m_hit = sCanvasHit;
            }
            this.showHitLabel();
            this.showHitRect();
        }

        void showHitRect() {
            Cloneable cloneable;
            CanvasPage canvasPage = SCanvasPaneController.this.getPage();
            if (canvasPage == null) {
                return;
            }
            Rectangle rectangle = null;
            if (this.m_hit != null) {
                cloneable = canvasPage.getPosition();
                Point point = SCanvasPaneController.this.getBorderPoint();
                rectangle = new Rectangle(this.m_hit.getRectangle(canvasPage.getCanvas()));
                rectangle.translate(-cloneable.x + point.x + 2, -cloneable.y + point.y + 2);
                if (rectangle.width < 10) {
                    rectangle.grow((10 - rectangle.width) / 2, 0);
                }
                if (rectangle.height < 10) {
                    rectangle.grow(0, (10 - rectangle.height) / 2);
                }
            }
            cloneable = this.m_hitRect;
            this.m_hitRect = rectangle;
            if (rectangle == cloneable || rectangle != null && rectangle.equals(cloneable)) {
                return;
            }
            if (cloneable != null) {
                this.repaintCanvasComponent((Rectangle)cloneable, 3);
            }
            if (rectangle != null) {
                this.repaintCanvasComponent(rectangle, 3);
            }
        }

        void showHitLabel() {
            if (this.m_hit != null) {
                this.setRightLabel(this.m_hit.getLabel());
            } else {
                this.setRightLabel(null);
            }
        }

        void doHit(int n, int n2, MouseEvent mouseEvent) {
            boolean bl;
            this.showHit(n, n2);
            boolean bl2 = mouseEvent.isControlDown();
            boolean bl3 = mouseEvent.isShiftDown();
            int n3 = mouseEvent.getModifiers();
            boolean bl4 = (n3 & 0x10) != 0;
            boolean bl5 = (n3 & 8) != 0;
            boolean bl6 = bl = (n3 & 4) != 0;
            if (!(bl4 || bl5 || bl)) {
                bl4 = true;
            }
            if (this.m_hit != null) {
                String string = this.m_hit.getAction();
                SCanvasPaneController.this.doHitAction(string, n, n2, bl4, bl5, bl, bl2, bl3);
            } else {
                boolean bl7 = false;
                if (!bl4 && !bl5 && bl) {
                    bl7 = SCanvasPaneController.this.doContextMenu(n, n2);
                }
                if (!bl7) {
                    SCanvasPaneController.this.doHitSelect(null, bl2, bl3);
                }
            }
        }

        void hideHit() {
            CanvasPage canvasPage = SCanvasPaneController.this.getPage();
            if (canvasPage == null) {
                return;
            }
            this.m_hit = null;
            this.showHitRect();
            this.showHitLabel();
        }

        void setLeftLabel(String string) {
            if (string == this.m_leftLabel) {
                return;
            }
            if (this.m_leftLabel != null) {
                this.repaintCanvasComponent(this.m_leftLabelRect);
                this.m_leftLabel = null;
            }
            if (string != null) {
                this.m_leftLabelRect = this.getLeftLabelRect(string);
                this.m_leftLabel = string;
                this.repaintCanvasComponent(this.m_leftLabelRect);
            }
        }

        void setRightLabel(String string) {
            if (string == this.m_rightLabel) {
                return;
            }
            if (this.m_rightLabel != null) {
                this.repaintCanvasComponent(this.m_rightLabelRect);
                this.m_rightLabel = null;
            }
            if (string != null) {
                this.m_rightLabelRect = this.getRightLabelRect(string);
                this.m_rightLabel = string;
                this.repaintCanvasComponent(this.m_rightLabelRect);
            }
        }

        void repaintCanvasComponent(Rectangle rectangle) {
            this.repaintCanvasComponent(rectangle, 0);
        }

        void repaintCanvasComponent(Rectangle rectangle, int n) {
            Component component = SCanvasPaneController.this.m_view.getCanvasComponent();
            if (component != null) {
                component.repaint(rectangle.x - n, rectangle.y - n, rectangle.width + 2 * n, rectangle.height + 2 * n);
            }
        }

        void repaintCanvasComponent() {
            Component component = SCanvasPaneController.this.m_view.getCanvasComponent();
            if (component != null) {
                component.repaint();
            }
        }

        Rectangle getLabelRect(String string) {
            Rectangle rectangle = new Rectangle(0, 0, 0, 0);
            Component component = SCanvasPaneController.this.m_view.getCanvasComponent();
            if (component == null) {
                return rectangle;
            }
            Graphics graphics = component.getGraphics();
            if (graphics == null) {
                return rectangle;
            }
            FontMetrics fontMetrics = graphics.getFontMetrics();
            int n = fontMetrics.getHeight();
            int n2 = 0;
            int n3 = 0;
            while (n3 < string.length()) {
                int n4 = string.indexOf("\n", n3);
                String string2 = n4 < 0 ? string.substring(n3) : string.substring(n3, n4);
                n3 += string2.length() + 1;
                rectangle.width = Math.max(rectangle.width, fontMetrics.stringWidth(string2));
                n2 += n;
            }
            rectangle.height = n2;
            return rectangle;
        }

        Rectangle getLeftLabelRect(String string) {
            Rectangle rectangle = this.getLabelRect(string);
            rectangle.x = 3;
            rectangle.y = 5;
            rectangle.width += 8;
            return rectangle;
        }

        Rectangle getRightLabelRect(String string) {
            Rectangle rectangle = this.getLabelRect(string);
            rectangle.y = 5;
            Component component = SCanvasPaneController.this.m_view.getCanvasComponent();
            if (component == null) {
                return rectangle;
            }
            int n = component.getSize().width;
            rectangle.x = n - 5 - rectangle.width - 6;
            rectangle.width += 8;
            return rectangle;
        }

        void paintLeftLabel(Graphics graphics) {
            if (this.m_leftLabel == null) {
                return;
            }
            CanvasPage canvasPage = SCanvasPaneController.this.getPage();
            Color color = canvasPage == null ? Color.white : canvasPage.getCanvas().getBackgroundColor();
            Color color2 = SCanvasPaneController.getAnnotationColor(canvasPage);
            FontMetrics fontMetrics = graphics.getFontMetrics();
            int n = fontMetrics.getHeight();
            int n2 = fontMetrics.getAscent();
            int n3 = 5;
            int n4 = 0;
            while (n4 < this.m_leftLabel.length()) {
                int n5 = this.m_leftLabel.indexOf("\n", n4);
                String string = n5 < 0 ? this.m_leftLabel.substring(n4) : this.m_leftLabel.substring(n4, n5);
                n4 += string.length() + 1;
                int n6 = fontMetrics.stringWidth(string);
                graphics.setPaintMode();
                graphics.setColor(color);
                graphics.fillRect(5, n3, n6 + 4, n);
                graphics.setColor(color2);
                graphics.drawString(string, 7, n3 + n2);
                n3 += n;
            }
        }

        void paintRightLabel(Graphics graphics) {
            if (this.m_rightLabel == null) {
                return;
            }
            CanvasPage canvasPage = SCanvasPaneController.this.getPage();
            Color color = canvasPage == null ? Color.white : canvasPage.getCanvas().getBackgroundColor();
            Color color2 = SCanvasPaneController.getAnnotationColor(canvasPage);
            Component component = SCanvasPaneController.this.m_view.getCanvasComponent();
            if (component == null) {
                return;
            }
            int n = component.getSize().width;
            FontMetrics fontMetrics = graphics.getFontMetrics();
            int n2 = fontMetrics.getHeight();
            int n3 = fontMetrics.getAscent();
            int n4 = 5;
            int n5 = 0;
            while (n5 < this.m_rightLabel.length()) {
                int n6 = this.m_rightLabel.indexOf("\n", n5);
                String string = n6 < 0 ? this.m_rightLabel.substring(n5) : this.m_rightLabel.substring(n5, n6);
                n5 += string.length() + 1;
                int n7 = fontMetrics.stringWidth(string);
                int n8 = n - 5 - n7 - 4;
                graphics.setColor(color);
                graphics.fillRect(n8, n4, n7 + 4, n2);
                graphics.setColor(color2);
                graphics.drawString(string, n8 + 2, n4 + n3);
                n4 += n2;
            }
        }
    }

    class CanvasPage {
        static final int EXTRA_BORDER_PIXELS = 2;
        SCanvasAWT m_canvas = null;
        Dimension m_size = new Dimension(100, 100);
        Point m_position = new Point(0, 0);
        boolean m_autoZoom = true;
        protected SCanvasRectangle m_lastSweepRect = null;
        protected boolean m_bSweepControlDown = false;
        protected boolean m_bSweepShiftDown = false;
        Dimension m_doubleBufferSize = null;
        Rectangle m_doubleBufferViewRect = null;
        protected Image m_imgGraph = null;
        protected Image m_imgSelections = null;
        int m_tabWidth = 10;
        protected boolean m_redraw = true;
        int m_canvasCmdsDrawn = 0;
        ColorScheme m_canvasColorScheme = null;
        int m_canvasClearCount = -1;
        private String m_lastTag = null;
        private ColorScheme m_lastTagPDFColorScheme = null;
        protected boolean m_possibleFireHose = false;
        protected boolean m_tagProcessed = false;
        protected String m_tagName = null;
        protected String m_tagEmbeddedFileName = null;
        protected int m_tagEmbeddedFilePage = 1;
        protected XMLElement m_onSelectChangedAction = null;
        protected XMLElement m_onPageChangedAction = null;

        CanvasPage(SCanvasAWT sCanvasAWT) {
            this.m_canvas = sCanvasAWT;
        }

        SCanvasAWT getCanvas() {
            return this.m_canvas;
        }

        Dimension getSize() {
            if (this.m_autoZoom) {
                this.m_size = this.m_canvas.getBestFitSize(SCanvasPaneController.this.getCanvasComponentSize());
            }
            return this.m_size;
        }

        Point getPosition() {
            if (this.m_autoZoom) {
                this.m_position = new Point(0, 0);
            }
            return this.m_position;
        }

        boolean getAutoZoom() {
            return this.m_autoZoom;
        }

        void setAutoZoom(boolean bl) {
            this.m_autoZoom = bl;
        }

        double getZoom() {
            if (this.getAutoZoom()) {
                return 1.0;
            }
            Dimension dimension = this.getSize();
            Dimension dimension2 = this.m_canvas.getBestFitSize(SCanvasPaneController.this.getCanvasComponentSize());
            double d = (double)dimension.width / (double)dimension2.width;
            double d2 = (double)dimension.height / (double)dimension2.height;
            return d < d2 ? d : d2;
        }

        void setZoom(double d) {
            double d2 = d / this.getZoom();
            this.zoom(d2);
        }

        void zoom(double d) {
            Dimension dimension = this.getSize();
            Point point = this.getPosition();
            int n = (int)((double)point.x * d);
            int n2 = (int)((double)point.y * d);
            int n3 = (int)((double)dimension.width * d);
            int n4 = (int)((double)dimension.height * d);
            Component component = SCanvasPaneController.this.m_view.getCanvasComponent();
            if (component != null) {
                Dimension dimension2 = component.getSize();
                if (dimension.width < dimension2.width) {
                    n = (int)((double)(dimension.width - dimension2.width) * 0.5 * d);
                }
                if (dimension.height < dimension2.height) {
                    n2 = (int)((double)(dimension.height - dimension2.height) * 0.5 * d);
                }
                n += (int)((double)dimension2.width * 0.5 * (d - 1.0));
                n2 += (int)((double)dimension2.height * 0.5 * (d - 1.0));
            }
            this.setAutoZoom(false);
            this.setCanvasZoom(n, n2, n3, n4);
        }

        void setCanvasZoom(int n, int n2, int n3, int n4) {
            this.m_position = new Point(n, n2);
            this.m_size = new Dimension(n3, n4);
            SCanvasPaneController.this.updateDisplay();
        }

        void zoomToRect() {
            this.setZoomToRect(this.m_lastSweepRect);
        }

        void setZoomToRect(SCanvasRectangle sCanvasRectangle) {
            if (sCanvasRectangle == null || (double)sCanvasRectangle.getWidth() == 0.0 || (double)sCanvasRectangle.getHeight() == 0.0) {
                return;
            }
            Dimension dimension = this.getSize();
            int n = (int)((float)dimension.width * sCanvasRectangle.getX());
            int n2 = (int)((float)dimension.height * sCanvasRectangle.getY());
            int n3 = (int)((float)dimension.width * sCanvasRectangle.getWidth());
            int n4 = (int)((float)dimension.height * sCanvasRectangle.getHeight());
            if (n3 < 5 || n4 < 5) {
                return;
            }
            Dimension dimension2 = SCanvasPaneController.this.getCanvasComponentSize();
            int n5 = dimension2.width;
            int n6 = dimension2.height;
            double d = (double)n5 / (double)n3;
            double d2 = (double)n6 / (double)n4;
            d2 = d = Math.min(d, d2);
            int n7 = (int)((double)dimension.width * d);
            int n8 = (int)((double)dimension.height * d2);
            int n9 = (int)((double)n * d);
            int n10 = (int)((double)n2 * d2);
            this.setAutoZoom(false);
            this.setCanvasZoom(n9, n10, n7, n8);
        }

        protected String[] getTagsInRect(SCanvasRectangle sCanvasRectangle) {
            if (sCanvasRectangle == null || this.m_canvas == null) {
                return new String[0];
            }
            Rectangle rectangle = sCanvasRectangle.getWindowRect(this.m_canvas);
            String[] stringArray = this.m_canvas.getIntersectingTags(rectangle);
            return stringArray;
        }

        protected void selectRect() {
            if (this.m_lastSweepRect == null || (double)this.m_lastSweepRect.getWidth() == 0.0 || (double)this.m_lastSweepRect.getHeight() == 0.0) {
                return;
            }
            if (this.m_canvas == null) {
                return;
            }
            String[] stringArray = this.getTagsInRect(this.m_lastSweepRect);
            if (this.m_bSweepControlDown) {
                SCanvasPaneController.this.toggleSelectedTagArray(stringArray);
            } else if (this.m_bSweepShiftDown) {
                SCanvasPaneController.this.addSelectedTagArray(stringArray);
            } else {
                SCanvasPaneController.this.clearSetSelectedTagArray(stringArray);
            }
        }

        public void initDisplay() {
            this.m_redraw = true;
        }

        public void releaseMemory() {
            this.m_imgGraph = null;
            this.m_imgSelections = null;
            if (this.m_canvas != null) {
                this.m_canvas.releaseMemory();
            }
        }

        public ColorScheme getTagPDFColorScheme() {
            String string = this.m_canvas.getTag();
            if (string == null && this.m_lastTag != null || string != null && !string.equals(this.m_lastTag)) {
                this.m_lastTagPDFColorScheme = SCanvasPaneController.this.parsePDFColorScheme(string);
                this.m_lastTag = string;
            }
            return this.m_lastTagPDFColorScheme;
        }

        protected boolean graphNeedsUpdating(Component component, int n) {
            int n2;
            ColorScheme colorScheme;
            ColorScheme colorScheme2 = this.m_canvas.getAltColorScheme();
            ColorScheme colorScheme3 = this.getTagPDFColorScheme();
            if (colorScheme3 == null) {
                colorScheme3 = SCanvasPaneController.this.getPage(0).getTagPDFColorScheme();
            }
            if (this.getEmbeddedFileName() != null) {
                colorScheme3 = null;
            }
            if (colorScheme2 != colorScheme3) {
                this.m_imgGraph = null;
                this.m_canvas.setAltColorScheme(colorScheme3);
            }
            if (this.m_canvasColorScheme != (colorScheme = this.m_canvas.getColorScheme())) {
                this.m_imgGraph = null;
                this.m_canvasColorScheme = colorScheme;
            }
            if (this.m_canvasClearCount != (n2 = this.m_canvas.getClearCount())) {
                this.m_imgGraph = null;
                this.m_canvasClearCount = n2;
            }
            if (n < this.m_canvasCmdsDrawn) {
                this.m_imgGraph = null;
            }
            if (n > this.m_canvasCmdsDrawn) {
                this.m_redraw = true;
            }
            Point point = this.getPosition();
            Dimension dimension = component.getSize();
            if (!(this.m_doubleBufferViewRect == null || this.m_doubleBufferViewRect.contains(point) && this.m_doubleBufferViewRect.contains(point.x + dimension.width, point.y + dimension.height))) {
                this.m_doubleBufferSize = null;
            }
            Dimension dimension2 = this.getSize();
            if (this.m_doubleBufferSize == null || this.m_doubleBufferSize.width != dimension2.width || this.m_doubleBufferSize.height != dimension2.height) {
                this.m_imgGraph = null;
                this.m_doubleBufferSize = dimension2;
                long l = (long)this.m_doubleBufferSize.width * (long)this.m_doubleBufferSize.height;
                long l2 = (long)dimension.width * (long)dimension.height;
                if (l > 9L * l2) {
                    this.m_doubleBufferViewRect = new Rectangle(point, dimension);
                    this.m_doubleBufferViewRect.grow(dimension.width, dimension.height);
                    this.m_doubleBufferViewRect = this.m_doubleBufferViewRect.intersection(new Rectangle(new Point(0, 0), this.m_doubleBufferSize));
                } else {
                    this.m_doubleBufferViewRect = null;
                }
            }
            if (this.m_imgGraph == null) {
                this.m_redraw = true;
                this.m_canvasCmdsDrawn = 0;
            }
            return this.m_redraw;
        }

        protected void updateGraph(Component component, int n) throws OutOfMemoryError {
            Graphics graphics;
            this.m_redraw = false;
            if (this.m_imgGraph == null) {
                this.m_imgGraph = this.m_doubleBufferViewRect != null ? component.createImage(this.m_doubleBufferViewRect.width, this.m_doubleBufferViewRect.height) : component.createImage(this.m_doubleBufferSize.width, this.m_doubleBufferSize.height);
                if (this.m_imgGraph == null) {
                    throw new OutOfMemoryError();
                }
            }
            if ((graphics = this.m_imgGraph.getGraphics()) == null) {
                throw new OutOfMemoryError();
            }
            if (this.m_doubleBufferViewRect != null) {
                graphics.translate(-this.m_doubleBufferViewRect.x, -this.m_doubleBufferViewRect.y);
            }
            this.paintCanvasPage(graphics, false, this.m_canvasCmdsDrawn);
            this.m_canvasCmdsDrawn = n;
            graphics.dispose();
        }

        public Image getGraphImage(Component component) throws OutOfMemoryError {
            int n;
            boolean bl;
            if (this.m_possibleFireHose) {
                this.throttleFireHose();
                this.m_possibleFireHose = false;
            }
            if (bl = this.graphNeedsUpdating(component, n = this.m_canvas.getNumberCommands())) {
                this.updateGraph(component, n);
            }
            if (SCanvasPaneController.this.m_tagset.isEmpty()) {
                return this.m_imgGraph;
            }
            if (bl || this.m_imgSelections == null) {
                this.updateSelections(component);
            }
            return this.m_imgSelections;
        }

        public void updateSelections(Component component) throws OutOfMemoryError {
            int n = 0;
            int n2 = 0;
            int n3 = this.m_doubleBufferSize.width;
            int n4 = this.m_doubleBufferSize.height;
            if (this.m_doubleBufferViewRect != null) {
                n = this.m_doubleBufferViewRect.x;
                n2 = this.m_doubleBufferViewRect.y;
                n3 = this.m_doubleBufferViewRect.width;
                n4 = this.m_doubleBufferViewRect.height;
            }
            this.m_imgSelections = component.createImage(n3, n4);
            if (this.m_imgSelections == null) {
                throw new OutOfMemoryError();
            }
            Graphics graphics = this.m_imgSelections.getGraphics();
            if (graphics == null) {
                throw new OutOfMemoryError();
            }
            graphics.clipRect(0, 0, n3, n4);
            if (SCanvasPaneController.this.m_bXorSelectedRegions) {
                graphics.setColor(Color.white);
                graphics.fillRect(0, 0, n3, n4);
                graphics.translate(-n, -n2);
                this.paintSelections(graphics);
                graphics.translate(n, n2);
                graphics.setXORMode(Color.white);
                graphics.drawImage(this.m_imgGraph, 0, 0, component);
            } else {
                graphics.setPaintMode();
                graphics.drawImage(this.m_imgGraph, 0, 0, component);
                graphics.translate(-n, -n2);
                this.paintSelections(graphics);
            }
            graphics.dispose();
        }

        public void paintCanvasPage(Graphics graphics, boolean bl, int n) {
            this.paintCanvasPage(graphics, bl, n, this.getSize());
        }

        public void paintCanvasPage(Graphics graphics, boolean bl, int n, Dimension dimension) {
            this.m_canvas.setAltBackgroundColor(SCanvasPaneController.this.getBackgroundColor());
            if (bl || n <= 0) {
                graphics.setColor(this.m_canvas.getBackgroundColor());
                graphics.fillRect(0, 0, dimension.width, 2);
                graphics.fillRect(0, dimension.height - 2, dimension.width, 2);
                graphics.fillRect(0, 0, 2, dimension.height);
                graphics.fillRect(dimension.width - 2, 0, 2, dimension.height);
            }
            graphics.clipRect(0, 0, dimension.width, dimension.height);
            this.m_canvas.setSize(dimension.width - 4, dimension.height - 4);
            graphics.translate(2, 2);
            if (bl) {
                this.m_canvas.print(graphics);
            } else {
                this.m_canvas.paint(graphics, n);
            }
            graphics.translate(-2, -2);
        }

        protected void paintSelections(Graphics graphics) {
            this.m_canvas.setSize(this.m_doubleBufferSize.width - 4, this.m_doubleBufferSize.height - 4);
            graphics.translate(2, 2);
            graphics.setColor(SCanvasPaneController.this.m_clrSelectionHighlight);
            this.m_canvas.paintSelections(graphics, SCanvasPaneController.this.m_tagset);
            graphics.translate(-2, -2);
        }

        protected void invalidateSelectionImages() {
            this.m_imgSelections = null;
        }

        void throttleFireHose() {
            int n;
            int n2;
            CanvasPage canvasPage = SCanvasPaneController.this.getPage();
            if (canvasPage == null) {
                return;
            }
            SCanvasAWT sCanvasAWT = canvasPage.getCanvas();
            int n3 = n2 = sCanvasAWT.getNumberCommands();
            for (n = 0; n < 10; ++n) {
                try {
                    Thread.sleep(200L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                int n4 = sCanvasAWT.getNumberCommands();
                if (n2 == n4) break;
                n2 = n4;
            }
            if (m_debugFirehose) {
                System.out.println("firehose end: i=" + n + ", cmds=" + n3 + "->" + n2);
            }
        }

        public void checkFireHose() {
            int n;
            if (m_debugFirehoseCheckSleep > 0) {
                try {
                    Thread.sleep(m_debugFirehoseCheckSleep);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.m_possibleFireHose = this.m_canvasCmdsDrawn != (n = this.m_canvas.getNumberCommands());
        }

        public String getTag() {
            String string = this.m_canvas == null ? "" : this.m_canvas.getTag();
            return string == null ? "" : string;
        }

        public void setTag(String string) {
            if (this.m_canvas != null) {
                this.m_canvas.setTag(string);
            }
            this.m_tagProcessed = false;
        }

        public String getTagName() {
            this.processTag();
            return this.m_tagName;
        }

        public String getEmbeddedFileName() {
            this.processTag();
            return this.m_tagEmbeddedFileName;
        }

        public int getEmbeddedFilePage() {
            this.processTag();
            return this.m_tagEmbeddedFilePage;
        }

        public XMLElement getOnSelectChangedAction() {
            this.processTag();
            return this.m_onSelectChangedAction;
        }

        public XMLElement getOnPageChangedAction() {
            this.processTag();
            return this.m_onPageChangedAction;
        }

        public void processTag() {
            String string;
            if (this.m_tagProcessed) {
                return;
            }
            this.m_tagName = string = this.getTag();
            this.m_tagEmbeddedFileName = null;
            this.m_tagEmbeddedFilePage = 1;
            this.m_onSelectChangedAction = null;
            this.m_onPageChangedAction = null;
            XMLElement xMLElement = null;
            if (string.indexOf("<") >= 0) {
                xMLElement = new XMLElement();
                try {
                    xMLElement.parseString(string);
                }
                catch (Exception exception) {
                    if (SCanvasPaneController.this.getDebug() || this.m_canvas != null && this.m_canvas.getInApplet()) {
                        System.out.println("exception " + exception + " while parsing tag XML: " + string);
                    }
                    xMLElement = null;
                }
                if (xMLElement != null && xMLElement.getTagName() != null && xMLElement.getTagName().equalsIgnoreCase("TAG")) {
                    Vector vector;
                    String string2;
                    String string3 = xMLElement.getProperty("NAME");
                    this.m_tagName = string3 == null ? "" : string3;
                    String string4 = xMLElement.getProperty("EMBEDFILE");
                    if (string4 != null) {
                        this.m_tagEmbeddedFileName = string4;
                    }
                    if ((string2 = xMLElement.getProperty("EMBEDPAGE")) != null) {
                        try {
                            this.m_tagEmbeddedFilePage = Integer.parseInt(string2);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if ((vector = xMLElement.getChildren()) != null) {
                        for (int i = 0; i < vector.size(); ++i) {
                            XMLElement xMLElement2 = (XMLElement)vector.elementAt(i);
                            if (xMLElement2 == null) continue;
                            Vector vector2 = xMLElement2.getChildren();
                            XMLElement xMLElement3 = vector2 == null || vector2.size() < 1 ? null : (XMLElement)vector2.elementAt(0);
                            String string5 = xMLElement2.getTagName();
                            if (string5 == null) continue;
                            if (string5.equalsIgnoreCase("ONSELECTCHANGED")) {
                                this.m_onSelectChangedAction = xMLElement3;
                                continue;
                            }
                            if (!string5.equalsIgnoreCase("ONPAGECHANGED")) continue;
                            this.m_onPageChangedAction = xMLElement3;
                        }
                    }
                }
            }
            this.m_tagProcessed = true;
        }
    }

    class TabComponentListener
    implements MouseListener,
    ComponentListener {
        boolean m_formatted = false;
        int m_tabHeight = 10;
        int m_fontAscent = 10;
        int m_tabOrigin = 0;
        int m_totalWidth = 10;
        int m_windowWidth = 100;

        public void componentResized(ComponentEvent componentEvent) {
            this.updateTabs();
        }

        public void componentMoved(ComponentEvent componentEvent) {
        }

        public void componentShown(ComponentEvent componentEvent) {
        }

        public void componentHidden(ComponentEvent componentEvent) {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            if (!SCanvasPaneController.leftButtonEvent(mouseEvent) || !this.m_formatted) {
                return;
            }
            if (n2 < 0 || n2 > this.m_tabHeight) {
                return;
            }
            if (n >= 0 && n <= this.m_tabHeight) {
                this.doLeftScroll();
            } else if (n >= this.m_tabHeight && n <= 2 * this.m_tabHeight) {
                this.doRightScroll();
            } else {
                int n3 = this.getTabNumber(n, n2);
                if (n3 < 0) {
                    return;
                }
                SCanvasPaneController.this.setSelectedTab(n3);
            }
        }

        void doLeftScroll() {
            this.m_tabOrigin += (int)((double)(this.m_windowWidth - 2 * this.m_tabHeight) * 0.8);
            this.updateTabs();
        }

        void doRightScroll() {
            this.m_tabOrigin -= (int)((double)(this.m_windowWidth - 2 * this.m_tabHeight) * 0.8);
            this.updateTabs();
        }

        void showSelectedTab() {
            int n = SCanvasPaneController.this.getSelectedTab();
            int n2 = this.getTabOffset(n);
            int n3 = this.getTabWidth(n);
            if (n3 >= this.m_windowWidth - 2 * this.m_tabHeight) {
                this.m_tabOrigin -= n2 - 2 * this.m_tabHeight;
            } else if (n2 + n3 > this.m_windowWidth - 10) {
                this.m_tabOrigin -= n2 + n3 - (this.m_windowWidth - 10);
            } else if (n2 < 2 * this.m_tabHeight + 10) {
                this.m_tabOrigin -= n2 - (2 * this.m_tabHeight + 10);
            }
            this.updateTabs();
        }

        void updateTabs() {
            this.m_formatted = false;
            Component component = SCanvasPaneController.this.m_view.getTabComponent();
            if (component != null) {
                component.repaint();
            }
        }

        void updateTabs(long l) {
            this.m_formatted = false;
            Component component = SCanvasPaneController.this.m_view.getTabComponent();
            if (component != null) {
                component.repaint(l);
            }
        }

        public void printApplet(Graphics graphics) {
            this.paint(graphics, true);
        }

        public void print(Graphics graphics) {
            this.paint(graphics, false);
        }

        public void paint(Graphics graphics) {
            this.paint(graphics, false);
        }

        public void paint(Graphics graphics, boolean bl) {
            Component component = SCanvasPaneController.this.m_view.getTabComponent();
            if (component == null) {
                return;
            }
            Dimension dimension = component.getSize();
            this.formatTabs(graphics, dimension);
            this.paintTabScrollButtons(graphics);
            this.paintTabs(graphics, bl);
        }

        int getTabNumber(int n, int n2) {
            int n3 = this.m_tabOrigin;
            int n4 = SCanvasPaneController.this.getTabCount();
            for (int i = 0; i < n4; ++i) {
                CanvasPage canvasPage = SCanvasPaneController.this.getPage(i);
                if (canvasPage == null) continue;
                if (n < n3) break;
                if (n < n3 + canvasPage.m_tabWidth) {
                    return i;
                }
                n3 += canvasPage.m_tabWidth;
            }
            return -1;
        }

        int getTabEnd() {
            int n = SCanvasPaneController.this.getTabCount();
            return this.getTabOffset(n - 1) + this.getTabWidth(n - 1);
        }

        int getTabOffset(int n) {
            int n2 = this.m_tabOrigin;
            int n3 = SCanvasPaneController.this.getTabCount();
            for (int i = 0; i < n3; ++i) {
                if (i >= n) {
                    return n2;
                }
                CanvasPage canvasPage = SCanvasPaneController.this.getPage(i);
                if (canvasPage == null) continue;
                n2 += canvasPage.m_tabWidth;
            }
            return 0;
        }

        int getTabWidth(int n) {
            CanvasPage canvasPage = SCanvasPaneController.this.getPage(n);
            if (canvasPage == null) {
                return 10;
            }
            return canvasPage.m_tabWidth;
        }

        String getFormattedTabTitle(int n) {
            String string = SCanvasPaneController.this.getTabTitle(n);
            if (string == null || string.equals("#")) {
                return "Page " + (n + 1);
            }
            return string;
        }

        void formatTabs(Graphics graphics, Dimension dimension) {
            if (this.m_formatted) {
                return;
            }
            FontMetrics fontMetrics = graphics.getFontMetrics();
            this.m_tabHeight = Math.min(fontMetrics.getHeight(), dimension.height);
            this.m_windowWidth = dimension.width;
            this.m_fontAscent = fontMetrics.getAscent();
            int n = 0;
            int n2 = SCanvasPaneController.this.getTabCount();
            for (int i = 0; i < n2; ++i) {
                CanvasPage canvasPage = SCanvasPaneController.this.getPage(i);
                if (canvasPage == null) continue;
                canvasPage.m_tabWidth = fontMetrics.stringWidth(this.getFormattedTabTitle(i)) + 10;
                n += canvasPage.m_tabWidth;
            }
            if (this.m_tabOrigin > 2 * this.m_tabHeight || n <= dimension.width - 2 * this.m_tabHeight) {
                this.m_tabOrigin = 2 * this.m_tabHeight;
            } else if (this.m_tabOrigin + n < dimension.width) {
                this.m_tabOrigin = dimension.width - n;
            }
            this.m_formatted = true;
        }

        void paintTabScrollButtons(Graphics graphics) {
            int n = this.m_tabHeight;
            int n2 = (int)((double)n * 0.2);
            int n3 = (int)((double)n * 0.8);
            int n4 = (int)((double)n * 0.5);
            graphics.setColor(Color.lightGray);
            graphics.fillRect(0, 0, this.m_tabHeight * 2, 1000);
            this.paintTabButtonOutline(graphics, n, 0);
            this.paintTabButtonOutline(graphics, n, n);
            graphics.setColor(this.m_tabOrigin < this.m_tabHeight * 2 ? Color.black : Color.gray);
            graphics.fillPolygon(new int[]{n3, n2, n3}, new int[]{n2, n4, n3}, 3);
            graphics.setColor(this.getTabEnd() > this.m_windowWidth ? Color.black : Color.gray);
            graphics.fillPolygon(new int[]{n + n2 + 1, n + n3 + 1, n + n2 + 1}, new int[]{n2, n4, n3}, 3);
        }

        void paintTabButtonOutline(Graphics graphics, int n, int n2) {
            graphics.setColor(Color.black);
            graphics.drawRect(n2, 0, n, n);
            graphics.setColor(Color.white);
            graphics.drawLine(n2 + 1, 1, n2 + 1, n - 2);
            graphics.drawLine(n2 + 1, 1, n2 + n - 1, 1);
            graphics.setColor(Color.darkGray);
            graphics.drawLine(n2 + n - 1, 2, n2 + n - 1, n - 1);
            graphics.drawLine(n2 + 1, n - 1, n2 + n - 1, n - 1);
            graphics.setColor(Color.black);
        }

        void paintTabs(Graphics graphics, boolean bl) {
            Rectangle rectangle = graphics.getClipBounds();
            if (rectangle == null) {
                rectangle = new Rectangle(0, 0, this.m_windowWidth, this.m_tabHeight + 5);
            }
            graphics.clipRect(this.m_tabHeight * 2, 0, this.m_windowWidth, 1000);
            graphics.setColor(Color.black);
            graphics.drawLine(0, 0, this.m_windowWidth, 0);
            int n = this.m_tabOrigin;
            int n2 = SCanvasPaneController.this.getTabCount();
            for (int i = 0; i < n2; ++i) {
                boolean bl2;
                int n3 = n;
                CanvasPage canvasPage = SCanvasPaneController.this.getPage(i);
                if (canvasPage == null) continue;
                int n4 = canvasPage.m_tabWidth;
                n += n4;
                String string = this.getFormattedTabTitle(i);
                boolean bl3 = bl2 = i == SCanvasPaneController.this.getSelectedTab();
                if (n3 + n4 < this.m_tabHeight * 2 || n3 > this.m_windowWidth) continue;
                graphics.setColor(Color.lightGray);
                graphics.fillRect(n3, 1, n4, 1000);
                if (bl2) {
                    graphics.setColor(Color.white);
                    graphics.fillPolygon(new int[]{n3 + 1, n3 + n4 - 1, n3 + n4 - 1, n3 + n4 - 3, n3 + 4, n3 + 1, n3 + 1}, new int[]{1, 1, this.m_tabHeight - 3, this.m_tabHeight, this.m_tabHeight, this.m_tabHeight - 3, 1}, 7);
                }
                graphics.setColor(Color.black);
                graphics.drawLine(n3 + n4 - 1, 0, n3 + n4 - 1, this.m_tabHeight - 2);
                graphics.drawLine(n3, 0, n3, this.m_tabHeight - 3);
                graphics.drawLine(n3, this.m_tabHeight - 3, n3 + 3, this.m_tabHeight);
                graphics.drawLine(n3 + n4 - 3, this.m_tabHeight, n3 + n4, this.m_tabHeight - 3);
                graphics.drawLine(n3 + 3, this.m_tabHeight, n3 + n4 - 3, this.m_tabHeight);
                graphics.drawLine(n3 + n4, 0, n3 + n4, this.m_tabHeight - 3);
                graphics.setColor(Color.white);
                graphics.drawLine(n3 + 1, 1, n3 + 1, this.m_tabHeight - 3);
                graphics.drawLine(n3 + 1, 1, n3 + n4 - 1, 1);
                graphics.setColor(Color.black);
                if (bl) {
                    SGraphTextAWT.paintTextPixels(graphics, string, n3 + 5, this.m_fontAscent, 0.0f, 0.0f, false);
                    continue;
                }
                graphics.drawString(string, n3 + 5, this.m_fontAscent);
            }
            graphics.setColor(Color.lightGray);
            graphics.fillRect(n, 1, 1000, 1000);
            graphics.setClip(rectangle);
        }
    }

    public static interface ContextMenuAccess {
        public boolean doContextMenu(int var1, int var2);
    }
}

