/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.gdevice;

import com.insightful.gdevice.SApplet;
import com.insightful.gdevice.SCanvasAWT;
import com.insightful.gdevice.SCanvasPaneController;
import com.insightful.gdevice.SCanvasPaneView2;
import com.insightful.gdevice.SCanvasRectangle;
import com.insightful.gdevice.SGraphCommand;
import com.insightful.gdevice.STreeNode;
import com.insightful.gdevice.XML;
import com.insightful.gdevice.XMLElement;
import java.applet.Applet;
import java.awt.Adjustable;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Canvas;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.FlowLayout;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Label;
import java.awt.MediaTracker;
import java.awt.Menu;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.PopupMenu;
import java.awt.PrintJob;
import java.awt.Scrollbar;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.Vector;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.standard.MediaSizeName;
import javax.print.attribute.standard.PageRanges;

public class SGui
extends Panel
implements ActionListener,
SCanvasPaneView2,
SCanvasPaneController.EmbeddedFileAccess,
SCanvasPaneController.ContextMenuAccess {
    static final String BUTTON_OPEN = "Open";
    static final String BUTTON_PRINT = "Print...";
    static final String BUTTON_ZOOMIN = "In";
    static final String BUTTON_ZOOMOUT = "Out";
    static final String BUTTON_ZOOMRECT = "Rect";
    static final String BUTTON_FILL = "Fill";
    static final String BUTTON_SELECT = "Select";
    static final String BUTTON_OPTIONS = "Options...";
    static final String BUTTON_HELP = "Help...";
    static final String BUTTON_INFO = "S-PLUS";
    static final String BUTTON_OK = "OK";
    static final String BUTTON_CANCEL = "Cancel";
    Applet m_applet = null;
    PopupMenu m_canvasPopupMenu = null;
    ActionListener m_canvasPopupMenuActionListener = null;
    Scrollbar m_hscroll = new Scrollbar(0);
    Scrollbar m_vscroll = new Scrollbar(1);
    Panel m_pagePanel = new Panel(new BorderLayout());
    Canvas m_pageCanvas = new Canvas(){

        public void print(Graphics graphics) {
            try {
                SGui.this.m_controller.printCanvas(graphics);
            }
            catch (Exception exception) {
                exception.printStackTrace(System.out);
            }
        }

        public void paint(Graphics graphics) {
            SGui.this.m_controller.paintCanvas(graphics);
        }

        public void update(Graphics graphics) {
            this.paint(graphics);
        }
    };
    Canvas m_tabCanvas = new Canvas(){
        int m_desiredHeight = 15;
        boolean m_gotDesiredHeight = false;

        public Dimension getPreferredSize() {
            if (!this.m_gotDesiredHeight) {
                Graphics graphics = this.getGraphics();
                if (graphics != null) {
                    FontMetrics fontMetrics = graphics.getFontMetrics();
                    this.m_desiredHeight = fontMetrics.getHeight() + 3;
                }
                this.m_gotDesiredHeight = true;
            }
            return new Dimension(100, this.m_desiredHeight);
        }

        public void paint(Graphics graphics) {
            SGui.this.m_controller.paintTabs(graphics);
        }

        public void update(Graphics graphics) {
            this.paint(graphics);
        }

        public void print(Graphics graphics) {
            try {
                SGui.this.m_controller.printTabsApplet(graphics);
            }
            catch (Exception exception) {
                exception.printStackTrace(System.out);
            }
        }
    };
    SCanvasPaneController m_controller = null;
    FlowLayout m_buttonLayout = new FlowLayout(){

        public Dimension preferredLayoutSize(Container container) {
            int n;
            int n2 = container.getParent().getSize().width;
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            Component[] componentArray = container.getComponents();
            if (componentArray == null || componentArray.length < 1) {
                return new Dimension(0, 0);
            }
            Component component = componentArray[componentArray.length - 1];
            Dimension dimension = component.getPreferredSize();
            int n7 = Math.max(10, n2 - dimension.width - 10);
            for (n = 0; n < componentArray.length - 1; ++n) {
                Component component2 = componentArray[n];
                Dimension dimension2 = component2.getPreferredSize();
                if (n3 > 0 && n3 + dimension2.width > n7) {
                    n3 = 0;
                    n4 = n6;
                }
                n5 = Math.max(n5, n3 + dimension2.width);
                n6 = Math.max(n6, n4 + dimension2.height);
                n3 += dimension2.width;
            }
            n = Math.min(n2, n5 + dimension.width);
            int n8 = Math.max(n6, dimension.height);
            return new Dimension(n, n8);
        }

        public Dimension minimumLayoutSize(Container container) {
            return this.preferredLayoutSize(container);
        }

        public void layoutContainer(Container container) {
            int n = container.getSize().width;
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            Component[] componentArray = container.getComponents();
            if (componentArray == null || componentArray.length < 1) {
                return;
            }
            Component component = componentArray[componentArray.length - 1];
            Dimension dimension = component.getPreferredSize();
            int n5 = Math.max(10, n - dimension.width - 10);
            for (int i = 0; i < componentArray.length - 1; ++i) {
                Component component2 = componentArray[i];
                Dimension dimension2 = component2.getPreferredSize();
                if (n2 > 0 && n2 + dimension2.width > n5) {
                    n2 = 0;
                    n3 = n4;
                }
                component2.setBounds(n2, n3, dimension2.width, dimension2.height);
                n4 = Math.max(n4, n3 + dimension2.height);
                n2 += dimension2.width;
            }
            component.setBounds(Math.max(0, n - dimension.width), 0, dimension.width, dimension.height);
        }
    };
    String m_brandImageFilename = "splusbutton.gif";
    boolean m_brandImageMapBackground = true;
    Image m_brandImage = null;
    int m_brandImageWidth = 0;
    int m_brandImageHeight = 0;
    private static final String m_brandURL = "http://www.insightful.com/graphlets";
    private static final String m_brandName = "S-PLUS";
    private Object m_jsObjectWindow = null;
    private Method m_javascriptEvalMt = null;
    public boolean m_printMultiplePages = false;
    public boolean m_printUnzoomedPages = false;
    public boolean m_printSelectedRegions = true;
    String m_lastFileDirectory = null;
    private static final String[] g_strStaticColor = new String[]{"black", "blue", "cyan", "darkGray", "gray", "green", "lightGray", "magenta", "orange", "pink", "red", "white", "yellow"};
    private static final Color[] g_clrStatic = new Color[]{Color.black, Color.blue, Color.cyan, Color.darkGray, Color.gray, Color.green, Color.lightGray, Color.magenta, Color.orange, Color.pink, Color.red, Color.white, Color.yellow};
    PopupMenu m_canvasContextMenu = null;

    public SCanvasPaneController getController() {
        return this.m_controller;
    }

    public SGui() {
        this((Applet)null);
    }

    public SGui(Applet applet) {
        super(new BorderLayout());
        this.setBackground(Color.lightGray);
        this.m_applet = applet;
        this.m_pagePanel.add("Center", this.m_pageCanvas);
        this.m_pagePanel.add("East", this.m_vscroll);
        this.m_pagePanel.add("South", this.m_hscroll);
        this.add("Center", this.m_pagePanel);
        if (!this.propGraphOnly()) {
            this.initBrandImage();
            Panel panel = new Panel(this.m_buttonLayout);
            if (this.propResizeButtons()) {
                panel.add(this.newActionButton(BUTTON_ZOOMIN));
                panel.add(this.newActionButton(BUTTON_ZOOMOUT));
                if (this.propRectButton()) {
                    panel.add(this.newActionButton(BUTTON_ZOOMRECT));
                }
                panel.add(this.newActionButton(BUTTON_FILL));
            }
            if (this.propSelectButton()) {
                panel.add(this.newActionButton(BUTTON_SELECT));
            }
            if (this.propOptionsButton()) {
                panel.add(this.newActionButton(BUTTON_OPTIONS));
            }
            if (this.propPrintButton()) {
                panel.add(this.newActionButton(BUTTON_PRINT));
            }
            if (this.propHelpButton()) {
                panel.add(this.newActionButton(BUTTON_HELP));
            }
            if (!this.propBrandButton()) {
                if (panel.getComponentCount() > 0) {
                    panel.add(new Label(""));
                }
            } else if (this.m_brandImage != null && this.m_brandImageWidth > 1 && this.m_brandImageHeight > 1) {
                panel.add(new BrandButton());
            } else {
                panel.add(this.newActionButton("S-PLUS", "S-PLUS"));
            }
            if (panel.getComponentCount() > 0) {
                this.add("North", panel);
            }
            if (this.propTabs()) {
                this.add("South", this.m_tabCanvas);
            }
        }
        this.m_controller = new SCanvasPaneController(this);
        SCanvasPaneController.setShowMouseLocation(this.getAppletParameter("spjgraph.mouse.position", false));
        SCanvasPaneController.setShowActiveRegions(this.getAppletParameter("spjgraph.active.regions", true));
        SCanvasPaneController.setBackgroundBorders(true);
        this.m_controller.setSelectionHighlightColor(SGui.getColorFromString(this.getAppletParameterString("spjgraph.selection.highlight.color")));
        this.m_controller.setSelectionHighlightMode(this.getAppletParameterString("spjgraph.selection.highlight.mode"));
        this.m_controller.setHighlightOutline(this.propHighlightOutline());
        this.m_controller.setDebug(this.propDebug());
        SCanvasPaneController.setAnnotationTextColor(this.getAppletNumericParameter("spjgraph.annotationtext.color", 1));
        this.setOptionPrintMultiplePages(this.getAppletParameter("spjgraph.print.multi", false));
        this.setOptionPrintUnzoomedPage(this.getAppletParameter("spjgraph.print.unzoomed", false));
        this.setOptionPrintSelectedRegions(this.getAppletParameter("spjgraph.print.selections", true));
        this.m_controller.setBackgroundColor(SGui.getColorFromString(this.getAppletParameterString("spjgraph.background.color")));
        SCanvasPaneController.setLabelColor(SGui.getColorFromString(this.getAppletParameterString("spjgraph.label.color")));
    }

    private void initBrandImage() {
        try {
            int n;
            InputStream inputStream = this.getClass().getResourceAsStream(this.m_brandImageFilename);
            byte[] byArray = new byte[10000];
            int n2 = 0;
            while (inputStream.available() > 0 && (n = inputStream.read(byArray, n2, byArray.length - n2)) >= 1) {
                n2 += n;
            }
            Image image = Toolkit.getDefaultToolkit().createImage(byArray, 0, n2);
            MediaTracker mediaTracker = new MediaTracker(this);
            mediaTracker.addImage(image, 0);
            mediaTracker.waitForAll(2000L);
            if (mediaTracker.isErrorAny()) {
                throw new Exception("MediaTracker error");
            }
            int n3 = image.getWidth(this);
            int n4 = image.getHeight(this);
            if (n3 < 1 || n4 < 1) {
                throw new Exception("image too small: " + n3 + " x " + n4);
            }
            if (this.m_brandImageMapBackground) {
                int[] nArray = new int[n3 * n4];
                PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, n3, n4, nArray, 0, n3);
                if (!pixelGrabber.grabPixels()) {
                    throw new Exception("PixelGrabber error");
                }
                int n5 = nArray[n3 - 1];
                int n6 = Color.lightGray.getRGB();
                for (int i = 0; i < nArray.length; ++i) {
                    int n7 = nArray[i];
                    if (n7 == n5) {
                        n7 = n6;
                    }
                    nArray[i] = n7 | 0xFF000000;
                }
                image = SGraphCommand.createImage(new MemoryImageSource(n3, n4, nArray, 0, n3));
            }
            this.m_brandImageWidth = n3;
            this.m_brandImageHeight = n4;
            this.m_brandImage = image;
        }
        catch (Exception exception) {
            System.out.println("Error reading " + this.m_brandImageFilename + ": " + exception);
        }
    }

    public Component getCanvasComponent() {
        return this.m_pageCanvas;
    }

    public Component getTabComponent() {
        return this.m_tabCanvas;
    }

    public Adjustable getScrollAdjustable(int n) {
        return this.getScrollbar(n);
    }

    public Scrollbar getScrollbar(int n) {
        return n == 0 ? this.m_hscroll : this.m_vscroll;
    }

    public boolean getScrollVisible(int n) {
        return this.getScrollbar(n).isVisible();
    }

    public void setScrollVisible(int n, boolean bl) {
        if (bl != this.getScrollVisible(n)) {
            this.getScrollbar(n).setVisible(bl);
            this.validate();
        }
    }

    public void doHitURL(String string, String string2) {
        try {
            if (string == null) {
                return;
            }
            if (string2 == null) {
                string2 = "_top";
            }
            System.out.println("showDocument(" + string + ", " + string2 + ")");
            if (this.m_applet == null) {
                throw new Exception("Not in applet");
            }
            URL uRL = new URL(this.m_applet.getDocumentBase(), string);
            this.m_applet.getAppletContext().showDocument(uRL, string2);
        }
        catch (Exception exception) {
            System.out.println("Can't show URL " + string + " (" + exception.getMessage() + ")");
        }
    }

    public void doHitMenu(String string, String[] stringArray, String[] stringArray2, int n, int n2) {
        if (stringArray == null || stringArray2 == null) {
            return;
        }
        int n3 = Math.min(stringArray.length, stringArray2.length);
        if (n3 < 1) {
            return;
        }
        if (this.m_canvasPopupMenu == null) {
            this.m_canvasPopupMenu = new PopupMenu();
            this.m_canvasPopupMenuActionListener = new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    String string = actionEvent.getActionCommand();
                    if (string != null && SGui.this.m_controller != null) {
                        SGui.this.m_controller.doHitAction(string);
                    }
                }
            };
            this.m_pageCanvas.add(this.m_canvasPopupMenu);
        }
        this.m_canvasPopupMenu.removeAll();
        for (int i = 0; i < n3; ++i) {
            MenuItem menuItem = new MenuItem(stringArray[i]);
            menuItem.setActionCommand(stringArray2[i]);
            menuItem.addActionListener(this.m_canvasPopupMenuActionListener);
            this.m_canvasPopupMenu.add(menuItem);
        }
        this.m_canvasPopupMenu.show(this.m_pageCanvas, n, n2);
    }

    public void doHitMenu(STreeNode sTreeNode, STreeNode sTreeNode2, int n, int n2) {
        if (sTreeNode == null || sTreeNode2 == null) {
            return;
        }
        if (sTreeNode.getChildCount() < 1 || sTreeNode2.getChildCount() < 1) {
            return;
        }
        if (this.m_canvasPopupMenu == null) {
            this.m_canvasPopupMenu = new PopupMenu();
            this.m_canvasPopupMenuActionListener = new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    String string = actionEvent.getActionCommand();
                    if (string != null && SGui.this.m_controller != null) {
                        SGui.this.m_controller.doHitAction(string);
                    }
                }
            };
            this.m_pageCanvas.add(this.m_canvasPopupMenu);
        }
        this.m_canvasPopupMenu.removeAll();
        this.constructMenu(this.m_canvasPopupMenu, sTreeNode, sTreeNode2);
        this.m_canvasPopupMenu.show(this.m_pageCanvas, n, n2);
    }

    protected void constructMenu(Menu menu, STreeNode sTreeNode, STreeNode sTreeNode2) {
        menu.setLabel((String)sTreeNode.getUserObject());
        int n = Math.min(sTreeNode.getChildCount(), sTreeNode2.getChildCount());
        for (int i = 0; i < n; ++i) {
            MenuItem menuItem;
            STreeNode sTreeNode3 = sTreeNode.getChildAt(i);
            STreeNode sTreeNode4 = sTreeNode2.getChildAt(i);
            if (sTreeNode3.isLeaf() || sTreeNode4.isLeaf()) {
                menuItem = new MenuItem((String)sTreeNode3.getUserObject());
                String string = (String)sTreeNode4.getUserObject();
                if (string != null && string.length() > 0) {
                    menuItem.setActionCommand(string);
                    menuItem.addActionListener(this.m_canvasPopupMenuActionListener);
                } else {
                    menuItem.setEnabled(false);
                }
                menu.add(menuItem);
                continue;
            }
            menuItem = new Menu();
            this.constructMenu((Menu)menuItem, sTreeNode3, sTreeNode4);
            menu.add(menuItem);
        }
    }

    public boolean doHitQueryWebService(XMLElement xMLElement, STreeNode sTreeNode, STreeNode sTreeNode2, boolean bl) throws Exception {
        String string = xMLElement.getProperty("URL");
        if (string == null) {
            throw new Exception("No URL specified for the web service");
        }
        String string2 = xMLElement.getProperty("TITLE", "");
        if (string2.equals("")) {
            string2 = xMLElement.getProperty("LABEL", "");
        }
        String string3 = xMLElement.getProperty("TARGET", "_top");
        String string4 = this.getSoapFromAction(xMLElement);
        String string5 = this.queryWebService(string, string4, bl);
        if (string5 == null) {
            return false;
        }
        sTreeNode.setUserObject(string2);
        this.parseSoapResponse(string5, sTreeNode, sTreeNode2, string3);
        return true;
    }

    protected String getSoapFromAction(XMLElement xMLElement) throws Exception {
        Object object;
        String string = xMLElement.getProperty("METHOD");
        String string2 = xMLElement.getProperty("NAMESPACE");
        if (string == null || string2 == null) {
            throw new Exception("No method and/or namespace specified");
        }
        String string3 = "";
        Enumeration enumeration = xMLElement.enumerateChildren();
        while (enumeration.hasMoreElements()) {
            object = (XMLElement)enumeration.nextElement();
            String string4 = ((XMLElement)object).getTagName();
            if (!string4.equalsIgnoreCase("INPUT")) {
                System.out.println("Ignored " + string4 + " element in <query> element.");
                continue;
            }
            String string5 = ((XMLElement)object).getProperty("NAME");
            String string6 = ((XMLElement)object).getProperty("VALUE");
            if (string5 == null || string6 == null) {
                System.out.println("An <input> element in a <query> element has no name and/or value; ignored.");
                continue;
            }
            String string7 = this.getXsiType(((XMLElement)object).getProperty("TYPE"));
            if (string7 == null) {
                System.out.println("Unrecognized <input> type in a <query> element; ignored.");
                continue;
            }
            string3 = string3 + "   <" + string5 + ' ' + "xsi:type=\"" + string7 + "\">" + string6 + "</" + string5 + ">\n";
        }
        object = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\n <soapenv:Body>\n  <ns1:" + string + " " + "soapenv:encodingStyle=" + "\"http://schemas.xmlsoap.org/soap/encoding/\" " + "xmlns:ns1=\"" + string2 + "\">\n" + string3 + "  </ns1:" + string + ">\n" + " </soapenv:Body>\n" + "</soapenv:Envelope>\n";
        return object;
    }

    protected String getXsiType(String string) {
        return "xsd:string";
    }

    protected String queryWebService(String string, String string2, boolean bl) throws MalformedURLException, NullPointerException, Exception {
        try {
            URL uRL = new URL(this.m_applet.getDocumentBase(), string);
            URLConnection uRLConnection = uRL.openConnection();
            if (uRLConnection == null) {
                throw new NullPointerException("Unable to open connection to " + uRL.getHost());
            }
            uRLConnection.setRequestProperty("method", "POST");
            uRLConnection.setDoOutput(true);
            uRLConnection.setRequestProperty("content-type", "text/xml; charset=utf-8");
            uRLConnection.setRequestProperty("accept", "text/*");
            uRLConnection.setRequestProperty("cache-control", "no-cache");
            uRLConnection.setRequestProperty("pragma", "no-cache");
            uRLConnection.setRequestProperty("soapaction", "\"\"");
            PrintWriter printWriter = new PrintWriter(uRLConnection.getOutputStream());
            printWriter.print(string2);
            printWriter.flush();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRLConnection.getInputStream()));
            StringBuffer stringBuffer = new StringBuffer();
            String string3 = null;
            while ((string3 = bufferedReader.readLine()) != null) {
                stringBuffer.append(string3 + '\n');
            }
            return stringBuffer.toString();
        }
        catch (IOException iOException) {
            if (bl) {
                this.showMessageDialog("Error", "Unable to access web service.  Please try again later or consult an administrator.");
            }
            System.out.println(iOException.toString());
            return null;
        }
    }

    protected void parseSoapResponse(String string, STreeNode sTreeNode, STreeNode sTreeNode2, String string2) throws Exception {
        XMLElement xMLElement = new XMLElement();
        xMLElement.parseString(string);
        Vector vector = xMLElement.getChildren();
        if (vector.size() != 1) {
            throw new Exception("Error in SOAP response:  envelope has multiple child elements");
        }
        XMLElement xMLElement2 = (XMLElement)vector.elementAt(0);
        if ((vector = xMLElement2.getChildren()).size() != 1) {
            throw new Exception("Error in SOAP response:  body has multiple child elements");
        }
        XMLElement xMLElement3 = (XMLElement)vector.elementAt(0);
        if ((vector = xMLElement3.getChildren()).size() != 1) {
            throw new Exception("Error in SOAP response:  response has multiple child elements");
        }
        XMLElement xMLElement4 = (XMLElement)vector.elementAt(0);
        Enumeration enumeration = xMLElement4.enumerateChildren();
        String string3 = null;
        boolean bl = false;
        while (enumeration.hasMoreElements()) {
            XMLElement xMLElement5 = (XMLElement)enumeration.nextElement();
            if (!xMLElement5.getTagName().equalsIgnoreCase("ITEM")) continue;
            if (!bl) {
                string3 = xMLElement5.getContents();
                if (string3 == null) continue;
                bl = true;
                continue;
            }
            String string4 = xMLElement5.getContents();
            if (string4 == null) continue;
            sTreeNode.add(new STreeNode(string3));
            sTreeNode2.add(new STreeNode("<link href=\"" + string4 + "\" " + "target=\"" + string2 + "\"/>"));
            bl = false;
        }
    }

    public void doHitError(String string, String string2) {
        System.out.println("Error: " + string2 + "\nin action:\n" + string);
    }

    public void doExec(String string, String string2) {
        if (this.m_applet != null && (string2 == null || string2.equals("") || string2.equalsIgnoreCase("javascript") || string2.equalsIgnoreCase("ecmascript"))) {
            try {
                Class<?> clazz;
                if (this.m_jsObjectWindow == null) {
                    clazz = Class.forName("netscape.javascript.JSObject");
                    Method method = clazz.getMethod("getWindow", Applet.class);
                    this.m_jsObjectWindow = method.invoke(null, this.m_applet);
                }
                if (this.m_javascriptEvalMt == null) {
                    clazz = Class.forName("netscape.javascript.JSObject");
                    this.m_javascriptEvalMt = clazz.getMethod("eval", String.class);
                }
                this.m_javascriptEvalMt.invoke(this.m_jsObjectWindow, string);
            }
            catch (Throwable throwable) {
                System.out.println("Exception executing code: " + string + " (language=" + string2 + ")");
                throwable.printStackTrace();
            }
        } else {
            System.out.println("Can't execute code: " + string + " (language=" + string2 + ")");
        }
    }

    public void addCanvas(SCanvasAWT sCanvasAWT) {
        this.addCanvas(sCanvasAWT, this.getNumberPages());
    }

    public void addCanvas(SCanvasAWT sCanvasAWT, int n) {
        this.setCanvasGuiProps(sCanvasAWT);
        this.m_controller.addCanvas(sCanvasAWT, n);
    }

    public int getTabCount() {
        return this.m_controller.getTabCount();
    }

    Button newActionButton(String string) {
        return this.newActionButton(string, string);
    }

    Button newActionButton(String string, String string2) {
        Button button = new Button(string);
        button.setActionCommand(string2);
        button.addActionListener(this);
        return button;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(BUTTON_OPEN)) {
            this.openFile();
        } else if (string.equals(BUTTON_PRINT)) {
            this.printAction();
        } else if (string.equals(BUTTON_ZOOMIN)) {
            this.m_controller.zoom(1.5);
        } else if (string.equals(BUTTON_ZOOMOUT)) {
            this.m_controller.zoom(0.6666666666666666);
        } else if (string.equals(BUTTON_ZOOMRECT)) {
            this.m_controller.zoomToRect();
        } else if (string.equals(BUTTON_FILL)) {
            this.m_controller.setAutoZoom(true);
        } else if (string.equals(BUTTON_SELECT)) {
            this.m_controller.selectRect();
        } else if (string.equals("S-PLUS")) {
            this.showInfo();
        } else if (string.equals(BUTTON_OPTIONS)) {
            this.showOptions();
        } else if (string.equals(BUTTON_HELP)) {
            this.showHelp();
        }
    }

    void showInfo() {
        this.doHitURL(m_brandURL, null);
    }

    public Frame getTopLevelFrame() {
        Container container = this;
        while (container.getParent() != null) {
            container = container.getParent();
        }
        if (container instanceof Frame) {
            return (Frame)container;
        }
        return null;
    }

    public void showMessageDialog(String string, Component component) {
        MessageDialog messageDialog = new MessageDialog(this.getTopLevelFrame(), string, component);
        messageDialog.show();
    }

    public void showMessageDialog(String string, String string2) {
        MessageDialog messageDialog = new MessageDialog(this.getTopLevelFrame(), string, string2);
        messageDialog.show();
    }

    public boolean getOptionPrintMultiplePages() {
        return this.m_printMultiplePages;
    }

    public void setOptionPrintMultiplePages(boolean bl) {
        this.m_printMultiplePages = bl;
    }

    public boolean getOptionPrintUnzoomedPage() {
        return this.m_printUnzoomedPages;
    }

    public void setOptionPrintUnzoomedPage(boolean bl) {
        this.m_printUnzoomedPages = bl;
    }

    public boolean getOptionPrintSelectedRegions() {
        return this.m_printSelectedRegions;
    }

    public void setOptionPrintSelectedRegions(boolean bl) {
        this.m_printSelectedRegions = bl;
    }

    public void doPrintJobPrint() throws Exception {
        int n = this.m_controller.getSelectedTab();
        int n2 = this.m_controller.getTabCount();
        PrintJob printJob = Toolkit.getDefaultToolkit().getPrintJob(this.getTopLevelFrame(), null, null);
        if (printJob == null) {
            return;
        }
        int n3 = n;
        int n4 = 1;
        int n5 = 1;
        if (this.getOptionPrintMultiplePages()) {
            if (printJob.lastPageFirst()) {
                n3 = n2 - 1;
                n4 = -1;
            } else {
                n3 = 0;
                n4 = 1;
            }
            n5 = n2;
        }
        for (int i = 0; i < n5; ++i) {
            Graphics graphics = printJob.getGraphics();
            Dimension dimension = printJob.getPageDimension();
            this.m_controller.printPage(n3 + i * n4, graphics, dimension, this.getOptionPrintUnzoomedPage() || this.getOptionPrintMultiplePages(), this.getOptionPrintSelectedRegions());
            graphics.dispose();
        }
        printJob.end();
    }

    void printAction() {
        SGraphCommand.getFactory().doPrint(this);
    }

    void openFile() {
        if (this.getTopLevelFrame() == null) {
            return;
        }
        FileDialog fileDialog = new FileDialog(this.getTopLevelFrame(), "Open File", 0);
        if (this.m_lastFileDirectory != null) {
            fileDialog.setDirectory(this.m_lastFileDirectory);
        }
        fileDialog.setFile("*.*");
        fileDialog.show();
        String string = fileDialog.getFile();
        if (string != null) {
            this.m_lastFileDirectory = fileDialog.getDirectory();
            String string2 = fileDialog.getDirectory() + string;
            if (string2.indexOf(".*.*") != -1) {
                string2 = string2.substring(0, string2.length() - 4);
            }
            FileInputStream fileInputStream = null;
            try {
                fileInputStream = new FileInputStream(string2);
                this.loadInputStream(fileInputStream);
            }
            catch (Exception exception) {
                exception.printStackTrace(System.out);
            }
        }
    }

    public void loadInputStream(InputStream inputStream) {
        if (inputStream == null) {
            return;
        }
        try {
            this.m_controller.removeAllPages();
            Vector vector = XML.readCanvasVector(inputStream);
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                SCanvasAWT sCanvasAWT = (SCanvasAWT)enumeration.nextElement();
                this.addCanvas(sCanvasAWT);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
        }
        this.m_controller.setSelectedTab(0);
    }

    public String[] getSelectedTags() {
        return this.m_controller.getSelectedTags();
    }

    public void setSelectedTags(String[] stringArray) {
        this.m_controller.setSelectedTags(stringArray);
    }

    public String getCurrentPageTagName() {
        return this.m_controller.getCurrentPageTagName();
    }

    public int getCurrentPageNumber() {
        return this.m_controller.getCurrentPageNumber();
    }

    public int getNumberPages() {
        return this.m_controller.getNumberPages();
    }

    public void setCurrentPageByTagName(String string) {
        this.m_controller.setCurrentPageByTagName(string);
    }

    public void setCurrentPageByNumber(int n) {
        this.m_controller.setCurrentPageByNumber(n);
    }

    public void setCurrentPageBack() {
        this.m_controller.setCurrentPageBack();
    }

    public void setCurrentPageForward() {
        this.m_controller.setCurrentPageForward();
    }

    void showOptions() {
        Frame frame = this.getTopLevelFrame();
        OptionsDialog optionsDialog = new OptionsDialog(frame);
        optionsDialog.show();
    }

    void showHelp() {
        Frame frame = this.getTopLevelFrame();
        HelpDialog helpDialog = new HelpDialog(frame);
        helpDialog.show();
    }

    boolean getAppletParameter(String string, boolean bl) {
        String string2 = this.getAppletParameterString(string);
        if (string2 == null) {
            return bl;
        }
        return string2.equalsIgnoreCase("YES") || string2.equalsIgnoreCase("ON") || string2.equalsIgnoreCase("Y") || string2.equalsIgnoreCase("T") || string2.equalsIgnoreCase("TRUE");
    }

    int getAppletNumericParameter(String string, int n) {
        String string2 = this.getAppletParameterString(string);
        if (string2 == null) {
            return n;
        }
        try {
            int n2 = Integer.parseInt(string2);
            if (n2 >= 1 && n2 <= 16) {
                return n2;
            }
        }
        catch (NumberFormatException numberFormatException) {
            return n;
        }
        return n;
    }

    String getAppletParameterString(String string) {
        if (this.m_applet == null || string == null) {
            return null;
        }
        String string2 = this.m_applet.getParameter(string);
        return string2;
    }

    boolean propMousePositionCheckbox() {
        return this.getAppletParameter("spjgraph.mouse.position.checkbox", true);
    }

    boolean propActiveRegionsCheckbox() {
        return this.getAppletParameter("spjgraph.active.regions.checkbox", true);
    }

    boolean propPrintOptionChooser() {
        return this.propPrintButton() && this.getAppletParameter("spjgraph.print.option.chooser", true);
    }

    boolean propPrintSelectionsCheckbox() {
        return this.propPrintButton() && this.getAppletParameter("spjgraph.print.selections.checkbox", true);
    }

    boolean propRectButton() {
        return this.propResizeButtons() && this.getAppletParameter("spjgraph.rect.button", true);
    }

    boolean propResizeButtons() {
        return this.getAppletParameter("spjgraph.resize.buttons", true);
    }

    boolean propSelectButton() {
        return this.getAppletParameter("spjgraph.select.button", false);
    }

    boolean propOptionsButton() {
        return this.getAppletParameter("spjgraph.options.button", true) && (this.propMousePositionCheckbox() || this.propActiveRegionsCheckbox() || this.propPrintOptionChooser() || this.propPrintSelectionsCheckbox());
    }

    boolean propPrintButton() {
        return this.getAppletParameter("spjgraph.print.button", true);
    }

    boolean propHelpButton() {
        return this.getAppletParameter("spjgraph.help.button", true);
    }

    boolean propTabs() {
        return this.getAppletParameter("spjgraph.tabs", true);
    }

    boolean propTabsCheckbox() {
        return this.getAppletParameter("spjgraph.tabs.checkbox", true);
    }

    boolean nowShowingTabs() {
        return this.m_tabCanvas.getParent() != null;
    }

    boolean propBrandButton() {
        return this.getAppletParameter("spjgraph.brand.button", true);
    }

    boolean propHighlightOutline() {
        return this.getAppletParameter("spjgraph.highlight.outline", true);
    }

    boolean propDebug() {
        return this.getAppletParameter("spjgraph.debug", false);
    }

    boolean propClipIdentify() {
        return this.getAppletParameter("spjgraph.clip.identify", false);
    }

    public boolean propGraphOnly() {
        return this.getAppletParameter("spjgraph.graph.only", false);
    }

    public boolean propContextMenu() {
        return this.getAppletParameter("spjgraph.context.menu", false);
    }

    public static Color getColorFromString(String string) {
        if (string == null) {
            return null;
        }
        try {
            String string2 = string.startsWith("#") ? string.substring(1) : string;
            int n = Integer.parseInt(string, 16);
            return new Color(n);
        }
        catch (NumberFormatException numberFormatException) {
            for (int i = 0; i < g_strStaticColor.length; ++i) {
                if (!g_strStaticColor[i].equalsIgnoreCase(string)) continue;
                return g_clrStatic[i];
            }
            return null;
        }
    }

    public Vector getEmbeddedCanvasVector(String string) throws Exception {
        if (this.m_applet == null || !(this.m_applet instanceof SApplet)) {
            throw new Exception("can't access SApplet");
        }
        InputStream inputStream = ((SApplet)this.m_applet).openGraphStream(string);
        if (inputStream == null) {
            throw new Exception("Can't open embedded SPJ file");
        }
        Vector vector = XML.readCanvasVector(inputStream);
        return vector;
    }

    public void prepareEmbeddedCanvas(SCanvasAWT sCanvasAWT) {
        this.setCanvasGuiProps(sCanvasAWT);
    }

    private void setCanvasGuiProps(SCanvasAWT sCanvasAWT) {
        URL uRL = this.m_applet == null ? null : this.m_applet.getDocumentBase();
        sCanvasAWT.setDocumentBase(uRL);
        sCanvasAWT.setClipIdentify(this.propClipIdentify());
        sCanvasAWT.setDebug(this.propDebug());
        sCanvasAWT.setInApplet(this.m_applet != null);
    }

    public void addPage() {
        this.addCanvas(new SCanvasAWT());
    }

    public void insertPage(int n) {
        this.addCanvas(new SCanvasAWT(), n);
    }

    public void removePage(int n) {
        this.m_controller.removeTabAt(n);
    }

    public void removeAllPages() {
        this.m_controller.removeAllPages();
    }

    public int getPageWithTagName(String string) {
        return this.m_controller.getTabNumberFromTagName(string);
    }

    public String getPageTagName(int n) {
        return this.m_controller.getTabTagName(n);
    }

    public String getPageTag(int n) {
        return this.m_controller.getTabTag(n);
    }

    public String getPageTitle(int n) {
        return this.m_controller.getTabTitle(n);
    }

    public void setPageTag(int n, String string) {
        this.m_controller.setTabTag(n, string);
    }

    public void setPageTitle(int n, String string) {
        this.m_controller.setTabTitle(n, string);
    }

    public void clearSelectedTags() {
        this.m_controller.clearSelectedTags();
    }

    public void addSelectedTag(String string) {
        this.m_controller.addSelectedTag(string);
    }

    public void removeSelectedTag(String string) {
        this.m_controller.removeSelectedTag(string);
    }

    public void toggleSelectedTag(String string) {
        this.m_controller.toggleSelectedTag(string);
    }

    public boolean isSelectedTag(String string) {
        return this.m_controller.isSelectedTag(string);
    }

    public SCanvasRectangle getSelectionRect() {
        return this.m_controller.getSelectionRect();
    }

    public boolean getOptionDisplayMousePosition() {
        SGui sGui = this;
        return sGui.m_controller.getShowMouseLocation();
    }

    public void setOptionDisplayMousePosition(boolean bl) {
        SCanvasPaneController.setShowMouseLocation(bl);
    }

    public int getOptionMousePositionDigits() {
        SGui sGui = this;
        return sGui.m_controller.getLocatorFractionDigits();
    }

    public void setOptionMousePositionDigits(int n) {
        SCanvasPaneController.setLocatorFractionDigits(n);
    }

    public boolean getOptionEnableActiveRegions() {
        SGui sGui = this;
        return sGui.m_controller.getShowActiveRegions();
    }

    public void setOptionEnableActiveRegions(boolean bl) {
        SCanvasPaneController.setShowActiveRegions(bl);
    }

    public boolean getOptionDisplayPageTabs() {
        return this.m_tabCanvas.getParent() != null;
    }

    public void setOptionDisplayPageTabs(boolean bl) {
        boolean bl2 = this.getOptionDisplayPageTabs();
        if (bl2 && !bl) {
            this.remove(this.m_tabCanvas);
            this.validate();
        } else if (!bl2 && bl) {
            this.add("South", this.m_tabCanvas);
            this.validate();
        }
    }

    public double getZoom() {
        return this.m_controller.getZoom();
    }

    public void setZoom(double d) {
        this.m_controller.setZoom(d);
    }

    public void setZoomToRect(SCanvasRectangle sCanvasRectangle) {
        this.m_controller.setZoomToRect(sCanvasRectangle);
    }

    public void setSelectionRect(SCanvasRectangle sCanvasRectangle) {
        this.m_controller.setSelectionRect(sCanvasRectangle);
    }

    public String[] getTagsInRect(SCanvasRectangle sCanvasRectangle) {
        return this.m_controller.getTagsInRect(sCanvasRectangle);
    }

    public boolean getSelectionRectShiftDown() {
        return this.m_controller.getSelectionRectShiftDown();
    }

    public void setSelectionRectShiftDown(boolean bl) {
        this.m_controller.setSelectionRectShiftDown(bl);
    }

    public boolean getSelectionRectControlDown() {
        return this.m_controller.getSelectionRectControlDown();
    }

    public void setSelectionRectControlDown(boolean bl) {
        this.m_controller.setSelectionRectControlDown(bl);
    }

    public void selectTagsFromSelectionRect() {
        this.m_controller.selectRect();
    }

    public boolean doContextMenu(int n, int n2) {
        if (!this.propContextMenu()) {
            return false;
        }
        if (this.m_canvasContextMenu == null) {
            PopupMenu popupMenu = new PopupMenu();
            MenuItem menuItem = new MenuItem("Zoom In");
            menuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    SGui.this.m_controller.zoom(1.5);
                }
            });
            popupMenu.add(menuItem);
            menuItem = new MenuItem("Zoom Out");
            menuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    SGui.this.m_controller.zoom(0.6666666865348816);
                }
            });
            popupMenu.add(menuItem);
            menuItem = new MenuItem("Zoom to Rectangle");
            menuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    SGui.this.m_controller.zoomToRect();
                }
            });
            popupMenu.add(menuItem);
            menuItem = new MenuItem("Original View");
            menuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    SGui.this.m_controller.setAutoZoom(true);
                }
            });
            popupMenu.add(menuItem);
            popupMenu.addSeparator();
            menuItem = new MenuItem("Select In Rectangle");
            menuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    SGui.this.m_controller.selectRect();
                }
            });
            popupMenu.add(menuItem);
            popupMenu.addSeparator();
            menuItem = new MenuItem(BUTTON_OPTIONS);
            menuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    SGui.this.showOptions();
                }
            });
            popupMenu.add(menuItem);
            menuItem = new MenuItem(BUTTON_PRINT);
            menuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    SGui.this.printAction();
                }
            });
            popupMenu.add(menuItem);
            menuItem = new MenuItem(BUTTON_HELP);
            menuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    SGui.this.showHelp();
                }
            });
            popupMenu.add(menuItem);
            this.m_pageCanvas.add(popupMenu);
            this.m_canvasContextMenu = popupMenu;
        }
        this.m_canvasContextMenu.show(this.m_pageCanvas, n, n2);
        return true;
    }

    class BrandButton
    extends Component
    implements MouseListener {
        boolean m_showButtonDown = false;
        boolean m_buttonDown = false;

        BrandButton() {
            this.addMouseListener(this);
        }

        public Dimension getPreferredSize() {
            return new Dimension(SGui.this.m_brandImageWidth + 5, SGui.this.m_brandImageHeight + 5);
        }

        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        public Dimension getMaximumSize() {
            return this.getPreferredSize();
        }

        public void paint(Graphics graphics) {
            graphics.setColor(Color.lightGray);
            int n = SGui.this.m_brandImageWidth + 5 - 1;
            int n2 = SGui.this.m_brandImageHeight + 5 - 1;
            graphics.fillRect(0, 0, n + 1, n2 + 1);
            int n3 = this.m_showButtonDown ? 3 : 2;
            graphics.drawImage(SGui.this.m_brandImage, n3, n3, this);
            graphics.setColor(Color.white);
            if (this.m_showButtonDown) {
                graphics.drawLine(1, n2, n, n2);
                graphics.drawLine(n, 1, n, n2);
            } else {
                graphics.drawLine(0, 0, n - 1, 0);
                graphics.drawLine(0, 0, 0, n2 - 1);
            }
            graphics.setColor(Color.black);
            if (this.m_showButtonDown) {
                graphics.drawLine(0, 0, n, 0);
                graphics.drawLine(0, 0, 0, n2);
            } else {
                graphics.drawLine(0, n2, n, n2);
                graphics.drawLine(n, 0, n, n2);
            }
            graphics.setColor(Color.darkGray);
            if (this.m_showButtonDown) {
                graphics.drawLine(1, 1, n - 1, 1);
                graphics.drawLine(1, 1, 1, n2 - 1);
            } else {
                graphics.drawLine(1, n2 - 1, n - 1, n2 - 1);
                graphics.drawLine(n - 1, 1, n - 1, n2 - 1);
            }
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.m_buttonDown = this.leftButtonEvent(mouseEvent) && this.insideButton(mouseEvent);
            this.showButtonDown(this.m_buttonDown);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.showButtonDown(false);
            boolean bl = this.m_buttonDown;
            this.m_buttonDown = false;
            if (bl && this.leftButtonEvent(mouseEvent) && this.insideButton(mouseEvent)) {
                SGui.this.showInfo();
            }
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            this.showButtonDown(this.m_buttonDown);
        }

        public void mouseExited(MouseEvent mouseEvent) {
            this.showButtonDown(false);
        }

        void showButtonDown(boolean bl) {
            this.m_showButtonDown = bl;
            this.repaint();
        }

        boolean leftButtonEvent(MouseEvent mouseEvent) {
            int n = mouseEvent.getModifiers();
            boolean bl = (n & 0x10) != 0;
            boolean bl2 = (n & 8) != 0;
            boolean bl3 = (n & 4) != 0;
            return bl || !bl && !bl2 && !bl3;
        }

        boolean insideButton(MouseEvent mouseEvent) {
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            return n >= 0 && n <= SGui.this.m_brandImageWidth + 5 && n2 >= 0 && n2 <= SGui.this.m_brandImageHeight + 5;
        }
    }

    class HelpDialog
    extends Dialog
    implements ActionListener,
    WindowListener {
        TextArea m_taText;

        HelpDialog(Frame frame) {
            super(frame, "Graphlet Help", false);
            this.m_taText = new TextArea();
            this.setLayout(new BorderLayout(5, 5));
            Button button = new Button(SGui.BUTTON_OK);
            button.addActionListener(this);
            this.add((Component)this.m_taText, "Center");
            this.add((Component)button, "South");
            this.setSize(400, 400);
            this.addWindowListener(this);
        }

        public void show() {
            String string = "S-PLUS Graphlet Help\n\n";
            if (SGui.this.getOptionDisplayPageTabs()) {
                string = string + "Left-buttoning the tabs along the bottom\nselects one of multiple graph pages.\n\n";
            }
            if (SGui.this.propResizeButtons()) {
                string = string + "The \"In\" button zooms in the graph.\nThe \"Out\" button zooms out the graph.\nThe \"Fill\" button resizes the graph\nso it fills the window.\n\n";
            }
            if (SGui.this.propRectButton()) {
                string = string + "The \"Rect\" button zooms in on a given\nrectangle.  Press and drag the left mouse\nbutton to define a rectangle, then press\n\"Rect\" to zoom in on it.\n\n";
            }
            if (SGui.this.propSelectButton()) {
                string = string + "The \"Select\" button selects all selectable\nregions within a given rectangle.  Press and\ndrag the left mouse button to define a\nrectangle, then press \"Select\" to select\nall the selectable regions within it.\n\n";
            }
            if (SGui.this.propOptionsButton()) {
                string = string + "The \"Options...\" button brings up a window for\nmodifying Graphlet options:\n";
                if (SGui.this.propMousePositionCheckbox()) {
                    string = string + "  \"Display mouse position\" specifies whether the\nmouse graph coordinates are displayed in the top left.\n  \"Mouse position digits\" specifies the number of\nfraction digits in the mouse graph coordinates.\n";
                }
                if (SGui.this.propActiveRegionsCheckbox()) {
                    string = string + "  \"Enable active regions\" specifies whether active\nregions are highlighted.\n";
                }
                if (SGui.this.propTabsCheckbox()) {
                    string = string + "  \"Display page tabs\" specifies whether to show\ntabs along the bottom of the page.\n";
                }
                if (SGui.this.propPrintOptionChooser()) {
                    string = string + "  The image printed by the \"Print...\"\nbutton is determined by selecting one of:\n      \"Print current page as-is\"\n      \"Print current page unzoomed\"\n      \"Print all pages unzoomed\"\nThe first option prints the portion of the\ncurrent page that is visible; the others print\nthe complete contents of the current or of all\nGraphlet pages.\n";
                }
                if (SGui.this.propPrintSelectionsCheckbox()) {
                    string = string + "  \"Print selected regions\" specifies whether selected\nregions should be highlighted when printed.\n";
                }
                string = string + "\n";
            }
            if (SGui.this.propPrintButton()) {
                string = string + "The \"Print...\" button prints the contents of\nthe Graphlet without printing the rest of the\nbrowser page.\n\n";
            }
            string = string + "The \"Help...\" button brings up this window.\n\n";
            if (SGui.this.propBrandButton()) {
                string = string + "The button in the upper right displays a\nWeb page describing the S-PLUS graphlet.\n\n";
            }
            string = string + "\n\nCopyright (c) 2000-2006 Insightful Corporation.\nAll rights reserved.\n\nYou are viewing a Graphlet(r) created using\nS-PLUS(r) software.  Permission to use, copy,\nand distribute this Graphlet in its entirety,\nwithout modification, is hereby granted without\nfee, provided that this license information and\ncopyright notice must appear in all copies.\n\nINSIGHTFUL DOES NOT WARRANT THAT THE OPERATION\nOF THIS PROGRAM WILL BE UNINTERRUPTED OR ERROR\nFREE.  INSIGHTFUL DISCLAIMS ALL WARRANTIES WITH\nRESPECT TO THIS PROGRAM, EITHER EXPRESS OR\nIMPLIED, INCLUDING MERCHANTIBILITY AND FITNESS\nFOR A PARTICULAR PURPOSE.  THIS PROGRAM IS\nDISTRIBUTED \"AS IS\".\n\nINSIGHTFUL SHALL NOT BE LIABLE FOR ANY DAMAGES\nWHATSOEVER, INCLUDING SPECIAL, INCIDENTAL, OR\nCONSEQUENTIAL DAMAGES, OR  LOSS OF PROFITS,\nARISING OUT OF THE USE OF THE PROGRAM, EVEN IF\nINFORMED OF THE POSSIBILITY OF THOSE DAMAGES\nIN ADVANCE.\n\nInsightful Corporation\n1700 Westlake Ave. N. Suite 500\nSeattle, WA   98109  U.S.A.\n\nInsightful, S-PLUS and Graphlet are registered\ntrademarks of Insightful Corporation.\n\n\n";
            this.m_taText.setEditable(false);
            this.m_taText.setText(string);
            super.show();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.hide();
        }

        public void windowActivated(WindowEvent windowEvent) {
        }

        public void windowClosed(WindowEvent windowEvent) {
        }

        public void windowClosing(WindowEvent windowEvent) {
            this.hide();
        }

        public void windowDeactivated(WindowEvent windowEvent) {
        }

        public void windowDeiconified(WindowEvent windowEvent) {
        }

        public void windowIconified(WindowEvent windowEvent) {
        }

        public void windowOpened(WindowEvent windowEvent) {
        }
    }

    class OptionsDialog
    extends Dialog
    implements ActionListener,
    WindowListener {
        Checkbox m_cbDisplayMouse;
        Checkbox m_cbDisplayActive;
        Checkbox m_cbTabs;
        TextField m_tfMouseFractionDigits;
        Choice m_chPrintOption;
        Checkbox m_cbPrintSelections;

        OptionsDialog(Frame frame) {
            Panel panel;
            super(frame, "Graphlet Options", false);
            this.m_cbDisplayMouse = new Checkbox("Display mouse position");
            this.m_cbDisplayActive = new Checkbox("Enable active regions");
            this.m_cbTabs = new Checkbox("Display page tabs");
            this.m_tfMouseFractionDigits = new TextField(3);
            this.m_chPrintOption = new Choice();
            this.m_cbPrintSelections = new Checkbox("Print selected regions");
            this.setLayout(new GridLayout(0, 1, 0, 3));
            if (SGui.this.propMousePositionCheckbox()) {
                this.add(this.m_cbDisplayMouse);
                panel = new Panel(new FlowLayout(0, 0, 0));
                panel.add(new Label("Mouse position digits:"));
                panel.add(this.m_tfMouseFractionDigits);
                this.add(panel);
            }
            if (SGui.this.propActiveRegionsCheckbox()) {
                this.add(this.m_cbDisplayActive);
            }
            if (SGui.this.propTabsCheckbox()) {
                this.add(this.m_cbTabs);
            }
            this.m_chPrintOption.add("Print current page as-is");
            this.m_chPrintOption.add("Print current page unzoomed");
            this.m_chPrintOption.add("Print all pages unzoomed");
            this.m_chPrintOption.select(0);
            if (SGui.this.propPrintOptionChooser()) {
                this.add(this.m_chPrintOption);
            }
            if (SGui.this.propPrintSelectionsCheckbox()) {
                this.add(this.m_cbPrintSelections);
            }
            panel = new Panel();
            panel.add(this.optionsButton(SGui.BUTTON_OK));
            panel.add(this.optionsButton(SGui.BUTTON_CANCEL));
            this.add(panel);
            this.setSize(300, 250);
            this.addWindowListener(this);
        }

        Button optionsButton(String string) {
            Button button = new Button(string);
            button.setActionCommand(string);
            button.addActionListener(this);
            return button;
        }

        public void show() {
            SGui sGui = SGui.this;
            this.m_cbDisplayMouse.setState(sGui.m_controller.getShowMouseLocation());
            SGui sGui2 = SGui.this;
            this.m_cbDisplayActive.setState(sGui2.m_controller.getShowActiveRegions());
            SGui sGui3 = SGui.this;
            this.m_tfMouseFractionDigits.setText(Integer.toString(sGui3.m_controller.getLocatorFractionDigits()));
            this.m_cbTabs.setState(SGui.this.getOptionDisplayPageTabs());
            this.m_chPrintOption.select(SGui.this.getOptionPrintMultiplePages() ? 2 : (SGui.this.getOptionPrintUnzoomedPage() ? 1 : 0));
            this.m_cbPrintSelections.setState(SGui.this.getOptionPrintSelectedRegions());
            super.show();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals(SGui.BUTTON_OK)) {
                SCanvasPaneController cfr_ignored_0 = SGui.this.m_controller;
                SCanvasPaneController.setShowMouseLocation(this.m_cbDisplayMouse.getState());
                SCanvasPaneController cfr_ignored_1 = SGui.this.m_controller;
                SCanvasPaneController.setShowActiveRegions(this.m_cbDisplayActive.getState());
                try {
                    int n = Integer.parseInt(this.m_tfMouseFractionDigits.getText());
                    SCanvasPaneController cfr_ignored_2 = SGui.this.m_controller;
                    SCanvasPaneController.setLocatorFractionDigits(n);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                SGui.this.setOptionDisplayPageTabs(this.m_cbTabs.getState());
                SGui.this.setOptionPrintMultiplePages(this.m_chPrintOption.getSelectedIndex() == 2);
                SGui.this.setOptionPrintUnzoomedPage(this.m_chPrintOption.getSelectedIndex() == 1);
                SGui.this.setOptionPrintSelectedRegions(this.m_cbPrintSelections.getState());
                this.hide();
            } else if (string.equals(SGui.BUTTON_CANCEL)) {
                this.hide();
            }
        }

        public void windowActivated(WindowEvent windowEvent) {
        }

        public void windowClosed(WindowEvent windowEvent) {
        }

        public void windowClosing(WindowEvent windowEvent) {
            this.hide();
        }

        public void windowDeactivated(WindowEvent windowEvent) {
        }

        public void windowDeiconified(WindowEvent windowEvent) {
        }

        public void windowIconified(WindowEvent windowEvent) {
        }

        public void windowOpened(WindowEvent windowEvent) {
        }
    }

    public static class SGuiPrintable
    implements Printable {
        private SCanvasPaneController m_controller;
        private boolean m_printSelections;
        private boolean m_printAll;
        private static PrintRequestAttributeSet m_lastAttr = null;

        public static void printControllerPages(SCanvasPaneController sCanvasPaneController, boolean bl, boolean bl2, boolean bl3) throws Exception {
            int n = sCanvasPaneController.getSelectedTab();
            int n2 = sCanvasPaneController.getTabCount();
            int n3 = n;
            int n4 = 1;
            if (bl) {
                n3 = 0;
                n4 = n2;
            }
            PrinterJob printerJob = PrinterJob.getPrinterJob();
            if (m_lastAttr == null) {
                m_lastAttr = new HashPrintRequestAttributeSet();
                m_lastAttr.add(MediaSizeName.NA_LETTER);
            }
            m_lastAttr.add(new PageRanges(n3 + 1, n3 + n4));
            if (!printerJob.printDialog(m_lastAttr)) {
                return;
            }
            SGuiPrintable sGuiPrintable = new SGuiPrintable(sCanvasPaneController, bl2, bl || bl3);
            printerJob.setPrintable(sGuiPrintable);
            printerJob.print(m_lastAttr);
        }

        public SGuiPrintable(SCanvasPaneController sCanvasPaneController, boolean bl, boolean bl2) {
            this.m_controller = sCanvasPaneController;
            this.m_printSelections = bl;
            this.m_printAll = bl2;
        }

        public int print(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
            if (n >= this.m_controller.getNumberPages()) {
                return 1;
            }
            graphics.translate((int)pageFormat.getImageableX(), (int)pageFormat.getImageableY());
            Dimension dimension = new Dimension((int)pageFormat.getImageableWidth(), (int)pageFormat.getImageableHeight());
            this.m_controller.printPage(n, graphics, dimension, this.m_printAll, this.m_printSelections, false);
            return 0;
        }
    }

    protected class MessageDialog
    extends Dialog
    implements ActionListener,
    WindowListener {
        MessageDialog(Frame frame, String string, String string2) {
            this(frame, string, new Label(string2));
        }

        MessageDialog(Frame frame, String string, Component component) {
            super(frame, string, false);
            Panel panel = new Panel();
            panel.setLayout(new FlowLayout(1));
            Button button = new Button(SGui.BUTTON_OK);
            button.addActionListener(this);
            panel.add(button);
            this.add(component, "Center");
            this.add((Component)panel, "South");
            this.addWindowListener(this);
            this.pack();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.hide();
        }

        public void windowActivated(WindowEvent windowEvent) {
        }

        public void windowClosed(WindowEvent windowEvent) {
        }

        public void windowClosing(WindowEvent windowEvent) {
            this.hide();
        }

        public void windowDeactivated(WindowEvent windowEvent) {
        }

        public void windowDeiconified(WindowEvent windowEvent) {
        }

        public void windowIconified(WindowEvent windowEvent) {
        }

        public void windowOpened(WindowEvent windowEvent) {
        }
    }
}

