/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.splus;

import com.insightful.splus.SplusConnectSpec;
import com.insightful.splus.SplusSession;
import com.insightful.splus.SplusSessionFactory;
import com.insightful.splus.client.SessionProfile;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.UnknownHostException;
import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import javax.swing.SwingUtilities;

public class SplusLogin {
    private static final String s_strEOL = "\n";
    protected Runnable m_runUpdateGui = null;
    protected String m_strProgress = null;
    protected Object m_lock = new Object();
    public static final String HELP_HOST_PROPERTY = "splus.help.host";

    public SplusSession newSession(SessionProfile sessionProfile, String string, String[] stringArray) throws SplusLoginException, SplusLoginFatalException {
        int n = 1099;
        if (sessionProfile.getServerRmiport().length() > 0) {
            try {
                n = Integer.parseInt(sessionProfile.getServerRmiport());
            }
            catch (NumberFormatException numberFormatException) {
                throw new SplusLoginException("RMI Port must be an integer");
            }
        }
        if (sessionProfile.getSessionArgs().length() > 0) {
            if (stringArray == null) {
                stringArray = new String[]{};
            }
            String[] stringArray2 = new String[stringArray.length + 1];
            stringArray2[0] = sessionProfile.getSessionArgs();
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray2[i + 1] = stringArray[i];
            }
            stringArray = stringArray2;
        }
        return this.newSession(sessionProfile.getServerHost(), sessionProfile.getUserName(), string, n, sessionProfile.getServerCwd(), sessionProfile.getXserverDisplay(), sessionProfile.getServerPrompt(), sessionProfile.getServerTelnetScript(), stringArray);
    }

    public SplusSession newSession(String string, String string2, String string3) throws SplusLoginException, SplusLoginFatalException {
        return this.newSession(string, string2, string3, 1099, "", "", "", "", new String[0]);
    }

    public SplusSession newSession(String string, String string2, String string3, int n, String string4, String string5, String string6, String string7, String[] stringArray) throws SplusLoginException, SplusLoginFatalException {
        String string8;
        if (string4.length() == 0) {
            string4 = ".";
        }
        if (string5.length() == 0) {
            try {
                string5 = InetAddress.getLocalHost().getHostName() + ":0.0";
            }
            catch (UnknownHostException unknownHostException) {
                throw new SplusLoginException("Unable to determine a default X Server Display.\nPlease provide one explicitely.");
            }
        }
        if (string6.length() == 0) {
            string6 = " ";
        }
        if ((string8 = SplusLogin.getHelpHost()) == null || string8.length() == 0) {
            string8 = string;
            SplusLogin.setHelpHost(string8);
        }
        this.setProgressText("Contacting the session factory...");
        LookupThread lookupThread = new LookupThread(string, n);
        lookupThread.start();
        try {
            int n2 = 10000;
            lookupThread.join(n2);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (lookupThread.isAlive()) {
            throw new SplusLoginFatalException("The host \"" + string + "\" is not responding." + s_strEOL + "Make sure that this machine is accessible " + "from the network.");
        }
        SplusSessionFactory splusSessionFactory = lookupThread.getFactory();
        this.setProgressText("Creating a session...");
        SplusConnectSpec splusConnectSpec = null;
        try {
            splusConnectSpec = splusSessionFactory.getSession(String.valueOf(n), string2, string3, string4, string5, string8, string6, string7, stringArray);
        }
        catch (Exception exception) {
            if (exception.getMessage().indexOf("Bad login") != -1) {
                throw new SplusLoginException("Remote session login failed.\nMake sure that the username and password are correct.");
            }
            if (exception.getMessage().indexOf("Too many sessions") != -1) {
                throw new SplusLoginException("The server has reached its session limit.\nTry again later or contact the server administrator for help.");
            }
            throw new SplusLoginFatalException("Network configuration error:\n\n\tMake sure that the server has a well-defined\n\tIP address (other than 127.0.0.1)");
        }
        this.setProgressText("Connecting to the session...");
        String string9 = "rmi://" + string + ':' + n + '/' + splusConnectSpec.getSessionID();
        for (int i = 0; i < 30; ++i) {
            try {
                return (SplusSession)Naming.lookup(string9);
            }
            catch (NotBoundException notBoundException) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            catch (Exception exception) {
                throw new SplusLoginException("Unexpected error during session connection!");
            }
        }
        throw new SplusLoginFatalException("Timeout occured while acquiring remote session.\nEither the session failed at startup or the startup was too slow.");
    }

    public void setProgressUpdateCode(Runnable runnable) {
        this.m_runUpdateGui = runnable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getProgressText() {
        Object object = this.m_lock;
        synchronized (object) {
            return this.m_strProgress;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setProgressText(String string) {
        Object object = this.m_lock;
        synchronized (object) {
            this.m_strProgress = string;
        }
        if (this.m_runUpdateGui != null) {
            SwingUtilities.invokeLater(this.m_runUpdateGui);
        }
    }

    public static String setHelpHost(String string) {
        return System.setProperty(HELP_HOST_PROPERTY, string);
    }

    public static String getHelpHost() {
        return System.getProperty(HELP_HOST_PROPERTY);
    }

    protected class LookupThread
    extends Thread {
        protected SplusSessionFactory m_factory = null;
        protected String m_strLookupURL;
        protected String m_strErrorMsg = null;

        public SplusSessionFactory getFactory() throws SplusLoginException {
            if (this.m_factory == null) {
                throw new SplusLoginException(this.m_strErrorMsg);
            }
            return this.m_factory;
        }

        public LookupThread(String string, int n) {
            this.m_strLookupURL = "rmi://" + string + ':' + n + "/SplusSessionServer";
        }

        public void run() {
            try {
                this.m_factory = (SplusSessionFactory)Naming.lookup(this.m_strLookupURL);
            }
            catch (MalformedURLException malformedURLException) {
                this.m_strErrorMsg = "Could not access RMI host\nBad URL:  \"" + this.m_strLookupURL + '\"' + SplusLogin.s_strEOL + "Check server hostname and rmi port.";
            }
            catch (RemoteException remoteException) {
                this.m_strErrorMsg = "RMI server not responding at\n  \"" + this.m_strLookupURL + '\"' + SplusLogin.s_strEOL + "Make sure that the hostname is correct and " + "that an RMI server has been started.";
            }
            catch (NotBoundException notBoundException) {
                this.m_strErrorMsg = "The S-PLUS session factory is not responding\nMake sure that an S-PLUS session factory is running on host\n  \"" + this.m_strLookupURL + '\"';
            }
        }
    }

    public class SplusLoginFatalException
    extends Exception {
        public SplusLoginFatalException(String string) {
            super(string);
        }
    }

    public class SplusLoginException
    extends Exception {
        public SplusLoginException(String string) {
            super(string);
        }
    }
}

