/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.splus;

import com.insightful.controls.SplusButton;
import com.insightful.controls.SplusCheckBox;
import com.insightful.controls.SplusGroupPanel;
import com.insightful.controls.SplusStaticTextField;
import com.insightful.controls.SplusTextField;
import com.insightful.splus.SplusAltKeyListener;
import com.insightful.splus.SplusSessionFactory;
import com.insightful.splus.SplusSessionFactoryFloor;
import com.insightful.splus.SplusSessionListEntry;
import com.insightful.splus.util.NamedTableScrollPane;
import com.insightful.splus.util.SimpleHelpDialog;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.net.InetAddress;
import java.rmi.Naming;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;

public class SplusServerToolsDialog
extends JDialog {
    private static boolean g_isWin = System.getProperty("os.name").toLowerCase().indexOf("windows") >= 0;
    private JPanel buttonPanel;
    private JPanel centerPanel;
    private SplusGroupPanel factoryGroup;
    private SplusGroupPanel logGroup;
    private SplusGroupPanel sessionGroup;
    private JButton closeButton;
    private JButton helpButton;
    private SplusButton startButton;
    private SplusButton stopButton;
    private SplusButton logButton;
    private SplusButton refreshButton;
    private SplusButton killButton;
    private ButtonListener buttonListener;
    private PortFieldListener portFieldListener;
    private LogFieldListener logFieldListener;
    private maxSessionsFieldListener maxSessionsFieldListener;
    private SplusSessionFactory factory;
    private SplusStaticTextField factoryStatusText;
    private SplusStaticTextField sessionStatusText;
    private SplusTextField portField;
    private SplusTextField maxSessionsField;
    private SplusTextField logFileField;
    private SplusCheckBox rotateLog;
    private LocalTableModel tableModel;
    private NamedTableScrollPane tableScrollPane;
    private static final String DEFAULT_PORT = "1099";
    private static final String DEFAULT_MAX_SESSIONS = "100";
    private static final Cursor WAIT_CURSOR = Cursor.getPredefinedCursor(3);
    private Cursor savedCursor;
    private static String shomeValue = System.getProperty("splus.shome");
    private static String helpFile = null;
    private SimpleHelpDialog helpDialog = null;
    private JDialog thisDialog = this;

    public SplusServerToolsDialog() {
        this((String)null);
    }

    public SplusServerToolsDialog(String string) {
        this.setTitle("S-PLUS Server Tools");
        this.setModal(true);
        this.portField = new SplusTextField("Port Number", 'P');
        if (string == null) {
            this.portField.setValue(DEFAULT_PORT);
        } else {
            this.portField.setValue(string);
            this.getPortNumber();
        }
        this.portFieldListener = new PortFieldListener();
        this.portField.addActionListener(this.portFieldListener);
        this.portField.registerKeyboardAction(this.portFieldListener, KeyStroke.getKeyStroke(10, 0), 1);
        this.factory = this.getFactory();
        this.buttonListener = new ButtonListener();
        this.centerPanel = new JPanel();
        this.centerPanel.setLayout(new BoxLayout(this.centerPanel, 1));
        Box box = new Box(0);
        this.centerPanel.add(box);
        this.factoryGroup = new SplusGroupPanel("Session Factory");
        box.add(this.factoryGroup);
        this.factoryStatusText = new SplusStaticTextField("Status: " + (this.factory != null ? "Running" : "Not Running"));
        this.factoryGroup.add(this.factoryStatusText);
        this.factoryGroup.add(this.portField);
        this.maxSessionsField = new SplusTextField("Max Sessions", 'M');
        try {
            this.maxSessionsField.setValue(this.factory == null ? DEFAULT_MAX_SESSIONS : Integer.toString(this.factory.getMaxSessions()));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.factoryGroup.add(this.maxSessionsField);
        this.maxSessionsFieldListener = new maxSessionsFieldListener();
        this.maxSessionsField.addActionListener(this.maxSessionsFieldListener);
        this.maxSessionsField.registerKeyboardAction(this.maxSessionsFieldListener, KeyStroke.getKeyStroke(10, 0), 1);
        this.startButton = new SplusButton("Start", 'S');
        this.startButton.setEnabled(this.factory == null);
        this.startButton.addActionListener(this.buttonListener);
        this.stopButton = new SplusButton("Stop", 'T');
        this.stopButton.setEnabled(this.factory != null);
        this.stopButton.addActionListener(this.buttonListener);
        Box box2 = new Box(0);
        box2.add(Box.createHorizontalStrut(5));
        Box box3 = new Box(1);
        box2.add(box3);
        box3.add(this.startButton);
        box3.add(Box.createVerticalStrut(5));
        box3.add(this.stopButton);
        box2.add(Box.createHorizontalGlue());
        this.factoryGroup.add(Box.createVerticalStrut(5));
        this.factoryGroup.add(box2);
        this.factoryGroup.add(Box.createVerticalStrut(5));
        this.logGroup = new SplusGroupPanel("Log File");
        box.add(this.logGroup);
        this.logFileField = new SplusTextField("Log File Name", 'L');
        this.logFileField.setEnabled(this.factory != null);
        try {
            if (this.factory != null) {
                this.logFileField.setValue(this.factory.getLogFileName());
            }
        }
        catch (Exception exception) {
            this.logFileField.setValue("");
        }
        this.logGroup.add(this.logFileField);
        this.logFieldListener = new LogFieldListener();
        this.logFileField.addActionListener(this.logFieldListener);
        this.logFileField.registerKeyboardAction(this.logFieldListener, KeyStroke.getKeyStroke(10, 0), 1);
        this.rotateLog = new SplusCheckBox("Rotate Log Daily", 'D');
        this.rotateLog.setEnabled(this.factory != null);
        try {
            if (this.factory != null) {
                this.rotateLog.setValue(this.factory.getLogRotateFlag() ? "T" : "F");
            }
        }
        catch (Exception exception) {
            this.rotateLog.setValue("F");
        }
        this.logGroup.add(this.rotateLog);
        this.rotateLog.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    if (SplusServerToolsDialog.this.factory != null) {
                        SplusServerToolsDialog.this.factory.setLogRotateFlag(SplusServerToolsDialog.this.rotateLog.isSelected());
                    }
                }
                catch (Exception exception) {
                    JOptionPane.showMessageDialog(SplusServerToolsDialog.this.thisDialog, "Cannot set rotate log flag.  Exception thrown:\n" + exception.toString(), "Set Rotate Log Error", 0);
                }
            }
        });
        this.logButton = new SplusButton("View", 'V');
        this.logButton.setEnabled(this.factory != null);
        this.logButton.addActionListener(this.buttonListener);
        Box box4 = new Box(0);
        box4.add(Box.createHorizontalStrut(5));
        box4.add(this.logButton);
        box4.add(Box.createHorizontalGlue());
        this.logGroup.add(Box.createVerticalStrut(5));
        this.logGroup.add(box4);
        this.logGroup.add(Box.createVerticalStrut(5));
        this.sessionGroup = new SplusGroupPanel("Sessions");
        this.centerPanel.add(this.sessionGroup);
        this.tableModel = new LocalTableModel();
        this.sessionStatusText = new SplusStaticTextField("Number of Sessions: " + Integer.toString(this.tableModel.getRowCount()));
        this.sessionGroup.add(this.sessionStatusText);
        this.refreshButton = new SplusButton("Refresh", 'R');
        if (this.factory == null) {
            this.refreshButton.setEnabled(false);
        }
        this.refreshButton.addActionListener(this.buttonListener);
        this.killButton = new SplusButton("Kill", 'K');
        this.killButton.setEnabled(false);
        this.killButton.addActionListener(this.buttonListener);
        Box box5 = new Box(0);
        box5.add(Box.createHorizontalStrut(5));
        Box box6 = new Box(1);
        box5.add(box6);
        box6.add(this.refreshButton);
        box6.add(Box.createVerticalStrut(5));
        box6.add(this.killButton);
        box5.add(Box.createHorizontalGlue());
        this.sessionGroup.add(Box.createVerticalStrut(5));
        this.sessionGroup.add(box5);
        this.sessionGroup.add(Box.createVerticalStrut(5));
        this.tableScrollPane = new NamedTableScrollPane(this.tableModel, null);
        this.tableScrollPane.getTable().setRowSelectionAllowed(true);
        ListSelectionModel listSelectionModel = this.tableScrollPane.getTable().getSelectionModel();
        listSelectionModel.setSelectionMode(0);
        listSelectionModel.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                SplusServerToolsDialog.this.killButton.setEnabled(true);
            }
        });
        this.sessionGroup.add(this.tableScrollPane);
        this.buttonPanel = new JPanel();
        this.closeButton = new JButton("Close");
        this.closeButton.addActionListener(this.buttonListener);
        this.helpButton = new JButton("Help");
        this.helpButton.addActionListener(this.buttonListener);
        this.buttonPanel.add(this.closeButton);
        this.buttonPanel.add(Box.createHorizontalGlue());
        this.buttonPanel.add(this.helpButton);
        this.getContentPane().add((Component)this.centerPanel, "Center");
        this.getContentPane().add((Component)this.buttonPanel, "South");
        this.closeButton.registerKeyboardAction(this.buttonListener, KeyStroke.getKeyStroke("ESCAPE"), 2);
        this.getRootPane().addKeyListener(new SplusAltKeyListener(this));
        this.setSize(650, 550);
        Dimension dimension = this.getSize();
        Dimension dimension2 = this.getToolkit().getScreenSize();
        this.setLocation((dimension2.width - dimension.width) / 2, (dimension2.height - dimension.height) / 2);
    }

    public static void main(String[] stringArray) {
        SplusServerToolsDialog splusServerToolsDialog = stringArray.length > 0 ? new SplusServerToolsDialog(stringArray[0]) : new SplusServerToolsDialog();
        splusServerToolsDialog.show();
        System.exit(0);
    }

    private boolean checkFactoryRunning() {
        return this.getFactory() == null;
    }

    private String getPortNumber() {
        if (this.portField == null) {
            return DEFAULT_PORT;
        }
        String string = this.portField.getValue();
        try {
            Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            string = DEFAULT_PORT;
            this.portField.setValue(string);
        }
        return string;
    }

    private void refreshControls() {
        this.factory = this.getFactory();
        this.startButton.setEnabled(this.factory == null);
        this.stopButton.setEnabled(this.factory != null);
        this.refreshButton.setEnabled(this.factory != null);
        this.factoryStatusText.setText("Status: " + (this.factory != null ? "Running" : "Not Running"));
        this.logFileField.setEnabled(this.factory != null);
        this.rotateLog.setEnabled(this.factory != null);
        this.logButton.setEnabled(this.factory != null);
        if (this.factory != null) {
            try {
                this.maxSessionsField.setValue(Integer.toString(this.factory.getMaxSessions()));
                this.logFileField.setValue(this.factory.getLogFileName());
                this.rotateLog.setValue(this.factory.getLogRotateFlag() ? "T" : "F");
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else {
            this.logFileField.setValue("");
            this.rotateLog.setValue("F");
        }
        this.tableModel.refresh();
        this.sessionStatusText.setText("Number of Sessions: " + Integer.toString(this.tableModel.getRowCount()));
    }

    private SplusSessionFactory getFactory() {
        SplusSessionFactory splusSessionFactory = null;
        try {
            splusSessionFactory = (SplusSessionFactory)Naming.lookup("rmi://" + InetAddress.getLocalHost().getHostName() + ":" + this.getPortNumber() + "/SplusSessionServer");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return splusSessionFactory;
    }

    private void stopFactory() {
        int n = Integer.parseInt(this.getPortNumber());
        try {
            SplusSessionFactory splusSessionFactory = this.getFactory();
            if (splusSessionFactory != null) {
                String[] stringArray = splusSessionFactory.getSessionIDs();
                if (stringArray != null) {
                    for (int i = 0; i < stringArray.length; ++i) {
                        SplusSessionFactoryFloor.endSession(stringArray[i], n);
                    }
                }
                splusSessionFactory.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            Naming.unbind("rmi://" + InetAddress.getLocalHost().getHostName() + ":" + n + "/SplusSessionServer");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String findCertFile(String string) {
        File file;
        String string2 = null;
        try {
            string2 = InetAddress.getLocalHost().getHostName();
            if (string2 == null || string2.length() == 0) {
                return null;
            }
        }
        catch (Exception exception) {
            return null;
        }
        String string3 = System.getProperty("splus.ssl.keystore");
        if (string3 == null || string3.length() == 0) {
            string3 = System.getProperty("splus.shome") + "/adm/spkey." + string2;
            if (string != null && string.length() != 0) {
                try {
                    int n = Integer.decode(string);
                    String string4 = string3 + "." + string;
                    File file2 = new File(string4);
                    if (file2.exists()) {
                        if (file2.canRead()) {
                            string3 = string4;
                        } else {
                            JOptionPane.showMessageDialog(this, "Warning: read access to keystore, \"" + string4 + "\", " + "is denied.\n  Trying keystore \"" + string3 + "\".", "Start-Up Error", 2);
                            System.exit(1);
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (!(file = new File(string3)).exists()) {
            return null;
        }
        if (!file.canRead()) {
            JOptionPane.showMessageDialog(this, "Cannot read keyfile, \"" + string3 + "\", in findCertFile.", "Start-Up Error", 2);
            System.exit(1);
        }
        return string3;
    }

    private class LocalLogViewer
    extends JDialog {
        private JDialog thisLogViewer;

        private LocalLogViewer(Dialog dialog) {
            super(dialog, "Session Factory Log", true);
            this.thisLogViewer = this;
            try {
                this.setSize(700, 400);
                JEditorPane jEditorPane = new JEditorPane("file:" + SplusServerToolsDialog.this.logFileField.getValue());
                jEditorPane.setEditable(false);
                JScrollPane jScrollPane = new JScrollPane(jEditorPane);
                this.getContentPane().add(jScrollPane);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    LocalLogViewer.this.thisLogViewer.dispose();
                }
            });
        }
    }

    private class LocalTableModel
    extends AbstractTableModel {
        private int numCols = 7;
        private final String[] colNames = new String[]{"Session ID", "User ID", "Session Host", "Port Number", "Display", "Help Host", "Work Dir"};
        private int sessionCount = 0;
        private SplusSessionListEntry[] sessionList;
        private String[][] sessionListInfo;

        public LocalTableModel() {
            this.refresh();
        }

        public int getColumnCount() {
            return this.numCols;
        }

        public int getRowCount() {
            return this.sessionCount;
        }

        public Object getValueAt(int n, int n2) {
            return this.sessionListInfo[n][n2];
        }

        public String getColumnName(int n) {
            return this.colNames[n];
        }

        public void refresh() {
            int n;
            SplusServerToolsDialog.this.factory = SplusServerToolsDialog.this.getFactory();
            if (SplusServerToolsDialog.this.factory == null) {
                boolean bl = this.sessionCount != 0;
                this.sessionCount = 0;
                this.sessionList = new SplusSessionListEntry[0];
                this.sessionListInfo = new String[0][this.numCols];
                if (bl) {
                    this.fireTableStructureChanged();
                }
                return;
            }
            try {
                this.sessionList = SplusServerToolsDialog.this.factory.getEntries();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            if (this.sessionList == null) {
                this.sessionList = new SplusSessionListEntry[0];
            }
            this.sessionCount = this.sessionList.length;
            boolean bl = this.sessionListInfo == null || this.sessionCount != this.sessionListInfo.length;
            for (n = 0; !bl && n < this.sessionCount; ++n) {
                if (this.sessionList[n].getSessionID().equals(this.sessionListInfo[n][0])) continue;
                bl = true;
            }
            if (bl) {
                this.sessionListInfo = new String[this.sessionCount][this.numCols];
                for (n = 0; n < this.sessionCount; ++n) {
                    this.sessionListInfo[n][0] = this.sessionList[n].getSessionID();
                    this.sessionListInfo[n][1] = this.sessionList[n].getUserID();
                    this.sessionListInfo[n][2] = this.sessionList[n].getSessionHost();
                    this.sessionListInfo[n][3] = Integer.toString(this.sessionList[n].getPort());
                    this.sessionListInfo[n][4] = this.sessionList[n].getDisplayTo();
                    this.sessionListInfo[n][5] = this.sessionList[n].getHelpHost();
                    this.sessionListInfo[n][6] = this.sessionList[n].getWorkDir();
                }
                this.fireTableStructureChanged();
            }
        }
    }

    private class LogFieldListener
    implements ActionListener {
        private LogFieldListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (SplusServerToolsDialog.this.factory != null) {
                try {
                    String string = SplusServerToolsDialog.this.factory.getLogFileName();
                    String string2 = SplusServerToolsDialog.this.logFileField.getValue();
                    if (!string.equals(string2)) {
                        SplusServerToolsDialog.this.factory.setLogFileName(string2);
                    }
                }
                catch (Exception exception) {
                    JOptionPane.showMessageDialog(SplusServerToolsDialog.this.thisDialog, "Cannot set log file name.  Exception thrown:\n" + exception.toString(), "Set Log File Name Error", 0);
                }
            }
        }
    }

    private class maxSessionsFieldListener
    implements ActionListener {
        private maxSessionsFieldListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                int n = Integer.parseInt(SplusServerToolsDialog.this.maxSessionsField.getValue());
                if (SplusServerToolsDialog.this.factory != null) {
                    SplusServerToolsDialog.this.factory.setMaxSessions(n);
                }
            }
            catch (Exception exception) {
                SplusServerToolsDialog.this.maxSessionsField.setValue(SplusServerToolsDialog.DEFAULT_MAX_SESSIONS);
            }
        }
    }

    private class PortFieldListener
    implements ActionListener {
        private PortFieldListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SplusServerToolsDialog.this.refreshControls();
        }
    }

    private class ButtonListener
    implements ActionListener {
        private ButtonListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JButton jButton = (JButton)actionEvent.getSource();
            if (jButton == SplusServerToolsDialog.this.closeButton) {
                SplusServerToolsDialog.this.dispose();
            } else if (jButton == SplusServerToolsDialog.this.helpButton) {
                if (SplusServerToolsDialog.this.helpDialog == null && helpFile == null) {
                    if (shomeValue == null || shomeValue.length() == 0) {
                        throw new RuntimeException("splus.shome not set");
                    }
                    helpFile = "file:" + shomeValue + "/java/doc/ServerTools.htm";
                    SplusServerToolsDialog.this.helpDialog = new SimpleHelpDialog((Dialog)SplusServerToolsDialog.this.thisDialog, "S-PLUS Server Tools Help", helpFile);
                }
                SplusServerToolsDialog.this.helpDialog.showTopic("S_PLUS_Server_Tools_Dialog");
            } else {
                SplusServerToolsDialog.this.savedCursor = SplusServerToolsDialog.this.getCursor();
                SplusServerToolsDialog.this.setCursor(WAIT_CURSOR);
                if (jButton == SplusServerToolsDialog.this.startButton) {
                    String string = SplusServerToolsDialog.this.findCertFile(SplusServerToolsDialog.this.getPortNumber());
                    if (string != null) {
                        JOptionPane.showMessageDialog(SplusServerToolsDialog.this.buttonPanel, "SSL configuration detected...\n\nPlease start from the command-line", "Start-Up Error", 2);
                    } else {
                        try {
                            if (shomeValue == null || shomeValue.length() == 0) {
                                throw new RuntimeException("splus.shome not set");
                            }
                            StringBuffer stringBuffer = new StringBuffer();
                            if (g_isWin) {
                                String string2 = System.getProperty("java.class.path", ".");
                                String string3 = System.getProperty("java.home", shomeValue + "/java/jre");
                                stringBuffer.append(string3);
                                stringBuffer.append("/bin/java.exe");
                                stringBuffer.append(" -classpath \"");
                                stringBuffer.append(string2);
                                stringBuffer.append("\"");
                                stringBuffer.append(" -Dsplus.shome=\"");
                                stringBuffer.append(shomeValue);
                                stringBuffer.append("\"");
                                stringBuffer.append(" com.insightful.splus.SplusSessionFactoryStart ");
                            } else {
                                stringBuffer.append(shomeValue);
                                stringBuffer.append("/cmd/SESSION -factory ");
                            }
                            stringBuffer.append(SplusServerToolsDialog.this.getPortNumber());
                            Runtime.getRuntime().exec(stringBuffer.toString());
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                            SplusServerToolsDialog.this.setCursor(SplusServerToolsDialog.this.savedCursor);
                        }
                        SplusServerToolsDialog.this.factory = SplusServerToolsDialog.this.getFactory();
                        while (SplusServerToolsDialog.this.factory == null) {
                            try {
                                Thread.currentThread();
                                Thread.sleep(1000L);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            SplusServerToolsDialog.this.factory = SplusServerToolsDialog.this.getFactory();
                        }
                        try {
                            SplusServerToolsDialog.this.factory.setMaxSessions(Integer.parseInt(SplusServerToolsDialog.this.maxSessionsField.getValue()));
                        }
                        catch (Exception exception) {
                            SplusServerToolsDialog.this.maxSessionsField.setValue(SplusServerToolsDialog.DEFAULT_MAX_SESSIONS);
                        }
                    }
                    SplusServerToolsDialog.this.refreshControls();
                } else if (jButton == SplusServerToolsDialog.this.stopButton) {
                    SplusServerToolsDialog.this.stopFactory();
                    SplusServerToolsDialog.this.refreshControls();
                    SplusServerToolsDialog.this.killButton.setEnabled(false);
                } else if (jButton == SplusServerToolsDialog.this.logButton) {
                    if (new File(SplusServerToolsDialog.this.logFileField.getValue()).exists()) {
                        new LocalLogViewer(SplusServerToolsDialog.this.thisDialog).show();
                    } else {
                        JOptionPane.showMessageDialog(SplusServerToolsDialog.this.thisDialog, "Cannot display log.  File does not exist.", "View Log Error", 0);
                    }
                } else if (jButton == SplusServerToolsDialog.this.refreshButton) {
                    SplusServerToolsDialog.this.tableModel.refresh();
                    SplusServerToolsDialog.this.tableScrollPane.getTable().getSelectionModel().clearSelection();
                    SplusServerToolsDialog.this.sessionStatusText.setText("Number of Sessions: " + Integer.toString(SplusServerToolsDialog.this.tableModel.getRowCount()));
                    SplusServerToolsDialog.this.killButton.setEnabled(false);
                } else if (jButton == SplusServerToolsDialog.this.killButton) {
                    int n = SplusServerToolsDialog.this.tableScrollPane.getTable().getSelectedRow();
                    String string = (String)SplusServerToolsDialog.this.tableModel.getValueAt(n, 0);
                    SplusSessionFactoryFloor.endSession(string, Integer.parseInt(SplusServerToolsDialog.this.getPortNumber()));
                    SplusServerToolsDialog.this.tableModel.refresh();
                    SplusServerToolsDialog.this.tableScrollPane.getTable().getSelectionModel().clearSelection();
                    SplusServerToolsDialog.this.sessionStatusText.setText("Number of Sessions: " + Integer.toString(SplusServerToolsDialog.this.tableModel.getRowCount()));
                    SplusServerToolsDialog.this.killButton.setEnabled(false);
                }
                SplusServerToolsDialog.this.setCursor(SplusServerToolsDialog.this.savedCursor);
            }
        }
    }
}

