/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.splus.client;

import com.insightful.splus.ClientUtilities;
import com.insightful.splus.SplusDataResult;
import com.insightful.splus.SplusSystem;
import com.insightful.splus.client.ServerFile;
import java.io.File;
import java.io.IOException;
import java.util.Hashtable;
import javax.swing.Icon;
import javax.swing.UIManager;
import javax.swing.filechooser.FileSystemView;

public class ServerFileSystemView
extends FileSystemView {
    private static int queryTimeout = 600000;
    private static ServerFile homeDir = null;
    private boolean cacheLastGetFiles = true;
    private String lastGetFilesName = "";
    private File[] lastGetFilesValue = new ServerFile[0];
    private ClientUtilities m_utils = null;
    private Hashtable m_storedFiles = new Hashtable();
    private Hashtable m_storedTimes = new Hashtable();
    private long m_threshholdTime = 5000L;
    private static final String INVOKE_CLASS_NAME = "com/insightful/splus/client/ServerFileSystemView";
    private static final String INVOKE_METHOD_NAME = "serverSideFileInfoQuery";
    private static Class[] INVOKE_PARAMETER_TYPES = null;
    private Object lockObject = new Object();
    private static FileSystemView m_serverSideFileSystemView = FileSystemView.getFileSystemView();

    private File getFileObject(String string, boolean bl) {
        String string2 = string;
        File file = (File)this.m_storedFiles.get(string2);
        boolean bl2 = false;
        if (file != null) {
            long l = (Long)this.m_storedTimes.get(string2);
            if (System.currentTimeMillis() - l > this.m_threshholdTime) {
                file = null;
                bl2 = true;
            }
        } else {
            bl2 = true;
        }
        if (bl && bl2) {
            ServerFile[] serverFileArray = this.clientSideFileInfoQuery(string2, false, false);
            if (serverFileArray == null || serverFileArray.length == 0) {
                file = new ServerFile(string2);
            } else {
                file = serverFileArray[0];
                this.m_storedFiles.put(string2, file);
                this.m_storedTimes.put(string2, new Long(System.currentTimeMillis()));
            }
        }
        return file;
    }

    public ServerFileSystemView() {
        this.getFiles(SplusSystem.getCwd(), true);
    }

    public ServerFileSystemView(ClientUtilities clientUtilities) {
        this.m_utils = clientUtilities;
        this.getFiles(SplusSystem.getCwd(), true);
    }

    public File createFileObject(String string) {
        return this.getFileObject(string, true);
    }

    public File createFileObject(File file, String string) {
        String string2 = file.getPath();
        if (!string2.endsWith("/")) {
            string2 = string2 + "/";
        }
        return this.getFileObject(string2 + string, true);
    }

    public File createNewFolder(File file) throws IOException {
        if (file == null) {
            throw new IOException("Containing directory is null");
        }
        ServerFile serverFile = null;
        serverFile = new ServerFile(file, "NewFolder", true);
        boolean bl = ((File)serverFile).exists();
        for (int i = 1; bl && i < 100; ++i) {
            serverFile = new ServerFile(file, "NewFolder." + i, true);
            bl = ((File)serverFile).exists();
        }
        if (bl) {
            throw new IOException("Directory already exists: " + ((File)serverFile).getAbsolutePath());
        }
        boolean bl2 = ((File)serverFile).mkdir();
        if (!bl2) {
            throw new IOException("Cannot create directory:\n" + ((File)serverFile).getAbsolutePath());
        }
        if (this.cacheLastGetFiles) {
            this.lastGetFilesName = "";
            this.lastGetFilesValue = new ServerFile[0];
        }
        return serverFile;
    }

    public File[] getFiles(File file, boolean bl) {
        if (file == null) {
            return new ServerFile[0];
        }
        String string = file.getPath();
        if (this.cacheLastGetFiles) {
            if (!this.lastGetFilesName.equals(string)) {
                this.lastGetFilesValue = this.clientSideFileInfoQuery(string, true, bl);
                this.lastGetFilesName = string;
            }
            return this.lastGetFilesValue;
        }
        return this.clientSideFileInfoQuery(string, true, bl);
    }

    public File getHomeDirectory() {
        if (homeDir == null) {
            homeDir = this.queryHomeDir();
        }
        return homeDir;
    }

    public File getParentDirectory(File file) {
        return file.getParentFile();
    }

    public File[] getRoots() {
        return ServerFile.listRoots();
    }

    public boolean isHiddenFile(File file) {
        return file.isHidden();
    }

    public boolean isRoot(File file) {
        return file.getPath().equals("/");
    }

    protected File createFileSystemRoot(File file) {
        return new ServerFile("/");
    }

    public File getChild(File file, String string) {
        return this.createFileObject(file, string);
    }

    public File getDefaultDirectory() {
        return this.getHomeDirectory();
    }

    public String getSystemDisplayName(File file) {
        return file == null ? null : file.getName();
    }

    public Icon getSystemIcon(File file) {
        return file == null ? null : UIManager.getIcon(file.isDirectory() ? "FileView.directoryIcon" : "FileView.fileIcon");
    }

    public String getSystemTypeDescription(File file) {
        return null;
    }

    public boolean isComputerNode(File file) {
        return false;
    }

    public boolean isDrive(File file) {
        return false;
    }

    public boolean isFileSystem(File file) {
        return true;
    }

    public boolean isFileSystemRoot(File file) {
        return file != null && file.getParent() == null;
    }

    public boolean isFloppyDrive(File file) {
        return false;
    }

    public boolean isParent(File file, File file2) {
        if (file == null || file2 == null) {
            return false;
        }
        return file.equals(file2.getParentFile());
    }

    public Boolean isTraversable(File file) {
        return file.isDirectory();
    }

    private ServerFile queryHomeDir() {
        String string = "/";
        try {
            String string2 = "getenv('PWD')";
            SplusDataResult splusDataResult = SplusSystem.getEngineQueryHandler().processDataQuery(string2, queryTimeout);
            string = splusDataResult.getStringData()[0];
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return new ServerFile(string, true);
    }

    public ServerFile[] clientSideFileInfoQuery(String string, boolean bl) {
        return this.clientSideFileInfoQuery(string, true, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServerFile[] clientSideFileInfoQuery(String string, boolean bl, boolean bl2) {
        ServerFile[] serverFileArray;
        int n;
        String[] stringArray = null;
        for (n = 0; n < 10; ++n) {
            try {
                if (INVOKE_PARAMETER_TYPES == null) {
                    INVOKE_PARAMETER_TYPES = new Class[]{Class.forName("java.lang.String"), Boolean.TYPE, Boolean.TYPE};
                }
                serverFileArray = this.lockObject;
                synchronized (this.lockObject) {
                    stringArray = (String[])this.m_utils.invokeStaticMethod(INVOKE_CLASS_NAME, INVOKE_METHOD_NAME, INVOKE_PARAMETER_TYPES, new Object[]{string, new Boolean(bl), new Boolean(bl2)});
                    // ** MonitorExit[var6_7] (shouldn't be in output)
                    if (stringArray != null) break;
                    stringArray = new String[]{};
                    break;
                }
            }
            catch (Exception exception) {
                stringArray = new String[]{};
                continue;
            }
        }
        {
            n = stringArray.length / 7;
            serverFileArray = new ServerFile[n];
            int n2 = 0;
            for (int i = 0; i < n; ++i) {
                String string2 = stringArray[n2++];
                String string3 = stringArray[n2++];
                String string4 = stringArray[n2++];
                String string5 = stringArray[n2++];
                String string6 = stringArray[n2++];
                String string7 = stringArray[n2++];
                String string8 = stringArray[n2++];
                boolean bl3 = string6.charAt(0) == 't';
                int n3 = string2.length();
                if (bl) {
                    serverFileArray[i] = new ServerFile(string, string2, bl3);
                } else if (string.equals(string2)) {
                    serverFileArray[i] = new ServerFile(string, bl3);
                } else {
                    int n4 = string.indexOf(string2);
                    String string9 = string.substring(0, n4 > 0 ? n4 : string.length());
                    serverFileArray[i] = new ServerFile(string9, string2, bl3);
                }
                serverFileArray[i].setLastModified(Long.parseLong(string8));
                serverFileArray[i].setLength(Long.parseLong(string7));
                serverFileArray[i].setExists(string3.charAt(0) == 't');
                serverFileArray[i].setIsDir(bl3);
                serverFileArray[i].setCanRead(string4.charAt(0) == 't');
                serverFileArray[i].setCanWrite(string5.charAt(0) == 't');
            }
            return serverFileArray;
        }
    }

    public static String[] serverSideFileInfoQuery(String string, boolean bl, boolean bl2) {
        String[] stringArray;
        if (System.getProperty("splus.client.mode", "").equals("true")) {
            return new String[0];
        }
        if (bl) {
            stringArray = ServerFileSystemView.getServerFilesInDir(string, bl2);
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = string;
        }
        String[] stringArray3 = stringArray;
        if (stringArray3 == null) {
            return new String[0];
        }
        String[] stringArray4 = new String[stringArray3.length * 7];
        File file = null;
        int n = 0;
        for (int i = 0; i < stringArray3.length; ++i) {
            file = bl ? (string.endsWith("/") ? new File(string + stringArray3[i]) : new File(string + "/" + stringArray3[i])) : new File(stringArray3[i]);
            stringArray4[n++] = file.getName();
            stringArray4[n++] = Boolean.toString(file.exists());
            stringArray4[n++] = Boolean.toString(file.canRead());
            stringArray4[n++] = Boolean.toString(file.canWrite());
            stringArray4[n++] = Boolean.toString(file.isDirectory());
            stringArray4[n++] = Long.toString(file.length());
            stringArray4[n++] = Long.toString(file.lastModified());
        }
        return stringArray4;
    }

    private static String[] getServerFilesInDir(String string, boolean bl) {
        File file = new File(string);
        String[] stringArray = null;
        if (file.isDirectory()) {
            int n;
            File[] fileArray = file.listFiles();
            String[] stringArray2 = new String[fileArray.length];
            for (n = 0; n < fileArray.length; ++n) {
                stringArray2[n] = fileArray[n].getName();
            }
            if (bl) {
                int n2;
                n = 0;
                for (n2 = 0; n2 < fileArray.length; ++n2) {
                    if (stringArray2[n2].startsWith(".")) continue;
                    ++n;
                }
                stringArray = new String[n];
                int n3 = 0;
                for (n2 = 0; n2 < fileArray.length; ++n2) {
                    if (stringArray2[n2].startsWith(".")) continue;
                    stringArray[n3++] = stringArray2[n2];
                }
            } else {
                stringArray = stringArray2;
            }
        } else {
            stringArray = new String[]{string};
        }
        return stringArray;
    }
}

