/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.splus.dataview;

import com.insightful.controls.SplusBoxFiller;
import com.insightful.controls.SplusButton;
import com.insightful.controls.SplusCheckBox;
import com.insightful.controls.SplusControlMetrics;
import com.insightful.controls.SplusDialog;
import com.insightful.controls.SplusFunctionInfo;
import com.insightful.controls.SplusGroupPanel;
import com.insightful.controls.SplusInvisibleControl;
import com.insightful.controls.SplusTextField;
import com.insightful.controls.SplusWideBoxFiller;
import com.insightful.controls.SplusWideComboBox;
import com.insightful.controls.SplusWideTextField;
import com.insightful.splus.SplusDataSetComboBox;
import com.insightful.splus.SplusSystem;
import com.insightful.splus.client.ServerFile;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.filechooser.FileFilter;

public class ExportDataDialog
extends SplusDialog {
    SplusFunctionInfo funcInfo;
    SplusDataSetComboBox dataSet;
    SplusWideTextField fileName;
    SplusWideTextField keepCols;
    SplusWideTextField dropCols;
    SplusWideTextField filterRows;
    ExportFileTypeControl fileTypeControl;
    SplusInvisibleControl fileTypeCode;
    SplusButton fileButton;
    JFileChooser fileChooser = null;
    SplusTextField textDelimiter;
    SplusTextField textFormat;
    SplusCheckBox saveColNames;
    SplusCheckBox saveRowNames;
    SplusCheckBox quoteStrings;
    int fileChooserReturnValue = 1;
    JDialog fileChooserDialog = null;
    private static String[] typeCodeList = new String[]{"", "ASCII", "ASCII", "ASCII", "ASCII", "DBASE", "EXCEL", "EXCELX", "FASCII", "GAUSS", "GAUSS96", "HTML", "LOTUS", "MATLAB", "MINITAB", "QUATTRO", "SAS7", "SAS", "SAS1", "SAS4", "SAS_TPT", "SPSS", "SPSSP", "STATA", "SYSTAT"};
    private static String[] typeDescriptionList = new String[]{"Unspecified file format", "ASCII file - space delimited (*.asc;*.dat;*.txt;*.prn)", "ASCII file - tab delimited (*.asc;*.dat;*.txt;*.prn)", "ASCII file - comma delimited (*.csv)", "ASCII file - user-defined delimiter (*.asc;*.dat;*.txt;*.prn)", "dBASE file (*.dbf)", "Excel Worksheet (*.xls)", "Excel 2007 Worksheet (*.xlsx)", "Fixed Format ASCII File (*.fix;*.fsc)", "Gauss Data File (*.dat)", "Gauss Data File - Unix (*.dat)", "HTML File (*.htm; *.html)", "Lotus 1-2-3 Worksheet (*.wks;*.wk1;*.wk3;*.wk4;*.wrk)", "Matlab Matrix (*.mat)", "Mintab Workbook (*.mtw)", "Quattro Pro Worksheet (*.wq1;*.wb2;*.wb3)", "SAS Version 7/8/9 (*.sas7bdat)", "SAS - Windows/OS2 (*.sd2)", "SAS - HP IBM & SUN Unix (*.ssd01)", "SAS - Dec Unix (*.ssd04)", "SAS Transport File (*.tpt;*.xpt)", "SPSS Data File (*.sav)", "SPSS Portable Data File (*.por)", "Stata Data File (*.dta)", "Systat File (*.syd, *.sys)"};
    private static String[][] extensionList = new String[][]{{""}, {".asc", ".dat", ".txt", ".prn"}, {".asc", ".dat", ".txt", ".prn"}, {".csv"}, {".asc", ".dat", ".txt", ".prn"}, {".dbf"}, {".xls"}, {".xlsx"}, {".fix", ".fsc"}, {".dat"}, {".dat"}, {".htm", ".html"}, {".wks", ".wk1", ".wk3", ".wk4", ".wrk"}, {".mat"}, {".mtw"}, {".wq1", ".wb2", ".wb3"}, {".sas7bdat"}, {".sd2"}, {".ssd01"}, {".ssd04"}, {".tpt", ".xpt"}, {".sav"}, {".por"}, {".dta"}, {".syd", ".sys"}};
    private static int FCD_EXTRA_WIDTH = 50;

    public ExportDataDialog() {
        super("Export Data");
        JTabbedPane jTabbedPane = new JTabbedPane();
        SplusFunctionInfo splusFunctionInfo = new SplusFunctionInfo("menuExportData");
        this.setFunctionInfo(splusFunctionInfo);
        JPanel jPanel = new JPanel();
        jTabbedPane.addTab("Data", jPanel);
        Box box = new Box(0);
        Box box2 = new Box(0);
        Box box3 = new Box(1);
        Box box4 = new Box(1);
        box.add(box3);
        box.add(box4);
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.add(box);
        jPanel.add(box2);
        SplusGroupPanel splusGroupPanel = new SplusGroupPanel("Data Set Name");
        box3.add(splusGroupPanel);
        this.dataSet = new SplusDataSetComboBox();
        splusGroupPanel.add(this.dataSet);
        splusFunctionInfo.add(this.dataSet, "data");
        box4.add(new SplusBoxFiller(1));
        SplusGroupPanel splusGroupPanel2 = new SplusGroupPanel("File");
        box2.add(splusGroupPanel2);
        this.fileName = new SplusWideTextField("File Name", 'N');
        splusGroupPanel2.add(this.fileName);
        splusFunctionInfo.add(this.fileName, "file", true);
        this.fileButton = new SplusButton("Browse", 'B');
        this.fileButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n;
                if (ExportDataDialog.this.fileChooser == null) {
                    ExportDataDialog.this.fileChooser = new JFileChooser(SplusSystem.getCwd(), SplusSystem.getServerFileHandler().getServerFileSystemView());
                    ExportDataDialog.this.fileChooser.setDialogTitle("Select File");
                    for (n = 1; n < extensionList.length; ++n) {
                        ExportDataDialog.this.fileChooser.addChoosableFileFilter(new LocalExtensionFileFilter(extensionList[n], typeDescriptionList[n]));
                    }
                    ExportDataDialog.this.fileChooser.setFileFilter(ExportDataDialog.this.fileChooser.getAcceptAllFileFilter());
                }
                if ((n = ExportDataDialog.this.showFileChooserDialog()) == 0) {
                    ExportDataDialog.this.fileName.setValue(ServerFile.convertServerFilePath(ExportDataDialog.this.fileChooser.getSelectedFile().getAbsolutePath()));
                    String string = ExportDataDialog.this.fileChooser.getFileFilter().getDescription();
                    if (!string.startsWith("All")) {
                        ExportDataDialog.this.fileTypeControl.setValue(string);
                    }
                    SplusSystem.setCwd(ExportDataDialog.this.fileChooser.getCurrentDirectory());
                }
            }
        });
        Box box5 = new Box(0);
        box5.add(Box.createHorizontalGlue());
        box5.add(this.fileButton);
        box5.add(Box.createHorizontalStrut(10));
        splusGroupPanel2.add(Box.createVerticalStrut(5));
        splusGroupPanel2.add(box5);
        splusGroupPanel2.add(Box.createVerticalStrut(5));
        splusGroupPanel2.add(Box.createVerticalStrut(SplusControlMetrics.getFullDimension().height));
        this.fileTypeControl = new ExportFileTypeControl();
        splusGroupPanel2.add(this.fileTypeControl);
        splusFunctionInfo.add(this.fileTypeControl, "");
        this.fileTypeCode = new SplusInvisibleControl("");
        splusGroupPanel2.add(this.fileTypeCode);
        splusFunctionInfo.add(this.fileTypeCode, "type", true);
        jPanel.add(new SplusWideBoxFiller());
        JPanel jPanel2 = new JPanel();
        jTabbedPane.addTab("Filter", jPanel2);
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        SplusGroupPanel splusGroupPanel3 = new SplusGroupPanel("Select Columns");
        jPanel2.add(splusGroupPanel3);
        this.keepCols = new SplusWideTextField("Keep Columns", 'K');
        splusGroupPanel3.add(this.keepCols);
        splusFunctionInfo.add(this.keepCols, "keep", true, true);
        this.dropCols = new SplusWideTextField("Drop Columns", 'D');
        splusGroupPanel3.add(this.dropCols);
        splusFunctionInfo.add(this.dropCols, "drop", true, true);
        SplusGroupPanel splusGroupPanel4 = new SplusGroupPanel("Select Rows");
        jPanel2.add(splusGroupPanel4);
        this.filterRows = new SplusWideTextField("Filter Rows", 'F');
        splusGroupPanel4.add(this.filterRows);
        splusFunctionInfo.add(this.filterRows, "filter", true);
        jPanel2.add(new SplusWideBoxFiller());
        JPanel jPanel3 = new JPanel();
        jTabbedPane.addTab("Format", jPanel3);
        Box box6 = new Box(1);
        Box box7 = new Box(1);
        jPanel3.setLayout(new BoxLayout(jPanel3, 0));
        jPanel3.add(box6);
        jPanel3.add(box7);
        SplusGroupPanel splusGroupPanel5 = new SplusGroupPanel("Export Names");
        box6.add(splusGroupPanel5);
        this.saveColNames = new SplusCheckBox("Export Column Names", 'C');
        this.saveColNames.setValue("T");
        splusGroupPanel5.add(this.saveColNames);
        splusFunctionInfo.add(this.saveColNames, "colNames");
        this.saveRowNames = new SplusCheckBox("Export Row Names", 'R');
        splusGroupPanel5.add(this.saveRowNames);
        splusFunctionInfo.add(this.saveRowNames, "rowNames");
        SplusGroupPanel splusGroupPanel6 = new SplusGroupPanel("Factor Columns");
        box6.add(splusGroupPanel6);
        this.quoteStrings = new SplusCheckBox("Quote Character Strings", 'Q');
        this.quoteStrings.setValue("T");
        splusGroupPanel6.add(this.quoteStrings);
        splusFunctionInfo.add(this.quoteStrings, "quote");
        box6.add(new SplusBoxFiller());
        SplusGroupPanel splusGroupPanel7 = new SplusGroupPanel("Text Files");
        box7.add(splusGroupPanel7);
        this.textDelimiter = new SplusTextField("Column Delimiter", 'D');
        this.textDelimiter.setEnabled(false);
        splusGroupPanel7.add(this.textDelimiter);
        splusFunctionInfo.add(this.textDelimiter, "delimiter", true);
        this.textFormat = new SplusTextField("Format String", 'F');
        this.textFormat.setEnabled(false);
        splusGroupPanel7.add(this.textFormat);
        splusFunctionInfo.add(this.textFormat, "format", true);
        box7.add(new SplusBoxFiller());
        this.setCenterPanel(jTabbedPane);
    }

    public boolean isComplete() {
        boolean bl;
        boolean bl2 = bl = this.warnIfEmpty(this.fileName) && this.warnIfEmpty(this.dataSet);
        if (bl && this.fileTypeCode.getValue().equals("")) {
            JOptionPane.showMessageDialog(this, "File format must be specified.", "File Format Not Specified", 2);
            bl = false;
        }
        if (bl && !this.keepCols.getValue().equals("") && !this.dropCols.getValue().equals("")) {
            JOptionPane.showMessageDialog(this, "Only one of Keep and Drop may be specified.", "Inconsistent Field Values", 2);
            bl = false;
        }
        return bl;
    }

    private int showFileChooserDialog() {
        if (this.fileChooserDialog == null) {
            this.fileChooser.setApproveButtonText("OK");
            this.fileChooser.setDialogType(2);
            String string = this.fileChooser.getDialogTitle();
            if (string == null) {
                string = this.fileChooser.getUI().getDialogTitle(this.fileChooser);
            }
            this.fileChooserDialog = new JDialog(SplusSystem.getDefaultFrame(), string, true);
            Container container = this.fileChooserDialog.getContentPane();
            container.setLayout(new BorderLayout());
            container.add((Component)this.fileChooser, "Center");
            this.fileChooser.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    String string = actionEvent.getActionCommand();
                    ExportDataDialog.this.fileChooserReturnValue = string.equals("ApproveSelection") ? 0 : (string.equals("CancelSelection") ? 1 : -1);
                    if (ExportDataDialog.this.fileChooserDialog != null) {
                        ExportDataDialog.this.fileChooserDialog.setVisible(false);
                    }
                }
            });
        }
        this.fileChooser.rescanCurrentDirectory();
        this.fileChooserReturnValue = 1;
        this.fileChooserDialog.setSize(new Dimension(this.getSize().width + FCD_EXTRA_WIDTH, this.getSize().height));
        this.fileChooserDialog.setLocationRelativeTo(SplusSystem.getDefaultFrame());
        this.fileChooserDialog.show();
        return this.fileChooserReturnValue;
    }

    private class LocalExtensionFileFilter
    extends FileFilter {
        String[] extList;
        String description;

        public LocalExtensionFileFilter(String string, String string2) {
            this.extList = new String[]{string};
            this.description = string2;
        }

        public LocalExtensionFileFilter(String[] stringArray, String string) {
            this.extList = stringArray;
            this.description = string;
        }

        public boolean accept(File file) {
            boolean bl = true;
            boolean bl2 = bl = file.isDirectory() || this.extList[0].equals("");
            if (!bl) {
                String string = file.getName().toLowerCase();
                for (int i = 0; i < this.extList.length; ++i) {
                    bl = bl || string.endsWith(this.extList[i]);
                }
            }
            return bl;
        }

        public String getDescription() {
            return this.description;
        }
    }

    private class ExportFileTypeListener
    implements ActionListener {
        int indexValue;
        String codeValue;
        String delimiterValue;
        boolean isAscii;
        boolean isUserDelimiter;
        boolean isFascii;

        ExportFileTypeListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.indexValue = ExportDataDialog.this.fileTypeControl.getSelectedIndex();
            this.codeValue = typeCodeList[this.indexValue];
            ExportDataDialog.this.fileTypeCode.setValue(this.codeValue);
            this.isAscii = this.codeValue.startsWith("ASCII");
            this.isFascii = this.codeValue.startsWith("FASCII");
            this.isUserDelimiter = this.indexValue == 4;
            ExportDataDialog.this.textDelimiter.setEnabled(this.isUserDelimiter);
            this.delimiterValue = "";
            if (this.isAscii) {
                switch (this.indexValue) {
                    case 1: {
                        this.delimiterValue = "<SPACE>";
                        break;
                    }
                    case 2: {
                        this.delimiterValue = "<TAB>";
                        break;
                    }
                    case 3: {
                        this.delimiterValue = ",";
                        break;
                    }
                }
            }
            ExportDataDialog.this.textDelimiter.setValue(this.delimiterValue);
            ExportDataDialog.this.textFormat.setEnabled(this.isFascii);
        }
    }

    private class ExportFileTypeControl
    extends SplusWideComboBox {
        ExportFileTypeControl() {
            super("File Format", 'F', typeDescriptionList);
            this.setValue("Unspecified file format");
            this.setEditable(false);
            this.addActionListener(new ExportFileTypeListener());
        }
    }
}

