/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.splus.parser;

import com.insightful.splus.parser.GenLexer;
import com.insightful.splus.parser.GenParser;
import com.insightful.splus.parser.PObject;
import com.insightful.splus.parser.PObjectFactory;
import com.insightful.splus.parser.PObjectFactoryImpl;
import com.insightful.splus.parser.Parser;
import com.insightful.splus.parser.ParserUtil;
import com.insightful.splus.parser.Scanner;
import com.insightful.splus.parser.Symbol;
import java.io.StringReader;
import java.util.Vector;

public class ParserImpl
implements Parser {
    public static String UNFINISHED_STRING_ERROR = "unfinished string";
    public static String PARSE_INCOMPLETE_ERROR = "parse incomplete";
    private PObjectFactory m_pof = null;
    private boolean m_addLimits = false;
    private boolean m_allowUnderscoreInNames = false;
    private boolean m_captureMultipleErrors = false;

    public ParserImpl(PObjectFactory pObjectFactory) {
        this.m_pof = pObjectFactory;
    }

    public void setAddLimits(boolean bl) {
        this.m_addLimits = bl;
    }

    public boolean getAddLimits() {
        return this.m_addLimits;
    }

    public void setAllowUnderscoreInNames(boolean bl) {
        this.m_allowUnderscoreInNames = bl;
    }

    public boolean getAllowUnderscoreInNames() {
        return this.m_allowUnderscoreInNames;
    }

    public void setCaptureMultipleErrors(boolean bl) {
        this.m_captureMultipleErrors = bl;
    }

    public boolean getCaptureMultipleErrors() {
        return this.m_captureMultipleErrors;
    }

    public PObject parse(String string) {
        return this.parse(string, false);
    }

    public PObject parse(String string, boolean bl) {
        Object object;
        if (string == null) {
            string = "";
        }
        GenLexer genLexer = new GenLexer(new StringReader(string));
        genLexer.setAllowUnderscoreInNames(this.m_allowUnderscoreInNames);
        GenParserManager.Error[] errorArray = null;
        PObject[] pObjectArray = null;
        while (!genLexer.isLexerDone()) {
            genLexer.clearLexer();
            object = new GenParserManager(genLexer, errorArray, pObjectArray);
            ((GenParser)object).setPObjectFactory(this.m_pof);
            ((GenParser)object).setAddLimits(this.m_addLimits);
            try {
                ((GenParserManager)object).parse();
            }
            catch (Throwable throwable) {
                ((GenParserManager)object).report_error("serious parser error: " + throwable, null);
            }
            errorArray = ((GenParserManager)object).getErrors();
            pObjectArray = ((GenParserManager)object).getResults();
            if (this.m_captureMultipleErrors) continue;
            break;
        }
        object = null;
        object = pObjectArray.length < 1 ? this.m_pof.pofCreateNull() : (pObjectArray.length == 1 ? pObjectArray[0] : this.m_pof.pofCreateRecursive("expression", null, pObjectArray));
        boolean bl2 = false;
        boolean bl3 = false;
        for (int i = 0; i < errorArray.length; ++i) {
            String string2 = errorArray[i].getMessage();
            if (string2.equals(PARSE_INCOMPLETE_ERROR)) {
                bl2 = true;
                continue;
            }
            if (!string2.equals(UNFINISHED_STRING_ERROR)) continue;
            bl3 = true;
        }
        String string3 = "";
        int n = -1;
        int n2 = -1;
        if (errorArray.length > 0) {
            string3 = errorArray[0].getMessage();
            n = errorArray[0].getLine();
            n2 = errorArray[0].getColumn();
        }
        if (!bl) {
            if (errorArray.length > 0) {
                return null;
            }
            return object;
        }
        PObject[] pObjectArray2 = new PObject[errorArray.length];
        for (int i = 0; i < errorArray.length; ++i) {
            GenParserManager.Error error = errorArray[i];
            String string4 = error.getMessage();
            int n3 = error.getLine();
            int n4 = error.getColumn();
            pObjectArray2[i] = this.m_pof.pofCreateRecursive("list", new String[]{"error", "errorLine", "errorColumn"}, new PObject[]{this.m_pof.pofCreateString(new String[]{string4}), this.m_pof.pofCreateDouble(n3), this.m_pof.pofCreateDouble(n4)});
        }
        return this.m_pof.pofCreateRecursive("list", new String[]{"result", "string", "incomplete", "unfinishedString", "error", "errorLine", "errorColumn", "allErrors"}, new PObject[]{object, this.m_pof.pofCreateString(new String[]{string}), this.m_pof.pofCreateLogical(bl2), this.m_pof.pofCreateLogical(bl3), this.m_pof.pofCreateString(new String[]{string3}), this.m_pof.pofCreateDouble(n), this.m_pof.pofCreateDouble(n2), this.m_pof.pofCreateRecursive("list", null, pObjectArray2)});
    }

    public static String parseTest(String string, boolean bl) {
        return ParserImpl.parseTest(string, true, false, false, bl);
    }

    public static String parseTest(String string, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        ParserImpl parserImpl = new ParserImpl(new PObjectFactoryImpl());
        parserImpl.setAddLimits(bl);
        parserImpl.setAllowUnderscoreInNames(bl2);
        parserImpl.setCaptureMultipleErrors(bl3);
        PObject pObject = parserImpl.parse(string, true);
        String string2 = "";
        PObject pObject2 = pObject.poGetElement("error");
        if (pObject2.poIsString() && pObject2.poGetLength() > 0 && pObject2.poGetStringElement(0).length() > 0) {
            string2 = pObject2.poGetStringElement(0) + ", line=" + (int)(1.0 + pObject.poGetElement("errorLine").poGetDoubleElement(0)) + ", column=" + (int)(1.0 + pObject.poGetElement("errorColumn").poGetDoubleElement(0));
        }
        if (bl4) {
            return string2;
        }
        PObject pObject3 = pObject.poGetElement("result");
        String string3 = pObject3.toString();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string3);
        PObject pObject4 = pObject.poGetElement("allErrors");
        if (pObject4.poGetLength() > 0) {
            for (int i = 0; i < pObject4.poGetLength(); ++i) {
                pObject2 = pObject4.poGetElement(i);
                PObject pObject5 = pObject2.poGetElement("error");
                if (pObject5.poIsString() && pObject5.poGetLength() > 0) {
                    string2 = pObject5.poGetStringElement(0) + ", line=" + (int)(1.0 + pObject2.poGetElement("errorLine").poGetDoubleElement(0)) + ", column=" + (int)(1.0 + pObject2.poGetElement("errorColumn").poGetDoubleElement(0));
                }
                stringBuffer.append("\n  error ");
                stringBuffer.append(i + 1);
                stringBuffer.append(": ");
                stringBuffer.append(string2);
            }
        }
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            System.out.println("\n***************\nparsing: " + stringArray[i]);
            String string = ParserImpl.parseTest(stringArray[i], true, false, true, false);
            System.out.println("\nresult:\n" + string);
        }
    }

    static class GenParserManager
    extends GenParser {
        private Vector m_parseErrors = new Vector();
        private Vector m_resultObjects = new Vector();

        public GenParserManager(Scanner scanner) {
            this.setScanner(scanner);
        }

        public GenParserManager(Scanner scanner, Error[] errorArray, PObject[] pObjectArray) {
            int n;
            this.setScanner(scanner);
            if (errorArray != null) {
                for (n = 0; n < errorArray.length; ++n) {
                    this.m_parseErrors.add(errorArray[n]);
                }
            }
            if (pObjectArray != null) {
                for (n = 0; n < pObjectArray.length; ++n) {
                    this.m_resultObjects.add(pObjectArray[n]);
                }
            }
        }

        public Symbol parse() throws Exception {
            Symbol symbol = super.parse();
            if (symbol != null && symbol.value != null && symbol.value instanceof PObject) {
                PObject pObject = (PObject)symbol.value;
                if (pObject.poGetMode().equals("expression")) {
                    for (int i = 0; i < pObject.poGetLength(); ++i) {
                        this.m_resultObjects.add(pObject.poGetElement(i));
                    }
                } else if (this.m_resultObjects.size() <= 0 || pObject != this.m_resultObjects.lastElement()) {
                    this.m_resultObjects.add(pObject);
                }
            }
            return symbol;
        }

        public Error[] getErrors() {
            int n = this.m_parseErrors.size();
            if (n == 0) {
                return new Error[0];
            }
            Error[] errorArray = new Error[n];
            this.m_parseErrors.toArray(errorArray);
            return errorArray;
        }

        public PObject[] getResults() {
            int n = this.m_resultObjects.size();
            if (n == 0) {
                return new PObject[0];
            }
            PObject[] pObjectArray = new PObject[n];
            this.m_resultObjects.toArray(pObjectArray);
            return pObjectArray;
        }

        public void unrecovered_syntax_error(Symbol symbol) throws Exception {
        }

        public void syntax_error(Symbol symbol) {
            Symbol symbol2;
            int n;
            for (n = 0; n < this.stack.size(); ++n) {
                symbol2 = (Symbol)this.stack.elementAt(n);
                Object object = symbol2.value;
                if (object == null) continue;
                if (object instanceof PObject) {
                    this.m_resultObjects.add(object);
                    continue;
                }
                if (!(object instanceof Vector)) continue;
                Vector vector = (Vector)object;
                for (int i = 0; i < vector.size(); ++i) {
                    Object e = vector.elementAt(i);
                    if (e == null || !(e instanceof PObject)) continue;
                    this.m_resultObjects.add(e);
                }
            }
            if (symbol == null || symbol.left < 0) {
                for (n = this.stack.size() - 1; n >= 0; --n) {
                    symbol2 = (Symbol)this.stack.elementAt(n);
                    if (symbol2.left < 0) continue;
                    symbol = new Symbol(symbol.sym, symbol2.left, symbol2.right, null);
                    break;
                }
            }
            this.report_error(symbol.sym == 0 ? PARSE_INCOMPLETE_ERROR : "Syntax error", symbol);
        }

        public void report_error(String string, Object object) {
            Object object2;
            String string2 = string;
            int n = -1;
            int n2 = -1;
            if (object != null) {
                if (object instanceof Symbol) {
                    object2 = (Symbol)object;
                    n = ((Symbol)object2).left;
                    n2 = ((Symbol)object2).right;
                    Object object3 = ((Symbol)object2).value;
                    if (object3 != null && object3 instanceof ParserUtil.Pos) {
                        n = ((ParserUtil.Pos)object3).line;
                        n2 = ((ParserUtil.Pos)object3).col;
                        object3 = ((ParserUtil.Pos)object3).val;
                    }
                    if (object3 != null && object3 instanceof String) {
                        string2 = ((Symbol)object2).sym == 1 ? (String)object3 : "unexpected " + (String)object3;
                    }
                    if (((Symbol)object2).sym == 4) {
                        string2 = UNFINISHED_STRING_ERROR;
                    } else if (((Symbol)object2).sym != 1 && n < 0 && n2 < 0) {
                        string2 = PARSE_INCOMPLETE_ERROR;
                    }
                } else if (object instanceof ParserUtil.Pos) {
                    object2 = (ParserUtil.Pos)object;
                    n = ((ParserUtil.Pos)object2).line;
                    n2 = ((ParserUtil.Pos)object2).col;
                }
            }
            if (n >= 0 && this.m_parseErrors.size() > 0 && (object2 = (Error)this.m_parseErrors.lastElement()) != null && ((Error)object2).getLine() == n) {
                return;
            }
            if (string2 != null && string2.length() > 0) {
                this.m_parseErrors.add(new Error(string2, n, n2));
            }
        }

        public void report_fatal_error(String string, Object object) {
            this.report_error(string, object);
        }

        public static class Error {
            private String m_message = "unknown error";
            private int m_line = -1;
            private int m_column = -1;

            public Error(String string, int n, int n2) {
                this.m_message = string == null || string.equals("") ? "unknown error" : string;
                this.m_line = n;
                this.m_column = n2;
            }

            public String getMessage() {
                return this.m_message;
            }

            public int getLine() {
                return this.m_line;
            }

            public int getColumn() {
                return this.m_column;
            }

            public String toString() {
                return "parse error: " + this.m_message + " at line " + (this.m_line + 1) + ", column " + (this.m_column + 1);
            }
        }
    }
}

