/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.splus.statdlg;

import com.insightful.controls.SplusBoxFiller;
import com.insightful.controls.SplusCheckBox;
import com.insightful.controls.SplusComboBox;
import com.insightful.controls.SplusDialog;
import com.insightful.controls.SplusFunctionInfo;
import com.insightful.controls.SplusGroupPanel;
import com.insightful.controls.SplusTextField;
import com.insightful.controls.SplusWideBoxFiller;
import com.insightful.splus.SplusDataColumnListBox;
import com.insightful.splus.SplusDataColumnListProvider;
import com.insightful.splus.SplusDataSetComboBox;
import com.insightful.splus.SplusSubsetField;
import com.insightful.splus.SplusWideFormulaField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class FactorAnalysisDialog
extends SplusDialog {
    SplusDataSetComboBox dataSet;
    SplusDataColumnListBox columnList;
    SplusSubsetField subsetRows;
    SplusCheckBox omitMissing;
    SplusCheckBox useCovList;
    SplusTextField covList;
    SplusWideFormulaField formulaField;
    SplusCheckBox loadings;
    SplusCheckBox plotBiplot;
    SplusTextField loadingsCutoff;
    SplusTextField biplotScores;
    SplusTextField numFactors;
    JTabbedPane tabbedPane = new JTabbedPane();

    public FactorAnalysisDialog() {
        super("Factor Analysis");
        SplusFunctionInfo splusFunctionInfo = new SplusFunctionInfo("menuFactanal");
        this.setFunctionInfo(splusFunctionInfo);
        JPanel jPanel = new JPanel();
        this.tabbedPane.addTab("Model", jPanel);
        Box box = new Box(0);
        Box box2 = new Box(0);
        Box box3 = new Box(1);
        Box box4 = new Box(1);
        box.add(box3);
        box.add(box4);
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.add(box);
        jPanel.add(box2);
        SplusGroupPanel splusGroupPanel = new SplusGroupPanel("Data");
        box3.add(splusGroupPanel);
        this.dataSet = new SplusDataSetComboBox();
        splusGroupPanel.add(this.dataSet);
        splusFunctionInfo.add(this.dataSet, "data");
        this.subsetRows = new SplusSubsetField();
        splusGroupPanel.add(this.subsetRows);
        splusFunctionInfo.add(this.subsetRows, "subset");
        this.omitMissing = new SplusCheckBox("Omit Rows with Missing Values", 'M');
        this.omitMissing.setValue("T");
        splusGroupPanel.add(this.omitMissing);
        splusFunctionInfo.add(this.omitMissing, "na.action");
        this.useCovList = new SplusCheckBox("Use Covariance List as Input", 'U');
        splusGroupPanel.add(this.useCovList);
        splusFunctionInfo.add(this.useCovList, "");
        this.covList = new SplusTextField("Covariance List", 'C');
        this.covList.setEnabled(false);
        splusGroupPanel.add(this.covList);
        splusFunctionInfo.add(this.covList, "covlist");
        this.useCovList.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = FactorAnalysisDialog.this.useCovList.getValue().equals("F");
                FactorAnalysisDialog.this.covList.setEnabled(!bl);
                FactorAnalysisDialog.this.dataSet.setEnabled(bl);
                FactorAnalysisDialog.this.subsetRows.setEnabled(bl);
                FactorAnalysisDialog.this.omitMissing.setEnabled(bl);
                FactorAnalysisDialog.this.columnList.setEnabled(bl);
                FactorAnalysisDialog.this.formulaField.setEnabled(bl);
            }
        });
        SplusGroupPanel splusGroupPanel2 = new SplusGroupPanel("Model");
        box4.add(splusGroupPanel2);
        this.numFactors = new SplusTextField("Number of Factors", 'N');
        this.numFactors.setValue("1");
        splusGroupPanel2.add(this.numFactors);
        splusFunctionInfo.add(this.numFactors, "factors");
        SplusComboBox splusComboBox = new SplusComboBox("Method", 'E', new String[]{"mle", "principal"});
        splusComboBox.setEditable(false);
        splusComboBox.setValue("mle");
        splusGroupPanel2.add(splusComboBox);
        splusFunctionInfo.add(splusComboBox, "method", true);
        SplusComboBox splusComboBox2 = new SplusComboBox("Rotation", 'O', new String[]{"varimax", "quartimax", "equamax", "parsimax", "orthomax", "covarimin", "biquartimin", "quartimin", "oblimin", "crawford.ferguson", "promax", "none"});
        splusComboBox2.setValue("varimax");
        splusComboBox2.setEditable(false);
        splusGroupPanel2.add(splusComboBox2);
        splusFunctionInfo.add(splusComboBox2, "rotation", true);
        SplusGroupPanel splusGroupPanel3 = new SplusGroupPanel("Save Model Object");
        box4.add(splusGroupPanel3);
        SplusTextField splusTextField = new SplusTextField("Save As", 'S');
        splusGroupPanel3.add(splusTextField);
        splusFunctionInfo.setResultControl(splusTextField);
        SplusCheckBox splusCheckBox = new SplusCheckBox("Include Scores", 'I');
        splusCheckBox.setValue("T");
        splusGroupPanel3.add(splusCheckBox);
        splusFunctionInfo.add(splusCheckBox, "scores");
        box4.add(new SplusBoxFiller(5));
        SplusGroupPanel splusGroupPanel4 = new SplusGroupPanel("Formula");
        box2.add(splusGroupPanel4);
        this.columnList = new SplusDataColumnListBox("Variables", 'V', (SplusDataColumnListProvider)this.dataSet);
        this.columnList.setPrepend(new String[]{"<ALL>"});
        splusGroupPanel4.add(this.columnList);
        splusFunctionInfo.add(this.columnList, "");
        this.formulaField = new SplusWideFormulaField();
        splusGroupPanel4.add(this.formulaField);
        splusFunctionInfo.add(this.formulaField, "x");
        this.columnList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                String string = FactorAnalysisDialog.this.columnList.getValue().replace(',', '+').trim();
                if (string.indexOf("<ALL>") > -1 || string.equals("")) {
                    FactorAnalysisDialog.this.formulaField.setValue("~ .");
                } else {
                    FactorAnalysisDialog.this.formulaField.setValue("~ " + string);
                }
            }
        });
        jPanel.add(new SplusWideBoxFiller());
        JPanel jPanel2 = new JPanel();
        this.tabbedPane.addTab("Options", jPanel2);
        Box box5 = new Box(1);
        Box box6 = new Box(1);
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel2.add(box5);
        jPanel2.add(box6);
        SplusGroupPanel splusGroupPanel5 = new SplusGroupPanel("Model Options");
        box5.add(splusGroupPanel5);
        SplusComboBox splusComboBox3 = new SplusComboBox("Type of Score", 'S', new String[]{"regression", "weighted.ls"});
        splusComboBox3.setValue("regression");
        splusComboBox3.setEditable(false);
        splusGroupPanel5.add(splusComboBox3);
        splusFunctionInfo.add(splusComboBox3, "type", true);
        SplusTextField splusTextField2 = new SplusTextField("Starting Values", 'V');
        splusGroupPanel5.add(splusTextField2);
        splusFunctionInfo.add(splusTextField2, "start", false, true);
        SplusTextField splusTextField3 = new SplusTextField("Max Iterations", 'V');
        splusTextField3.setValue("20");
        splusGroupPanel5.add(splusTextField3);
        splusFunctionInfo.add(splusTextField3, "iter.max");
        SplusTextField splusTextField4 = new SplusTextField("Uniqueness Tolerance", 'T');
        splusTextField4.setValue("0.0001");
        splusGroupPanel5.add(splusTextField4);
        splusFunctionInfo.add(splusTextField4, "unique.tol");
        box5.add(new SplusBoxFiller());
        box6.add(new SplusBoxFiller());
        JPanel jPanel3 = new JPanel();
        this.tabbedPane.addTab("Results", jPanel3);
        Box box7 = new Box(1);
        Box box8 = new Box(1);
        jPanel3.setLayout(new BoxLayout(jPanel3, 0));
        jPanel3.add(box7);
        jPanel3.add(box8);
        SplusGroupPanel splusGroupPanel6 = new SplusGroupPanel("Printed Results");
        box7.add(splusGroupPanel6);
        SplusCheckBox splusCheckBox2 = new SplusCheckBox("Short Output", 'S');
        splusCheckBox2.setValue("T");
        splusGroupPanel6.add(splusCheckBox2);
        splusFunctionInfo.add(splusCheckBox2, "print.short");
        SplusCheckBox splusCheckBox3 = new SplusCheckBox("Component Importance", 'C');
        splusCheckBox3.setValue("T");
        splusGroupPanel6.add(splusCheckBox3);
        splusFunctionInfo.add(splusCheckBox3, "print.importance");
        this.loadings = new SplusCheckBox("Loadings", 'L');
        splusGroupPanel6.add(this.loadings);
        splusFunctionInfo.add(this.loadings, "print.loadings");
        box7.add(new SplusBoxFiller());
        SplusGroupPanel splusGroupPanel7 = new SplusGroupPanel("Loadings Options");
        box8.add(splusGroupPanel7);
        this.loadingsCutoff = new SplusTextField("Cutoff Loading Value", 'V');
        this.loadingsCutoff.setValue("0.1");
        this.loadingsCutoff.setEnabled(false);
        splusGroupPanel7.add(this.loadingsCutoff);
        splusFunctionInfo.add(this.loadingsCutoff, "cutoff.loadings");
        this.loadings.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FactorAnalysisDialog.this.loadingsCutoff.setEnabled(FactorAnalysisDialog.this.loadings.getValue().equals("T"));
            }
        });
        box8.add(new SplusBoxFiller());
        JPanel jPanel4 = new JPanel();
        this.tabbedPane.addTab("Plot", jPanel4);
        Box box9 = new Box(1);
        Box box10 = new Box(1);
        jPanel4.setLayout(new BoxLayout(jPanel4, 0));
        jPanel4.add(box9);
        jPanel4.add(box10);
        SplusGroupPanel splusGroupPanel8 = new SplusGroupPanel("Plots");
        box9.add(splusGroupPanel8);
        SplusCheckBox splusCheckBox4 = new SplusCheckBox("Loadings", 'L');
        splusGroupPanel8.add(splusCheckBox4);
        splusFunctionInfo.add(splusCheckBox4, "plot.loadings");
        this.plotBiplot = new SplusCheckBox("Biplot", 'B');
        this.plotBiplot.setEnabled(false);
        splusGroupPanel8.add(this.plotBiplot);
        splusFunctionInfo.add(this.plotBiplot, "plot.biplot");
        this.tabbedPane.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                if (FactorAnalysisDialog.this.tabbedPane.getSelectedIndex() == 3) {
                    String string = FactorAnalysisDialog.this.numFactors.getValue().trim();
                    if (string.equals("1") || string.equals("")) {
                        FactorAnalysisDialog.this.plotBiplot.setValue("F");
                        FactorAnalysisDialog.this.plotBiplot.setEnabled(false);
                        FactorAnalysisDialog.this.biplotScores.setEnabled(false);
                    } else {
                        FactorAnalysisDialog.this.plotBiplot.setEnabled(true);
                        if (FactorAnalysisDialog.this.plotBiplot.getValue().equals("T")) {
                            FactorAnalysisDialog.this.biplotScores.setEnabled(true);
                        }
                    }
                }
            }
        });
        box9.add(new SplusBoxFiller());
        SplusGroupPanel splusGroupPanel9 = new SplusGroupPanel("Biplot Options");
        box10.add(splusGroupPanel9);
        this.biplotScores = new SplusTextField("Biplot Which Scores:", 'S');
        this.biplotScores.setValue("c(1,2)");
        this.biplotScores.setEnabled(false);
        splusGroupPanel9.add(this.biplotScores);
        splusFunctionInfo.add(this.biplotScores, "plot.biplot.choices");
        this.plotBiplot.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FactorAnalysisDialog.this.biplotScores.setEnabled(FactorAnalysisDialog.this.plotBiplot.getValue().equals("T"));
            }
        });
        box10.add(new SplusBoxFiller());
        JPanel jPanel5 = new JPanel();
        this.tabbedPane.addTab("Predict", jPanel5);
        Box box11 = new Box(1);
        Box box12 = new Box(1);
        jPanel5.setLayout(new BoxLayout(jPanel5, 0));
        jPanel5.add(box11);
        jPanel5.add(box12);
        SplusGroupPanel splusGroupPanel10 = new SplusGroupPanel("");
        box11.add(splusGroupPanel10);
        SplusDataSetComboBox splusDataSetComboBox = new SplusDataSetComboBox("New Data", 'N');
        splusDataSetComboBox.setValue("");
        splusGroupPanel10.add(splusDataSetComboBox);
        splusFunctionInfo.add(splusDataSetComboBox, "newdata");
        box11.add(new SplusBoxFiller());
        SplusGroupPanel splusGroupPanel11 = new SplusGroupPanel("Save");
        box12.add(splusGroupPanel11);
        SplusDataSetComboBox splusDataSetComboBox2 = new SplusDataSetComboBox("Save In", 'I');
        splusDataSetComboBox2.setValue("");
        splusGroupPanel11.add(splusDataSetComboBox2);
        splusFunctionInfo.add(splusDataSetComboBox2, "save.name", true);
        SplusCheckBox splusCheckBox5 = new SplusCheckBox("Predictions", 'P');
        splusGroupPanel11.add(splusCheckBox5);
        splusFunctionInfo.add(splusCheckBox5, "predict.p");
        box12.add(new SplusBoxFiller());
        this.setCenterPanel(this.tabbedPane);
    }

    public boolean isComplete() {
        if (this.useCovList.getValue().equals("T")) {
            return this.warnIfEmpty(this.covList) && this.warnIfEmpty(this.numFactors);
        }
        return this.warnIfEmpty(this.dataSet) && this.warnIfEmpty(this.formulaField) && this.warnIfEmpty(this.numFactors);
    }
}

