/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.splus.eclipse.debug.core.model;

import com.insightful.splus.eclipse.debug.core.model.SplusDebugElement;
import com.insightful.splus.eclipse.debug.core.model.SplusDebugTarget;
import com.insightful.splus.eclipse.debug.core.model.SplusDebugThread;
import com.insightful.splus.eclipse.editors.spluseditor.context.SplusFindSource;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IRegisterGroup;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.jface.text.Position;

public class SplusDebugStackFrame
extends SplusDebugElement
implements IStackFrame {
    private SplusDebugThread fThread;
    private String fContainerFunctionName;
    private String fFunctionName;
    private String fCall;
    private int fId;
    private int fPC;

    public SplusDebugStackFrame(SplusDebugThread splusDebugThread, String string, String string2, String string3, int n) {
        super((SplusDebugTarget)splusDebugThread.getDebugTarget());
        this.fId = n;
        this.fThread = splusDebugThread;
        this.init(string, string2, string3);
    }

    private void init(String string, String string2, String string3) {
        this.fFunctionName = string;
        this.fContainerFunctionName = string2;
        this.fCall = string3;
        this.fPC = 0;
    }

    public IThread getThread() {
        return this.fThread;
    }

    public IVariable[] getVariables() throws DebugException {
        return ((SplusDebugTarget)this.getThread().getDebugTarget()).getVariables();
    }

    public boolean hasVariables() throws DebugException {
        return this.getVariables().length > 0;
    }

    public int getLineNumber() throws DebugException {
        return this.fPC;
    }

    public int getCharStart() throws DebugException {
        long[] lArray = this.getSourceAddress();
        String string = this.getSourceName();
        Position position = SplusFindSource.getCharRange((String)string, (long[])lArray);
        return position.offset;
    }

    public int getCharEnd() throws DebugException {
        long[] lArray = this.getSourceAddress();
        String string = this.getSourceName();
        Position position = SplusFindSource.getCharRange((String)string, (long[])lArray);
        return position.length + 1;
    }

    public String getName() throws DebugException {
        return this.fFunctionName + "  -->  " + this.fCall;
    }

    public IRegisterGroup[] getRegisterGroups() throws DebugException {
        return null;
    }

    public boolean hasRegisterGroups() throws DebugException {
        return false;
    }

    public boolean canStepInto() {
        return this.getThread().canStepInto();
    }

    public boolean canStepOver() {
        return this.getThread().canStepOver();
    }

    public boolean canStepReturn() {
        return this.getThread().canStepReturn();
    }

    public boolean isStepping() {
        return this.getThread().isStepping();
    }

    public void stepInto() throws DebugException {
        this.getThread().stepInto();
    }

    public void stepOver() throws DebugException {
        this.getThread().stepOver();
    }

    public void stepReturn() throws DebugException {
        this.getThread().stepReturn();
    }

    public boolean canResume() {
        return this.getThread().canResume();
    }

    public boolean canSuspend() {
        return this.getThread().canSuspend();
    }

    public boolean isSuspended() {
        return this.getThread().isSuspended();
    }

    public void resume() throws DebugException {
        this.getThread().resume();
    }

    public void suspend() throws DebugException {
        this.getThread().suspend();
    }

    public boolean canTerminate() {
        return this.getThread().canTerminate();
    }

    public boolean isTerminated() {
        return this.getThread().isTerminated();
    }

    public void terminate() throws DebugException {
        this.getThread().terminate();
    }

    public String getSourceName() {
        if (this.fContainerFunctionName != null && this.fContainerFunctionName.length() != 0) {
            return this.fContainerFunctionName;
        }
        return this.fFunctionName;
    }

    public boolean isTopStackFrame() {
        try {
            IStackFrame iStackFrame = this.fThread.getTopStackFrame();
            if (iStackFrame != null) {
                return this.fThread.getTopStackFrame().equals((Object)this);
            }
        }
        catch (DebugException debugException) {
            debugException.printStackTrace();
        }
        return false;
    }

    public long[] getSourceAddress() {
        if (this.isTopStackFrame()) {
            return this.fThread.getAddress();
        }
        return new long[0];
    }

    public boolean equals(Object object) {
        if (object instanceof SplusDebugStackFrame) {
            SplusDebugStackFrame splusDebugStackFrame = (SplusDebugStackFrame)((Object)object);
            try {
                return splusDebugStackFrame.getSourceName().equals(this.getSourceName()) && splusDebugStackFrame.getLineNumber() == this.getLineNumber() && splusDebugStackFrame.fId == this.fId;
            }
            catch (DebugException debugException) {
                // empty catch block
            }
        }
        return false;
    }

    public int hashCode() {
        return this.getSourceName().hashCode() + this.fId;
    }

    protected int getIdentifier() {
        return this.fId;
    }
}

