/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.splus.eclipse.debug.ui.actions;

import com.insightful.splus.eclipse.debug.core.model.SplusDebugLineBreakpoint;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IVerticalRulerInfo;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.texteditor.AbstractMarkerAnnotationModel;
import org.eclipse.ui.texteditor.AbstractRulerActionDelegate;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.IUpdate;

public class EnableDisableBreakpointRulerActionDelegate
extends AbstractRulerActionDelegate {
    protected IAction createAction(ITextEditor iTextEditor, IVerticalRulerInfo iVerticalRulerInfo) {
        return new EnableDisableBreakpointRulerAction(iTextEditor, iVerticalRulerInfo);
    }

    public class EnableDisableBreakpointRulerAction
    extends Action
    implements IUpdate {
        private IVerticalRulerInfo fInfo;
        private ITextEditor fTextEditor;
        private IBreakpoint fBreakpoint;

        protected IBreakpoint determineBreakpoint() {
            IBreakpoint[] iBreakpointArray = DebugPlugin.getDefault().getBreakpointManager().getBreakpoints("com.insightful.splus.eclipse.debug");
            for (int i = 0; i < iBreakpointArray.length; ++i) {
                IBreakpoint iBreakpoint = iBreakpointArray[i];
                if (!(iBreakpoint instanceof SplusDebugLineBreakpoint)) continue;
                SplusDebugLineBreakpoint splusDebugLineBreakpoint = (SplusDebugLineBreakpoint)iBreakpoint;
                try {
                    if (!this.breakpointAtRulerLine(splusDebugLineBreakpoint)) continue;
                    return splusDebugLineBreakpoint;
                }
                catch (CoreException coreException) {
                    coreException.printStackTrace();
                }
            }
            return null;
        }

        protected IVerticalRulerInfo getInfo() {
            return this.fInfo;
        }

        protected void setInfo(IVerticalRulerInfo iVerticalRulerInfo) {
            this.fInfo = iVerticalRulerInfo;
        }

        protected ITextEditor getTextEditor() {
            return this.fTextEditor;
        }

        protected void setTextEditor(ITextEditor iTextEditor) {
            this.fTextEditor = iTextEditor;
        }

        protected IResource getResource() {
            IEditorInput iEditorInput = this.fTextEditor.getEditorInput();
            IResource iResource = (IResource)iEditorInput.getAdapter(IFile.class);
            if (iResource == null) {
                iResource = (IResource)iEditorInput.getAdapter(IResource.class);
            }
            return iResource;
        }

        protected boolean breakpointAtRulerLine(SplusDebugLineBreakpoint splusDebugLineBreakpoint) throws CoreException {
            Position position;
            AbstractMarkerAnnotationModel abstractMarkerAnnotationModel = this.getAnnotationModel();
            if (abstractMarkerAnnotationModel != null && (position = abstractMarkerAnnotationModel.getMarkerPosition(splusDebugLineBreakpoint.getMarker())) != null) {
                IDocumentProvider iDocumentProvider = this.getTextEditor().getDocumentProvider();
                IDocument iDocument = iDocumentProvider.getDocument((Object)this.getTextEditor().getEditorInput());
                try {
                    int n = iDocument.getLineOfOffset(position.getOffset());
                    int n2 = this.getInfo().getLineOfLastMouseButtonActivity();
                    if (n2 == n) {
                        if (this.getTextEditor().isDirty()) {
                            return splusDebugLineBreakpoint.getLineNumber() == n + 1;
                        }
                        return true;
                    }
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
            return false;
        }

        protected IBreakpoint getBreakpoint() {
            return this.fBreakpoint;
        }

        protected void setBreakpoint(IBreakpoint iBreakpoint) {
            this.fBreakpoint = iBreakpoint;
        }

        protected AbstractMarkerAnnotationModel getAnnotationModel() {
            IDocumentProvider iDocumentProvider = this.fTextEditor.getDocumentProvider();
            IAnnotationModel iAnnotationModel = iDocumentProvider.getAnnotationModel((Object)this.getTextEditor().getEditorInput());
            if (iAnnotationModel instanceof AbstractMarkerAnnotationModel) {
                return (AbstractMarkerAnnotationModel)iAnnotationModel;
            }
            return null;
        }

        public EnableDisableBreakpointRulerAction(ITextEditor iTextEditor, IVerticalRulerInfo iVerticalRulerInfo) {
            this.setInfo(iVerticalRulerInfo);
            this.setTextEditor(iTextEditor);
            this.setText("Enabling/Disabling Breakpoint");
        }

        public void run() {
            if (this.getBreakpoint() != null) {
                new Job("Enable/Disable Breakpoing"){

                    protected IStatus run(IProgressMonitor iProgressMonitor) {
                        try {
                            EnableDisableBreakpointRulerAction.this.getBreakpoint().setEnabled(!EnableDisableBreakpointRulerAction.this.getBreakpoint().isEnabled());
                            return Status.OK_STATUS;
                        }
                        catch (CoreException coreException) {
                            Display.getDefault().asyncExec(new Runnable(){

                                public void run() {
                                    ErrorDialog.openError((Shell)EnableDisableBreakpointRulerAction.this.getTextEditor().getEditorSite().getShell(), (String)"Failed to toggle breakpoing", (String)"Exception occurred enabling/disabling breakpoint", (IStatus)coreException.getStatus());
                                }
                            });
                            return Status.CANCEL_STATUS;
                        }
                    }
                }.schedule();
            }
        }

        public void update() {
            this.setBreakpoint(this.determineBreakpoint());
            if (this.getBreakpoint() == null) {
                this.setEnabled(false);
                return;
            }
            this.setEnabled(true);
            try {
                boolean bl = this.getBreakpoint().isEnabled();
                this.setText(bl ? "Disable Breakpoint" : "Enable Breakpoint");
            }
            catch (CoreException coreException) {
                coreException.printStackTrace();
            }
        }
    }
}

