/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.splus.eclipse.debug.ui.actions;

import com.insightful.splus.eclipse.debug.ui.model.SplusDebugLineBreakpointAdapter;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IVerticalRulerInfo;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.texteditor.AbstractMarkerAnnotationModel;
import org.eclipse.ui.texteditor.AbstractRulerActionDelegate;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public class ManageBreakpointRulerActionDelegate
extends AbstractRulerActionDelegate {
    private ManageBreakpointRulerAction targetAction;
    private IEditorPart activeEditor;

    protected IAction createAction(ITextEditor iTextEditor, IVerticalRulerInfo iVerticalRulerInfo) {
        this.targetAction = new ManageBreakpointRulerAction(iVerticalRulerInfo, iTextEditor);
        return this.targetAction;
    }

    public void setActiveEditor(IAction iAction, IEditorPart iEditorPart) {
        if (this.activeEditor != null && this.targetAction != null) {
            this.targetAction.dispose();
            this.targetAction = null;
        }
        this.activeEditor = iEditorPart;
        super.setActiveEditor(iAction, iEditorPart);
    }

    public class ManageBreakpointRulerAction
    extends Action {
        private IVerticalRulerInfo fRuler;
        private ITextEditor fTextEditor;
        private SplusDebugLineBreakpointAdapter fBreakpointAdapter;

        public ManageBreakpointRulerAction(IVerticalRulerInfo iVerticalRulerInfo, ITextEditor iTextEditor) {
            super("Manage Breakpoint Ruler Action");
            this.fRuler = iVerticalRulerInfo;
            this.fTextEditor = iTextEditor;
            this.fBreakpointAdapter = new SplusDebugLineBreakpointAdapter();
        }

        public void dispose() {
            this.fTextEditor = null;
            this.fRuler = null;
        }

        protected IVerticalRulerInfo getVerticalRulerInfo() {
            return this.fRuler;
        }

        protected ITextEditor getTextEditor() {
            return this.fTextEditor;
        }

        protected IDocument getDocument() {
            IDocumentProvider iDocumentProvider = this.fTextEditor.getDocumentProvider();
            return iDocumentProvider.getDocument((Object)this.fTextEditor.getEditorInput());
        }

        public void run() {
            try {
                List list = this.getMarkers();
                if (list.isEmpty()) {
                    IDocument iDocument = this.getDocument();
                    int n = this.getVerticalRulerInfo().getLineOfLastMouseButtonActivity();
                    if (n >= iDocument.getNumberOfLines()) {
                        return;
                    }
                    try {
                        IRegion iRegion = iDocument.getLineInformation(n);
                        TextSelection textSelection = new TextSelection(iDocument, iRegion.getOffset(), iRegion.getLength());
                        this.fBreakpointAdapter.toggleLineBreakpoints((IWorkbenchPart)this.fTextEditor, (ISelection)textSelection);
                    }
                    catch (BadLocationException badLocationException) {}
                } else {
                    IBreakpointManager iBreakpointManager = DebugPlugin.getDefault().getBreakpointManager();
                    for (IMarker iMarker : list) {
                        IBreakpoint iBreakpoint = iBreakpointManager.getBreakpoint(iMarker);
                        if (iBreakpoint == null) continue;
                        iBreakpoint.delete();
                    }
                }
            }
            catch (CoreException coreException) {
                coreException.printStackTrace();
            }
        }

        protected List getMarkers() {
            ArrayList<IMarker> arrayList = new ArrayList<IMarker>();
            IDocument iDocument = this.getDocument();
            AbstractMarkerAnnotationModel abstractMarkerAnnotationModel = this.getAnnotationModel();
            if (abstractMarkerAnnotationModel != null) {
                try {
                    IMarker[] iMarkerArray = null;
                    IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
                    iMarkerArray = iWorkspaceRoot.findMarkers(IBreakpoint.BREAKPOINT_MARKER, true, 2);
                    if (iMarkerArray != null) {
                        IBreakpointManager iBreakpointManager = DebugPlugin.getDefault().getBreakpointManager();
                        for (int i = 0; i < iMarkerArray.length; ++i) {
                            IBreakpoint iBreakpoint = iBreakpointManager.getBreakpoint(iMarkerArray[i]);
                            if (iBreakpoint == null || !iBreakpointManager.isRegistered(iBreakpoint) || !this.includesRulerLine(abstractMarkerAnnotationModel.getMarkerPosition(iMarkerArray[i]), iDocument)) continue;
                            arrayList.add(iMarkerArray[i]);
                        }
                    }
                }
                catch (CoreException coreException) {
                    coreException.printStackTrace();
                }
            }
            return arrayList;
        }

        protected AbstractMarkerAnnotationModel getAnnotationModel() {
            IDocumentProvider iDocumentProvider = this.fTextEditor.getDocumentProvider();
            IAnnotationModel iAnnotationModel = iDocumentProvider.getAnnotationModel((Object)this.fTextEditor.getEditorInput());
            if (iAnnotationModel instanceof AbstractMarkerAnnotationModel) {
                return (AbstractMarkerAnnotationModel)iAnnotationModel;
            }
            return null;
        }

        protected boolean includesRulerLine(Position position, IDocument iDocument) {
            if (position != null) {
                try {
                    int n = iDocument.getLineOfOffset(position.getOffset());
                    int n2 = this.fRuler.getLineOfLastMouseButtonActivity();
                    if (n2 == n) {
                        return true;
                    }
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
            return false;
        }
    }
}

