/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.controls;

import com.insightful.controls.SplusControlMethods;
import com.insightful.controls.SplusLabelBox;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JTextField;

public class SplusIntegerSpinner
extends SplusLabelBox
implements SplusControlMethods {
    JTextField textField;
    JScrollBar scrollBar;
    int minValue;
    int maxValue;
    int incrementValue;
    int numSteps;
    int lastStepValue;
    static int SCROLL_WIDTH = 15;

    public SplusIntegerSpinner(String string) {
        this(string, 0, 100, 1);
    }

    public SplusIntegerSpinner(String string, char c) {
        this(string, 0, 100, 1);
        this.setMnemonic(c);
    }

    public SplusIntegerSpinner(String string, int n) {
        this(string, 0, 100, 1);
        this.setMnemonic(n);
    }

    public SplusIntegerSpinner(String string, int n, int n2, int n3, int n4) {
        this(string, n2, n3, n4);
        this.setMnemonic(n);
    }

    public SplusIntegerSpinner(String string, char c, int n, int n2, int n3) {
        this(string, n, n2, n3);
        this.setMnemonic(c);
    }

    public SplusIntegerSpinner(String string, int n, int n2, int n3) {
        super(string);
        this.minValue = n;
        this.maxValue = n2;
        this.incrementValue = n3;
        this.lastStepValue = this.numSteps = (n2 - n) / n3;
        this.textField = new JTextField();
        this.textField.setPreferredSize(new Dimension(SplusIntegerSpinner.labelDimension.width - SCROLL_WIDTH, SplusIntegerSpinner.labelDimension.height));
        this.textField.setText(new Integer(this.minValue).toString());
        this.scrollBar = new JScrollBar(1, this.lastStepValue, 0, 0, this.numSteps);
        this.scrollBar.setPreferredSize(new Dimension(SCROLL_WIDTH, SplusIntegerSpinner.labelDimension.height));
        this.scrollBar.addAdjustmentListener(new ScrollListener());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel.add((Component)this.textField, "Center");
        jPanel.add((Component)this.scrollBar, "East");
        jPanel.setPreferredSize(labelDimension);
        jPanel.setMinimumSize(labelDimension);
        jPanel.setMaximumSize(labelDimension);
        this.setActionControl(jPanel);
        this.setLabelFor(this.textField);
    }

    public String getValue() {
        return this.textField.getText();
    }

    public void setValue(String string) {
        this.textField.setText(string);
    }

    public String[] getOptionList() {
        return null;
    }

    public void setOptionList(String[] stringArray) {
    }

    public boolean isEnabled() {
        return this.textField.isEnabled();
    }

    public void setEnabled(boolean bl) {
        this.textField.setEnabled(bl);
        this.scrollBar.setEnabled(bl);
        this.setLabelEnabled(bl);
    }

    public void addActionListener(ActionListener actionListener) {
        this.textField.addActionListener(actionListener);
    }

    private class TextListener
    implements ActionListener {
        private TextListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SplusIntegerSpinner.this.setValue(SplusIntegerSpinner.this.textField.getText());
        }
    }

    private class ScrollListener
    implements AdjustmentListener {
        private ScrollListener() {
        }

        public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
            int n;
            try {
                n = Integer.valueOf(SplusIntegerSpinner.this.textField.getText());
            }
            catch (NumberFormatException numberFormatException) {
                n = SplusIntegerSpinner.this.minValue;
            }
            n += (SplusIntegerSpinner.this.lastStepValue - adjustmentEvent.getValue()) * SplusIntegerSpinner.this.incrementValue;
            n = Math.max(Math.min(n, SplusIntegerSpinner.this.maxValue), SplusIntegerSpinner.this.minValue);
            SplusIntegerSpinner.this.textField.setText(new Integer(n).toString());
            SplusIntegerSpinner.this.lastStepValue = adjustmentEvent.getValue();
        }
    }
}

