/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.gdevice;

import com.insightful.gdevice.IDHash;
import com.insightful.gdevice.SCanvasAWT;
import com.insightful.gdevice.SCanvasHit;
import com.insightful.gdevice.SCanvasRectangle;
import com.insightful.gdevice.SFactoryAWT;
import com.insightful.gdevice.SGraphClear;
import com.insightful.gdevice.SGraphIdentify;
import com.insightful.gdevice.SGraphImage;
import com.insightful.gdevice.SGraphPoints;
import com.insightful.gdevice.SGraphPolygon;
import com.insightful.gdevice.TagSet;
import com.insightful.gdevice.XML;
import com.insightful.gdevice.XMLElement;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.ImageProducer;
import java.io.PrintWriter;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Vector;

abstract class SGraphCommand
implements Serializable {
    float m_clipX = 0.0f;
    float m_clipY = 0.0f;
    float m_clipWidth = 1.0f;
    float m_clipHeight = 1.0f;
    float m_plotX = 0.0f;
    float m_plotY = 0.0f;
    float m_plotWidth = 1.0f;
    float m_plotHeight = 1.0f;
    float m_usrX = 0.0f;
    float m_usrY = 0.0f;
    float m_usrWidth = 1.0f;
    float m_usrHeight = 1.0f;
    int m_iColor = 1;
    boolean m_useNewColor = false;
    int m_newColorR = 0;
    int m_newColorG = 0;
    int m_newColorB = 0;
    int m_newColorA = 255;
    static Component m_createImageComponent = null;
    private static final String m_hexChars = "0123456789ABCDEF";
    private static SFactoryAWT m_factory = null;

    SGraphCommand() {
    }

    public boolean getUseNewColor() {
        return this.m_useNewColor;
    }

    public int getNewColorR() {
        return this.m_newColorR;
    }

    public int getNewColorG() {
        return this.m_newColorG;
    }

    public int getNewColorB() {
        return this.m_newColorB;
    }

    public int getNewColorA() {
        return this.m_newColorA;
    }

    public Color getNewColor() {
        return SGraphCommand.getFactory().createColor(this.m_newColorR, this.m_newColorG, this.m_newColorB, this.m_newColorA);
    }

    abstract void display(SCanvasAWT var1, Graphics var2);

    void print(SCanvasAWT sCanvasAWT, Graphics graphics) {
        this.display(sCanvasAWT, graphics);
    }

    void highlightActiveRegions(SCanvasAWT sCanvasAWT, Graphics graphics, TagSet tagSet) {
    }

    public String[] getIntersectingTags(Rectangle rectangle, SCanvasAWT sCanvasAWT) {
        return null;
    }

    SGraphCommand getAWT() {
        return this;
    }

    int valToWindowX(SCanvasAWT sCanvasAWT, float f) {
        int n = Math.round((float)sCanvasAWT.getWidth() * (this.m_plotX + this.m_plotWidth * ((f - this.m_usrX) / this.m_usrWidth)));
        return n;
    }

    int valToWindowY(SCanvasAWT sCanvasAWT, float f) {
        int n = Math.round((float)sCanvasAWT.getHeight() * (this.m_plotY + this.m_plotHeight * ((f - this.m_usrY) / this.m_usrHeight)));
        return n;
    }

    float windowToValX(SCanvasAWT sCanvasAWT, int n) {
        return this.m_usrX + this.m_usrWidth * ((float)n / (float)sCanvasAWT.getWidth() - this.m_plotX) / this.m_plotWidth;
    }

    float windowToValY(SCanvasAWT sCanvasAWT, int n) {
        return this.m_usrY + this.m_usrHeight * ((float)n / (float)sCanvasAWT.getHeight() - this.m_plotY) / this.m_plotHeight;
    }

    int fracToWindowX(SCanvasAWT sCanvasAWT, float f) {
        return Math.round((float)sCanvasAWT.getWidth() * f);
    }

    int fracToWindowY(SCanvasAWT sCanvasAWT, float f) {
        return Math.round((float)sCanvasAWT.getHeight() * f);
    }

    public void setCommonProperties(HashMap hashMap) {
        this.m_iColor = (int)this.getAttribute(hashMap, "color", 1.0f);
        this.m_useNewColor = this.getAttribute(hashMap, "usenewcolor", 0.0f) != 0.0f;
        this.m_newColorR = this.getRGBAttribute(hashMap, "newcolorr", 0.0f);
        this.m_newColorG = this.getRGBAttribute(hashMap, "newcolorg", 0.0f);
        this.m_newColorB = this.getRGBAttribute(hashMap, "newcolorb", 0.0f);
        this.m_newColorA = this.getRGBAttribute(hashMap, "newcolora", 255.0f);
        if (this instanceof SGraphClear) {
            SGraphClear sGraphClear = (SGraphClear)this;
            sGraphClear.m_bgColorR = this.getRGBAttribute(hashMap, "bgcolorr", 0.0f);
            sGraphClear.m_bgColorG = this.getRGBAttribute(hashMap, "bgcolorg", 0.0f);
            sGraphClear.m_bgColorB = this.getRGBAttribute(hashMap, "bgcolorb", 0.0f);
            sGraphClear.m_bgColorA = this.getRGBAttribute(hashMap, "bgcolora", 255.0f);
        }
        this.setClip(this.getAttribute(hashMap, "ClipX1", 0.0f), this.getAttribute(hashMap, "ClipY1", 0.0f), this.getAttribute(hashMap, "ClipX2", 1.0f), this.getAttribute(hashMap, "ClipY2", 1.0f));
        this.setPlotRect(this.getAttribute(hashMap, "PlotX1", 0.0f), this.getAttribute(hashMap, "PlotY1", 0.0f), this.getAttribute(hashMap, "PlotX2", 1.0f), this.getAttribute(hashMap, "PlotY2", 1.0f));
        this.setUsrRect(this.getAttribute(hashMap, "UsrX1", 0.0f), this.getAttribute(hashMap, "UsrY1", 0.0f), this.getAttribute(hashMap, "UsrX2", 1.0f), this.getAttribute(hashMap, "UsrY2", 1.0f));
    }

    private float getAttribute(HashMap hashMap, String string, float f) {
        Object v = hashMap.get(string.toLowerCase());
        if (v == null) {
            return f;
        }
        Float f2 = (Float)v;
        return f2.floatValue();
    }

    private int getRGBAttribute(HashMap hashMap, String string, float f) {
        float f2 = this.getAttribute(hashMap, string, f);
        if (f2 < 0.0f) {
            f2 = 0.0f;
        } else if (f2 > 255.0f) {
            f2 = 255.0f;
        }
        return (int)f2;
    }

    public void setMyColor(int n) {
        this.setMyColor(n, false, 0, 0, 0, 255);
    }

    public void setMyColor(int n, boolean bl, int n2, int n3, int n4, int n5) {
        this.m_iColor = n;
        this.m_useNewColor = bl;
        this.m_newColorR = this.goodColorNum(n2);
        this.m_newColorG = this.goodColorNum(n3);
        this.m_newColorB = this.goodColorNum(n4);
        this.m_newColorA = this.goodColorNum(n5);
    }

    private int goodColorNum(int n) {
        if (n < 0) {
            return 0;
        }
        if (n > 255) {
            return 255;
        }
        return n;
    }

    public void setClip(float f, float f2, float f3, float f4) {
        this.m_clipX = f;
        this.m_clipY = f2;
        this.m_clipWidth = f3 - f;
        this.m_clipHeight = f4 - f2;
    }

    public SCanvasRectangle getClipRect() {
        return new SCanvasRectangle(this.m_clipX, this.m_clipY, this.m_clipWidth, this.m_clipHeight);
    }

    protected void setPlotRect(float f, float f2, float f3, float f4) {
        this.m_plotX = f;
        this.m_plotY = f2;
        this.m_plotWidth = f3 - f;
        this.m_plotHeight = f4 - f2;
    }

    public SCanvasRectangle getPlotRect() {
        return new SCanvasRectangle(this.m_plotX, this.m_plotY, this.m_plotWidth, this.m_plotHeight);
    }

    protected void setUsrRect(float f, float f2, float f3, float f4) {
        this.m_usrX = f;
        this.m_usrY = f2;
        this.m_usrWidth = f3 - f;
        this.m_usrHeight = f4 - f2;
    }

    public SCanvasRectangle getUsrRect() {
        return new SCanvasRectangle(this.m_usrX, this.m_usrY, this.m_usrWidth, this.m_usrHeight);
    }

    public void setCommonProperties(SGraphCommand sGraphCommand) {
        this.m_iColor = sGraphCommand.m_iColor;
        this.m_useNewColor = sGraphCommand.m_useNewColor;
        this.m_newColorR = sGraphCommand.m_newColorR;
        this.m_newColorG = sGraphCommand.m_newColorG;
        this.m_newColorB = sGraphCommand.m_newColorB;
        this.m_newColorA = sGraphCommand.m_newColorA;
        this.m_clipX = sGraphCommand.m_clipX;
        this.m_clipY = sGraphCommand.m_clipY;
        this.m_clipWidth = sGraphCommand.m_clipWidth;
        this.m_clipHeight = sGraphCommand.m_clipHeight;
        this.m_plotX = sGraphCommand.m_plotX;
        this.m_plotY = sGraphCommand.m_plotY;
        this.m_plotWidth = sGraphCommand.m_plotWidth;
        this.m_plotHeight = sGraphCommand.m_plotHeight;
        this.m_usrX = sGraphCommand.m_usrX;
        this.m_usrY = sGraphCommand.m_usrY;
        this.m_usrWidth = sGraphCommand.m_usrWidth;
        this.m_usrHeight = sGraphCommand.m_usrHeight;
    }

    void setColor(SCanvasAWT sCanvasAWT, Graphics graphics) {
        graphics.setColor(sCanvasAWT.getPaletteColor(this));
    }

    void setTextColor(SCanvasAWT sCanvasAWT, Graphics graphics) {
        graphics.setColor(sCanvasAWT.getTextColor(this));
    }

    void setLineColor(SCanvasAWT sCanvasAWT, Graphics graphics) {
        graphics.setColor(sCanvasAWT.getLineColor(this));
    }

    void setPolygonColor(SCanvasAWT sCanvasAWT, Graphics graphics) {
        graphics.setColor(sCanvasAWT.getPolygonColor(this));
    }

    int getColorInt() {
        return this.m_iColor;
    }

    void graphSizeChanged() {
    }

    public void releaseMemory() {
    }

    Rectangle getClipBounds(SCanvasAWT sCanvasAWT) {
        int n = this.fracToWindowX(sCanvasAWT, this.m_clipX);
        int n2 = this.fracToWindowX(sCanvasAWT, this.m_clipX + this.m_clipWidth);
        int n3 = this.fracToWindowY(sCanvasAWT, this.m_clipY);
        int n4 = this.fracToWindowY(sCanvasAWT, this.m_clipY + this.m_clipHeight);
        Rectangle rectangle = new Rectangle(n, n3, n2 - n + 1, n4 - n3 + 1);
        return rectangle;
    }

    Rectangle setParClip(SCanvasAWT sCanvasAWT, Graphics graphics) {
        Rectangle rectangle = graphics.getClipBounds();
        if (rectangle == null) {
            rectangle = new Rectangle(0, 0, sCanvasAWT.getWidth(), sCanvasAWT.getHeight());
        }
        int n = this.fracToWindowX(sCanvasAWT, this.m_clipX);
        int n2 = this.fracToWindowX(sCanvasAWT, this.m_clipX + this.m_clipWidth);
        int n3 = this.fracToWindowY(sCanvasAWT, this.m_clipY);
        int n4 = this.fracToWindowY(sCanvasAWT, this.m_clipY + this.m_clipHeight);
        graphics.clipRect(n, n3, n2 - n + 1, n4 - n3 + 1);
        return rectangle;
    }

    void resetClip(SCanvasAWT sCanvasAWT, Graphics graphics, Rectangle rectangle) {
        if (rectangle != null) {
            graphics.setClip(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }

    public boolean canHit() {
        return false;
    }

    public SCanvasHit getHit(SCanvasAWT sCanvasAWT, int n, int n2) {
        return null;
    }

    public static Component getCreateImageComponent() {
        if (m_createImageComponent == null) {
            Frame frame = new Frame();
            frame.addNotify();
            m_createImageComponent = frame;
        }
        return m_createImageComponent;
    }

    public static Image createImage(ImageProducer imageProducer) {
        Component component = SGraphCommand.getCreateImageComponent();
        Image image = null;
        for (int i = 0; i < 5 && image == null && (image = component.createImage(imageProducer)) == null; ++i) {
            try {
                m_createImageComponent = null;
                component = SGraphCommand.getCreateImageComponent();
                Thread.yield();
                Thread.sleep(3 * (i + 1));
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (image == null) {
            throw new RuntimeException("SGraphCommand.createImage(ImageProducer) failed");
        }
        return image;
    }

    public static Image createImage(int n, int n2) {
        Component component = SGraphCommand.getCreateImageComponent();
        Image image = null;
        for (int i = 0; i < 5 && image == null && (image = component.createImage(n, n2)) == null; ++i) {
            try {
                m_createImageComponent = null;
                component = SGraphCommand.getCreateImageComponent();
                Thread.yield();
                Thread.sleep(3 * (i + 1));
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (image == null) {
            throw new RuntimeException("SGraphCommand.createImage(int,int) failed");
        }
        return image;
    }

    public void writeXML(PrintWriter printWriter, Vector vector) {
        int n;
        String string = this.getXMLTag();
        printWriter.print("<" + string);
        this.writeXMLProperties(printWriter);
        printWriter.print(" COLOR=" + this.m_iColor);
        if (this.m_useNewColor) {
            printWriter.print(" RGBA=\"" + SGraphCommand.createRGBAString(this.m_newColorR, this.m_newColorG, this.m_newColorB, this.m_newColorA) + "\"");
        }
        if ((n = XML.indexOfMatchingRects(vector, this)) >= 0) {
            printWriter.print(" REF=" + XML.getDefineRectTag(n));
        } else {
            this.writeXMLRectProps(printWriter);
        }
        printWriter.println(">");
        this.writeXMLContents(printWriter);
        printWriter.println("</" + string + ">");
    }

    public static String createRGBAString(int n, int n2, int n3, int n4) {
        StringBuffer stringBuffer = new StringBuffer("#");
        stringBuffer.append(SGraphCommand.int2hexbyte(n));
        stringBuffer.append(SGraphCommand.int2hexbyte(n2));
        stringBuffer.append(SGraphCommand.int2hexbyte(n3));
        String string = SGraphCommand.int2hexbyte(n4);
        if (!string.equals("FF")) {
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    public static int[] readRGBAString(String string) {
        int n;
        if (string == null || !string.startsWith("#") || string.length() < 7) {
            return null;
        }
        string = string.toUpperCase();
        int n2 = SGraphCommand.hexbyte2int(string.substring(1, 3));
        int n3 = SGraphCommand.hexbyte2int(string.substring(3, 5));
        int n4 = SGraphCommand.hexbyte2int(string.substring(5, 7));
        int n5 = n = string.length() < 9 ? 255 : SGraphCommand.hexbyte2int(string.substring(7, 9));
        if (n2 < 0 || n3 < 0 || n4 < 0 || n < 0) {
            return null;
        }
        return new int[]{n2, n3, n4, n};
    }

    public static int hexbyte2int(String string) {
        if (string == null || string.length() != 2) {
            return -1;
        }
        int n = m_hexChars.indexOf(string.substring(0, 1));
        int n2 = m_hexChars.indexOf(string.substring(1, 2));
        if (n < 0 || n2 < 0) {
            return -1;
        }
        return n * 16 + n2;
    }

    public static String int2hexbyte(int n) {
        if (n < 0) {
            n += 256;
        }
        if (n > 255) {
            n = 255;
        }
        int n2 = n >> 4 & 0xF;
        int n3 = n & 0xF;
        return m_hexChars.substring(n2, n2 + 1) + m_hexChars.substring(n3, n3 + 1);
    }

    public void writeXMLRectProps(PrintWriter printWriter) {
        printWriter.print(" CLIP=\"" + this.m_clipX + "," + this.m_clipY + "," + this.m_clipWidth + "," + this.m_clipHeight + "\"");
        printWriter.print(" PLOT=\"" + this.m_plotX + "," + this.m_plotY + "," + this.m_plotWidth + "," + this.m_plotHeight + "\"");
        printWriter.print(" USR=\"" + this.m_usrX + "," + this.m_usrY + "," + this.m_usrWidth + "," + this.m_usrHeight + "\"");
    }

    public boolean sameRectProps(SGraphCommand sGraphCommand) {
        return this.m_clipX == sGraphCommand.m_clipX && this.m_clipY == sGraphCommand.m_clipY && this.m_clipWidth == sGraphCommand.m_clipWidth && this.m_clipHeight == sGraphCommand.m_clipHeight && this.m_plotX == sGraphCommand.m_plotX && this.m_plotY == sGraphCommand.m_plotY && this.m_plotWidth == sGraphCommand.m_plotWidth && this.m_plotHeight == sGraphCommand.m_plotHeight && this.m_usrX == sGraphCommand.m_usrX && this.m_usrY == sGraphCommand.m_usrY && this.m_usrWidth == sGraphCommand.m_usrWidth && this.m_usrHeight == sGraphCommand.m_usrHeight;
    }

    public void writeXMLProperties(PrintWriter printWriter) {
    }

    public void writeXMLContents(PrintWriter printWriter) {
    }

    public String getXMLTag() {
        return "UNDEFINED";
    }

    public static SGraphCommand createFromXML(XMLElement xMLElement, IDHash iDHash) {
        SGraphCommand sGraphCommand = null;
        String string = xMLElement.getTagName();
        if (string != null) {
            if (string.equalsIgnoreCase("IDENTIFY")) {
                sGraphCommand = SGraphIdentify.createFromXML(xMLElement, iDHash);
            } else if (string.equalsIgnoreCase("IMAGE")) {
                sGraphCommand = SGraphImage.createFromXML(xMLElement, iDHash);
            } else if (string.equalsIgnoreCase("LINES")) {
                sGraphCommand = SGraphCommand.getFactory().createLinesCommandFromXML(xMLElement, iDHash);
            } else if (string.equalsIgnoreCase("POINTS")) {
                sGraphCommand = SGraphPoints.createFromXML(xMLElement, iDHash);
            } else if (string.equalsIgnoreCase("POLYGON")) {
                sGraphCommand = SGraphPolygon.createFromXML(xMLElement, iDHash);
            } else if (string.equalsIgnoreCase("SEGMENTS")) {
                sGraphCommand = SGraphCommand.getFactory().createSegmentsCommandFromXML(xMLElement, iDHash);
            } else if (string.equalsIgnoreCase("TEXT")) {
                sGraphCommand = SGraphCommand.getFactory().createTextCommandFromXML(xMLElement, iDHash);
            }
        }
        if (sGraphCommand != null) {
            int n = XML.getIntProperty(xMLElement, "COLOR", iDHash);
            String string2 = XML.getStringProperty(xMLElement, "RGBA", iDHash);
            int[] nArray = SGraphCommand.readRGBAString(string2);
            if (nArray != null) {
                sGraphCommand.setMyColor(n, true, nArray[0], nArray[1], nArray[2], nArray[3]);
            } else {
                sGraphCommand.setMyColor(n);
            }
            float[] fArray = XML.getFloatArrayProperty(xMLElement, "CLIP", iDHash);
            float[] fArray2 = XML.getFloatArrayProperty(xMLElement, "PLOT", iDHash);
            float[] fArray3 = XML.getFloatArrayProperty(xMLElement, "USR", iDHash);
            if (fArray != null && fArray.length >= 4) {
                sGraphCommand.setClip(fArray[0], fArray[1], fArray[0] + fArray[2], fArray[1] + fArray[3]);
            }
            if (fArray2 != null && fArray2.length >= 4) {
                sGraphCommand.setPlotRect(fArray2[0], fArray2[1], fArray2[0] + fArray2[2], fArray2[1] + fArray2[3]);
            }
            if (fArray3 != null && fArray3.length >= 4) {
                sGraphCommand.setUsrRect(fArray3[0], fArray3[1], fArray3[0] + fArray3[2], fArray3[1] + fArray3[3]);
            }
        }
        return sGraphCommand;
    }

    public static void setFactory(SFactoryAWT sFactoryAWT) {
        m_factory = sFactoryAWT;
    }

    public static SFactoryAWT getFactory() {
        if (m_factory == null) {
            try {
                Class<?> clazz = Class.forName("com.insightful.gdevice.SFactory");
                Constructor<?> constructor = clazz.getConstructor(new Class[0]);
                Object obj = constructor.newInstance(new Object[0]);
                m_factory = (SFactoryAWT)obj;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (m_factory == null) {
                m_factory = new SFactoryAWT();
            }
        }
        return m_factory;
    }
}

