/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.gdevice;

import com.insightful.gdevice.IDHash;
import com.insightful.gdevice.SCanvasAWT;
import com.insightful.gdevice.SCustomLineAWT;
import com.insightful.gdevice.SGraphCommand;
import com.insightful.gdevice.XML;
import com.insightful.gdevice.XMLElement;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.io.PrintWriter;

class SGraphSegmentsAWT
extends SGraphCommand {
    float[] m_x1;
    float[] m_y1;
    float[] m_x2;
    float[] m_y2;
    int m_dash;
    int m_width;
    transient SCustomLineAWT m_line = null;

    SGraphSegmentsAWT(float[] fArray, float[] fArray2, float[] fArray3, float[] fArray4, int n, int n2) {
        this.m_x1 = fArray;
        this.m_y1 = fArray2;
        this.m_x2 = fArray3;
        this.m_y2 = fArray4;
        this.m_dash = n2;
        this.m_width = n;
    }

    public void display(SCanvasAWT sCanvasAWT, Graphics graphics) {
        if (this.m_line == null) {
            this.m_line = this.getCustomLine(sCanvasAWT);
        }
        Rectangle rectangle = this.setParClip(sCanvasAWT, graphics);
        this.setLineColor(sCanvasAWT, graphics);
        for (int i = 0; i < this.m_x1.length; ++i) {
            int n = this.valToWindowX(sCanvasAWT, this.m_x1[i]);
            int n2 = this.valToWindowX(sCanvasAWT, this.m_x2[i]);
            int n3 = this.valToWindowY(sCanvasAWT, this.m_y1[i]);
            int n4 = this.valToWindowY(sCanvasAWT, this.m_y2[i]);
            this.m_line.drawLine(graphics, n, n3, n2, n4);
        }
        this.resetClip(sCanvasAWT, graphics, rectangle);
    }

    SCustomLineAWT getCustomLine(SCanvasAWT sCanvasAWT) {
        return new SCustomLineAWT(sCanvasAWT.getLineDashes(this.m_dash), this.m_width);
    }

    public String getXMLTag() {
        return "SEGMENTS";
    }

    public void writeXMLProperties(PrintWriter printWriter) {
        XML.writeProperty(printWriter, "WIDTH", this.m_width);
        XML.writeProperty(printWriter, "DASH", this.m_dash);
    }

    public void writeXMLContents(PrintWriter printWriter) {
        XML.writeData(printWriter, "X1", this.m_x1);
        XML.writeData(printWriter, "Y1", this.m_y1);
        XML.writeData(printWriter, "X2", this.m_x2);
        XML.writeData(printWriter, "Y2", this.m_y2);
    }

    public static SGraphCommand createFromXML(XMLElement xMLElement, IDHash iDHash) {
        int n = XML.getIntProperty(xMLElement, "WIDTH", iDHash);
        int n2 = XML.getIntProperty(xMLElement, "DASH", iDHash);
        float[] fArray = XML.getFloatArrayData(xMLElement, "X1");
        float[] fArray2 = XML.getFloatArrayData(xMLElement, "Y1");
        float[] fArray3 = XML.getFloatArrayData(xMLElement, "X2");
        float[] fArray4 = XML.getFloatArrayData(xMLElement, "Y2");
        return new SGraphSegmentsAWT(fArray, fArray2, fArray3, fArray4, n, n2);
    }
}

