/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.splus;

import com.insightful.splus.ActiveDocument;
import com.insightful.splus.PrintSetupCommand;
import com.insightful.splus.SplusPrintable;
import com.insightful.splus.SplusSystem;
import java.awt.Graphics;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JOptionPane;

public class PrintCommand
implements Printable {
    private SplusPrintable m_printable = null;
    private PrinterJob m_printerJob;

    public PrintCommand(JFrame jFrame) {
        this(jFrame, null);
    }

    public PrintCommand(JFrame jFrame, SplusPrintable splusPrintable) {
        this.m_printable = splusPrintable;
    }

    public boolean doExecute() {
        JInternalFrame jInternalFrame;
        if (this.m_printable == null && (jInternalFrame = ActiveDocument.get()) instanceof SplusPrintable) {
            this.m_printable = (SplusPrintable)((Object)jInternalFrame);
        }
        if (this.m_printable != null) {
            this.m_printerJob = PrinterJob.getPrinterJob();
            this.m_printerJob.setPrintable(this);
            if (this.m_printerJob.printDialog(PrintSetupCommand.getPrintAttributeSet())) {
                try {
                    this.m_printerJob.print(PrintSetupCommand.getPrintAttributeSet());
                }
                catch (Exception exception) {
                    JOptionPane.showMessageDialog(SplusSystem.getDefaultFrame(), exception.getLocalizedMessage(), "Printing Error", 0);
                    return false;
                }
                return true;
            }
            return false;
        }
        return false;
    }

    public int getNumberOfPages() {
        return this.m_printable.getNumberOfPages();
    }

    public Printable getPrintable(int n) {
        return this.m_printable;
    }

    public int print(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
        return this.m_printable.print(graphics, pageFormat, n);
    }
}

