/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.splus;

public class XClipboard {
    static boolean isUnix;
    protected byte[] privateXData;

    public XClipboard() {
        if (isUnix) {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                securityManager.checkSystemClipboardAccess();
            }
            this.privateXData = this.openXConnection();
        }
    }

    protected void finalize() {
        if (isUnix) {
            this.closeXConnection(this.privateXData);
        }
    }

    public byte[] readCutBuffer0() {
        if (!isUnix) {
            return new byte[0];
        }
        return this.readCutBuffer0(this.privateXData);
    }

    public void writeCutBuffer0(String string) {
        if (isUnix) {
            this.writeCutBuffer0(this.privateXData, string);
        }
    }

    protected synchronized native Object readSelection(byte[] var1, byte[] var2, byte[] var3);

    public String readPrimarySelectionString() {
        if (!isUnix) {
            return null;
        }
        byte[] byArray = (byte[])this.readSelection(this.privateXData, new String("PRIMARY").getBytes(), new String("STRING").getBytes());
        return byArray == null ? null : new String(byArray);
    }

    public String readSecondarySelectionString() {
        if (!isUnix) {
            return null;
        }
        byte[] byArray = (byte[])this.readSelection(this.privateXData, new String("SECONDARY").getBytes(), new String("STRING").getBytes());
        return byArray == null ? null : new String(byArray);
    }

    public String readClipboardSelectionString() {
        if (!isUnix) {
            return null;
        }
        byte[] byArray = (byte[])this.readSelection(this.privateXData, new String("CLIPBOARD").getBytes(), new String("STRING").getBytes());
        return byArray == null ? null : new String(byArray);
    }

    public static void main(String[] stringArray) {
        XClipboard xClipboard = new XClipboard();
        String string = xClipboard.readPrimarySelectionString();
        if (string != null) {
            System.out.println("Primary Selection (length = " + string.length() + "): " + string);
        }
        if ((string = xClipboard.readSecondarySelectionString()) != null) {
            System.out.println("Secondary Selection (length = " + string.length() + "): " + string);
        }
        if ((string = xClipboard.readClipboardSelectionString()) != null) {
            System.out.println("Clipboard Selection (length = " + string.length() + "): " + string);
        }
        if ((string = new String(xClipboard.readCutBuffer0())) != null) {
            System.out.println("CutBuffer0 (length = " + string.length() + "): " + string);
        }
    }

    private synchronized native byte[] readCutBuffer0(byte[] var1);

    private synchronized native void writeCutBuffer0(byte[] var1, String var2);

    private synchronized native byte[] openXConnection();

    private synchronized native long closeXConnection(byte[] var1);

    static {
        String string = System.getProperty("os.name", "unknown").toLowerCase();
        isUnix = string.indexOf("windows") < 0 && !string.startsWith("mac");
    }
}

