/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.splus.parser;

import com.insightful.splus.parser.PObject;
import com.insightful.splus.parser.PObjectFactory;

public class PObjectFactoryImpl
implements PObjectFactory {
    public PObject pofCreateNull() {
        return new TinyPObjectNull();
    }

    public PObject pofCreateMissing() {
        return new TinyPObjectMissing();
    }

    public PObject pofCreateName(String string) {
        return new TinyPObjectName(string);
    }

    public PObject pofCreateRecursive(String string, String[] stringArray, PObject[] pObjectArray) {
        return new TinyPObjectRecursive(string, stringArray, pObjectArray);
    }

    public PObject pofCreateDouble(double d) {
        return new TinyPObjectDouble(d);
    }

    public PObject pofCreateString(String string) {
        return this.pofCreateString(new String[]{string});
    }

    public PObject pofCreateString(String[] stringArray) {
        return new TinyPObjectString(stringArray);
    }

    public PObject pofCreateLogical(boolean bl) {
        return new TinyPObjectLogical(bl);
    }

    public static class TinyPObjectLogical
    extends TinyPObject {
        private boolean m_val;

        TinyPObjectLogical(boolean bl) {
            this.m_val = bl;
        }

        public boolean poIsLogical() {
            return true;
        }

        public int poGetLength() {
            return 1;
        }

        public boolean poGetLogicalElement(int n) {
            if (n != 0) {
                throw new RuntimeException("can't retrieve element " + n);
            }
            return this.m_val;
        }

        public String poGetMode() {
            return "logical";
        }

        public String toString() {
            return this.m_val ? "T" : "F";
        }
    }

    public static class TinyPObjectString
    extends TinyPObject {
        private String[] m_elements;

        TinyPObjectString(String[] stringArray) {
            int n = stringArray.length;
            this.m_elements = new String[n];
            for (int i = 0; i < n; ++i) {
                if (stringArray[i] == null) {
                    throw new RuntimeException("can't create PObject string vector with null entry");
                }
                this.m_elements[i] = stringArray[i];
            }
        }

        public boolean poIsString() {
            return true;
        }

        public int poGetLength() {
            return this.m_elements.length;
        }

        public String poGetStringElement(int n) {
            return this.m_elements[n];
        }

        public String poGetMode() {
            return "character";
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < this.poGetLength(); ++i) {
                if (i > 0) {
                    stringBuffer.append(",");
                }
                String string = this.poGetName(i);
                String string2 = this.poGetStringElement(i);
                if (string != null && !string.equals("")) {
                    stringBuffer.append(string + "=");
                }
                stringBuffer.append("\"");
                stringBuffer.append(string2);
                stringBuffer.append("\"");
            }
            return stringBuffer.toString();
        }
    }

    public static class TinyPObjectDouble
    extends TinyPObject {
        private double m_val;

        TinyPObjectDouble(double d) {
            this.m_val = d;
        }

        public boolean poIsDouble() {
            return true;
        }

        public int poGetLength() {
            return 1;
        }

        public double poGetDoubleElement(int n) {
            if (n != 0) {
                throw new RuntimeException("can't retrieve element " + n);
            }
            return this.m_val;
        }

        public String poGetMode() {
            return "double";
        }

        public String toString() {
            return Double.toString(this.m_val);
        }
    }

    public static class TinyPObjectRecursive
    extends TinyPObject {
        private String m_mode;
        private PObject[] m_elements;

        TinyPObjectRecursive(String string, String[] stringArray, PObject[] pObjectArray) {
            int n;
            this.m_mode = string;
            int n2 = pObjectArray.length;
            this.m_elements = new PObject[n2];
            for (n = 0; n < n2; ++n) {
                if (pObjectArray[n] == null) {
                    throw new RuntimeException("can't create PObject recursive vector with null entry");
                }
                this.m_elements[n] = pObjectArray[n];
            }
            if (stringArray != null) {
                for (n = 0; n < stringArray.length; ++n) {
                    this.poSetName(n, stringArray[n]);
                }
            }
        }

        public boolean poIsRecursive() {
            return true;
        }

        public PObject poGetElement(int n) {
            return this.m_elements[n];
        }

        public int poGetLength() {
            return this.m_elements.length;
        }

        public String poGetMode() {
            return this.m_mode;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.m_mode);
            stringBuffer.append("(");
            for (int i = 0; i < this.poGetLength(); ++i) {
                if (i > 0) {
                    stringBuffer.append(", ");
                }
                String string = this.poGetName(i);
                PObject pObject = this.poGetElement(i);
                if (string != null && !string.equals("")) {
                    stringBuffer.append(string + "=");
                }
                stringBuffer.append(pObject);
            }
            stringBuffer.append(")");
            return stringBuffer.toString();
        }
    }

    public static class TinyPObjectName
    extends TinyPObject {
        private String m_name;

        public TinyPObjectName(String string) {
            this.m_name = string;
        }

        public boolean poIsName() {
            return true;
        }

        public String poGetName() {
            return this.m_name;
        }

        public String poGetMode() {
            return "name";
        }

        public String toString() {
            return this.m_name;
        }
    }

    public static class TinyPObjectMissing
    extends TinyPObject {
        public String poGetMode() {
            return "missing";
        }

        public String toString() {
            return this.poGetMode();
        }

        public boolean poIsMissing() {
            return true;
        }
    }

    public static class TinyPObjectNull
    extends TinyPObject {
        public String poGetMode() {
            return "NULL";
        }

        public String toString() {
            return this.poGetMode();
        }

        public boolean poIsNull() {
            return true;
        }
    }

    public static abstract class TinyPObject
    implements PObject {
        private String[] m_names = null;
        private int m_startLine = -1;
        private int m_startColumn = -1;
        private int m_endLine = -1;
        private int m_endColumn = -1;

        public boolean poIsNull() {
            return false;
        }

        public boolean poIsMissing() {
            return false;
        }

        public boolean poIsName() {
            return false;
        }

        public boolean poIsDouble() {
            return false;
        }

        public boolean poIsString() {
            return false;
        }

        public boolean poIsLogical() {
            return false;
        }

        public boolean poIsRecursive() {
            return false;
        }

        public abstract String poGetMode();

        public int poGetLength() {
            return 0;
        }

        public PObject poGetElement(int n) {
            throw new RuntimeException("this operation not allowed on " + this.poGetMode() + " object");
        }

        public PObject poGetElement(String string) {
            for (int i = 0; i < this.poGetLength(); ++i) {
                if (!this.poGetName(i).equals(string)) continue;
                return this.poGetElement(i);
            }
            return null;
        }

        public double poGetDoubleElement(int n) {
            throw new RuntimeException("this operation not allowed on " + this.poGetMode() + " object");
        }

        public String poGetStringElement(int n) {
            throw new RuntimeException("this operation not allowed on " + this.poGetMode() + " object");
        }

        public boolean poGetLogicalElement(int n) {
            throw new RuntimeException("this operation not allowed on " + this.poGetMode() + " object");
        }

        public String poGetName() {
            throw new RuntimeException("this operation not allowed on " + this.poGetMode() + " object");
        }

        public String poGetName(int n) {
            String string = null;
            if (this.m_names != null && n >= 0 && n < this.m_names.length) {
                string = this.m_names[n];
            }
            if (string == null) {
                string = "";
            }
            return string;
        }

        public void poSetName(int n, String string) {
            if (this.m_names == null) {
                this.m_names = new String[this.poGetLength()];
            }
            if (n >= 0 && n < this.m_names.length) {
                this.m_names[n] = string;
            }
        }

        public void poSetAttribute(String string, PObject pObject) {
            int n = 0;
            if (pObject.poIsDouble() && pObject.poGetLength() > 0) {
                n = (int)pObject.poGetDoubleElement(0);
            }
            if (string.equals("start.line")) {
                this.m_startLine = n;
            } else if (string.equals("start.column")) {
                this.m_startColumn = n;
            } else if (string.equals("end.line")) {
                this.m_endLine = n;
            } else if (string.equals("end.column")) {
                this.m_endColumn = n;
            } else {
                throw new RuntimeException("attribute name " + string + " not supported");
            }
        }

        public PObject poGetAttribute(String string) {
            int n = 0;
            if (string.equals("start.line")) {
                n = this.m_startLine;
            } else if (string.equals("start.column")) {
                n = this.m_startColumn;
            } else if (string.equals("end.line")) {
                n = this.m_endLine;
            } else if (string.equals("end.column")) {
                n = this.m_endColumn;
            } else {
                throw new RuntimeException("attribute name " + string + " not supported");
            }
            return new TinyPObjectDouble(n);
        }
    }
}

