/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.splus.statdlg;

import com.insightful.controls.SplusBoxFiller;
import com.insightful.controls.SplusCheckBox;
import com.insightful.controls.SplusComboBox;
import com.insightful.controls.SplusDialog;
import com.insightful.controls.SplusFunctionInfo;
import com.insightful.controls.SplusGroupPanel;
import com.insightful.controls.SplusIntegerSpinner;
import com.insightful.controls.SplusListBox;
import com.insightful.controls.SplusTextField;
import com.insightful.splus.SplusDataColumnComboBox;
import com.insightful.splus.SplusDataColumnListProvider;
import com.insightful.splus.SplusDataResult;
import com.insightful.splus.SplusDataSetComboBox;
import com.insightful.splus.SplusObjectComboBox;
import com.insightful.splus.SplusSystem;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public class QualityControlGroupedDialog
extends SplusDialog {
    SplusDataSetComboBox dataSet;
    SplusDataColumnComboBox dataColumn;
    SplusDataColumnComboBox groupColumn;
    SplusComboBox groupingType;
    SplusComboBox calibrationType;
    SplusComboBox chartType;
    SplusComboBox savedObject;
    SplusComboBox limitsType;
    SplusListBox groupValues;
    SplusCheckBox capabilitySummary;
    SplusCheckBox plotShewhart;
    SplusCheckBox plotCusum;
    SplusCheckBox includeStats;
    SplusCheckBox includeCalib;
    SplusCheckBox resetControl;
    SplusTextField groupSize;
    SplusTextField capabilityRange;
    SplusTextField capabilityMin;
    SplusTextField capabilityMax;
    SplusTextField targetOverride;
    SplusTextField stdDevOverride;
    SplusTextField confLevel;
    SplusTextField numSigmas;
    SplusTextField lowerLimit;
    SplusTextField upperLimit;
    SplusTextField decisionInterval;
    SplusTextField seShift;
    SplusTextField headstart;
    SplusIntegerSpinner maxRunLength;

    public QualityControlGroupedDialog() {
        super("Quality Control Charts (Continuous Grouped)");
        JTabbedPane jTabbedPane = new JTabbedPane();
        SplusFunctionInfo splusFunctionInfo = new SplusFunctionInfo("menuQccGrouped");
        this.setFunctionInfo(splusFunctionInfo);
        JPanel jPanel = new JPanel();
        jTabbedPane.addTab("Model", jPanel);
        Box box = new Box(1);
        Box box2 = new Box(1);
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.add(box);
        jPanel.add(box2);
        SplusGroupPanel splusGroupPanel = new SplusGroupPanel("Data");
        box.add(splusGroupPanel);
        this.dataSet = new SplusDataSetComboBox();
        splusGroupPanel.add(this.dataSet);
        splusFunctionInfo.add(this.dataSet, "df");
        this.dataColumn = new SplusDataColumnComboBox("Variable", 'V', (SplusDataColumnListProvider)this.dataSet);
        splusGroupPanel.add(this.dataColumn);
        splusFunctionInfo.add(this.dataColumn, "sample.column", true);
        this.groupingType = new SplusComboBox("Group By", 'B', new String[]{"Column", "Size"});
        this.groupingType.setValue("Column");
        this.groupingType.setEditable(false);
        splusGroupPanel.add(this.groupingType);
        splusFunctionInfo.add(this.groupingType, "group.type", true);
        this.groupingType.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = QualityControlGroupedDialog.this.groupingType.getValue().equals("Column");
                QualityControlGroupedDialog.this.groupColumn.setEnabled(bl);
                QualityControlGroupedDialog.this.groupSize.setEnabled(!bl);
            }
        });
        this.groupColumn = new SplusDataColumnComboBox("Group Column", 'C', (SplusDataColumnListProvider)this.dataSet);
        this.groupColumn.setValue("");
        splusGroupPanel.add(this.groupColumn);
        splusFunctionInfo.add(this.groupColumn, "group.column", true);
        this.groupColumn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String[] stringArray;
                String string = QualityControlGroupedDialog.this.dataSet.getValue().trim();
                String string2 = QualityControlGroupedDialog.this.groupColumn.getValue().trim();
                if (string.equals("") || string2.equals("")) {
                    stringArray = new String[]{};
                } else {
                    String string3 = "javaGuiQccGroups(\"" + string + "\", \"" + string2 + "\")";
                    try {
                        SplusDataResult splusDataResult = SplusSystem.getEngineQueryHandler().processDataQuery(string3);
                        stringArray = splusDataResult.getStringData();
                    }
                    catch (Exception exception) {
                        stringArray = new String[]{};
                    }
                }
                QualityControlGroupedDialog.this.groupValues.setOptionList(stringArray);
            }
        });
        this.groupSize = new SplusTextField("Group Size", 'Z');
        this.groupSize.setEnabled(false);
        splusGroupPanel.add(this.groupSize);
        splusFunctionInfo.add(this.groupSize, "group.size");
        SplusGroupPanel splusGroupPanel2 = new SplusGroupPanel("Chart Type");
        box.add(splusGroupPanel2);
        this.chartType = new SplusComboBox("Type", 'T', new String[]{"Mean (xbar)", "Std Dev (x)", "Range (R)"});
        this.chartType.setValue("Mean (xbar)");
        this.chartType.setEditable(false);
        splusGroupPanel2.add(this.chartType);
        splusFunctionInfo.add(this.chartType, "type", true);
        this.chartType.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (QualityControlGroupedDialog.this.chartType.getValue().equals("Range (R)")) {
                    QualityControlGroupedDialog.this.plotCusum.setValue("F");
                    QualityControlGroupedDialog.this.plotCusum.setEnabled(false);
                } else {
                    QualityControlGroupedDialog.this.plotCusum.setEnabled(true);
                }
            }
        });
        box.add(new SplusBoxFiller());
        SplusGroupPanel splusGroupPanel3 = new SplusGroupPanel("Calibration");
        box2.add(splusGroupPanel3);
        this.calibrationType = new SplusComboBox("Type", 'Y', new String[]{"Self", "Groups", "Saved"});
        this.calibrationType.setValue("Self");
        this.calibrationType.setEditable(false);
        splusGroupPanel3.add(this.calibrationType);
        splusFunctionInfo.add(this.calibrationType, "calib.type", true);
        this.groupValues = new SplusListBox("Groups", 'G', new String[0]);
        this.groupValues.setEnabled(false);
        splusGroupPanel3.add(this.groupValues);
        splusFunctionInfo.add(this.groupValues, "calib.gps", true, true);
        this.savedObject = new SplusComboBox("Saved Object", 'O', new String[0]);
        this.savedObject.setEnabled(false);
        this.savedObject.setOptionList(SplusObjectComboBox.getObjectsOfClass("qcc", true));
        this.savedObject.setValue("");
        splusGroupPanel3.add(this.savedObject);
        splusFunctionInfo.add(this.savedObject, "calib.saved", true);
        this.calibrationType.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = QualityControlGroupedDialog.this.calibrationType.getValue();
                QualityControlGroupedDialog.this.groupValues.setEnabled(string.equals("Groups"));
                QualityControlGroupedDialog.this.savedObject.setEnabled(string.equals("Saved"));
            }
        });
        SplusGroupPanel splusGroupPanel4 = new SplusGroupPanel("Save Calibration Object");
        box2.add(splusGroupPanel4);
        SplusTextField splusTextField = new SplusTextField("Save As", 'S');
        splusGroupPanel4.add(splusTextField);
        splusFunctionInfo.setResultControl(splusTextField);
        box2.add(new SplusBoxFiller());
        JPanel jPanel2 = new JPanel();
        jTabbedPane.addTab("Results", jPanel2);
        Box box3 = new Box(1);
        Box box4 = new Box(1);
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel2.add(box3);
        jPanel2.add(box4);
        SplusGroupPanel splusGroupPanel5 = new SplusGroupPanel("Printed Results");
        box3.add(splusGroupPanel5);
        SplusCheckBox splusCheckBox = new SplusCheckBox("Calibration Summary", 'C');
        splusGroupPanel5.add(splusCheckBox);
        splusFunctionInfo.add(splusCheckBox, "print.calibration.p");
        SplusCheckBox splusCheckBox2 = new SplusCheckBox("Chart Summary", 'H');
        splusGroupPanel5.add(splusCheckBox2);
        splusFunctionInfo.add(splusCheckBox2, "print.chart.p");
        this.capabilitySummary = new SplusCheckBox("Capability", 'P');
        splusGroupPanel5.add(this.capabilitySummary);
        splusFunctionInfo.add(this.capabilitySummary, "print.capability.p");
        box3.add(new SplusBoxFiller());
        SplusGroupPanel splusGroupPanel6 = new SplusGroupPanel("Capability Options");
        box4.add(splusGroupPanel6);
        this.capabilityRange = new SplusTextField("Allowable Range", 'R');
        this.capabilityRange.setEnabled(false);
        splusGroupPanel6.add(this.capabilityRange);
        splusFunctionInfo.add(this.capabilityRange, "cap.range");
        this.capabilityMin = new SplusTextField("Lower Limit", 'L');
        this.capabilityMin.setEnabled(false);
        splusGroupPanel6.add(this.capabilityMin);
        splusFunctionInfo.add(this.capabilityMin, "cap.min");
        this.capabilityMax = new SplusTextField("Upper Limit", 'L');
        this.capabilityMax.setEnabled(false);
        splusGroupPanel6.add(this.capabilityMax);
        splusFunctionInfo.add(this.capabilityMax, "cap.max");
        this.capabilitySummary.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = QualityControlGroupedDialog.this.capabilitySummary.getValue().equals("T");
                QualityControlGroupedDialog.this.capabilityRange.setEnabled(bl);
                QualityControlGroupedDialog.this.capabilityMin.setEnabled(bl);
                QualityControlGroupedDialog.this.capabilityMax.setEnabled(bl);
            }
        });
        box4.add(new SplusBoxFiller());
        JPanel jPanel3 = new JPanel();
        jTabbedPane.addTab("Plot", jPanel3);
        Box box5 = new Box(1);
        Box box6 = new Box(1);
        jPanel3.setLayout(new BoxLayout(jPanel3, 0));
        jPanel3.add(box5);
        jPanel3.add(box6);
        SplusGroupPanel splusGroupPanel7 = new SplusGroupPanel("Plots");
        box5.add(splusGroupPanel7);
        this.plotShewhart = new SplusCheckBox("Shewhart", 'H');
        this.plotShewhart.setValue("T");
        splusGroupPanel7.add(this.plotShewhart);
        splusFunctionInfo.add(this.plotShewhart, "plot.shewhart.p");
        this.plotCusum = new SplusCheckBox("Cusum", 'U');
        splusGroupPanel7.add(this.plotCusum);
        splusFunctionInfo.add(this.plotCusum, "plot.cusum.p");
        SplusGroupPanel splusGroupPanel8 = new SplusGroupPanel("General Options");
        box5.add(splusGroupPanel8);
        this.includeStats = new SplusCheckBox("Include Statistics", 'S');
        this.includeStats.setValue("T");
        splusGroupPanel8.add(this.includeStats);
        splusFunctionInfo.add(this.includeStats, "add.stats");
        this.includeCalib = new SplusCheckBox("Include Calibration Data", 'C');
        this.includeCalib.setValue("T");
        splusGroupPanel8.add(this.includeCalib);
        splusFunctionInfo.add(this.includeCalib, "chart.all");
        this.targetOverride = new SplusTextField("Target Override", 'T');
        splusGroupPanel8.add(this.targetOverride);
        splusFunctionInfo.add(this.targetOverride, "target");
        this.stdDevOverride = new SplusTextField("Std Dev Override", 'D');
        splusGroupPanel8.add(this.stdDevOverride);
        splusFunctionInfo.add(this.stdDevOverride, "std.dev");
        box5.add(new SplusBoxFiller());
        SplusGroupPanel splusGroupPanel9 = new SplusGroupPanel("Shewhart Options");
        box6.add(splusGroupPanel9);
        this.limitsType = new SplusComboBox("Limits Type", 'T', new String[]{"Confidence Level", "Number of Sigmas", "Specified Limits"});
        this.limitsType.setValue("Confidence Level");
        this.limitsType.setEditable(false);
        splusGroupPanel9.add(this.limitsType);
        splusFunctionInfo.add(this.limitsType, "limits.type", true);
        this.confLevel = new SplusTextField("Confidence Level", 'L');
        this.confLevel.setValue("0.999");
        splusGroupPanel9.add(this.confLevel);
        splusFunctionInfo.add(this.confLevel, "confidence.level");
        this.numSigmas = new SplusTextField("Number of Sigmas", 'G');
        this.numSigmas.setEnabled(false);
        splusGroupPanel9.add(this.numSigmas);
        splusFunctionInfo.add(this.numSigmas, "nsigmas");
        this.lowerLimit = new SplusTextField("Lower Limit", 'L');
        this.lowerLimit.setEnabled(false);
        splusGroupPanel9.add(this.lowerLimit);
        splusFunctionInfo.add(this.lowerLimit, "limits.min");
        this.upperLimit = new SplusTextField("Upper Limit", 'U');
        this.upperLimit.setEnabled(false);
        splusGroupPanel9.add(this.upperLimit);
        splusFunctionInfo.add(this.upperLimit, "limits.max");
        this.maxRunLength = new SplusIntegerSpinner("Max Run Length", 'X', 1, 100, 1);
        this.maxRunLength.setValue("5");
        splusGroupPanel9.add(this.maxRunLength);
        splusFunctionInfo.add(this.maxRunLength, "run.length");
        this.limitsType.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                QualityControlGroupedDialog.this.adjustLimitsType(QualityControlGroupedDialog.this.plotShewhart.getValue().equals("T"));
            }
        });
        this.plotShewhart.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = QualityControlGroupedDialog.this.plotShewhart.getValue().equals("T");
                QualityControlGroupedDialog.this.limitsType.setEnabled(bl);
                QualityControlGroupedDialog.this.maxRunLength.setEnabled(bl);
                QualityControlGroupedDialog.this.adjustLimitsType(bl);
                QualityControlGroupedDialog.this.adjustGeneralOptions(bl, QualityControlGroupedDialog.this.plotCusum.getValue().equals("T"));
            }
        });
        SplusGroupPanel splusGroupPanel10 = new SplusGroupPanel("Cusum Options");
        box6.add(splusGroupPanel10);
        this.decisionInterval = new SplusTextField("Decision Interval", 'I');
        this.decisionInterval.setValue("5");
        this.decisionInterval.setEnabled(false);
        splusGroupPanel10.add(this.decisionInterval);
        splusFunctionInfo.add(this.decisionInterval, "decision.int");
        this.seShift = new SplusTextField("SE Shift", 'E');
        this.seShift.setValue("1");
        this.seShift.setEnabled(false);
        splusGroupPanel10.add(this.seShift);
        splusFunctionInfo.add(this.seShift, "se.shift");
        this.resetControl = new SplusCheckBox("Reset when out of control", 'R');
        this.resetControl.setEnabled(false);
        splusGroupPanel10.add(this.resetControl);
        splusFunctionInfo.add(this.resetControl, "reset");
        this.headstart = new SplusTextField("Headstart Value", 'H');
        this.headstart.setEnabled(false);
        splusGroupPanel10.add(this.headstart);
        splusFunctionInfo.add(this.headstart, "headstart");
        this.resetControl.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = QualityControlGroupedDialog.this.resetControl.getValue().equals("T");
                QualityControlGroupedDialog.this.headstart.setEnabled(bl);
            }
        });
        this.plotCusum.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = QualityControlGroupedDialog.this.plotCusum.getValue().equals("T");
                QualityControlGroupedDialog.this.decisionInterval.setEnabled(bl);
                QualityControlGroupedDialog.this.seShift.setEnabled(bl);
                QualityControlGroupedDialog.this.resetControl.setEnabled(bl);
                QualityControlGroupedDialog.this.headstart.setEnabled(bl && QualityControlGroupedDialog.this.resetControl.getValue().equals("T"));
                QualityControlGroupedDialog.this.adjustGeneralOptions(QualityControlGroupedDialog.this.plotShewhart.getValue().equals("T"), bl);
            }
        });
        box6.add(new SplusBoxFiller());
        this.setCenterPanel(jTabbedPane);
    }

    private void adjustLimitsType(boolean bl) {
        boolean[] blArray = new boolean[]{false, false, false, false};
        if (bl) {
            String string = this.limitsType.getValue();
            if (string.equals("Confidence Level")) {
                blArray[0] = true;
            } else if (string.equals("Number of Sigmas")) {
                blArray[1] = true;
            } else if (string.equals("Specified Limits")) {
                blArray[3] = true;
                blArray[2] = true;
            }
        }
        this.confLevel.setEnabled(blArray[0]);
        this.numSigmas.setEnabled(blArray[1]);
        this.lowerLimit.setEnabled(blArray[2]);
        this.upperLimit.setEnabled(blArray[3]);
    }

    private void adjustGeneralOptions(boolean bl, boolean bl2) {
        boolean bl3 = bl || bl2;
        this.includeStats.setEnabled(bl3);
        this.includeCalib.setEnabled(bl3);
        this.targetOverride.setEnabled(bl3);
        this.stdDevOverride.setEnabled(bl3);
    }

    public boolean isComplete() {
        boolean bl;
        boolean bl2 = bl = this.warnIfEmpty(this.dataSet) && this.warnIfEmpty(this.dataColumn);
        if (bl) {
            bl = this.groupingType.getValue().equals("Column") ? this.warnIfEmpty(this.groupColumn) : this.warnIfEmpty(this.groupSize);
        }
        if (bl) {
            String string = this.calibrationType.getValue();
            if (string.equals("Groups")) {
                bl = this.warnIfEmpty(this.groupValues);
            } else if (string.equals("Saved")) {
                bl = this.warnIfEmpty(this.savedObject);
            }
        }
        return bl;
    }
}

