/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart;

import com.jrefinery.chart.AbstractXYItemRenderer;
import com.jrefinery.chart.CrosshairInfo;
import com.jrefinery.chart.DrawInfo;
import com.jrefinery.chart.ValueAxis;
import com.jrefinery.chart.XYItemRenderer;
import com.jrefinery.chart.XYPlot;
import com.jrefinery.data.XYDataset;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;

public class AreaXYItemRenderer
extends AbstractXYItemRenderer
implements XYItemRenderer {
    public static final int SHAPES = 1;
    public static final int LINES = 2;
    public static final int SHAPES_AND_LINES = 3;
    public static final int AREA = 4;
    public static final int AREA_AND_SHAPES = 5;
    protected boolean plotShapes;
    protected boolean plotLines;
    protected boolean plotArea;
    protected double shapeScale = 6.0;
    protected boolean showOutline;
    protected Line2D line;
    protected Polygon pArea = null;

    public AreaXYItemRenderer() {
        this(4);
    }

    public AreaXYItemRenderer(int n) {
        if (n == 1) {
            this.plotShapes = true;
        }
        if (n == 2) {
            this.plotLines = true;
        }
        if (n == 3) {
            this.plotShapes = true;
            this.plotLines = true;
        }
        if (n == 4) {
            this.plotArea = true;
        }
        if (n == 5) {
            this.plotArea = true;
            this.plotShapes = true;
        }
        this.line = new Line2D.Double(0.0, 0.0, 0.0, 0.0);
        this.showOutline = false;
    }

    public boolean isOutline() {
        return this.showOutline;
    }

    public void setOutline(boolean bl) {
        this.showOutline = bl;
    }

    public boolean getPlotShapes() {
        return this.plotShapes;
    }

    public boolean getPlotLines() {
        return this.plotLines;
    }

    public boolean getPlotArea() {
        return this.plotArea;
    }

    public Shape drawItem(Graphics2D graphics2D, Rectangle2D rectangle2D, DrawInfo drawInfo, XYPlot xYPlot, ValueAxis valueAxis, ValueAxis valueAxis2, XYDataset xYDataset, int n, int n2, double d, CrosshairInfo crosshairInfo) {
        double d2;
        int n3 = xYDataset.getItemCount(n);
        Shape shape = null;
        Paint paint = xYPlot.getSeriesPaint(n);
        Stroke stroke = xYPlot.getSeriesStroke(n);
        graphics2D.setPaint(paint);
        graphics2D.setStroke(stroke);
        Number number = xYDataset.getXValue(n, n2);
        Number number2 = xYDataset.getYValue(n, n2);
        double d3 = valueAxis.translateValueToJava2D(number.doubleValue(), rectangle2D);
        double d4 = valueAxis2.translateValueToJava2D(number2.doubleValue(), rectangle2D);
        if (n2 == 0) {
            this.pArea = new Polygon();
            d2 = valueAxis2.translateValueToJava2D(0.0, rectangle2D);
            this.pArea.addPoint((int)d3, (int)d2);
        }
        this.pArea.addPoint((int)d3, (int)d4);
        if (this.plotShapes) {
            Shape shape2 = xYPlot.getShape(n, n2, d3, d4, this.shapeScale);
            graphics2D.draw(shape2);
            shape = shape2;
        }
        if (this.plotLines && n2 > 0) {
            Number number3 = xYDataset.getXValue(n, n2 - 1);
            Number number4 = xYDataset.getYValue(n, n2 - 1);
            double d5 = valueAxis.translateValueToJava2D(number3.doubleValue(), rectangle2D);
            double d6 = valueAxis2.translateValueToJava2D(number4.doubleValue(), rectangle2D);
            this.line.setLine(d5, d6, d3, d4);
            graphics2D.draw(this.line);
        }
        if (this.plotArea && n2 > 0 && n2 == n3 - 1) {
            d2 = valueAxis2.translateValueToJava2D(0.0, rectangle2D);
            this.pArea.addPoint((int)d3, (int)d2);
            graphics2D.fill(this.pArea);
            shape = this.pArea;
            if (this.showOutline) {
                graphics2D.setStroke(xYPlot.outlineStroke);
                graphics2D.setPaint(xYPlot.outlinePaint);
                graphics2D.draw(this.pArea);
            }
        }
        d2 = 0.0;
        if (valueAxis.isCrosshairLockedOnData()) {
            if (valueAxis2.isCrosshairLockedOnData()) {
                crosshairInfo.updateCrosshairPoint(number.doubleValue(), number2.doubleValue());
            } else {
                crosshairInfo.updateCrosshairX(number.doubleValue());
            }
        } else if (valueAxis2.isCrosshairLockedOnData()) {
            crosshairInfo.updateCrosshairY(number2.doubleValue());
        }
        return shape;
    }
}

