/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart;

import com.jrefinery.chart.AxisConstants;
import com.jrefinery.chart.CategoryAxis;
import com.jrefinery.chart.CategoryPlot;
import com.jrefinery.chart.HorizontalAxis;
import com.jrefinery.chart.Plot;
import com.jrefinery.chart.Tick;
import com.jrefinery.chart.VerticalCategoryPlot;
import com.jrefinery.chart.event.AxisChangeEvent;
import com.jrefinery.data.CategoryDataset;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.Iterator;

public class HorizontalCategoryAxis
extends CategoryAxis
implements HorizontalAxis {
    protected boolean verticalCategoryLabels;

    public HorizontalCategoryAxis() {
        this(null, AxisConstants.DEFAULT_AXIS_LABEL_FONT, AxisConstants.DEFAULT_AXIS_LABEL_PAINT, AxisConstants.DEFAULT_AXIS_LABEL_INSETS, true, false, AxisConstants.DEFAULT_TICK_LABEL_FONT, AxisConstants.DEFAULT_TICK_LABEL_PAINT, AxisConstants.DEFAULT_TICK_LABEL_INSETS, false, AxisConstants.DEFAULT_TICK_STROKE);
    }

    public HorizontalCategoryAxis(String string) {
        this(string, AxisConstants.DEFAULT_AXIS_LABEL_FONT, AxisConstants.DEFAULT_AXIS_LABEL_PAINT, AxisConstants.DEFAULT_AXIS_LABEL_INSETS, true, false, AxisConstants.DEFAULT_TICK_LABEL_FONT, AxisConstants.DEFAULT_TICK_LABEL_PAINT, AxisConstants.DEFAULT_TICK_LABEL_INSETS, false, AxisConstants.DEFAULT_TICK_STROKE);
    }

    public HorizontalCategoryAxis(String string, Font font, Paint paint, Insets insets, boolean bl, boolean bl2, Font font2, Paint paint2, Insets insets2, boolean bl3, Stroke stroke) {
        super(string, font, paint, insets, bl, font2, paint2, insets2, bl3, stroke);
        this.verticalCategoryLabels = bl2;
    }

    public boolean getVerticalCategoryLabels() {
        return this.verticalCategoryLabels;
    }

    public void setVerticalCategoryLabels(boolean bl) {
        if (this.verticalCategoryLabels != bl) {
            this.verticalCategoryLabels = bl;
            this.notifyListeners(new AxisChangeEvent(this));
        }
    }

    public void draw(Graphics2D graphics2D, Rectangle2D rectangle2D, Rectangle2D rectangle2D2) {
        Object object;
        Object object2;
        if (this.label != null) {
            graphics2D.setFont(this.labelFont);
            graphics2D.setPaint(this.labelPaint);
            object2 = graphics2D.getFontRenderContext();
            object = this.labelFont.getStringBounds(this.label, (FontRenderContext)object2);
            LineMetrics lineMetrics = this.labelFont.getLineMetrics(this.label, (FontRenderContext)object2);
            float f = (float)(rectangle2D2.getX() + rectangle2D2.getWidth() / 2.0 - ((RectangularShape)object).getWidth() / 2.0);
            float f2 = (float)(rectangle2D.getMaxY() - (double)this.labelInsets.bottom - (double)lineMetrics.getDescent() - (double)lineMetrics.getLeading());
            graphics2D.drawString(this.label, f, f2);
        }
        if (this.tickLabelsVisible) {
            graphics2D.setFont(this.tickLabelFont);
            graphics2D.setPaint(this.tickLabelPaint);
            this.refreshTicks(graphics2D, rectangle2D, rectangle2D2);
            object2 = this.ticks.iterator();
            while (object2.hasNext()) {
                object = (Tick)object2.next();
                if (this.verticalCategoryLabels) {
                    this.drawVerticalString(((Tick)object).getText(), graphics2D, ((Tick)object).getX(), ((Tick)object).getY());
                    continue;
                }
                graphics2D.drawString(((Tick)object).getText(), ((Tick)object).getX(), ((Tick)object).getY());
            }
        }
    }

    public void refreshTicks(Graphics2D graphics2D, Rectangle2D rectangle2D, Rectangle2D rectangle2D2) {
        this.ticks.clear();
        CategoryPlot categoryPlot = (CategoryPlot)this.plot;
        CategoryDataset categoryDataset = (CategoryDataset)this.plot.getChart().getDataset();
        if (categoryDataset != null) {
            FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
            Font font = this.getTickLabelFont();
            graphics2D.setFont(font);
            int n = 0;
            float f = 0.0f;
            float f2 = 0.0f;
            Iterator iterator = categoryDataset.getCategories().iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                String string = e.toString();
                Rectangle2D rectangle2D3 = font.getStringBounds(string, fontRenderContext);
                LineMetrics lineMetrics = font.getLineMetrics(string, fontRenderContext);
                float f3 = (float)categoryPlot.getCategoryCoordinate(n, rectangle2D2);
                if (this.verticalCategoryLabels) {
                    f = (float)((double)f3 + rectangle2D3.getHeight() / 2.0 - (double)lineMetrics.getDescent());
                    f2 = (float)(rectangle2D2.getMaxY() + (double)this.tickLabelInsets.top + rectangle2D3.getWidth());
                } else {
                    f = (float)((double)f3 - rectangle2D3.getWidth() / 2.0);
                    f2 = (float)(rectangle2D2.getMaxY() + (double)this.tickLabelInsets.top + (double)lineMetrics.getHeight() - (double)lineMetrics.getDescent());
                }
                Tick tick = new Tick(e, string, f, f2);
                this.ticks.add(tick);
                ++n;
            }
        }
    }

    public double reserveHeight(Graphics2D graphics2D, Plot plot, Rectangle2D rectangle2D) {
        double d = 0.0;
        if (this.label != null) {
            Rectangle2D rectangle2D2 = this.labelFont.getStringBounds(this.label, graphics2D.getFontRenderContext());
            d = (double)(this.labelInsets.top + this.labelInsets.bottom) + rectangle2D2.getHeight();
        }
        double d2 = 0.0;
        if (this.tickLabelsVisible) {
            graphics2D.setFont(this.tickLabelFont);
            this.refreshTicks(graphics2D, rectangle2D, rectangle2D);
            d2 = (double)(this.tickLabelInsets.top + this.tickLabelInsets.bottom) + this.getMaxTickLabelHeight(graphics2D, rectangle2D, this.verticalCategoryLabels);
        }
        return d + d2;
    }

    public Rectangle2D reserveAxisArea(Graphics2D graphics2D, Plot plot, Rectangle2D rectangle2D, double d) {
        double d2 = 0.0;
        if (this.label != null) {
            Rectangle2D rectangle2D2 = this.labelFont.getStringBounds(this.label, graphics2D.getFontRenderContext());
            d2 = (double)(this.labelInsets.top + this.labelInsets.bottom) + rectangle2D2.getHeight();
        }
        double d3 = 0.0;
        if (this.tickLabelsVisible) {
            graphics2D.setFont(this.tickLabelFont);
            this.refreshTicks(graphics2D, rectangle2D, rectangle2D);
            d3 = (double)(this.tickLabelInsets.top + this.tickLabelInsets.bottom) + this.getMaxTickLabelHeight(graphics2D, rectangle2D, this.verticalCategoryLabels);
        }
        return new Rectangle2D.Double(rectangle2D.getX(), rectangle2D.getMaxY() - d2 - d3, rectangle2D.getWidth() - d, d2 + d3);
    }

    private double getMaxTickLabelHeight(Graphics2D graphics2D, Rectangle2D rectangle2D, boolean bl) {
        Font font = this.getTickLabelFont();
        graphics2D.setFont(font);
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        double d = 0.0;
        if (bl) {
            Iterator iterator = this.ticks.iterator();
            while (iterator.hasNext()) {
                Tick tick = (Tick)iterator.next();
                Rectangle2D rectangle2D2 = font.getStringBounds(tick.getText(), fontRenderContext);
                if (!(rectangle2D2.getWidth() > d)) continue;
                d = rectangle2D2.getWidth();
            }
        } else {
            LineMetrics lineMetrics = font.getLineMetrics("Sample", fontRenderContext);
            d = lineMetrics.getHeight();
        }
        return d;
    }

    protected boolean isCompatiblePlot(Plot plot) {
        return plot instanceof VerticalCategoryPlot;
    }

    public void configure() {
    }
}

