/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart;

import com.jrefinery.chart.Axis;
import com.jrefinery.chart.AxisConstants;
import com.jrefinery.chart.AxisNotCompatibleException;
import com.jrefinery.chart.DrawInfo;
import com.jrefinery.chart.HorizontalAxis;
import com.jrefinery.chart.JFreeChart;
import com.jrefinery.chart.PlotNotCompatibleException;
import com.jrefinery.chart.ValueAxis;
import com.jrefinery.chart.VerticalAxis;
import com.jrefinery.chart.event.AxisChangeEvent;
import com.jrefinery.chart.event.AxisChangeListener;
import com.jrefinery.chart.event.ChartChangeEvent;
import com.jrefinery.chart.event.ChartChangeListener;
import com.jrefinery.chart.event.PlotChangeEvent;
import com.jrefinery.chart.event.PlotChangeListener;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public abstract class Plot
implements AxisChangeListener,
ChartChangeListener,
AxisConstants {
    public static final Number ZERO = new Integer(0);
    protected static final Insets DEFAULT_INSETS = new Insets(2, 2, 2, 10);
    protected static final Paint DEFAULT_BACKGROUND_PAINT = Color.white;
    protected static final float DEFAULT_BACKGROUND_ALPHA = 1.0f;
    protected static final Stroke DEFAULT_OUTLINE_STROKE = new BasicStroke(1.0f);
    protected static final Paint DEFAULT_OUTLINE_PAINT = Color.gray;
    protected static final float DEFAULT_FOREGROUND_ALPHA = 1.0f;
    protected static final int MINIMUM_WIDTH_TO_DRAW = 10;
    protected static final int MINIMUM_HEIGHT_TO_DRAW = 10;
    protected JFreeChart chart = null;
    protected Axis verticalAxis;
    protected Axis horizontalAxis;
    protected Insets insets;
    protected Paint backgroundPaint;
    protected Image backgroundImage;
    protected float backgroundAlpha;
    protected Stroke outlineStroke;
    protected Paint outlinePaint;
    protected Paint[] seriesPaint;
    protected Stroke[] seriesStroke;
    protected Paint[] seriesOutlinePaint;
    protected Stroke[] seriesOutlineStroke;
    protected float foregroundAlpha;
    protected List listeners;

    protected Plot(Axis axis, Axis axis2) {
        this(axis, axis2, DEFAULT_INSETS, DEFAULT_BACKGROUND_PAINT, null, 1.0f, DEFAULT_OUTLINE_STROKE, DEFAULT_OUTLINE_PAINT, 1.0f);
    }

    protected Plot(Axis axis, Axis axis2, Insets insets, Paint paint, Image image, float f, Stroke stroke, Paint paint2, float f2) {
        this.horizontalAxis = axis;
        if (axis != null) {
            axis.setPlot(this);
            axis.addChangeListener(this);
        }
        this.verticalAxis = axis2;
        if (axis2 != null) {
            axis2.setPlot(this);
            axis2.addChangeListener(this);
        }
        this.insets = insets;
        this.backgroundPaint = paint;
        this.backgroundAlpha = f;
        this.outlineStroke = stroke;
        this.outlinePaint = paint2;
        this.foregroundAlpha = f2;
        this.seriesStroke = new Stroke[]{new BasicStroke(1.0f)};
        this.seriesPaint = new Paint[]{Color.red, Color.blue, Color.green, Color.yellow, Color.cyan, Color.magenta, Color.orange, Color.pink, Color.lightGray};
        this.seriesOutlinePaint = new Paint[]{Color.gray};
        this.seriesOutlineStroke = new Stroke[]{new BasicStroke(0.5f)};
        this.listeners = new ArrayList();
    }

    public JFreeChart getChart() {
        return this.chart;
    }

    public Axis getAxis(int n) {
        switch (n) {
            case 0: {
                return this.horizontalAxis;
            }
            case 1: {
                return this.verticalAxis;
            }
        }
        return null;
    }

    public HorizontalAxis getHorizontalAxis() {
        return (HorizontalAxis)((Object)this.horizontalAxis);
    }

    public VerticalAxis getVerticalAxis() {
        return (VerticalAxis)((Object)this.verticalAxis);
    }

    public Insets getInsets() {
        return this.insets;
    }

    public void setInsets(Insets insets) {
        if (!this.insets.equals(insets)) {
            this.insets = insets;
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public Paint getBackgroundPaint() {
        return this.backgroundPaint;
    }

    public void setBackgroundPaint(Paint paint) {
        if (paint == null) {
            if (this.backgroundPaint != null) {
                this.backgroundPaint = null;
                this.notifyListeners(new PlotChangeEvent(this));
            }
        } else {
            if (this.backgroundPaint != null && this.backgroundPaint.equals(paint)) {
                return;
            }
            this.backgroundPaint = paint;
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public float getBackgroundAlpha() {
        return this.backgroundAlpha;
    }

    public void setBackgroundAlpha(float f) {
        if (this.backgroundAlpha != f) {
            this.backgroundAlpha = f;
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public void setBackgroundImage(Image image) {
        this.backgroundImage = image;
    }

    public Stroke getOutlineStroke() {
        return this.outlineStroke;
    }

    public void setOutlineStroke(Stroke stroke) {
        if (stroke == null) {
            if (this.outlineStroke != null) {
                this.outlineStroke = null;
                this.notifyListeners(new PlotChangeEvent(this));
            }
        } else {
            if (this.outlineStroke != null && this.outlineStroke.equals(stroke)) {
                return;
            }
            this.outlineStroke = stroke;
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public Paint getOutlinePaint() {
        return this.outlinePaint;
    }

    public void setOutlinePaint(Paint paint) {
        if (paint == null) {
            if (this.outlinePaint != null) {
                this.outlinePaint = null;
                this.notifyListeners(new PlotChangeEvent(this));
            }
        } else {
            if (this.outlinePaint != null && this.outlinePaint.equals(paint)) {
                return;
            }
            this.outlinePaint = paint;
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public float getForegroundAlpha() {
        return this.foregroundAlpha;
    }

    public void setForegroundAlpha(float f) {
        if (this.foregroundAlpha != f) {
            this.foregroundAlpha = f;
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public void setChart(JFreeChart jFreeChart) {
        if (this.chart != null) {
            jFreeChart.removeChangeListener(this);
        }
        this.chart = jFreeChart;
        if (this.verticalAxis != null) {
            this.verticalAxis.configure();
        }
        if (this.horizontalAxis != null) {
            this.horizontalAxis.configure();
        }
    }

    public void setVerticalAxis(Axis axis) throws AxisNotCompatibleException {
        if (this.isCompatibleVerticalAxis(axis)) {
            if (axis != null) {
                try {
                    axis.setPlot(this);
                }
                catch (PlotNotCompatibleException plotNotCompatibleException) {
                    throw new AxisNotCompatibleException("Plot.setVerticalAxis(...): plot not compatible with axis.");
                }
                axis.addChangeListener(this);
            }
            if (this.verticalAxis != null) {
                this.verticalAxis.removeChangeListener(this);
            }
        } else {
            throw new AxisNotCompatibleException("Plot.setVerticalAxis(...): axis not compatible with plot.");
        }
        this.verticalAxis = axis;
    }

    public void setHorizontalAxis(Axis axis) throws AxisNotCompatibleException {
        if (this.isCompatibleHorizontalAxis(axis)) {
            if (axis != null) {
                try {
                    axis.setPlot(this);
                }
                catch (PlotNotCompatibleException plotNotCompatibleException) {
                    throw new AxisNotCompatibleException("Plot.setHorizontalAxis(...): plot not compatible with axis.");
                }
                axis.addChangeListener(this);
            }
            if (this.horizontalAxis != null) {
                this.horizontalAxis.removeChangeListener(this);
            }
        } else {
            throw new AxisNotCompatibleException("Plot.setHorizontalAxis(...): axis not compatible with plot.");
        }
        this.horizontalAxis = axis;
    }

    public Paint getSeriesPaint(int n) {
        return this.seriesPaint[n % this.seriesPaint.length];
    }

    public void setSeriesPaint(Paint[] paintArray) {
        this.seriesPaint = paintArray;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public Stroke getSeriesStroke(int n) {
        return this.seriesStroke[n % this.seriesStroke.length];
    }

    public void setSeriesStroke(Stroke[] strokeArray) {
        this.seriesStroke = strokeArray;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public Paint getSeriesOutlinePaint(int n) {
        return this.seriesOutlinePaint[n % this.seriesOutlinePaint.length];
    }

    public void setSeriesOutlinePaint(Paint[] paintArray) {
        this.seriesOutlinePaint = paintArray;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public Stroke getSeriesOutlineStroke(int n) {
        return this.seriesOutlineStroke[n % this.seriesOutlinePaint.length];
    }

    public void setSeriesOutlineStroke(Stroke[] strokeArray) {
        this.seriesOutlineStroke = strokeArray;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public Shape getShape(int n, int n2, double d, double d2, double d3) {
        if (n == 0) {
            return new Rectangle2D.Double(d - 0.5 * d3, d2 - 0.5 * d3, d3, d3);
        }
        return new Ellipse2D.Double(d - 0.5 * d3, d2 - 0.5 * d3, d3, d3);
    }

    public Shape getShape(int n, Object object, double d, double d2, double d3) {
        return new Ellipse2D.Double(d - 0.5 * d3, d2 - 0.5 * d3, d3, d3);
    }

    public void notifyListeners(PlotChangeEvent plotChangeEvent) {
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            PlotChangeListener plotChangeListener = (PlotChangeListener)iterator.next();
            plotChangeListener.plotChanged(plotChangeEvent);
        }
    }

    public void addChangeListener(PlotChangeListener plotChangeListener) {
        this.listeners.add(plotChangeListener);
    }

    public void removeChangeListener(PlotChangeListener plotChangeListener) {
        this.listeners.remove(plotChangeListener);
    }

    public abstract boolean isCompatibleHorizontalAxis(Axis var1);

    public abstract boolean isCompatibleVerticalAxis(Axis var1);

    public abstract void draw(Graphics2D var1, Rectangle2D var2, DrawInfo var3);

    public void drawOutlineAndBackground(Graphics2D graphics2D, Rectangle2D rectangle2D) {
        Composite composite;
        if (this.backgroundPaint != null) {
            composite = graphics2D.getComposite();
            graphics2D.setComposite(AlphaComposite.getInstance(3, this.backgroundAlpha));
            graphics2D.setPaint(this.backgroundPaint);
            graphics2D.fill(rectangle2D);
            graphics2D.setComposite(composite);
        }
        if (this.backgroundImage != null) {
            composite = graphics2D.getComposite();
            graphics2D.setComposite(AlphaComposite.getInstance(3, 0.15f));
            graphics2D.drawImage(this.backgroundImage, (int)rectangle2D.getX(), (int)rectangle2D.getY(), (int)rectangle2D.getWidth(), (int)rectangle2D.getHeight(), null);
            graphics2D.setComposite(composite);
        }
        if (this.outlineStroke != null && this.outlinePaint != null) {
            graphics2D.setStroke(this.outlineStroke);
            graphics2D.setPaint(this.outlinePaint);
            graphics2D.draw(rectangle2D);
        }
    }

    public void handleClick(int n, int n2, DrawInfo drawInfo) {
        double d;
        ValueAxis valueAxis;
        if (this.horizontalAxis instanceof ValueAxis) {
            valueAxis = (ValueAxis)this.horizontalAxis;
            d = valueAxis.translateJava2DtoValue(n, drawInfo.getDataArea());
        }
        if (this.verticalAxis instanceof ValueAxis) {
            valueAxis = (ValueAxis)this.verticalAxis;
            d = valueAxis.translateJava2DtoValue(n2, drawInfo.getDataArea());
        }
    }

    public abstract void zoom(double var1);

    public void axisChanged(AxisChangeEvent axisChangeEvent) {
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public void chartChanged(ChartChangeEvent chartChangeEvent) {
        if (chartChangeEvent.getType() == 2) {
            if (this.verticalAxis != null) {
                this.verticalAxis.configure();
            }
            if (this.horizontalAxis != null) {
                this.horizontalAxis.configure();
            }
        }
        if (chartChangeEvent.getType() == 3) {
            if (this.verticalAxis != null) {
                this.verticalAxis.configure();
            }
            if (this.horizontalAxis != null) {
                this.horizontalAxis.configure();
            }
        }
    }

    public abstract String getPlotType();
}

