/*
 * Decompiled with CFR 0.152.
 */
package org.jfor.jfor.tools;

import java.io.IOException;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public abstract class ElementVisitor {
    public final void visit(Element element) throws IOException, SAXException {
        if (element != null) {
            this.startElement(element);
            NodeList nodeList = element.getChildNodes();
            int n = 0;
            while (n < nodeList.getLength()) {
                Node node = nodeList.item(n);
                if (node instanceof Element) {
                    this.visit((Element)node);
                } else if (node instanceof CDATASection) {
                    this.visitCDATA((CDATASection)node);
                } else if (node instanceof Text) {
                    this.visitText((Text)node);
                } else if (node instanceof Comment) {
                    this.visitComment((Comment)node);
                } else {
                    this.visitNode(node);
                }
                ++n;
            }
            this.endElement(element);
        }
    }

    protected abstract void startElement(Element var1) throws IOException, SAXException;

    protected abstract void endElement(Element var1) throws IOException, SAXException;

    protected abstract void visitText(Text var1) throws IOException, SAXException;

    protected abstract void visitCDATA(CDATASection var1) throws IOException, SAXException;

    protected abstract void visitComment(Comment var1) throws IOException, SAXException;

    protected abstract void visitNode(Node var1) throws IOException, SAXException;
}

