/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai;

import com.sun.media.jai.util.PropertyUtil;
import com.sun.media.jai.util.ReaderWriterLock;
import java.awt.RenderingHints;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ContextualRenderedImageFactory;
import java.awt.image.renderable.ParameterBlock;
import java.awt.image.renderable.RenderedImageFactory;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.StreamTokenizer;
import java.text.MessageFormat;
import java.util.AbstractList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Vector;
import javax.media.jai.CollectionImage;
import javax.media.jai.CollectionImageFactory;
import javax.media.jai.JaiI18N;
import javax.media.jai.OperationDescriptor;
import javax.media.jai.OperationGraph;
import javax.media.jai.PartialOrderNode;
import javax.media.jai.PlanarImage;
import javax.media.jai.ProductOperationGraph;
import javax.media.jai.PropertyGenerator;
import javax.media.jai.PropertyGeneratorFromSource;
import javax.media.jai.PropertySource;
import javax.media.jai.PropertySourceImpl;
import javax.media.jai.RegistryInitData;
import javax.media.jai.RenderableOp;
import javax.media.jai.RenderedOp;
import javax.media.jai.Storage;
import javax.media.jai.Store;

public class OperationRegistry
implements Externalizable {
    Hashtable opDescsName = new Hashtable();
    Hashtable products = new Hashtable();
    Hashtable rifs = new Hashtable();
    Hashtable rifsByName = new Hashtable();
    int rifcount = 0;
    Hashtable cifs = new Hashtable();
    Hashtable cifsByName = new Hashtable();
    int cifcount = 0;
    Hashtable crifs = new Hashtable();
    Hashtable productPrefs = new Hashtable();
    Hashtable rifPrefs = new Hashtable();
    Hashtable cifPrefs = new Hashtable();
    protected Hashtable properties = new Hashtable();
    protected Hashtable suppressed = new Hashtable();
    protected Hashtable sourceForProp = new Hashtable();
    protected Hashtable propNames = new Hashtable();
    private static MessageFormat formatter;
    private ReaderWriterLock lock = new ReaderWriterLock();

    public OperationRegistry() {
        formatter = new MessageFormat("");
        formatter.setLocale(Locale.getDefault());
    }

    public void addPropertyGenerator(String string, PropertyGenerator propertyGenerator) {
        String string2;
        int n;
        String string3 = string.toLowerCase();
        this.lock.getWriteLock();
        Vector vector = (Vector)this.properties.get(string3);
        if (vector == null) {
            vector = new Vector();
            vector.addElement(propertyGenerator);
            this.properties.put(string3, vector);
        } else {
            vector.addElement(propertyGenerator);
        }
        vector = (Vector)this.suppressed.get(string3);
        Hashtable hashtable = (Hashtable)this.sourceForProp.get(string3);
        String[] stringArray = propertyGenerator.getPropertyNames();
        if (vector != null) {
            n = 0;
            while (n < stringArray.length) {
                string2 = stringArray[n].toLowerCase();
                vector.remove(string2);
                ++n;
            }
        }
        if (hashtable != null) {
            n = 0;
            while (n < stringArray.length) {
                string2 = stringArray[n].toLowerCase();
                hashtable.remove(string2);
                ++n;
            }
        }
        this.lock.releaseWriteLock();
    }

    public void clearCIFPreferences(String string, String string2) {
        if (string2 == null) {
            throw new NullPointerException();
        }
        String string3 = string.toLowerCase();
        this.lock.getWriteLock();
        if (!this.opDescsName.containsKey(string3)) {
            Object[] objectArray = new Object[]{new String(string)};
            formatter.applyPattern(JaiI18N.getString("OperationRegistry10"));
            System.err.println(formatter.format(objectArray));
            this.lock.releaseWriteLock();
            return;
        }
        if (!this.cifPrefs.containsKey(string3)) {
            this.lock.releaseWriteLock();
            return;
        }
        Vector vector = (Vector)this.cifPrefs.get(string3);
        if (vector == null) {
            this.lock.releaseWriteLock();
            return;
        }
        Iterator iterator = ((AbstractList)vector).iterator();
        while (iterator.hasNext()) {
            Object[] objectArray;
            Store store = (Store)iterator.next();
            String string4 = store.product;
            if (!string4.equalsIgnoreCase(string2)) continue;
            ProductOperationGraph productOperationGraph = (ProductOperationGraph)this.products.get(string3);
            PartialOrderNode partialOrderNode = productOperationGraph.lookupOp(string2.toLowerCase());
            if (partialOrderNode == null) {
                objectArray = new Object[]{new String(string2), new String(string)};
                formatter.applyPattern(JaiI18N.getString("OperationRegistry14"));
                System.err.println(formatter.format(objectArray));
                this.lock.releaseWriteLock();
                return;
            }
            objectArray = (Object[])partialOrderNode.getData();
            CollectionImageFactory collectionImageFactory = (CollectionImageFactory)store.object1;
            CollectionImageFactory collectionImageFactory2 = (CollectionImageFactory)store.object2;
            if (objectArray.lookupCIF(collectionImageFactory) == null) {
                System.err.println(String.valueOf(collectionImageFactory.getClass().getName()) + " " + JaiI18N.getString("OperationRegistry26"));
                this.lock.releaseWriteLock();
                return;
            }
            if (objectArray.lookupCIF(collectionImageFactory2) == null) {
                System.err.println(String.valueOf(collectionImageFactory2.getClass().getName()) + " " + JaiI18N.getString("OperationRegistry26"));
                this.lock.releaseWriteLock();
                return;
            }
            objectArray.unsetCIFPreference(collectionImageFactory, collectionImageFactory2);
            iterator.remove();
        }
        this.lock.releaseWriteLock();
    }

    public synchronized void clearOperationPreferences(String string, String string2) {
        this.clearRIFPreferences(string, string2);
        this.clearCIFPreferences(string, string2);
    }

    public void clearProductPreferences(String string) {
        String string2 = string.toLowerCase();
        this.lock.getWriteLock();
        if (!this.opDescsName.containsKey(string2)) {
            Object[] objectArray = new Object[]{new String(string)};
            formatter.applyPattern(JaiI18N.getString("OperationRegistry10"));
            System.err.println(formatter.format(objectArray));
            this.lock.releaseWriteLock();
            return;
        }
        if (this.productPrefs.containsKey(string2)) {
            Vector vector = (Vector)this.productPrefs.get(string2);
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                Store store = (Store)enumeration.nextElement();
                ProductOperationGraph productOperationGraph = (ProductOperationGraph)this.products.get(string2);
                if (productOperationGraph == null) {
                    System.err.println(String.valueOf(string) + " " + JaiI18N.getString("OperationRegistry23"));
                    this.lock.releaseWriteLock();
                    return;
                }
                String string3 = ((String)store.object1).toLowerCase();
                String string4 = ((String)store.object2).toLowerCase();
                if (productOperationGraph.lookupOp(string3) == null) {
                    Object[] objectArray = new Object[]{new String(string3), new String(string)};
                    formatter.applyPattern(JaiI18N.getString("OperationRegistry24"));
                    System.err.println(formatter.format(objectArray));
                    this.lock.releaseWriteLock();
                    return;
                }
                if (productOperationGraph.lookupOp(string4) == null) {
                    Object[] objectArray = new Object[]{new String(string4), new String(string)};
                    formatter.applyPattern(JaiI18N.getString("OperationRegistry24"));
                    System.err.println(formatter.format(objectArray));
                    this.lock.releaseWriteLock();
                    return;
                }
                productOperationGraph.unsetPreference(string3.toLowerCase(), string4.toLowerCase());
            }
            this.productPrefs.remove(string2);
        }
        this.lock.releaseWriteLock();
    }

    public void clearPropertyState() {
        this.lock.getWriteLock();
        this.properties = new Hashtable();
        this.suppressed = new Hashtable();
        this.lock.releaseWriteLock();
    }

    public void clearRIFPreferences(String string, String string2) {
        if (string2 == null) {
            throw new NullPointerException();
        }
        String string3 = string.toLowerCase();
        this.lock.getWriteLock();
        if (!this.opDescsName.containsKey(string3)) {
            Object[] objectArray = new Object[]{new String(string)};
            formatter.applyPattern(JaiI18N.getString("OperationRegistry10"));
            System.err.println(formatter.format(objectArray));
            this.lock.releaseWriteLock();
            return;
        }
        if (!this.rifPrefs.containsKey(string3)) {
            this.lock.releaseWriteLock();
            return;
        }
        Vector vector = (Vector)this.rifPrefs.get(string3);
        if (vector == null) {
            this.lock.releaseWriteLock();
            return;
        }
        Iterator iterator = ((AbstractList)vector).iterator();
        while (iterator.hasNext()) {
            Object[] objectArray;
            Store store = (Store)iterator.next();
            String string4 = store.product;
            if (!string4.equalsIgnoreCase(string2)) continue;
            ProductOperationGraph productOperationGraph = (ProductOperationGraph)this.products.get(string3);
            PartialOrderNode partialOrderNode = productOperationGraph.lookupOp(string2.toLowerCase());
            if (partialOrderNode == null) {
                objectArray = new Object[]{new String(string2), new String(string)};
                formatter.applyPattern(JaiI18N.getString("OperationRegistry14"));
                System.err.println(formatter.format(objectArray));
                this.lock.releaseWriteLock();
                return;
            }
            objectArray = (Object[])partialOrderNode.getData();
            RenderedImageFactory renderedImageFactory = (RenderedImageFactory)store.object1;
            RenderedImageFactory renderedImageFactory2 = (RenderedImageFactory)store.object2;
            if (objectArray.lookupRIF(renderedImageFactory) == null) {
                System.err.println(String.valueOf(renderedImageFactory.getClass().getName()) + " " + JaiI18N.getString("OperationRegistry26"));
                this.lock.releaseWriteLock();
                return;
            }
            if (objectArray.lookupRIF(renderedImageFactory2) == null) {
                System.err.println(String.valueOf(renderedImageFactory2.getClass().getName()) + " " + JaiI18N.getString("OperationRegistry26"));
                this.lock.releaseWriteLock();
                return;
            }
            objectArray.unsetRIFPreference(renderedImageFactory, renderedImageFactory2);
            iterator.remove();
        }
        this.lock.releaseWriteLock();
    }

    public void copyPropertyFromSource(String string, String string2, int n) {
        String string3 = string.toLowerCase();
        string2 = string2.toLowerCase();
        this.lock.getWriteLock();
        Hashtable<String, Integer> hashtable = (Hashtable<String, Integer>)this.sourceForProp.get(string3);
        if (hashtable == null) {
            hashtable = new Hashtable<String, Integer>();
            hashtable.put(string2, new Integer(n));
            this.sourceForProp.put(string3, hashtable);
        } else {
            hashtable.put(string3, new Integer(n));
        }
        Vector vector = (Vector)this.suppressed.get(string3);
        if (vector != null) {
            vector.remove(string2);
        }
        this.lock.releaseWriteLock();
    }

    public PlanarImage create(String string, ParameterBlock parameterBlock, RenderingHints renderingHints) {
        this.lock.getReadLock();
        Vector vector = this.getOrderedProductList(string);
        if (vector == null) {
            this.lock.releaseReadLock();
            return null;
        }
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            Vector vector2 = this.getOrderedRIFList(string, string2);
            Enumeration enumeration2 = vector2.elements();
            RenderedImage renderedImage = null;
            while (enumeration2.hasMoreElements()) {
                RenderedImageFactory renderedImageFactory = (RenderedImageFactory)enumeration2.nextElement();
                try {
                    renderedImage = renderedImageFactory.create(parameterBlock, renderingHints);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                if (renderedImage == null) continue;
                this.lock.releaseReadLock();
                return PlanarImage.wrapRenderedImage(renderedImage);
            }
        }
        this.lock.releaseReadLock();
        return null;
    }

    public CollectionImage createCollection(String string, ParameterBlock parameterBlock, RenderingHints renderingHints) {
        this.lock.getReadLock();
        Vector vector = this.getOrderedProductList(string);
        if (vector == null) {
            this.lock.releaseReadLock();
            return null;
        }
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            Vector vector2 = this.getOrderedCIFList(string, string2);
            Enumeration enumeration2 = vector2.elements();
            CollectionImage collectionImage = null;
            while (enumeration2.hasMoreElements()) {
                CollectionImageFactory collectionImageFactory = (CollectionImageFactory)enumeration2.nextElement();
                try {
                    collectionImage = collectionImageFactory.create(parameterBlock, renderingHints);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                if (collectionImage == null) continue;
                this.lock.releaseReadLock();
                return collectionImage;
            }
        }
        this.lock.releaseReadLock();
        return null;
    }

    public ContextualRenderedImageFactory createRenderable(String string, ParameterBlock parameterBlock) {
        String string2 = string.toLowerCase();
        this.lock.getReadLock();
        if (!this.opDescsName.containsKey(string2)) {
            Object[] objectArray = new Object[]{new String(string)};
            formatter.applyPattern(JaiI18N.getString("OperationRegistry10"));
            System.err.println(formatter.format(objectArray));
            this.lock.releaseReadLock();
            return null;
        }
        this.lock.releaseReadLock();
        return (ContextualRenderedImageFactory)this.crifs.get(string2);
    }

    public String[] getGeneratedPropertyNames(String string) {
        String string2 = string.toLowerCase();
        this.lock.getReadLock();
        this.hashNames(string2);
        Hashtable hashtable = (Hashtable)this.propNames.get(string2);
        if (hashtable != null && hashtable.size() > 0) {
            String[] stringArray = new String[hashtable.size()];
            int n = 0;
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                String string3 = (String)enumeration.nextElement();
                stringArray[n++] = string3;
            }
            this.lock.releaseReadLock();
            return n > 0 ? stringArray : null;
        }
        this.lock.releaseReadLock();
        return null;
    }

    public OperationDescriptor getOperationDescriptor(String string) {
        return (OperationDescriptor)this.opDescsName.get(string.toLowerCase());
    }

    public Vector getOperationDescriptors() {
        this.lock.getReadLock();
        Vector vector = new Vector();
        Enumeration enumeration = this.opDescsName.elements();
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement());
        }
        this.lock.releaseReadLock();
        return vector;
    }

    public String[] getOperationNames() {
        this.lock.getReadLock();
        Enumeration enumeration = this.opDescsName.keys();
        int n = this.opDescsName.size();
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            stringArray[n2] = (String)enumeration.nextElement();
            ++n2;
        }
        this.lock.releaseReadLock();
        return stringArray;
    }

    public Vector getOrderedCIFList(String string, String string2) {
        String string3 = string.toLowerCase();
        this.lock.getReadLock();
        if (!this.opDescsName.containsKey(string3)) {
            Object[] objectArray = new Object[]{new String(string)};
            formatter.applyPattern(JaiI18N.getString("OperationRegistry10"));
            System.err.println(formatter.format(objectArray));
            this.lock.releaseReadLock();
            return null;
        }
        ProductOperationGraph productOperationGraph = (ProductOperationGraph)this.products.get(string3);
        if (productOperationGraph == null) {
            this.lock.releaseReadLock();
            return null;
        }
        PartialOrderNode partialOrderNode = productOperationGraph.lookupOp(string2.toLowerCase());
        if (partialOrderNode == null) {
            this.lock.releaseReadLock();
            return null;
        }
        OperationGraph operationGraph = (OperationGraph)partialOrderNode.getData();
        Vector vector = operationGraph.getOrderedOperationList("cif");
        if (vector == null) {
            this.lock.releaseReadLock();
            return null;
        }
        Vector<Object> vector2 = new Vector<Object>();
        int n = 0;
        while (n < vector.size()) {
            vector2.addElement(((PartialOrderNode)vector.elementAt(n)).getData());
            ++n;
        }
        this.lock.releaseReadLock();
        return vector2;
    }

    public Vector getOrderedProductList(String string) {
        String string2 = string.toLowerCase();
        this.lock.getReadLock();
        if (!this.opDescsName.containsKey(string2)) {
            this.lock.releaseReadLock();
            return null;
        }
        ProductOperationGraph productOperationGraph = (ProductOperationGraph)this.products.get(string2);
        if (productOperationGraph == null) {
            this.lock.releaseReadLock();
            return null;
        }
        Vector vector = productOperationGraph.getOrderedOperationList();
        int n = vector.size();
        if (n == 0) {
            this.lock.releaseReadLock();
            return null;
        }
        Vector<String> vector2 = new Vector<String>();
        int n2 = 0;
        while (n2 < n) {
            vector2.addElement(((PartialOrderNode)vector.elementAt(n2)).getName());
            ++n2;
        }
        this.lock.releaseReadLock();
        return vector2;
    }

    public Vector getOrderedRIFList(String string, String string2) {
        String string3 = string.toLowerCase();
        this.lock.getReadLock();
        if (!this.opDescsName.containsKey(string3)) {
            Object[] objectArray = new Object[]{new String(string)};
            formatter.applyPattern(JaiI18N.getString("OperationRegistry10"));
            System.err.println(formatter.format(objectArray));
            this.lock.releaseReadLock();
            return null;
        }
        ProductOperationGraph productOperationGraph = (ProductOperationGraph)this.products.get(string3);
        if (productOperationGraph == null) {
            this.lock.releaseReadLock();
            return null;
        }
        PartialOrderNode partialOrderNode = productOperationGraph.lookupOp(string2.toLowerCase());
        if (partialOrderNode == null) {
            this.lock.releaseReadLock();
            return null;
        }
        OperationGraph operationGraph = (OperationGraph)partialOrderNode.getData();
        Vector vector = operationGraph.getOrderedOperationList("rif");
        if (vector == null) {
            this.lock.releaseReadLock();
            return null;
        }
        Vector<Object> vector2 = new Vector<Object>();
        int n = 0;
        while (n < vector.size()) {
            vector2.addElement(((PartialOrderNode)vector.elementAt(n)).getData());
            ++n;
        }
        this.lock.releaseReadLock();
        return vector2;
    }

    public String[][] getProductPreferences(String string) {
        String string2 = string.toLowerCase();
        this.lock.getReadLock();
        if (!this.productPrefs.containsKey(string2)) {
            this.lock.releaseReadLock();
            return null;
        }
        Vector vector = (Vector)this.productPrefs.get(string2);
        int n = vector.size();
        if (n == 0) {
            this.lock.releaseReadLock();
            return null;
        }
        String[][] stringArray = new String[n][2];
        int n2 = 0;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Store store = (Store)enumeration.nextElement();
            stringArray[n2][0] = (String)store.object1;
            stringArray[n2++][1] = (String)store.object2;
        }
        this.lock.releaseReadLock();
        return stringArray;
    }

    public PropertySource getPropertySource(RenderableOp renderableOp) {
        String string = renderableOp.getOperationName().toLowerCase();
        Vector vector = renderableOp.getSources();
        this.lock.getReadLock();
        Vector vector2 = (Vector)this.properties.get(string);
        Vector vector3 = (Vector)this.suppressed.get(string);
        Hashtable hashtable = (Hashtable)this.sourceForProp.get(string);
        PropertySourceImpl propertySourceImpl = new PropertySourceImpl(vector, vector2, vector3, hashtable, renderableOp);
        this.lock.releaseReadLock();
        return propertySourceImpl;
    }

    public PropertySource getPropertySource(RenderedOp renderedOp) {
        String string = renderedOp.getOperationName().toLowerCase();
        Vector vector = renderedOp.getSources();
        this.lock.getReadLock();
        Vector vector2 = (Vector)this.properties.get(string);
        Vector vector3 = (Vector)this.suppressed.get(string);
        Hashtable hashtable = (Hashtable)this.sourceForProp.get(string);
        PropertySourceImpl propertySourceImpl = new PropertySourceImpl(vector, vector2, vector3, hashtable, renderedOp);
        this.lock.releaseReadLock();
        return propertySourceImpl;
    }

    private void hashNames(String string) {
        Object object;
        Object object2;
        Serializable serializable;
        Object object3;
        String string2 = string.toLowerCase();
        Vector vector = (Vector)this.properties.get(string2);
        Vector vector2 = (Vector)this.suppressed.get(string2);
        Hashtable<Object, Object> hashtable = new Hashtable<Object, Object>();
        this.propNames.put(string2, hashtable);
        if (vector != null) {
            int n;
            if (vector2 != null) {
                object3 = ((AbstractList)vector).iterator();
                while (object3.hasNext()) {
                    serializable = (PropertyGenerator)object3.next();
                    object2 = serializable.getPropertyNames();
                    n = 0;
                    while (n < ((String[])object2).length) {
                        object = object2[n].toLowerCase();
                        if (!vector2.contains(object)) {
                            hashtable.put(object, serializable);
                        }
                        ++n;
                    }
                }
            } else {
                object3 = ((AbstractList)vector).iterator();
                while (object3.hasNext()) {
                    serializable = (PropertyGenerator)object3.next();
                    object2 = serializable.getPropertyNames();
                    n = 0;
                    while (n < ((String[])object2).length) {
                        hashtable.put(object2[n].toLowerCase(), serializable);
                        ++n;
                    }
                }
            }
        }
        if ((serializable = (Hashtable)this.sourceForProp.get(string2)) != null) {
            Enumeration enumeration = ((Hashtable)serializable).keys();
            while (enumeration.hasMoreElements()) {
                object2 = (String)enumeration.nextElement();
                object3 = (Integer)((Hashtable)serializable).get(object2);
                object = new PropertyGeneratorFromSource((Integer)object3, (String)object2);
                hashtable.put(object2, object);
            }
        }
    }

    public synchronized void initializeFromStream(InputStream inputStream) throws IOException {
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        RegistryInitData registryInitData = OperationRegistry.readInitFile(bufferedReader);
        this.loadDescriptors(registryInitData);
        inputStream.close();
        ((Reader)inputStreamReader).close();
    }

    static synchronized OperationRegistry initializeRegistry() {
        try {
            InputStream inputStream = PropertyUtil.getFileFromClasspath("registryFile.jai");
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            OperationRegistry operationRegistry = new OperationRegistry();
            RegistryInitData registryInitData = OperationRegistry.readInitFile(bufferedReader);
            operationRegistry.loadDescriptors(registryInitData);
            return operationRegistry;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new RuntimeException(JaiI18N.getString("OperationRegistry0"));
        }
    }

    private void loadDescriptors(RegistryInitData registryInitData) {
        Object[] objectArray;
        Object object;
        Class<Object> clazz;
        Object object2;
        Object object3;
        Object object4;
        Hashtable hashtable = registryInitData.descTable;
        Hashtable hashtable2 = registryInitData.rifTable;
        Hashtable hashtable3 = registryInitData.crifTable;
        Hashtable hashtable4 = registryInitData.cifTable;
        Vector vector = registryInitData.prodPref;
        Vector vector2 = registryInitData.rifPref;
        Vector vector3 = registryInitData.cifPref;
        this.opDescsName = new Hashtable();
        this.products = new Hashtable();
        this.rifs = new Hashtable();
        this.rifsByName = new Hashtable();
        this.crifs = new Hashtable();
        this.cifs = new Hashtable();
        this.cifsByName = new Hashtable();
        this.productPrefs = new Hashtable();
        this.rifPrefs = new Hashtable();
        this.cifPrefs = new Hashtable();
        this.properties = new Hashtable();
        this.suppressed = new Hashtable();
        this.sourceForProp = new Hashtable();
        this.propNames = new Hashtable();
        this.lock.getWriteLock();
        Enumeration<Object> enumeration = hashtable2.keys();
        while (enumeration.hasMoreElements()) {
            object4 = (String)enumeration.nextElement();
            object3 = (Storage)hashtable2.get(object4);
            object2 = (String)hashtable.get(object3.registerName);
            if (object3 == null) {
                System.err.println(String.valueOf(object4) + " " + JaiI18N.getString("OperationRegistry27"));
                continue;
            }
            if (object2 == null) {
                System.err.println(String.valueOf(object3.registerName) + " " + JaiI18N.getString("OperationRegistry29"));
                continue;
            }
            try {
                if (!this.opDescsName.containsKey(object3.registerName)) {
                    clazz = Class.forName((String)object2);
                    object = (OperationDescriptor)clazz.newInstance();
                    this.registerOperationDescriptorNoLock((OperationDescriptor)object, object3.registerName);
                } else {
                    object = (OperationDescriptor)this.opDescsName.get(object3.registerName);
                }
                clazz = Class.forName(object3.path);
                objectArray = (RenderedImageFactory)clazz.newInstance();
                this.registerRIFNoLock(object3.registerName, object3.product, (RenderedImageFactory)objectArray);
                hashtable2.put(object4, objectArray);
            }
            catch (ClassNotFoundException classNotFoundException) {
                System.err.println(String.valueOf(classNotFoundException.toString()) + " " + JaiI18N.getString("OperationRegistry5"));
            }
            catch (InstantiationException instantiationException) {
                System.err.println(String.valueOf(instantiationException.toString()) + " " + JaiI18N.getString("OperationRegistry5"));
            }
            catch (IllegalAccessException illegalAccessException) {
                System.err.println(String.valueOf(illegalAccessException.toString()) + " " + JaiI18N.getString("OperationRegistry5"));
            }
        }
        enumeration = hashtable3.keys();
        while (enumeration.hasMoreElements()) {
            object4 = (String)enumeration.nextElement();
            object3 = (String)hashtable.get(object4);
            if (object3 == null) {
                System.err.println(String.valueOf(object4) + " " + JaiI18N.getString("OperationRegistry29"));
                continue;
            }
            try {
                if (!this.opDescsName.containsKey(object4)) {
                    object2 = Class.forName((String)object3);
                    clazz = (OperationDescriptor)((Class)object2).newInstance();
                    this.registerOperationDescriptorNoLock((OperationDescriptor)((Object)clazz), (String)object4);
                } else {
                    clazz = (OperationDescriptor)this.opDescsName.get(object4);
                }
                object2 = Class.forName((String)hashtable3.get(object4));
                object = (ContextualRenderedImageFactory)((Class)object2).newInstance();
                this.registerCRIFNoLock((String)object4, (ContextualRenderedImageFactory)object);
            }
            catch (ClassNotFoundException classNotFoundException) {
                System.err.println(String.valueOf(classNotFoundException.toString()) + " " + JaiI18N.getString("OperationRegistry5"));
            }
            catch (InstantiationException instantiationException) {
                System.err.println(String.valueOf(instantiationException.toString()) + " " + JaiI18N.getString("OperationRegistry5"));
            }
            catch (IllegalAccessException illegalAccessException) {
                System.err.println(String.valueOf(illegalAccessException.toString()) + " " + JaiI18N.getString("OperationRegistry5"));
            }
        }
        enumeration = hashtable4.keys();
        while (enumeration.hasMoreElements()) {
            object4 = (String)enumeration.nextElement();
            object3 = (Storage)hashtable4.get(object4);
            object2 = (String)hashtable.get(object3.registerName);
            if (object3 == null) {
                System.err.println(String.valueOf(object4) + " " + JaiI18N.getString("OperationRegistry28"));
                continue;
            }
            if (object2 == null) {
                System.err.println(String.valueOf(object3.registerName) + " " + JaiI18N.getString("OperationRegistry29"));
                continue;
            }
            try {
                if (!this.opDescsName.containsKey(object3.registerName)) {
                    clazz = Class.forName(object2);
                    object = (OperationDescriptor)clazz.newInstance();
                    this.registerOperationDescriptorNoLock((OperationDescriptor)object, object3.registerName);
                } else {
                    object = (OperationDescriptor)this.opDescsName.get(object3.registerName);
                }
                clazz = Class.forName(object3.path);
                objectArray = (CollectionImageFactory)clazz.newInstance();
                this.registerCIFNoLock(object3.registerName, object3.product, (CollectionImageFactory)objectArray);
                hashtable4.put(object4, objectArray);
            }
            catch (ClassNotFoundException classNotFoundException) {
                System.err.println(String.valueOf(classNotFoundException.toString()) + " " + JaiI18N.getString("OperationRegistry5"));
            }
            catch (InstantiationException instantiationException) {
                System.err.println(String.valueOf(instantiationException.toString()) + " " + JaiI18N.getString("OperationRegistry5"));
            }
            catch (IllegalAccessException illegalAccessException) {
                System.err.println(String.valueOf(illegalAccessException.toString()) + " " + JaiI18N.getString("OperationRegistry5"));
            }
        }
        enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            object4 = (Storage)enumeration.nextElement();
            if (!this.opDescsName.containsKey(((Storage)object4).name)) {
                object3 = new Object[]{new String(((Storage)object4).name)};
                formatter.applyPattern(JaiI18N.getString("OperationRegistry6"));
                System.err.println(formatter.format(object3));
                continue;
            }
            this.setProductPreferenceNoLock(((Storage)object4).name, ((Storage)object4).product, ((Storage)object4).registerName);
        }
        enumeration = vector2.elements();
        while (enumeration.hasMoreElements()) {
            object4 = (Storage)enumeration.nextElement();
            if (!this.opDescsName.containsKey(((Storage)object4).name)) {
                object3 = new Object[]{new String(((Storage)object4).name)};
                formatter.applyPattern(JaiI18N.getString("OperationRegistry7"));
                System.err.println(formatter.format(object3));
                continue;
            }
            object3 = null;
            object2 = null;
            clazz = hashtable2.get(((Storage)object4).product);
            object = hashtable2.get(((Storage)object4).registerName);
            if (clazz instanceof Storage || clazz == null) {
                objectArray = new Object[]{new String(((Storage)object4).product)};
                formatter.applyPattern(JaiI18N.getString("OperationRegistry8"));
                System.err.println(formatter.format(objectArray));
                continue;
            }
            if (object instanceof Storage || object == null) {
                objectArray = new Object[]{new String(((Storage)object4).registerName)};
                formatter.applyPattern(JaiI18N.getString("OperationRegistry8"));
                System.err.println(formatter.format(objectArray));
                continue;
            }
            object3 = (RenderedImageFactory)((Object)clazz);
            object2 = (RenderedImageFactory)object;
            this.setRIFPreferenceNoLock(((Storage)object4).name, ((Storage)object4).path, (RenderedImageFactory)object3, (RenderedImageFactory)object2);
        }
        enumeration = vector3.elements();
        while (enumeration.hasMoreElements()) {
            object4 = (Storage)enumeration.nextElement();
            if (!this.opDescsName.containsKey(((Storage)object4).name)) {
                object3 = new Object[]{new String(((Storage)object4).name)};
                formatter.applyPattern(JaiI18N.getString("OperationRegistry19"));
                System.err.println(formatter.format(object3));
                continue;
            }
            object3 = null;
            object2 = null;
            clazz = hashtable4.get(((Storage)object4).product);
            object = hashtable4.get(((Storage)object4).registerName);
            if (clazz instanceof Storage || clazz == null) {
                objectArray = new Object[]{new String(((Storage)object4).product)};
                formatter.applyPattern(JaiI18N.getString("OperationRegistry8"));
                System.err.println(formatter.format(objectArray));
                continue;
            }
            if (object instanceof Storage || object == null) {
                objectArray = new Object[]{new String(((Storage)object4).registerName)};
                formatter.applyPattern(JaiI18N.getString("OperationRegistry8"));
                System.err.println(formatter.format(objectArray));
                continue;
            }
            object3 = (CollectionImageFactory)((Object)clazz);
            object2 = (CollectionImageFactory)object;
            this.setCIFPreferenceNoLock(((Storage)object4).name, ((Storage)object4).path, (CollectionImageFactory)object3, (CollectionImageFactory)object2);
        }
        this.lock.releaseWriteLock();
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        byte[] byArray = (byte[])objectInput.readObject();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        this.initializeFromStream(byteArrayInputStream);
    }

    /*
     * Unable to fully structure code
     */
    private static RegistryInitData readInitFile(Reader var0) throws IOException {
        var1_1 = new Hashtable<String, String>();
        var2_2 = new Hashtable<String, Storage>();
        var3_3 = new Hashtable<String, String>();
        var4_4 = new Hashtable<String, Storage>();
        var5_5 = new Vector<Storage>();
        var6_6 = new Vector<Storage>();
        var7_7 = new Vector<Storage>();
        var8_8 = null;
        var10_9 = new Vector<String>();
        var11_10 = null;
        var12_11 = null;
        var13_12 = null;
        var14_13 = null;
        var15_14 = null;
        var17_15 = false;
        var18_16 = new StreamTokenizer(var0);
        var18_16.commentChar(35);
        var18_16.eolIsSignificant(true);
        var18_16.slashSlashComments(true);
        var18_16.slashStarComments(true);
        var19_17 = var18_16.nextToken();
        ** GOTO lbl204
        {
            block43: {
                if (var19_17 != -1) break block43;
                var17_15 = true;
                ** GOTO lbl31
            }
            var19_17 = var18_16.nextToken();
            var17_15 = false;
            do {
                if (var18_16.sval == null) continue block0;
lbl31:
                // 2 sources

                if (var17_15) break block0;
                var16_18 = var18_16.lineno();
                if (var18_16.sval.equalsIgnoreCase("odesc")) {
                    var16_18 = var18_16.lineno();
                    var19_17 = var18_16.nextToken();
                    while (var19_17 != 10 && var19_17 != -1) {
                        if (var18_16.sval != null) {
                            var10_9.addElement(var18_16.sval);
                        }
                        var19_17 = var18_16.nextToken();
                    }
                    if (var10_9.size() != 2) {
                        var20_19 = new Object[]{new Integer(var16_18)};
                        OperationRegistry.formatter.applyPattern(JaiI18N.getString("OperationRegistry1"));
                        System.err.println(OperationRegistry.formatter.format(var20_19));
                    } else {
                        var11_10 = (String)var10_9.elementAt(0);
                        var13_12 = (String)var10_9.elementAt(1);
                        var1_1.put(var13_12, var11_10);
                    }
                    var10_9.removeAllElements();
                    continue;
                }
                if (var18_16.sval.equalsIgnoreCase("rif")) {
                    var16_18 = var18_16.lineno();
                    var19_17 = var18_16.nextToken();
                    while (var19_17 != 10 && var19_17 != -1) {
                        if (var18_16.sval != null) {
                            var10_9.addElement(var18_16.sval);
                        }
                        var19_17 = var18_16.nextToken();
                    }
                    if (var10_9.size() != 4) {
                        var20_20 = new Object[]{new Integer(var16_18)};
                        OperationRegistry.formatter.applyPattern(JaiI18N.getString("OperationRegistry1"));
                        System.err.println(OperationRegistry.formatter.format(var20_20));
                    } else {
                        var11_10 = (String)var10_9.elementAt(0);
                        var12_11 = (String)var10_9.elementAt(1);
                        var13_12 = (String)var10_9.elementAt(2);
                        var14_13 = (String)var10_9.elementAt(3);
                        var15_14 = new Storage(null, var11_10, var12_11, var13_12);
                        var2_2.put(var14_13, var15_14);
                    }
                    var10_9.removeAllElements();
                    continue;
                }
                if (var18_16.sval.equalsIgnoreCase("crif")) {
                    var16_18 = var18_16.lineno();
                    var19_17 = var18_16.nextToken();
                    while (var19_17 != 10 && var19_17 != -1) {
                        if (var18_16.sval != null) {
                            var10_9.addElement(var18_16.sval);
                        }
                        var19_17 = var18_16.nextToken();
                    }
                    if (var10_9.size() != 2) {
                        var20_21 = new Object[]{new Integer(var16_18)};
                        OperationRegistry.formatter.applyPattern(JaiI18N.getString("OperationRegistry1"));
                        System.err.println(OperationRegistry.formatter.format(var20_21));
                    } else {
                        var11_10 = (String)var10_9.elementAt(0);
                        var13_12 = (String)var10_9.elementAt(1);
                        var3_3.put(var13_12, var11_10);
                    }
                    var10_9.removeAllElements();
                    continue;
                }
                if (var18_16.sval.equalsIgnoreCase("cif")) {
                    var16_18 = var18_16.lineno();
                    var19_17 = var18_16.nextToken();
                    while (var19_17 != 10 && var19_17 != -1) {
                        if (var18_16.sval != null) {
                            var10_9.addElement(var18_16.sval);
                        }
                        var19_17 = var18_16.nextToken();
                    }
                    if (var10_9.size() != 4) {
                        var20_22 = new Object[]{new Integer(var16_18)};
                        OperationRegistry.formatter.applyPattern(JaiI18N.getString("OperationRegistry1"));
                        System.err.println(OperationRegistry.formatter.format(var20_22));
                    } else {
                        var11_10 = (String)var10_9.elementAt(0);
                        var12_11 = (String)var10_9.elementAt(1);
                        var13_12 = (String)var10_9.elementAt(2);
                        var14_13 = (String)var10_9.elementAt(3);
                        var15_14 = new Storage(null, var11_10, var12_11, var13_12);
                        var4_4.put(var14_13, var15_14);
                    }
                    var10_9.removeAllElements();
                    continue;
                }
                if (var18_16.sval.equalsIgnoreCase("pref")) {
                    var16_18 = var18_16.lineno();
                    var19_17 = var18_16.nextToken();
                    if (var18_16.sval.equalsIgnoreCase("product")) {
                        var19_17 = var18_16.nextToken();
                        while (var19_17 != 10 && var19_17 != -1) {
                            if (var18_16.sval != null) {
                                var10_9.addElement(var18_16.sval);
                            }
                            var19_17 = var18_16.nextToken();
                        }
                        var20_23 = var10_9.size();
                        if (var20_23 < 3) {
                            var21_28 = new Object[]{new Integer(var16_18)};
                            OperationRegistry.formatter.applyPattern(JaiI18N.getString("OperationRegistry2"));
                            System.err.println(OperationRegistry.formatter.format(var21_28));
                        } else {
                            var11_10 = (String)var10_9.elementAt(0);
                            --var20_23;
                            var21_29 = 1;
                            while (var21_29 < var20_23) {
                                var12_11 = (String)var10_9.elementAt(var21_29);
                                var13_12 = (String)var10_9.elementAt(var21_29 + 1);
                                var15_14 = new Storage(var11_10, null, var12_11, var13_12);
                                var5_5.addElement(var15_14);
                                ++var21_29;
                            }
                        }
                        var10_9.removeAllElements();
                        continue;
                    }
                    if (var18_16.sval.equalsIgnoreCase("rif")) {
                        var19_17 = var18_16.nextToken();
                        while (var19_17 != 10 && var19_17 != -1) {
                            if (var18_16.sval != null) {
                                var10_9.addElement(var18_16.sval);
                            }
                            var19_17 = var18_16.nextToken();
                        }
                        var20_24 = var10_9.size();
                        if (var20_24 < 4) {
                            var21_28 = new Object[]{new Integer(var16_18)};
                            OperationRegistry.formatter.applyPattern(JaiI18N.getString("OperationRegistry2"));
                            System.err.println(OperationRegistry.formatter.format(var21_28));
                        } else {
                            var11_10 = (String)var10_9.elementAt(0);
                            var12_11 = (String)var10_9.elementAt(1);
                            --var20_24;
                            var21_30 = 2;
                            while (var21_30 < var20_24) {
                                var13_12 = (String)var10_9.elementAt(var21_30);
                                var14_13 = (String)var10_9.elementAt(var21_30 + 1);
                                var6_6.addElement(new Storage(var11_10, var12_11, var13_12, var14_13));
                                ++var21_30;
                            }
                        }
                        var10_9.removeAllElements();
                        continue;
                    }
                    if (var18_16.sval.equalsIgnoreCase("cif")) {
                        var19_17 = var18_16.nextToken();
                        while (var19_17 != 10 && var19_17 != -1) {
                            if (var18_16.sval != null) {
                                var10_9.addElement(var18_16.sval);
                            }
                            var19_17 = var18_16.nextToken();
                        }
                        var20_25 = var10_9.size();
                        if (var20_25 < 4) {
                            var21_28 = new Object[]{new Integer(var16_18)};
                            OperationRegistry.formatter.applyPattern(JaiI18N.getString("OperationRegistry2"));
                            System.err.println(OperationRegistry.formatter.format(var21_28));
                        } else {
                            var11_10 = (String)var10_9.elementAt(0);
                            var12_11 = (String)var10_9.elementAt(1);
                            --var20_25;
                            var21_31 = 2;
                            while (var21_31 < var20_25) {
                                var13_12 = (String)var10_9.elementAt(var21_31);
                                var14_13 = (String)var10_9.elementAt(var21_31 + 1);
                                var7_7.addElement(new Storage(var11_10, var12_11, var13_12, var14_13));
                                ++var21_31;
                            }
                        }
                        var10_9.removeAllElements();
                        continue;
                    }
                    var20_26 = new Object[]{new Integer(var16_18)};
                    OperationRegistry.formatter.applyPattern(JaiI18N.getString("OperationRegistry3"));
                    System.err.println(OperationRegistry.formatter.format(var20_26));
                    while ((var19_17 = var18_16.nextToken()) != 10 && var19_17 != -1) {
                    }
                    continue;
                }
                var20_27 = new Object[]{"\"" + new String(var18_16.sval) + "\"", new Integer(var16_18)};
                OperationRegistry.formatter.applyPattern(JaiI18N.getString("OperationRegistry4"));
                System.err.println(OperationRegistry.formatter.format(var20_27));
                while ((var19_17 = var18_16.nextToken()) != 10 && var19_17 != -1) {
                }
lbl204:
                // 10 sources

            } while (var19_17 != -1);
        }
        var0.close();
        return new RegistryInitData(var1_1, var2_2, var3_3, var4_4, var5_5, var6_6, var7_7);
    }

    public void registerCIF(String string, String string2, CollectionImageFactory collectionImageFactory) {
        this.lock.getWriteLock();
        this.registerCIFNoLock(string, string2, collectionImageFactory);
        this.lock.releaseWriteLock();
    }

    private void registerCIFNoLock(String string, String string2, CollectionImageFactory collectionImageFactory) {
        String string3;
        String string4 = string.toLowerCase();
        if (!this.opDescsName.containsKey(string4)) {
            Object[] objectArray = new Object[]{new String(string)};
            formatter.applyPattern(JaiI18N.getString("OperationRegistry10"));
            System.err.println(formatter.format(objectArray));
            return;
        }
        ProductOperationGraph productOperationGraph = (ProductOperationGraph)this.products.get(string4);
        PartialOrderNode partialOrderNode = productOperationGraph.lookupOp(string3 = string2.toLowerCase());
        if (partialOrderNode == null) {
            productOperationGraph.addProduct(string3);
            partialOrderNode = productOperationGraph.lookupOp(string3);
        }
        OperationGraph operationGraph = (OperationGraph)partialOrderNode.getData();
        operationGraph.addCIF(collectionImageFactory);
        String string5 = "cif" + this.cifcount;
        this.cifsByName.put(collectionImageFactory, string5);
        Class<?> clazz = collectionImageFactory.getClass();
        String string6 = clazz.getName();
        this.cifs.put(string5, new Storage(string6, null, string2, string));
        ++this.cifcount;
    }

    public void registerCRIF(String string, ContextualRenderedImageFactory contextualRenderedImageFactory) {
        this.lock.getWriteLock();
        this.registerCRIFNoLock(string, contextualRenderedImageFactory);
        this.lock.releaseWriteLock();
    }

    private void registerCRIFNoLock(String string, ContextualRenderedImageFactory contextualRenderedImageFactory) {
        String string2 = string.toLowerCase();
        if (!this.opDescsName.containsKey(string2)) {
            Object[] objectArray = new Object[]{new String(string)};
            formatter.applyPattern(JaiI18N.getString("OperationRegistry10"));
            System.err.println(formatter.format(objectArray));
            return;
        }
        this.crifs.put(string2, contextualRenderedImageFactory);
    }

    public void registerOperationDescriptor(OperationDescriptor operationDescriptor, String string) {
        this.lock.getWriteLock();
        this.registerOperationDescriptorNoLock(operationDescriptor, string);
        this.lock.releaseWriteLock();
    }

    private void registerOperationDescriptorNoLock(OperationDescriptor operationDescriptor, String string) {
        String string2 = string.toLowerCase();
        if (!this.opDescsName.containsKey(string2)) {
            this.opDescsName.put(string2, operationDescriptor);
            this.products.put(string2, new ProductOperationGraph());
            PropertyGenerator[] propertyGeneratorArray = operationDescriptor.getPropertyGenerators();
            if (propertyGeneratorArray != null) {
                int n = 0;
                while (n < propertyGeneratorArray.length) {
                    String string3;
                    int n2;
                    Vector vector = (Vector)this.properties.get(string2);
                    if (vector == null) {
                        vector = new Vector();
                        vector.addElement(propertyGeneratorArray[n]);
                        this.properties.put(string2, vector);
                    } else {
                        vector.addElement(propertyGeneratorArray[n]);
                    }
                    vector = (Vector)this.suppressed.get(string2);
                    Hashtable hashtable = (Hashtable)this.sourceForProp.get(string2);
                    String[] stringArray = propertyGeneratorArray[n].getPropertyNames();
                    if (vector != null) {
                        n2 = 0;
                        while (n2 < stringArray.length) {
                            string3 = stringArray[n2].toLowerCase();
                            vector.remove(string3);
                            ++n2;
                        }
                    }
                    if (hashtable != null) {
                        n2 = 0;
                        while (n2 < stringArray.length) {
                            string3 = stringArray[n2].toLowerCase();
                            hashtable.remove(string3);
                            ++n2;
                        }
                    }
                    ++n;
                }
            }
        } else {
            Object[] objectArray = new Object[]{new String(string)};
            formatter.applyPattern(JaiI18N.getString("OperationRegistry9"));
            System.err.println(formatter.format(objectArray));
        }
    }

    public void registerRIF(String string, String string2, RenderedImageFactory renderedImageFactory) {
        this.lock.getWriteLock();
        this.registerRIFNoLock(string, string2, renderedImageFactory);
        this.lock.releaseWriteLock();
    }

    private void registerRIFNoLock(String string, String string2, RenderedImageFactory renderedImageFactory) {
        String string3;
        String string4 = string.toLowerCase();
        if (!this.opDescsName.containsKey(string4)) {
            Object[] objectArray = new Object[]{new String(string)};
            formatter.applyPattern(JaiI18N.getString("OperationRegistry10"));
            System.err.println(formatter.format(objectArray));
            return;
        }
        ProductOperationGraph productOperationGraph = (ProductOperationGraph)this.products.get(string4);
        PartialOrderNode partialOrderNode = productOperationGraph.lookupOp(string3 = string2.toLowerCase());
        if (partialOrderNode == null) {
            productOperationGraph.addProduct(string3);
            partialOrderNode = productOperationGraph.lookupOp(string3);
        }
        OperationGraph operationGraph = (OperationGraph)partialOrderNode.getData();
        operationGraph.addRIF(renderedImageFactory);
        String string5 = "rif" + this.rifcount;
        this.rifsByName.put(renderedImageFactory, string5);
        Class<?> clazz = renderedImageFactory.getClass();
        String string6 = clazz.getName();
        this.rifs.put(string5, new Storage(string6, null, string2, string));
        ++this.rifcount;
    }

    public void removePropertyGenerator(String string, PropertyGenerator propertyGenerator) {
        if (propertyGenerator == null) {
            throw new NullPointerException();
        }
        String string2 = string.toLowerCase();
        this.lock.getWriteLock();
        Vector vector = (Vector)this.properties.get(string2);
        if (vector == null) {
            this.lock.releaseWriteLock();
            return;
        }
        vector.removeElement(propertyGenerator);
        this.lock.releaseWriteLock();
    }

    public void setCIFPreference(String string, String string2, CollectionImageFactory collectionImageFactory, CollectionImageFactory collectionImageFactory2) {
        this.lock.getWriteLock();
        this.setCIFPreferenceNoLock(string, string2, collectionImageFactory, collectionImageFactory2);
        this.lock.releaseWriteLock();
    }

    private void setCIFPreferenceNoLock(String string, String string2, CollectionImageFactory collectionImageFactory, CollectionImageFactory collectionImageFactory2) {
        String string3;
        if (collectionImageFactory == null || collectionImageFactory2 == null) {
            throw new NullPointerException();
        }
        if (collectionImageFactory == collectionImageFactory2) {
            return;
        }
        String string4 = string.toLowerCase();
        if (!this.opDescsName.containsKey(string4)) {
            Object[] objectArray = new Object[]{new String(string)};
            formatter.applyPattern(JaiI18N.getString("OperationRegistry10"));
            System.err.println(formatter.format(objectArray));
            return;
        }
        ProductOperationGraph productOperationGraph = (ProductOperationGraph)this.products.get(string4);
        PartialOrderNode partialOrderNode = productOperationGraph.lookupOp(string3 = string2.toLowerCase());
        if (partialOrderNode == null) {
            Object[] objectArray = new Object[]{new String(string2), new String(string)};
            formatter.applyPattern(JaiI18N.getString("OperationRegistry14"));
            System.err.println(formatter.format(objectArray));
            return;
        }
        OperationGraph operationGraph = (OperationGraph)partialOrderNode.getData();
        if (operationGraph.lookupCIF(collectionImageFactory) == null) {
            System.err.println(String.valueOf(collectionImageFactory.getClass().getName()) + " " + JaiI18N.getString("OperationRegistry25"));
            return;
        }
        if (operationGraph.lookupCIF(collectionImageFactory2) == null) {
            System.err.println(String.valueOf(collectionImageFactory2.getClass().getName()) + " " + JaiI18N.getString("OperationRegistry25"));
            return;
        }
        operationGraph.setCIFPreference(collectionImageFactory, collectionImageFactory2);
        if (!this.cifPrefs.containsKey(string4)) {
            Vector<Store> vector = new Vector<Store>();
            vector.addElement(new Store(string3, collectionImageFactory, collectionImageFactory2));
            this.cifPrefs.put(string4, vector);
        } else {
            Vector vector = (Vector)this.cifPrefs.get(string4);
            vector.addElement(new Store(string3, collectionImageFactory, collectionImageFactory2));
            this.cifPrefs.put(string4, vector);
        }
    }

    public void setProductPreference(String string, String string2, String string3) {
        this.lock.getWriteLock();
        this.setProductPreferenceNoLock(string, string2, string3);
        this.lock.releaseWriteLock();
    }

    private void setProductPreferenceNoLock(String string, String string2, String string3) {
        String string4 = string.toLowerCase();
        if (string2.equalsIgnoreCase(string3)) {
            return;
        }
        if (!this.opDescsName.containsKey(string4)) {
            Object[] objectArray = new Object[]{new String(string)};
            formatter.applyPattern(JaiI18N.getString("OperationRegistry10"));
            System.err.println(formatter.format(objectArray));
            return;
        }
        ProductOperationGraph productOperationGraph = (ProductOperationGraph)this.products.get(string4);
        if (productOperationGraph == null) {
            System.err.println(String.valueOf(string) + " " + JaiI18N.getString("OperationRegistry22"));
            return;
        }
        if (productOperationGraph.lookupOp(string2.toLowerCase()) == null) {
            Object[] objectArray = new Object[]{new String(string2), new String(string)};
            formatter.applyPattern(JaiI18N.getString("OperationRegistry18"));
            System.err.println(formatter.format(objectArray));
            return;
        }
        if (productOperationGraph.lookupOp(string3.toLowerCase()) == null) {
            Object[] objectArray = new Object[]{new String(string3), new String(string)};
            formatter.applyPattern(JaiI18N.getString("OperationRegistry18"));
            System.err.println(formatter.format(objectArray));
            return;
        }
        productOperationGraph.setPreference(string2.toLowerCase(), string3.toLowerCase());
        if (!this.productPrefs.containsKey(string4)) {
            Vector<Store> vector = new Vector<Store>();
            vector.addElement(new Store(null, string2, string3));
            this.productPrefs.put(string4, vector);
        } else {
            Vector vector = (Vector)this.productPrefs.get(string4);
            vector.addElement(new Store(null, string2, string3));
            this.productPrefs.put(string4, vector);
        }
    }

    public void setRIFPreference(String string, String string2, RenderedImageFactory renderedImageFactory, RenderedImageFactory renderedImageFactory2) {
        this.lock.getWriteLock();
        this.setRIFPreferenceNoLock(string, string2, renderedImageFactory, renderedImageFactory2);
        this.lock.releaseWriteLock();
    }

    private void setRIFPreferenceNoLock(String string, String string2, RenderedImageFactory renderedImageFactory, RenderedImageFactory renderedImageFactory2) {
        String string3;
        if (renderedImageFactory == null || renderedImageFactory2 == null) {
            throw new NullPointerException();
        }
        String string4 = string.toLowerCase();
        if (renderedImageFactory == renderedImageFactory2) {
            return;
        }
        if (!this.opDescsName.containsKey(string4)) {
            Object[] objectArray = new Object[]{new String(string)};
            formatter.applyPattern(JaiI18N.getString("OperationRegistry10"));
            System.err.println(formatter.format(objectArray));
            return;
        }
        ProductOperationGraph productOperationGraph = (ProductOperationGraph)this.products.get(string4);
        PartialOrderNode partialOrderNode = productOperationGraph.lookupOp(string3 = string2.toLowerCase());
        if (partialOrderNode == null) {
            Object[] objectArray = new Object[]{new String(string2), new String(string)};
            formatter.applyPattern(JaiI18N.getString("OperationRegistry14"));
            System.err.println(formatter.format(objectArray));
            return;
        }
        OperationGraph operationGraph = (OperationGraph)partialOrderNode.getData();
        if (operationGraph.lookupRIF(renderedImageFactory) == null) {
            System.err.println(String.valueOf(renderedImageFactory.getClass().getName()) + " " + JaiI18N.getString("OperationRegistry25"));
            return;
        }
        if (operationGraph.lookupRIF(renderedImageFactory2) == null) {
            System.err.println(String.valueOf(renderedImageFactory2.getClass().getName()) + " " + JaiI18N.getString("OperationRegistry25"));
            return;
        }
        operationGraph.setRIFPreference(renderedImageFactory, renderedImageFactory2);
        if (!this.rifPrefs.containsKey(string4)) {
            Vector<Store> vector = new Vector<Store>();
            vector.addElement(new Store(string3, renderedImageFactory, renderedImageFactory2));
            this.rifPrefs.put(string4, vector);
        } else {
            Vector vector = (Vector)this.rifPrefs.get(string4);
            vector.addElement(new Store(string3, renderedImageFactory, renderedImageFactory2));
            this.rifPrefs.put(string4, vector);
        }
    }

    public synchronized void suppressAllProperties(String string) {
        String string2 = string.toLowerCase();
        Vector vector = (Vector)this.properties.get(string2);
        if (vector != null) {
            Iterator iterator = ((AbstractList)vector).iterator();
            while (iterator.hasNext()) {
                PropertyGenerator propertyGenerator = (PropertyGenerator)iterator.next();
                String[] stringArray = propertyGenerator.getPropertyNames();
                int n = 0;
                while (n < stringArray.length) {
                    this.suppressProperty(string2, stringArray[n]);
                    ++n;
                }
            }
        }
    }

    public void suppressProperty(String string, String string2) {
        String string3 = string.toLowerCase();
        string2 = string2.toLowerCase();
        this.lock.getWriteLock();
        Vector<String> vector = (Vector<String>)this.suppressed.get(string3);
        if (vector == null) {
            vector = new Vector<String>();
            vector.addElement(string2);
            this.suppressed.put(string3, vector);
        } else {
            vector.addElement(string2);
        }
        Hashtable hashtable = (Hashtable)this.sourceForProp.get(string3);
        if (hashtable != null) {
            hashtable.remove(string2);
        }
        this.lock.releaseWriteLock();
    }

    public String toString() {
        String string;
        this.lock.getReadLock();
        int n = this.opDescsName.size();
        if (n == 0) {
            string = "\n[<empty>]";
        } else {
            string = "\n[";
            Enumeration enumeration = this.opDescsName.keys();
            while (enumeration.hasMoreElements()) {
                string = String.valueOf(string) + " < ";
                String string2 = (String)enumeration.nextElement();
                string = String.valueOf(string) + string2;
                string = String.valueOf(string) + "-";
                ContextualRenderedImageFactory contextualRenderedImageFactory = (ContextualRenderedImageFactory)this.crifs.get(string2);
                string = contextualRenderedImageFactory == null ? String.valueOf(string) + " CRIF-() " : String.valueOf(string) + " CRIF-(" + contextualRenderedImageFactory.getClass().getName() + ") ";
                ProductOperationGraph productOperationGraph = (ProductOperationGraph)this.products.get(string2);
                Vector vector = productOperationGraph.getOrderedOperationList();
                int n2 = 0;
                while (n2 < vector.size()) {
                    int n3;
                    string = String.valueOf(string) + "{ ";
                    PartialOrderNode partialOrderNode = (PartialOrderNode)vector.elementAt(n2);
                    string = String.valueOf(string) + partialOrderNode.getName();
                    OperationGraph operationGraph = (OperationGraph)partialOrderNode.getData();
                    Vector vector2 = operationGraph.getOrderedOperationList("rif");
                    Vector vector3 = operationGraph.getOrderedOperationList("cif");
                    if (vector2 != null && vector2.size() > 0) {
                        PartialOrderNode partialOrderNode2;
                        string = String.valueOf(string) + " RIFs-(";
                        n3 = 0;
                        while (n3 < vector2.size() - 1) {
                            partialOrderNode2 = (PartialOrderNode)vector2.elementAt(n3);
                            string = String.valueOf(string) + partialOrderNode2.getName();
                            string = String.valueOf(string) + ", ";
                            ++n3;
                        }
                        partialOrderNode2 = (PartialOrderNode)vector2.elementAt(n3);
                        string = String.valueOf(string) + partialOrderNode2.getName();
                        string = String.valueOf(string) + ") ";
                    } else {
                        string = String.valueOf(string) + " RIFs-() ";
                    }
                    if (vector3 != null && vector3.size() > 0) {
                        PartialOrderNode partialOrderNode3;
                        string = String.valueOf(string) + " CIFs-(";
                        n3 = 0;
                        while (n3 < vector3.size() - 1) {
                            partialOrderNode3 = (PartialOrderNode)vector3.elementAt(n3);
                            string = String.valueOf(string) + partialOrderNode3.getName();
                            string = String.valueOf(string) + ", ";
                            ++n3;
                        }
                        partialOrderNode3 = (PartialOrderNode)vector3.elementAt(n3);
                        string = String.valueOf(string) + partialOrderNode3.getName();
                        string = String.valueOf(string) + ") ";
                    } else {
                        string = String.valueOf(string) + " CIFs-() ";
                    }
                    string = String.valueOf(string) + "} ";
                    ++n2;
                }
                string = String.valueOf(string) + ">\n";
            }
            string = String.valueOf(string) + "]";
        }
        this.lock.releaseReadLock();
        return string;
    }

    public void unregisterCIF(String string, String string2, CollectionImageFactory collectionImageFactory) {
        String string3;
        String string4 = string.toLowerCase();
        this.lock.getWriteLock();
        if (!this.opDescsName.containsKey(string4)) {
            Object[] objectArray = new Object[]{new String(string)};
            formatter.applyPattern(JaiI18N.getString("OperationRegistry10"));
            System.err.println(formatter.format(objectArray));
            this.lock.releaseWriteLock();
            return;
        }
        ProductOperationGraph productOperationGraph = (ProductOperationGraph)this.products.get(string4);
        PartialOrderNode partialOrderNode = productOperationGraph.lookupOp(string3 = string2.toLowerCase());
        if (partialOrderNode == null) {
            Object[] objectArray = new Object[]{new String(string2), new String(string)};
            formatter.applyPattern(JaiI18N.getString("OperationRegistry14"));
            System.err.println(formatter.format(objectArray));
            this.lock.releaseWriteLock();
            return;
        }
        OperationGraph operationGraph = (OperationGraph)partialOrderNode.getData();
        if (operationGraph.lookupCIF(collectionImageFactory) == null) {
            System.err.println(String.valueOf(collectionImageFactory.getClass().getName()) + " " + JaiI18N.getString("OperationRegistry20"));
            this.lock.releaseWriteLock();
            return;
        }
        operationGraph.removeCIF(collectionImageFactory);
        String string5 = (String)this.cifsByName.get(collectionImageFactory);
        this.cifsByName.remove(collectionImageFactory);
        this.cifs.remove(string5);
        --this.cifcount;
        this.lock.releaseWriteLock();
    }

    public void unregisterCRIF(String string, ContextualRenderedImageFactory contextualRenderedImageFactory) {
        if (contextualRenderedImageFactory == null) {
            throw new NullPointerException();
        }
        String string2 = string.toLowerCase();
        this.lock.getWriteLock();
        if (!this.opDescsName.containsKey(string2)) {
            Object[] objectArray = new Object[]{new String(string)};
            formatter.applyPattern(JaiI18N.getString("OperationRegistry10"));
            System.err.println(formatter.format(objectArray));
            this.lock.releaseWriteLock();
            return;
        }
        this.crifs.remove(string2);
        this.lock.releaseWriteLock();
    }

    public void unregisterOperationDescriptor(String string) {
        String string2 = string.toLowerCase();
        this.lock.getWriteLock();
        if (this.opDescsName.containsKey(string2)) {
            OperationDescriptor operationDescriptor = (OperationDescriptor)this.opDescsName.get(string2);
            PropertyGenerator[] propertyGeneratorArray = operationDescriptor.getPropertyGenerators();
            if (propertyGeneratorArray != null) {
                int n = 0;
                while (n < propertyGeneratorArray.length) {
                    if (propertyGeneratorArray[n] == null) {
                        this.lock.releaseWriteLock();
                        throw new NullPointerException();
                    }
                    Vector vector = (Vector)this.properties.get(string2);
                    if (vector != null) {
                        vector.removeElement(propertyGeneratorArray[n]);
                    }
                    ++n;
                }
            }
            this.opDescsName.remove(string2);
            this.products.remove(string2);
        } else {
            Object[] objectArray = new Object[]{new String(string)};
            formatter.applyPattern(JaiI18N.getString("OperationRegistry10"));
            System.err.println(formatter.format(objectArray));
        }
        this.lock.releaseWriteLock();
    }

    public void unregisterRIF(String string, String string2, RenderedImageFactory renderedImageFactory) {
        String string3;
        String string4 = string.toLowerCase();
        this.lock.getWriteLock();
        if (!this.opDescsName.containsKey(string4)) {
            Object[] objectArray = new Object[]{new String(string)};
            formatter.applyPattern(JaiI18N.getString("OperationRegistry10"));
            System.err.println(formatter.format(objectArray));
            this.lock.releaseWriteLock();
            return;
        }
        ProductOperationGraph productOperationGraph = (ProductOperationGraph)this.products.get(string4);
        PartialOrderNode partialOrderNode = productOperationGraph.lookupOp(string3 = string2.toLowerCase());
        if (partialOrderNode == null) {
            Object[] objectArray = new Object[]{new String(string2)};
            formatter.applyPattern(JaiI18N.getString("OperationRegistry11"));
            System.err.println(formatter.format(objectArray));
            this.lock.releaseWriteLock();
            return;
        }
        OperationGraph operationGraph = (OperationGraph)partialOrderNode.getData();
        if (operationGraph.lookupRIF(renderedImageFactory) == null) {
            System.err.println(String.valueOf(renderedImageFactory.getClass().getName()) + " " + JaiI18N.getString("OperationRegistry20"));
            this.lock.releaseWriteLock();
            return;
        }
        operationGraph.removeRIF(renderedImageFactory);
        String string5 = (String)this.rifsByName.get(renderedImageFactory);
        this.rifsByName.remove(renderedImageFactory);
        this.rifs.remove(string5);
        --this.rifcount;
        this.lock.releaseWriteLock();
    }

    public void unsetCIFPreference(String string, String string2, CollectionImageFactory collectionImageFactory, CollectionImageFactory collectionImageFactory2) {
        String string3;
        if (collectionImageFactory == null || collectionImageFactory2 == null) {
            throw new NullPointerException();
        }
        if (collectionImageFactory == collectionImageFactory2) {
            return;
        }
        String string4 = string.toLowerCase();
        this.lock.getWriteLock();
        if (!this.opDescsName.containsKey(string4)) {
            Object[] objectArray = new Object[]{new String(string)};
            formatter.applyPattern(JaiI18N.getString("OperationRegistry10"));
            System.err.println(formatter.format(objectArray));
            this.lock.releaseWriteLock();
            return;
        }
        ProductOperationGraph productOperationGraph = (ProductOperationGraph)this.products.get(string4);
        PartialOrderNode partialOrderNode = productOperationGraph.lookupOp(string3 = string2.toLowerCase());
        if (partialOrderNode == null) {
            Object[] objectArray = new Object[]{new String(string2), new String(string)};
            formatter.applyPattern(JaiI18N.getString("OperationRegistry14"));
            System.err.println(formatter.format(objectArray));
            this.lock.releaseWriteLock();
            return;
        }
        if (!this.cifPrefs.containsKey(string4)) {
            System.err.println(JaiI18N.getString("OperationRegistry21"));
            this.lock.releaseWriteLock();
            return;
        }
        OperationGraph operationGraph = (OperationGraph)partialOrderNode.getData();
        if (operationGraph.lookupCIF(collectionImageFactory) == null) {
            System.err.println(String.valueOf(collectionImageFactory.getClass().getName()) + " " + JaiI18N.getString("OperationRegistry26"));
            this.lock.releaseWriteLock();
            return;
        }
        if (operationGraph.lookupCIF(collectionImageFactory2) == null) {
            System.err.println(String.valueOf(collectionImageFactory2.getClass().getName()) + " " + JaiI18N.getString("OperationRegistry26"));
            this.lock.releaseWriteLock();
            return;
        }
        operationGraph.unsetCIFPreference(collectionImageFactory, collectionImageFactory2);
        Vector vector = (Vector)this.cifPrefs.get(string4);
        boolean bl = false;
        Iterator iterator = ((AbstractList)vector).iterator();
        while (iterator.hasNext()) {
            Store store = (Store)iterator.next();
            if (store.product != string2 || (CollectionImageFactory)store.object1 != collectionImageFactory || (CollectionImageFactory)store.object2 != collectionImageFactory2) continue;
            iterator.remove();
            break;
        }
        this.lock.releaseWriteLock();
    }

    public void unsetProductPreference(String string, String string2, String string3) {
        String string4 = string.toLowerCase();
        if (string2.equalsIgnoreCase(string3)) {
            return;
        }
        this.lock.getWriteLock();
        if (!this.opDescsName.containsKey(string4)) {
            Object[] objectArray = new Object[]{new String(string)};
            formatter.applyPattern(JaiI18N.getString("OperationRegistry10"));
            System.err.println(formatter.format(objectArray));
            this.lock.releaseWriteLock();
            return;
        }
        ProductOperationGraph productOperationGraph = (ProductOperationGraph)this.products.get(string4);
        if (productOperationGraph == null) {
            System.err.println(String.valueOf(string) + " " + JaiI18N.getString("OperationRegistry23"));
            this.lock.releaseWriteLock();
            return;
        }
        if (productOperationGraph.lookupOp(string2.toLowerCase()) == null) {
            Object[] objectArray = new Object[]{new String(string2), new String(string)};
            formatter.applyPattern(JaiI18N.getString("OperationRegistry24"));
            System.err.println(formatter.format(objectArray));
            this.lock.releaseWriteLock();
            return;
        }
        if (productOperationGraph.lookupOp(string3.toLowerCase()) == null) {
            Object[] objectArray = new Object[]{new String(string3), new String(string)};
            formatter.applyPattern(JaiI18N.getString("OperationRegistry24"));
            System.err.println(formatter.format(objectArray));
            this.lock.releaseWriteLock();
            return;
        }
        productOperationGraph.unsetPreference(string2.toLowerCase(), string3.toLowerCase());
        if (!this.productPrefs.containsKey(string4)) {
            Object[] objectArray = new Object[]{new String(string)};
            formatter.applyPattern(JaiI18N.getString("OperationRegistry12"));
            System.err.println(formatter.format(objectArray));
            this.lock.releaseWriteLock();
            return;
        }
        Vector vector = (Vector)this.productPrefs.get(string4);
        boolean bl = false;
        Iterator iterator = ((AbstractList)vector).iterator();
        while (iterator.hasNext()) {
            Store store = (Store)iterator.next();
            if ((String)store.object1 != string2 || (String)store.object2 != string3) continue;
            iterator.remove();
            break;
        }
        this.lock.releaseWriteLock();
    }

    public void unsetRIFPreference(String string, String string2, RenderedImageFactory renderedImageFactory, RenderedImageFactory renderedImageFactory2) {
        String string3;
        if (renderedImageFactory == null || renderedImageFactory2 == null) {
            throw new NullPointerException();
        }
        if (renderedImageFactory == renderedImageFactory2) {
            return;
        }
        String string4 = string.toLowerCase();
        this.lock.getWriteLock();
        if (!this.opDescsName.containsKey(string4)) {
            Object[] objectArray = new Object[]{new String(string)};
            formatter.applyPattern(JaiI18N.getString("OperationRegistry10"));
            System.err.println(formatter.format(objectArray));
            this.lock.releaseWriteLock();
            return;
        }
        ProductOperationGraph productOperationGraph = (ProductOperationGraph)this.products.get(string4);
        PartialOrderNode partialOrderNode = productOperationGraph.lookupOp(string3 = string2.toLowerCase());
        if (partialOrderNode == null) {
            Object[] objectArray = new Object[]{new String(string2), new String(string)};
            formatter.applyPattern(JaiI18N.getString("OperationRegistry14"));
            System.err.println(formatter.format(objectArray));
            this.lock.releaseWriteLock();
            return;
        }
        if (!this.rifPrefs.containsKey(string4)) {
            System.err.println(JaiI18N.getString("OperationRegistry17"));
            this.lock.releaseWriteLock();
            return;
        }
        OperationGraph operationGraph = (OperationGraph)partialOrderNode.getData();
        if (operationGraph.lookupRIF(renderedImageFactory) == null) {
            System.err.println(String.valueOf(renderedImageFactory.getClass().getName()) + " " + JaiI18N.getString("OperationRegistry26"));
            this.lock.releaseWriteLock();
            return;
        }
        if (operationGraph.lookupRIF(renderedImageFactory2) == null) {
            System.err.println(String.valueOf(renderedImageFactory2.getClass().getName()) + " " + JaiI18N.getString("OperationRegistry26"));
            this.lock.releaseWriteLock();
            return;
        }
        operationGraph.unsetRIFPreference(renderedImageFactory, renderedImageFactory2);
        Vector vector = (Vector)this.rifPrefs.get(string4);
        boolean bl = false;
        Iterator iterator = ((AbstractList)vector).iterator();
        while (iterator.hasNext()) {
            Store store = (Store)iterator.next();
            if (store.product != string2 || (RenderedImageFactory)store.object1 != renderedImageFactory || (RenderedImageFactory)store.object2 != renderedImageFactory2) continue;
            iterator.remove();
            break;
        }
        this.lock.releaseWriteLock();
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.writeToStream(byteArrayOutputStream);
        objectOutput.writeObject(byteArrayOutputStream.toByteArray());
    }

    public void writeToStream(OutputStream outputStream) throws IOException {
        this.lock.getReadLock();
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream);
        BufferedWriter bufferedWriter = new BufferedWriter(outputStreamWriter);
        try {
            Store store;
            Iterator iterator;
            Vector vector;
            Storage storage;
            String string;
            String string2;
            String string3 = "odesc";
            int n = 9;
            Enumeration enumeration = this.opDescsName.keys();
            while (enumeration.hasMoreElements()) {
                bufferedWriter.write(string3);
                bufferedWriter.write(n);
                string2 = (String)enumeration.nextElement();
                OperationDescriptor operationDescriptor = (OperationDescriptor)this.opDescsName.get(string2);
                String string4 = operationDescriptor.getClass().getName();
                bufferedWriter.write(string4);
                bufferedWriter.write(n);
                bufferedWriter.write(string2);
                bufferedWriter.newLine();
            }
            string3 = "rif";
            Enumeration enumeration2 = this.rifs.keys();
            while (enumeration2.hasMoreElements()) {
                string = (String)enumeration2.nextElement();
                storage = (Storage)this.rifs.get(string);
                bufferedWriter.write(string3);
                bufferedWriter.write(n);
                bufferedWriter.write(storage.name);
                bufferedWriter.write(n);
                bufferedWriter.write(storage.product);
                bufferedWriter.write(n);
                bufferedWriter.write(storage.registerName);
                bufferedWriter.write(n);
                bufferedWriter.write(string);
                bufferedWriter.newLine();
            }
            string3 = "crif";
            Enumeration enumeration3 = this.crifs.keys();
            while (enumeration3.hasMoreElements()) {
                string = (String)enumeration3.nextElement();
                ContextualRenderedImageFactory contextualRenderedImageFactory = (ContextualRenderedImageFactory)this.crifs.get(string);
                bufferedWriter.write(string3);
                bufferedWriter.write(n);
                bufferedWriter.write(contextualRenderedImageFactory.getClass().getName());
                bufferedWriter.write(n);
                bufferedWriter.write(string);
                bufferedWriter.newLine();
            }
            string3 = "cif";
            Enumeration enumeration4 = this.cifs.keys();
            while (enumeration4.hasMoreElements()) {
                string = (String)enumeration4.nextElement();
                storage = (Storage)this.cifs.get(string);
                bufferedWriter.write(string3);
                bufferedWriter.write(n);
                bufferedWriter.write(storage.name);
                bufferedWriter.write(n);
                bufferedWriter.write(storage.product);
                bufferedWriter.write(n);
                bufferedWriter.write(storage.registerName);
                bufferedWriter.write(n);
                bufferedWriter.write(string);
                bufferedWriter.newLine();
            }
            String string5 = "pref";
            string3 = "product";
            Enumeration enumeration5 = this.productPrefs.keys();
            while (enumeration5.hasMoreElements()) {
                string2 = (String)enumeration5.nextElement();
                vector = (Vector)this.productPrefs.get(string2);
                iterator = ((AbstractList)vector).iterator();
                while (iterator.hasNext()) {
                    store = (Store)iterator.next();
                    bufferedWriter.write(string5);
                    bufferedWriter.write(n);
                    bufferedWriter.write(string3);
                    bufferedWriter.write(n);
                    bufferedWriter.write(string2);
                    bufferedWriter.write(n);
                    bufferedWriter.write((String)store.object1);
                    bufferedWriter.write(n);
                    bufferedWriter.write((String)store.object2);
                    bufferedWriter.newLine();
                }
            }
            string3 = "rif";
            Enumeration enumeration6 = this.rifPrefs.keys();
            while (enumeration6.hasMoreElements()) {
                string2 = (String)enumeration6.nextElement();
                vector = (Vector)this.rifPrefs.get(string2);
                iterator = ((AbstractList)vector).iterator();
                while (iterator.hasNext()) {
                    store = (Store)iterator.next();
                    RenderedImageFactory renderedImageFactory = (RenderedImageFactory)store.object1;
                    RenderedImageFactory renderedImageFactory2 = (RenderedImageFactory)store.object2;
                    String string6 = (String)this.rifsByName.get(renderedImageFactory);
                    String string7 = (String)this.rifsByName.get(renderedImageFactory2);
                    bufferedWriter.write(string5);
                    bufferedWriter.write(n);
                    bufferedWriter.write(string3);
                    bufferedWriter.write(n);
                    bufferedWriter.write(string2);
                    bufferedWriter.write(n);
                    bufferedWriter.write(store.product);
                    bufferedWriter.write(n);
                    bufferedWriter.write(string6);
                    bufferedWriter.write(n);
                    bufferedWriter.write(string7);
                    bufferedWriter.newLine();
                }
            }
            string3 = "cif";
            Enumeration enumeration7 = this.cifPrefs.keys();
            while (enumeration7.hasMoreElements()) {
                string2 = (String)enumeration7.nextElement();
                vector = (Vector)this.cifPrefs.get(string2);
                iterator = ((AbstractList)vector).iterator();
                while (iterator.hasNext()) {
                    store = (Store)iterator.next();
                    CollectionImageFactory collectionImageFactory = (CollectionImageFactory)store.object1;
                    CollectionImageFactory collectionImageFactory2 = (CollectionImageFactory)store.object2;
                    String string8 = (String)this.cifsByName.get(collectionImageFactory);
                    String string9 = (String)this.cifsByName.get(collectionImageFactory2);
                    bufferedWriter.write(string5);
                    bufferedWriter.write(n);
                    bufferedWriter.write(string3);
                    bufferedWriter.write(n);
                    bufferedWriter.write(string2);
                    bufferedWriter.write(n);
                    bufferedWriter.write(store.product);
                    bufferedWriter.write(n);
                    bufferedWriter.write(string8);
                    bufferedWriter.write(n);
                    bufferedWriter.write(string9);
                    bufferedWriter.newLine();
                }
            }
            bufferedWriter.flush();
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            bufferedWriter.flush();
            bufferedWriter.close();
            this.lock.releaseReadLock();
            throw iOException;
        }
        this.lock.releaseReadLock();
    }
}

