/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai;

import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import javax.media.jai.JaiI18N;
import javax.media.jai.WarpPolynomial;

public final class WarpAffine
extends WarpPolynomial {
    private float c1;
    private float c2;
    private float c3;
    private float c4;
    private float c5;
    private float c6;
    private AffineTransform transform;

    public WarpAffine(AffineTransform affineTransform) {
        this(affineTransform, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    public WarpAffine(AffineTransform affineTransform, float f, float f2, float f3, float f4) {
        this(WarpAffine.xCoeffsHelper(affineTransform), WarpAffine.yCoeffsHelper(affineTransform), f, f2, f3, f4);
    }

    public WarpAffine(float[] fArray, float[] fArray2) {
        this(fArray, fArray2, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    public WarpAffine(float[] fArray, float[] fArray2, float f, float f2, float f3, float f4) {
        super(fArray, fArray2, f, f2, f3, f4);
        if (fArray.length != 3 || fArray2.length != 3) {
            throw new IllegalArgumentException(JaiI18N.getString("WarpAffine0"));
        }
        this.c1 = fArray[0];
        this.c2 = fArray[1];
        this.c3 = fArray[2];
        this.c4 = fArray2[0];
        this.c5 = fArray2[1];
        this.c6 = fArray2[2];
        this.transform = this.getTransform();
    }

    public AffineTransform getTransform() {
        return new AffineTransform(this.c2, this.c5, this.c3, this.c6, this.c1, this.c4);
    }

    private float[] mapDestPoint(int n, int n2) {
        float f = ((float)n + 0.5f) * this.preScaleX;
        float f2 = ((float)n2 + 0.5f) * this.preScaleY;
        float[] fArray = new float[]{(this.c1 + this.c2 * f + this.c3 * f2) * this.postScaleX - 0.5f, (this.c4 + this.c5 * f + this.c6 * f2) * this.postScaleY - 0.5f};
        return fArray;
    }

    public Rectangle mapDestRect(Rectangle rectangle) {
        int n = rectangle.x;
        int n2 = rectangle.x + rectangle.width;
        int n3 = rectangle.y;
        int n4 = rectangle.y + rectangle.height;
        float[] fArray = this.mapDestPoint(n, n3);
        float f = fArray[0];
        float f2 = fArray[0];
        float f3 = fArray[1];
        float f4 = fArray[1];
        fArray = this.mapDestPoint(n2, n3);
        f = Math.min(f, fArray[0]);
        f2 = Math.max(f2, fArray[0]);
        f3 = Math.min(f3, fArray[1]);
        f4 = Math.max(f4, fArray[1]);
        fArray = this.mapDestPoint(n, n4);
        f = Math.min(f, fArray[0]);
        f2 = Math.max(f2, fArray[0]);
        f3 = Math.min(f3, fArray[1]);
        f4 = Math.max(f4, fArray[1]);
        fArray = this.mapDestPoint(n2, n4);
        f = Math.min(f, fArray[0]);
        f2 = Math.max(f2, fArray[0]);
        f3 = Math.min(f3, fArray[1]);
        f4 = Math.max(f4, fArray[1]);
        int n5 = (int)Math.floor(f);
        int n6 = (int)Math.floor(f3);
        int n7 = (int)Math.ceil(f2 - (float)n5);
        int n8 = (int)Math.ceil(f4 - (float)n6);
        return new Rectangle(n5, n6, n7, n8);
    }

    public float[] warpSparseRect(int n, int n2, int n3, int n4, int n5, int n6, float[] fArray) {
        if (fArray == null) {
            fArray = new float[(n3 + n5 - 1) / n5 * ((n4 + n6 - 1) / n6) * 2];
        }
        float f = (float)n5 * this.preScaleX;
        float f2 = this.c2 * f * this.postScaleX;
        float f3 = this.c5 * f * this.postScaleY;
        float f4 = ((float)n + 0.5f) * this.preScaleX;
        n3 += n;
        n4 += n2;
        int n7 = 0;
        int n8 = n2;
        while (n8 < n4) {
            float f5 = ((float)n8 + 0.5f) * this.preScaleY;
            float f6 = (this.c1 + this.c2 * f4 + this.c3 * f5) * this.postScaleX - 0.5f;
            float f7 = (this.c4 + this.c5 * f4 + this.c6 * f5) * this.postScaleY - 0.5f;
            int n9 = n;
            while (n9 < n3) {
                fArray[n7++] = f6;
                fArray[n7++] = f7;
                f6 += f2;
                f7 += f3;
                n9 += n5;
            }
            n8 += n6;
        }
        return fArray;
    }

    private static final float[] xCoeffsHelper(AffineTransform affineTransform) {
        float[] fArray = new float[]{(float)affineTransform.getTranslateX(), (float)affineTransform.getScaleX(), (float)affineTransform.getShearX()};
        return fArray;
    }

    private static final float[] yCoeffsHelper(AffineTransform affineTransform) {
        float[] fArray = new float[]{(float)affineTransform.getTranslateY(), (float)affineTransform.getShearY(), (float)affineTransform.getScaleY()};
        return fArray;
    }
}

