/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.splusserver.domain;

import com.insightful.splusserver.exception.ExceptionType;
import com.insightful.splusserver.exception.GenericException;
import com.insightful.splusserver.exception.IException;
import com.insightful.splusserver.exception.JobDoesNotExistException;
import com.insightful.splusserver.exception.NotAuthenticatedException;
import com.insightful.splusserver.exception.ServerNotRespondingException;
import com.insightful.splusserver.exception.StorageException;
import java.io.Serializable;
import java.util.EnumSet;

public class Exception
implements Serializable {
    private static final long serialVersionUID = 1107L;
    private int mOrdinal = -1;
    private String mMessage = null;

    public String getMessage() {
        return this.mMessage;
    }

    public void setMessage(String message) {
        this.mMessage = message;
    }

    public int getOrdinal() {
        return this.mOrdinal;
    }

    public void setOrdinal(int ordinal) {
        this.mOrdinal = ordinal;
    }

    public ExceptionType getType() {
        ExceptionType type = null;
        for (ExceptionType et : EnumSet.range(ExceptionType.JobDoesNotExist, ExceptionType.Generic)) {
            if (this.mOrdinal != et.ordinal()) continue;
            type = et;
            break;
        }
        return type;
    }

    public IException getException() {
        IException e = null;
        switch (this.getType()) {
            case JobDoesNotExist: {
                e = new JobDoesNotExistException(this.mMessage);
                break;
            }
            case NotAuthenticated: {
                e = new NotAuthenticatedException(this.mMessage);
                break;
            }
            case ServerNotResponding: {
                e = new ServerNotRespondingException(this.mMessage);
                break;
            }
            case Storage: {
                e = new StorageException(this.mMessage);
                break;
            }
            case Generic: {
                e = new GenericException(this.mMessage);
                break;
            }
        }
        return e;
    }
}

