/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.ui.internal.preferences;

import org.eclipse.core.runtime.Preferences;
import org.eclipse.help.internal.base.HelpBasePlugin;
import org.eclipse.help.internal.base.remote.PreferenceFileHandler;
import org.eclipse.help.internal.base.remote.RemoteHelp;
import org.eclipse.help.internal.base.remote.RemoteIC;
import org.eclipse.help.ui.internal.Messages;
import org.eclipse.help.ui.internal.preferences.HelpContentBlock;
import org.eclipse.help.ui.internal.preferences.InfocenterDisplay;
import org.eclipse.help.ui.internal.preferences.RestoreDefaultsDialog;
import org.eclipse.help.ui.internal.preferences.TabFolderLayout;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;

public class HelpContentPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private InfocenterDisplay remoteICPage;
    Preferences prefs;
    private Button checkbox;
    private Listener changeListener = new Listener(){

        public void handleEvent(Event event) {
            HelpContentBlock currentBlock = HelpContentPreferencePage.this.remoteICPage.getHelpContentBlock();
            boolean isRemoteHelpEnabled = HelpContentPreferencePage.this.checkbox.getSelection();
            if (isRemoteHelpEnabled) {
                currentBlock.restoreDefaultButtons();
            } else {
                currentBlock.disableAllButtons();
            }
            currentBlock.getRemoteICviewer().getTable().setEnabled(isRemoteHelpEnabled);
        }
    };

    public HelpContentPreferencePage() {
        this.prefs = HelpBasePlugin.getDefault().getPluginPreferences();
    }

    public void init(IWorkbench workbench) {
    }

    protected Control createContents(Composite parent) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.help.ui.prefPageHelpContent");
        this.initializeDialogUnits((Control)parent);
        this.createCheckbox(parent);
        TabFolder folder = new TabFolder(parent, 0);
        folder.setLayout((Layout)new TabFolderLayout());
        folder.setLayoutData((Object)new GridData(1808));
        folder.setFont(parent.getFont());
        this.remoteICPage = new InfocenterDisplay(this);
        this.remoteICPage.createTabItem(folder);
        this.initializeTableEnablement(this.checkbox.getSelection());
        return folder;
    }

    protected void performDefaults() {
        super.performDefaults();
        RestoreDefaultsDialog dialog = new RestoreDefaultsDialog(this.getControl().getShell());
        if (dialog.open() == 0) {
            HelpContentBlock currentBlock = this.remoteICPage.getHelpContentBlock();
            currentBlock.getRemoteICviewer().getRemoteICList().removeAllRemoteICs(currentBlock.getRemoteICList());
            currentBlock.restoreDefaultButtons();
        }
    }

    public boolean performOk() {
        this.prefs = HelpBasePlugin.getDefault().getPluginPreferences();
        this.prefs.setValue("remoteHelpOn", this.checkbox.getSelection());
        HelpContentBlock currentBlock = this.remoteICPage.getHelpContentBlock();
        RemoteIC[] currentRemoteICArray = currentBlock.getRemoteICList();
        PreferenceFileHandler.commitRemoteICs((RemoteIC[])currentRemoteICArray);
        HelpBasePlugin.getDefault().savePluginPreferences();
        RemoteHelp.notifyPreferenceChange();
        return super.performOk();
    }

    protected GridData setButtonLayoutData(Button button) {
        return super.setButtonLayoutData(button);
    }

    private void createCheckbox(Composite parent) {
        this.checkbox = new Button(parent, 32);
        this.checkbox.setText(Messages.HelpContentPreferencePage_remote);
        this.checkbox.addListener(13, this.changeListener);
        boolean isOn = this.prefs.getBoolean("remoteHelpOn");
        this.checkbox.setSelection(isOn);
    }

    private void initializeTableEnablement(boolean isRemoteHelpEnabled) {
        HelpContentBlock currentBlock = this.remoteICPage.getHelpContentBlock();
        if (isRemoteHelpEnabled) {
            currentBlock.restoreDefaultButtons();
        } else {
            currentBlock.disableAllButtons();
        }
        currentBlock.getRemoteICviewer().getTable().setEnabled(isRemoteHelpEnabled);
    }
}

